/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.property.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"hotelIdentifier", "name", "urlName", "currencyCode", "status", "externalStatus", "stars", "numberOfRooms", "active", "propertyActive", "platformActive"})
@JsonTypeName(value="HotelLightweight_Supplier")
public class HotelLightweightSupplier {
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_URL_NAME = "urlName";
    private String urlName;
    public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
    private String currencyCode;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status = StatusEnum.WAITING_ON_CONTRACT;
    public static final String JSON_PROPERTY_EXTERNAL_STATUS = "externalStatus";
    private String externalStatus = "6";
    public static final String JSON_PROPERTY_STARS = "stars";
    private Integer stars;
    public static final String JSON_PROPERTY_NUMBER_OF_ROOMS = "numberOfRooms";
    private Integer numberOfRooms;
    public static final String JSON_PROPERTY_ACTIVE = "active";
    private Boolean active;
    public static final String JSON_PROPERTY_PROPERTY_ACTIVE = "propertyActive";
    private Boolean propertyActive;
    public static final String JSON_PROPERTY_PLATFORM_ACTIVE = "platformActive";
    private Boolean platformActive;

    public HotelLightweightSupplier hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public HotelLightweightSupplier name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public HotelLightweightSupplier urlName(String urlName) {
        this.urlName = urlName;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="urlName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUrlName() {
        return this.urlName;
    }

    @JsonProperty(value="urlName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUrlName(String urlName) {
        this.urlName = urlName;
    }

    public HotelLightweightSupplier currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public HotelLightweightSupplier status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public HotelLightweightSupplier externalStatus(String externalStatus) {
        this.externalStatus = externalStatus;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="externalStatus")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getExternalStatus() {
        return this.externalStatus;
    }

    @JsonProperty(value="externalStatus")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExternalStatus(String externalStatus) {
        this.externalStatus = externalStatus;
    }

    public HotelLightweightSupplier stars(Integer stars) {
        this.stars = stars;
        return this;
    }

    @Nullable
    @Min(value=0L)
    @Max(value=6L)
    @JsonProperty(value="stars")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Min(value=0L) @Max(value=6L) Integer getStars() {
        return this.stars;
    }

    @JsonProperty(value="stars")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStars(Integer stars) {
        this.stars = stars;
    }

    public HotelLightweightSupplier numberOfRooms(Integer numberOfRooms) {
        this.numberOfRooms = numberOfRooms;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="numberOfRooms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getNumberOfRooms() {
        return this.numberOfRooms;
    }

    @JsonProperty(value="numberOfRooms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNumberOfRooms(Integer numberOfRooms) {
        this.numberOfRooms = numberOfRooms;
    }

    public HotelLightweightSupplier active(Boolean active) {
        this.active = active;
        return this;
    }

    @Nullable
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActive(Boolean active) {
        this.active = active;
    }

    public HotelLightweightSupplier propertyActive(Boolean propertyActive) {
        this.propertyActive = propertyActive;
        return this;
    }

    @Nullable
    @JsonProperty(value="propertyActive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPropertyActive() {
        return this.propertyActive;
    }

    @JsonProperty(value="propertyActive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPropertyActive(Boolean propertyActive) {
        this.propertyActive = propertyActive;
    }

    public HotelLightweightSupplier platformActive(Boolean platformActive) {
        this.platformActive = platformActive;
        return this;
    }

    @Nullable
    @JsonProperty(value="platformActive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPlatformActive() {
        return this.platformActive;
    }

    @JsonProperty(value="platformActive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlatformActive(Boolean platformActive) {
        this.platformActive = platformActive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HotelLightweightSupplier hotelLightweightSupplier = (HotelLightweightSupplier)o;
        return Objects.equals(this.hotelIdentifier, hotelLightweightSupplier.hotelIdentifier) && Objects.equals(this.name, hotelLightweightSupplier.name) && Objects.equals(this.urlName, hotelLightweightSupplier.urlName) && Objects.equals(this.currencyCode, hotelLightweightSupplier.currencyCode) && Objects.equals((Object)this.status, (Object)hotelLightweightSupplier.status) && Objects.equals(this.externalStatus, hotelLightweightSupplier.externalStatus) && Objects.equals(this.stars, hotelLightweightSupplier.stars) && Objects.equals(this.numberOfRooms, hotelLightweightSupplier.numberOfRooms) && Objects.equals(this.active, hotelLightweightSupplier.active) && Objects.equals(this.propertyActive, hotelLightweightSupplier.propertyActive) && Objects.equals(this.platformActive, hotelLightweightSupplier.platformActive);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hotelIdentifier, this.name, this.urlName, this.currencyCode, this.status, this.externalStatus, this.stars, this.numberOfRooms, this.active, this.propertyActive, this.platformActive});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HotelLightweightSupplier {\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    urlName: ").append(this.toIndentedString(this.urlName)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    externalStatus: ").append(this.toIndentedString(this.externalStatus)).append("\n");
        sb.append("    stars: ").append(this.toIndentedString(this.stars)).append("\n");
        sb.append("    numberOfRooms: ").append(this.toIndentedString(this.numberOfRooms)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    propertyActive: ").append(this.toIndentedString(this.propertyActive)).append("\n");
        sb.append("    platformActive: ").append(this.toIndentedString(this.platformActive)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        DISABLED("DISABLED"),
        SUSPENDED("SUSPENDED"),
        REMOVED("REMOVED"),
        WAITING_ON_CONTRACT("WAITING_ON_CONTRACT"),
        CONTRACT_SIGNED("CONTRACT_SIGNED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

