/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.property.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.property.invoker.ApiClient;
import travel.wink.sdk.extranet.property.model.PropertySupplier;
import travel.wink.sdk.extranet.property.model.UpdateChannelManagerRequestSupplier;

public class ChannelManagerApi {
    private ApiClient apiClient;

    public ChannelManagerApi() {
        this(new ApiClient());
    }

    @Autowired
    public ChannelManagerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec updateChannelManagerRequestCreation(@Nonnull String propertyIdentifier, @Nonnull UpdateChannelManagerRequestSupplier updateChannelManagerRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        UpdateChannelManagerRequestSupplier postBody = updateChannelManagerRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateChannelManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (updateChannelManagerRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateChannelManagerRequestSupplier' when calling updateChannelManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/channel-manager", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertySupplier> updateChannelManager(@Nonnull String propertyIdentifier, @Nonnull UpdateChannelManagerRequestSupplier updateChannelManagerRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.updateChannelManagerRequestCreation(propertyIdentifier, updateChannelManagerRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertySupplier>> updateChannelManagerWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull UpdateChannelManagerRequestSupplier updateChannelManagerRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.updateChannelManagerRequestCreation(propertyIdentifier, updateChannelManagerRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateChannelManagerWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull UpdateChannelManagerRequestSupplier updateChannelManagerRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateChannelManagerRequestCreation(propertyIdentifier, updateChannelManagerRequestSupplier, winkVersion);
    }
}

