/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.property.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.property.invoker.ApiClient;
import travel.wink.sdk.extranet.property.model.PropertySupplier;
import travel.wink.sdk.extranet.property.model.SimpleMultimediaSupplier;

public class MediaApi {
    private ApiClient apiClient;

    public MediaApi() {
        this(new ApiClient());
    }

    @Autowired
    public MediaApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createMultimediaRequestCreation(@Nonnull String propertyIdentifier, @Nonnull SimpleMultimediaSupplier simpleMultimediaSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        SimpleMultimediaSupplier postBody = simpleMultimediaSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (simpleMultimediaSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'simpleMultimediaSupplier' when calling createMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/multimedia", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertySupplier> createMultimedia(@Nonnull String propertyIdentifier, @Nonnull SimpleMultimediaSupplier simpleMultimediaSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.createMultimediaRequestCreation(propertyIdentifier, simpleMultimediaSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertySupplier>> createMultimediaWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull SimpleMultimediaSupplier simpleMultimediaSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.createMultimediaRequestCreation(propertyIdentifier, simpleMultimediaSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createMultimediaWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull SimpleMultimediaSupplier simpleMultimediaSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createMultimediaRequestCreation(propertyIdentifier, simpleMultimediaSupplier, winkVersion);
    }

    private WebClient.ResponseSpec removeMediaListRequestCreation(@Nonnull String propertyIdentifier, @Nonnull List<String> multimediaIdentifiers, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeMediaList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (multimediaIdentifiers == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifiers' when calling removeMediaList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "multimediaIdentifiers", multimediaIdentifiers));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/multimedia/list", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertySupplier> removeMediaList(@Nonnull String propertyIdentifier, @Nonnull List<String> multimediaIdentifiers, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.removeMediaListRequestCreation(propertyIdentifier, multimediaIdentifiers, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertySupplier>> removeMediaListWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull List<String> multimediaIdentifiers, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.removeMediaListRequestCreation(propertyIdentifier, multimediaIdentifiers, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeMediaListWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull List<String> multimediaIdentifiers, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeMediaListRequestCreation(propertyIdentifier, multimediaIdentifiers, winkVersion, accept);
    }

    private WebClient.ResponseSpec removeMultimediaRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String multimediaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling removeMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertySupplier> removeMultimedia(@Nonnull String propertyIdentifier, @Nonnull String multimediaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.removeMultimediaRequestCreation(propertyIdentifier, multimediaIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertySupplier>> removeMultimediaWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String multimediaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.removeMultimediaRequestCreation(propertyIdentifier, multimediaIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeMultimediaWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String multimediaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeMultimediaRequestCreation(propertyIdentifier, multimediaIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showMediaListRequestCreation(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showMediaList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SimpleMultimediaSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/multimedia/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SimpleMultimediaSupplier> showMediaList(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleMultimediaSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaSupplier>(this){};
        return this.showMediaListRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SimpleMultimediaSupplier>>> showMediaListWithHttpInfo(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleMultimediaSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaSupplier>(this){};
        return this.showMediaListRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showMediaListWithResponseSpec(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showMediaListRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec updateMediaListRequestCreation(@Nonnull String propertyIdentifier, @Nonnull List<@Valid SimpleMultimediaSupplier> simpleMultimediaSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        List<SimpleMultimediaSupplier> postBody = simpleMultimediaSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateMediaList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (simpleMultimediaSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'simpleMultimediaSupplier' when calling updateMediaList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/multimedia/list", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertySupplier> updateMediaList(@Nonnull String propertyIdentifier, @Nonnull List<@Valid SimpleMultimediaSupplier> simpleMultimediaSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.updateMediaListRequestCreation(propertyIdentifier, simpleMultimediaSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertySupplier>> updateMediaListWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull List<@Valid SimpleMultimediaSupplier> simpleMultimediaSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.updateMediaListRequestCreation(propertyIdentifier, simpleMultimediaSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateMediaListWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull List<@Valid SimpleMultimediaSupplier> simpleMultimediaSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateMediaListRequestCreation(propertyIdentifier, simpleMultimediaSupplier, winkVersion);
    }

    private WebClient.ResponseSpec updateMultimediaRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String multimediaIdentifier, @Nonnull SimpleMultimediaSupplier simpleMultimediaSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        SimpleMultimediaSupplier postBody = simpleMultimediaSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling updateMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (simpleMultimediaSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'simpleMultimediaSupplier' when calling updateMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertySupplier> updateMultimedia(@Nonnull String propertyIdentifier, @Nonnull String multimediaIdentifier, @Nonnull SimpleMultimediaSupplier simpleMultimediaSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.updateMultimediaRequestCreation(propertyIdentifier, multimediaIdentifier, simpleMultimediaSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertySupplier>> updateMultimediaWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String multimediaIdentifier, @Nonnull SimpleMultimediaSupplier simpleMultimediaSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.updateMultimediaRequestCreation(propertyIdentifier, multimediaIdentifier, simpleMultimediaSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateMultimediaWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String multimediaIdentifier, @Nonnull SimpleMultimediaSupplier simpleMultimediaSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateMultimediaRequestCreation(propertyIdentifier, multimediaIdentifier, simpleMultimediaSupplier, winkVersion);
    }

    private WebClient.ResponseSpec uploadMultipartFilesRequestCreation(@Nonnull String propertyIdentifier, @Nonnull List<File> files) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling uploadMultipartFiles", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadMultipartFiles", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (files != null) {
            formParams.addAll((Object)"files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/multimedia/upload", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertySupplier> uploadMultipartFiles(@Nonnull String propertyIdentifier, @Nonnull List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.uploadMultipartFilesRequestCreation(propertyIdentifier, files).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertySupplier>> uploadMultipartFilesWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.uploadMultipartFilesRequestCreation(propertyIdentifier, files).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec uploadMultipartFilesWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull List<File> files) throws WebClientResponseException {
        return this.uploadMultipartFilesRequestCreation(propertyIdentifier, files);
    }
}

