/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.property.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.property.invoker.ApiClient;
import travel.wink.sdk.extranet.property.model.ChangePropertyNameRequestSupplier;
import travel.wink.sdk.extranet.property.model.GeneralManagerSupplier;
import travel.wink.sdk.extranet.property.model.ImproveWelcomeTextRequestSupplier;
import travel.wink.sdk.extranet.property.model.KeyValuePairSupplier;
import travel.wink.sdk.extranet.property.model.PagePropertySupplier;
import travel.wink.sdk.extranet.property.model.PropertyLightweightSupplier;
import travel.wink.sdk.extranet.property.model.PropertySupplier;
import travel.wink.sdk.extranet.property.model.SimpleDescriptionSupplier;
import travel.wink.sdk.extranet.property.model.StateSupplier;
import travel.wink.sdk.extranet.property.model.SuggestAmenitiesRequestSupplier;
import travel.wink.sdk.extranet.property.model.SuggestProfileRequestSupplier;
import travel.wink.sdk.extranet.property.model.SuggestProfileResponseSupplier;
import travel.wink.sdk.extranet.property.model.SuggestWelcomeTextRequestSupplier;
import travel.wink.sdk.extranet.property.model.UniqueResultSupplier;
import travel.wink.sdk.extranet.property.model.UpdateExternalHotelStatusRequestSupplier;
import travel.wink.sdk.extranet.property.model.UpdatePropertyAmenitiesAndServicesRequestSupplier;
import travel.wink.sdk.extranet.property.model.UpsertContactInfoRequestSupplier;
import travel.wink.sdk.extranet.property.model.UpsertPropertyAddressRequestSupplier;
import travel.wink.sdk.extranet.property.model.UpsertPropertyProfileRequestSupplier;
import travel.wink.sdk.extranet.property.model.UpsertWelcomeTextRequestSupplier;

public class PropertyApi {
    private ApiClient apiClient;

    public PropertyApi() {
        this(new ApiClient());
    }

    @Autowired
    public PropertyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec changePropertyNameRequestCreation(@Nonnull String propertyIdentifier, @Nonnull ChangePropertyNameRequestSupplier changePropertyNameRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ChangePropertyNameRequestSupplier postBody = changePropertyNameRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling changePropertyName", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (changePropertyNameRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'changePropertyNameRequestSupplier' when calling changePropertyName", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/change-name", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertySupplier> changePropertyName(@Nonnull String propertyIdentifier, @Nonnull ChangePropertyNameRequestSupplier changePropertyNameRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.changePropertyNameRequestCreation(propertyIdentifier, changePropertyNameRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertySupplier>> changePropertyNameWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull ChangePropertyNameRequestSupplier changePropertyNameRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.changePropertyNameRequestCreation(propertyIdentifier, changePropertyNameRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec changePropertyNameWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull ChangePropertyNameRequestSupplier changePropertyNameRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.changePropertyNameRequestCreation(propertyIdentifier, changePropertyNameRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec improveWelcomeTextRequestCreation(@Nonnull String propertyIdentifier, @Nonnull ImproveWelcomeTextRequestSupplier improveWelcomeTextRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ImproveWelcomeTextRequestSupplier postBody = improveWelcomeTextRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling improveWelcomeText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (improveWelcomeTextRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'improveWelcomeTextRequestSupplier' when calling improveWelcomeText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SimpleDescriptionSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleDescriptionSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/welcome-text/improve", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SimpleDescriptionSupplier> improveWelcomeText(@Nonnull String propertyIdentifier, @Nonnull ImproveWelcomeTextRequestSupplier improveWelcomeTextRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleDescriptionSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleDescriptionSupplier>(this){};
        return this.improveWelcomeTextRequestCreation(propertyIdentifier, improveWelcomeTextRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SimpleDescriptionSupplier>> improveWelcomeTextWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull ImproveWelcomeTextRequestSupplier improveWelcomeTextRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleDescriptionSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleDescriptionSupplier>(this){};
        return this.improveWelcomeTextRequestCreation(propertyIdentifier, improveWelcomeTextRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec improveWelcomeTextWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull ImproveWelcomeTextRequestSupplier improveWelcomeTextRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.improveWelcomeTextRequestCreation(propertyIdentifier, improveWelcomeTextRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec isHotelNameUniqueRequestCreation(@Nonnull String key, @Nullable String hotelIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (key == null) {
            throw new WebClientResponseException("Missing the required parameter 'key' when calling isHotelNameUnique", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "key", key));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "hotelIdentifier", hotelIdentifier));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<UniqueResultSupplier> localVarReturnType = new ParameterizedTypeReference<UniqueResultSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/unique/name", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<UniqueResultSupplier> isHotelNameUnique(@Nonnull String key, @Nullable String hotelIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResultSupplier> localVarReturnType = new ParameterizedTypeReference<UniqueResultSupplier>(this){};
        return this.isHotelNameUniqueRequestCreation(key, hotelIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<UniqueResultSupplier>> isHotelNameUniqueWithHttpInfo(@Nonnull String key, @Nullable String hotelIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResultSupplier> localVarReturnType = new ParameterizedTypeReference<UniqueResultSupplier>(this){};
        return this.isHotelNameUniqueRequestCreation(key, hotelIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec isHotelNameUniqueWithResponseSpec(@Nonnull String key, @Nullable String hotelIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.isHotelNameUniqueRequestCreation(key, hotelIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec isHotelUrlNameUniqueRequestCreation(@Nonnull String urlName, @Nullable String hotelIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (urlName == null) {
            throw new WebClientResponseException("Missing the required parameter 'urlName' when calling isHotelUrlNameUnique", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "urlName", urlName));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "hotelIdentifier", hotelIdentifier));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<UniqueResultSupplier> localVarReturnType = new ParameterizedTypeReference<UniqueResultSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/unique/url-name", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<UniqueResultSupplier> isHotelUrlNameUnique(@Nonnull String urlName, @Nullable String hotelIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResultSupplier> localVarReturnType = new ParameterizedTypeReference<UniqueResultSupplier>(this){};
        return this.isHotelUrlNameUniqueRequestCreation(urlName, hotelIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<UniqueResultSupplier>> isHotelUrlNameUniqueWithHttpInfo(@Nonnull String urlName, @Nullable String hotelIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResultSupplier> localVarReturnType = new ParameterizedTypeReference<UniqueResultSupplier>(this){};
        return this.isHotelUrlNameUniqueRequestCreation(urlName, hotelIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec isHotelUrlNameUniqueWithResponseSpec(@Nonnull String urlName, @Nullable String hotelIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.isHotelUrlNameUniqueRequestCreation(urlName, hotelIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec propertySearchRequestCreation(@Nonnull StateSupplier stateSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        StateSupplier postBody = stateSupplier;
        if (stateSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateSupplier' when calling propertySearch", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PagePropertySupplier> localVarReturnType = new ParameterizedTypeReference<PagePropertySupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PagePropertySupplier> propertySearch(@Nonnull StateSupplier stateSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PagePropertySupplier> localVarReturnType = new ParameterizedTypeReference<PagePropertySupplier>(this){};
        return this.propertySearchRequestCreation(stateSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PagePropertySupplier>> propertySearchWithHttpInfo(@Nonnull StateSupplier stateSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PagePropertySupplier> localVarReturnType = new ParameterizedTypeReference<PagePropertySupplier>(this){};
        return this.propertySearchRequestCreation(stateSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec propertySearchWithResponseSpec(@Nonnull StateSupplier stateSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.propertySearchRequestCreation(stateSupplier, winkVersion);
    }

    private WebClient.ResponseSpec showHotelByManagerRequestCreation(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showHotelByManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertySupplier> showHotelByManager(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.showHotelByManagerRequestCreation(propertyIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertySupplier>> showHotelByManagerWithHttpInfo(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.showHotelByManagerRequestCreation(propertyIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showHotelByManagerWithResponseSpec(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showHotelByManagerRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showHotelStatusRequestCreation(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showHotelStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<UpdateExternalHotelStatusRequestSupplier> localVarReturnType = new ParameterizedTypeReference<UpdateExternalHotelStatusRequestSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/status", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<UpdateExternalHotelStatusRequestSupplier> showHotelStatus(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateExternalHotelStatusRequestSupplier> localVarReturnType = new ParameterizedTypeReference<UpdateExternalHotelStatusRequestSupplier>(this){};
        return this.showHotelStatusRequestCreation(propertyIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<UpdateExternalHotelStatusRequestSupplier>> showHotelStatusWithHttpInfo(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateExternalHotelStatusRequestSupplier> localVarReturnType = new ParameterizedTypeReference<UpdateExternalHotelStatusRequestSupplier>(this){};
        return this.showHotelStatusRequestCreation(propertyIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showHotelStatusWithResponseSpec(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showHotelStatusRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showHotelsByManagerRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PropertyLightweightSupplier> localVarReturnType = new ParameterizedTypeReference<PropertyLightweightSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<PropertyLightweightSupplier> showHotelsByManager(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyLightweightSupplier> localVarReturnType = new ParameterizedTypeReference<PropertyLightweightSupplier>(this){};
        return this.showHotelsByManagerRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<PropertyLightweightSupplier>>> showHotelsByManagerWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyLightweightSupplier> localVarReturnType = new ParameterizedTypeReference<PropertyLightweightSupplier>(this){};
        return this.showHotelsByManagerRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showHotelsByManagerWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showHotelsByManagerRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec suggestPropertyProfileRequestCreation(@Nonnull String propertyIdentifier, @Nonnull SuggestProfileRequestSupplier suggestProfileRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        SuggestProfileRequestSupplier postBody = suggestProfileRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling suggestPropertyProfile", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (suggestProfileRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'suggestProfileRequestSupplier' when calling suggestPropertyProfile", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SuggestProfileResponseSupplier> localVarReturnType = new ParameterizedTypeReference<SuggestProfileResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/profile/suggest", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SuggestProfileResponseSupplier> suggestPropertyProfile(@Nonnull String propertyIdentifier, @Nonnull SuggestProfileRequestSupplier suggestProfileRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SuggestProfileResponseSupplier> localVarReturnType = new ParameterizedTypeReference<SuggestProfileResponseSupplier>(this){};
        return this.suggestPropertyProfileRequestCreation(propertyIdentifier, suggestProfileRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SuggestProfileResponseSupplier>> suggestPropertyProfileWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull SuggestProfileRequestSupplier suggestProfileRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SuggestProfileResponseSupplier> localVarReturnType = new ParameterizedTypeReference<SuggestProfileResponseSupplier>(this){};
        return this.suggestPropertyProfileRequestCreation(propertyIdentifier, suggestProfileRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec suggestPropertyProfileWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull SuggestProfileRequestSupplier suggestProfileRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.suggestPropertyProfileRequestCreation(propertyIdentifier, suggestProfileRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec suggestPropertyWelcomeTextRequestCreation(@Nonnull String propertyIdentifier, @Nonnull SuggestWelcomeTextRequestSupplier suggestWelcomeTextRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        SuggestWelcomeTextRequestSupplier postBody = suggestWelcomeTextRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling suggestPropertyWelcomeText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (suggestWelcomeTextRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'suggestWelcomeTextRequestSupplier' when calling suggestPropertyWelcomeText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SimpleDescriptionSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleDescriptionSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/welcome-text/suggest", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SimpleDescriptionSupplier> suggestPropertyWelcomeText(@Nonnull String propertyIdentifier, @Nonnull SuggestWelcomeTextRequestSupplier suggestWelcomeTextRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleDescriptionSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleDescriptionSupplier>(this){};
        return this.suggestPropertyWelcomeTextRequestCreation(propertyIdentifier, suggestWelcomeTextRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SimpleDescriptionSupplier>> suggestPropertyWelcomeTextWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull SuggestWelcomeTextRequestSupplier suggestWelcomeTextRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleDescriptionSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleDescriptionSupplier>(this){};
        return this.suggestPropertyWelcomeTextRequestCreation(propertyIdentifier, suggestWelcomeTextRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec suggestPropertyWelcomeTextWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull SuggestWelcomeTextRequestSupplier suggestWelcomeTextRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.suggestPropertyWelcomeTextRequestCreation(propertyIdentifier, suggestWelcomeTextRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec suggestPropertyWelcomeText1RequestCreation(@Nonnull String propertyIdentifier, @Nonnull SuggestAmenitiesRequestSupplier suggestAmenitiesRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        SuggestAmenitiesRequestSupplier postBody = suggestAmenitiesRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling suggestPropertyWelcomeText1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (suggestAmenitiesRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'suggestAmenitiesRequestSupplier' when calling suggestPropertyWelcomeText1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/services/suggest", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairSupplier> suggestPropertyWelcomeText1(@Nonnull String propertyIdentifier, @Nonnull SuggestAmenitiesRequestSupplier suggestAmenitiesRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.suggestPropertyWelcomeText1RequestCreation(propertyIdentifier, suggestAmenitiesRequestSupplier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> suggestPropertyWelcomeText1WithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull SuggestAmenitiesRequestSupplier suggestAmenitiesRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.suggestPropertyWelcomeText1RequestCreation(propertyIdentifier, suggestAmenitiesRequestSupplier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec suggestPropertyWelcomeText1WithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull SuggestAmenitiesRequestSupplier suggestAmenitiesRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.suggestPropertyWelcomeText1RequestCreation(propertyIdentifier, suggestAmenitiesRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec updateAddressRequestCreation(@Nonnull String propertyIdentifier, @Nonnull UpsertPropertyAddressRequestSupplier upsertPropertyAddressRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertPropertyAddressRequestSupplier postBody = upsertPropertyAddressRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateAddress", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertPropertyAddressRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertPropertyAddressRequestSupplier' when calling updateAddress", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/address", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertySupplier> updateAddress(@Nonnull String propertyIdentifier, @Nonnull UpsertPropertyAddressRequestSupplier upsertPropertyAddressRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.updateAddressRequestCreation(propertyIdentifier, upsertPropertyAddressRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertySupplier>> updateAddressWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull UpsertPropertyAddressRequestSupplier upsertPropertyAddressRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.updateAddressRequestCreation(propertyIdentifier, upsertPropertyAddressRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateAddressWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull UpsertPropertyAddressRequestSupplier upsertPropertyAddressRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateAddressRequestCreation(propertyIdentifier, upsertPropertyAddressRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec updateGeneralManagerRequestCreation(@Nonnull String propertyIdentifier, @Nonnull GeneralManagerSupplier generalManagerSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        GeneralManagerSupplier postBody = generalManagerSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateGeneralManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (generalManagerSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'generalManagerSupplier' when calling updateGeneralManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/general-manager", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertySupplier> updateGeneralManager(@Nonnull String propertyIdentifier, @Nonnull GeneralManagerSupplier generalManagerSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.updateGeneralManagerRequestCreation(propertyIdentifier, generalManagerSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertySupplier>> updateGeneralManagerWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull GeneralManagerSupplier generalManagerSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.updateGeneralManagerRequestCreation(propertyIdentifier, generalManagerSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateGeneralManagerWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull GeneralManagerSupplier generalManagerSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateGeneralManagerRequestCreation(propertyIdentifier, generalManagerSupplier, winkVersion);
    }

    private WebClient.ResponseSpec updateHotelStatusRequestCreation(@Nonnull String propertyIdentifier, @Nonnull UpdateExternalHotelStatusRequestSupplier updateExternalHotelStatusRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        UpdateExternalHotelStatusRequestSupplier postBody = updateExternalHotelStatusRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateHotelStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (updateExternalHotelStatusRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateExternalHotelStatusRequestSupplier' when calling updateHotelStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/status", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertySupplier> updateHotelStatus(@Nonnull String propertyIdentifier, @Nonnull UpdateExternalHotelStatusRequestSupplier updateExternalHotelStatusRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.updateHotelStatusRequestCreation(propertyIdentifier, updateExternalHotelStatusRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertySupplier>> updateHotelStatusWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull UpdateExternalHotelStatusRequestSupplier updateExternalHotelStatusRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.updateHotelStatusRequestCreation(propertyIdentifier, updateExternalHotelStatusRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateHotelStatusWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull UpdateExternalHotelStatusRequestSupplier updateExternalHotelStatusRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateHotelStatusRequestCreation(propertyIdentifier, updateExternalHotelStatusRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec updatePropertyProfileRequestCreation(@Nonnull String propertyIdentifier, @Nonnull UpsertPropertyProfileRequestSupplier upsertPropertyProfileRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertPropertyProfileRequestSupplier postBody = upsertPropertyProfileRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updatePropertyProfile", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertPropertyProfileRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertPropertyProfileRequestSupplier' when calling updatePropertyProfile", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/profile", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertySupplier> updatePropertyProfile(@Nonnull String propertyIdentifier, @Nonnull UpsertPropertyProfileRequestSupplier upsertPropertyProfileRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.updatePropertyProfileRequestCreation(propertyIdentifier, upsertPropertyProfileRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertySupplier>> updatePropertyProfileWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull UpsertPropertyProfileRequestSupplier upsertPropertyProfileRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.updatePropertyProfileRequestCreation(propertyIdentifier, upsertPropertyProfileRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updatePropertyProfileWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull UpsertPropertyProfileRequestSupplier upsertPropertyProfileRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updatePropertyProfileRequestCreation(propertyIdentifier, upsertPropertyProfileRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec updateReservationsDeskRequestCreation(@Nonnull String propertyIdentifier, @Nonnull UpsertContactInfoRequestSupplier upsertContactInfoRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertContactInfoRequestSupplier postBody = upsertContactInfoRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateReservationsDesk", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertContactInfoRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertContactInfoRequestSupplier' when calling updateReservationsDesk", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/contact-info", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertySupplier> updateReservationsDesk(@Nonnull String propertyIdentifier, @Nonnull UpsertContactInfoRequestSupplier upsertContactInfoRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.updateReservationsDeskRequestCreation(propertyIdentifier, upsertContactInfoRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertySupplier>> updateReservationsDeskWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull UpsertContactInfoRequestSupplier upsertContactInfoRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.updateReservationsDeskRequestCreation(propertyIdentifier, upsertContactInfoRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateReservationsDeskWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull UpsertContactInfoRequestSupplier upsertContactInfoRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateReservationsDeskRequestCreation(propertyIdentifier, upsertContactInfoRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec updateServicesRequestCreation(@Nonnull String propertyIdentifier, @Nonnull UpdatePropertyAmenitiesAndServicesRequestSupplier updatePropertyAmenitiesAndServicesRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        UpdatePropertyAmenitiesAndServicesRequestSupplier postBody = updatePropertyAmenitiesAndServicesRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateServices", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (updatePropertyAmenitiesAndServicesRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'updatePropertyAmenitiesAndServicesRequestSupplier' when calling updateServices", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/services", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertySupplier> updateServices(@Nonnull String propertyIdentifier, @Nonnull UpdatePropertyAmenitiesAndServicesRequestSupplier updatePropertyAmenitiesAndServicesRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.updateServicesRequestCreation(propertyIdentifier, updatePropertyAmenitiesAndServicesRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertySupplier>> updateServicesWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull UpdatePropertyAmenitiesAndServicesRequestSupplier updatePropertyAmenitiesAndServicesRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.updateServicesRequestCreation(propertyIdentifier, updatePropertyAmenitiesAndServicesRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateServicesWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull UpdatePropertyAmenitiesAndServicesRequestSupplier updatePropertyAmenitiesAndServicesRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateServicesRequestCreation(propertyIdentifier, updatePropertyAmenitiesAndServicesRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec updateWelcomeTextRequestCreation(@Nonnull String propertyIdentifier, @Nonnull UpsertWelcomeTextRequestSupplier upsertWelcomeTextRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertWelcomeTextRequestSupplier postBody = upsertWelcomeTextRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateWelcomeText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertWelcomeTextRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertWelcomeTextRequestSupplier' when calling updateWelcomeText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/welcome-text", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertySupplier> updateWelcomeText(@Nonnull String propertyIdentifier, @Nonnull UpsertWelcomeTextRequestSupplier upsertWelcomeTextRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.updateWelcomeTextRequestCreation(propertyIdentifier, upsertWelcomeTextRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertySupplier>> updateWelcomeTextWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull UpsertWelcomeTextRequestSupplier upsertWelcomeTextRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.updateWelcomeTextRequestCreation(propertyIdentifier, upsertWelcomeTextRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateWelcomeTextWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull UpsertWelcomeTextRequestSupplier upsertWelcomeTextRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateWelcomeTextRequestCreation(propertyIdentifier, upsertWelcomeTextRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec uploadGeneralManagerProfilePictureRequestCreation(@Nonnull String propertyIdentifier, @Nonnull File _file) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling uploadGeneralManagerProfilePicture", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (_file == null) {
            throw new WebClientResponseException("Missing the required parameter '_file' when calling uploadGeneralManagerProfilePicture", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (_file != null) {
            formParams.add((Object)"file", (Object)new FileSystemResource(_file));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/multimedia/general-manager/upload", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertySupplier> uploadGeneralManagerProfilePicture(@Nonnull String propertyIdentifier, @Nonnull File _file) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.uploadGeneralManagerProfilePictureRequestCreation(propertyIdentifier, _file).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertySupplier>> uploadGeneralManagerProfilePictureWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull File _file) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.uploadGeneralManagerProfilePictureRequestCreation(propertyIdentifier, _file).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec uploadGeneralManagerProfilePictureWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull File _file) throws WebClientResponseException {
        return this.uploadGeneralManagerProfilePictureRequestCreation(propertyIdentifier, _file);
    }
}

