/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.property.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.property.invoker.ApiClient;
import travel.wink.sdk.extranet.property.model.PropertySupplier;
import travel.wink.sdk.extranet.property.model.SocialNetworksRequestSupplier;
import travel.wink.sdk.extranet.property.model.SocialNetworksResponseSupplier;

public class SocialNetworkApi {
    private ApiClient apiClient;

    public SocialNetworkApi() {
        this(new ApiClient());
    }

    @Autowired
    public SocialNetworkApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec showSocialNetworksRequestCreation(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showSocialNetworks", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SocialNetworksResponseSupplier> localVarReturnType = new ParameterizedTypeReference<SocialNetworksResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/social-networks", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SocialNetworksResponseSupplier> showSocialNetworks(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SocialNetworksResponseSupplier> localVarReturnType = new ParameterizedTypeReference<SocialNetworksResponseSupplier>(this){};
        return this.showSocialNetworksRequestCreation(propertyIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SocialNetworksResponseSupplier>> showSocialNetworksWithHttpInfo(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SocialNetworksResponseSupplier> localVarReturnType = new ParameterizedTypeReference<SocialNetworksResponseSupplier>(this){};
        return this.showSocialNetworksRequestCreation(propertyIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSocialNetworksWithResponseSpec(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showSocialNetworksRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec updateSocialsRequestCreation(@Nonnull String propertyIdentifier, @Nonnull SocialNetworksRequestSupplier socialNetworksRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        SocialNetworksRequestSupplier postBody = socialNetworksRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateSocials", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (socialNetworksRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'socialNetworksRequestSupplier' when calling updateSocials", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/social-networks", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertySupplier> updateSocials(@Nonnull String propertyIdentifier, @Nonnull SocialNetworksRequestSupplier socialNetworksRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.updateSocialsRequestCreation(propertyIdentifier, socialNetworksRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertySupplier>> updateSocialsWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull SocialNetworksRequestSupplier socialNetworksRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertySupplier> localVarReturnType = new ParameterizedTypeReference<PropertySupplier>(this){};
        return this.updateSocialsRequestCreation(propertyIdentifier, socialNetworksRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateSocialsWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull SocialNetworksRequestSupplier socialNetworksRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateSocialsRequestCreation(propertyIdentifier, socialNetworksRequestSupplier, winkVersion);
    }
}

