/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.property.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.extranet.property.model.SimpleDescriptionSupplier;

@JsonPropertyOrder(value={"id", "createdDate", "lastUpdate", "version", "hotelIdentifier", "startDate", "endDate", "descriptions", "showTitle", "showAlways"})
@JsonTypeName(value="Announcement_Supplier")
public class AnnouncementSupplier {
    public static final String JSON_PROPERTY_ID = "id";
    @Nullable
    private String id;
    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    @Nullable
    private LocalDateTime createdDate;
    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    @Nullable
    private LocalDateTime lastUpdate;
    public static final String JSON_PROPERTY_VERSION = "version";
    @Nullable
    private Long version;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    @Nonnull
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    @Nullable
    private LocalDate startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    @Nullable
    private LocalDate endDate;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    @Nonnull
    private List<@Valid SimpleDescriptionSupplier> descriptions = new ArrayList<SimpleDescriptionSupplier>();
    public static final String JSON_PROPERTY_SHOW_TITLE = "showTitle";
    @Nullable
    private Boolean showTitle = false;
    public static final String JSON_PROPERTY_SHOW_ALWAYS = "showAlways";
    @Nullable
    private Boolean showAlways = false;

    public AnnouncementSupplier id(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(@Nullable String id) {
        this.id = id;
    }

    public AnnouncementSupplier createdDate(@Nullable LocalDateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedDate(@Nullable LocalDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public AnnouncementSupplier lastUpdate(@Nullable LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastUpdate(@Nullable LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public AnnouncementSupplier version(@Nullable Long version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(@Nullable Long version) {
        this.version = version;
    }

    public AnnouncementSupplier hotelIdentifier(@Nonnull UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(@Nonnull UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public AnnouncementSupplier startDate(@Nullable LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartDate(@Nullable LocalDate startDate) {
        this.startDate = startDate;
    }

    public AnnouncementSupplier endDate(@Nullable LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndDate(@Nullable LocalDate endDate) {
        this.endDate = endDate;
    }

    public AnnouncementSupplier descriptions(@Nonnull List<@Valid SimpleDescriptionSupplier> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public AnnouncementSupplier addDescriptionsItem(SimpleDescriptionSupplier descriptionsItem) {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<SimpleDescriptionSupplier>();
        }
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<@Valid SimpleDescriptionSupplier> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(@Nonnull List<@Valid SimpleDescriptionSupplier> descriptions) {
        this.descriptions = descriptions;
    }

    public AnnouncementSupplier showTitle(@Nullable Boolean showTitle) {
        this.showTitle = showTitle;
        return this;
    }

    @Nullable
    @JsonProperty(value="showTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowTitle() {
        return this.showTitle;
    }

    @JsonProperty(value="showTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowTitle(@Nullable Boolean showTitle) {
        this.showTitle = showTitle;
    }

    public AnnouncementSupplier showAlways(@Nullable Boolean showAlways) {
        this.showAlways = showAlways;
        return this;
    }

    @Nullable
    @JsonProperty(value="showAlways")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowAlways() {
        return this.showAlways;
    }

    @JsonProperty(value="showAlways")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowAlways(@Nullable Boolean showAlways) {
        this.showAlways = showAlways;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnouncementSupplier announcementSupplier = (AnnouncementSupplier)o;
        return Objects.equals(this.id, announcementSupplier.id) && Objects.equals(this.createdDate, announcementSupplier.createdDate) && Objects.equals(this.lastUpdate, announcementSupplier.lastUpdate) && Objects.equals(this.version, announcementSupplier.version) && Objects.equals(this.hotelIdentifier, announcementSupplier.hotelIdentifier) && Objects.equals(this.startDate, announcementSupplier.startDate) && Objects.equals(this.endDate, announcementSupplier.endDate) && Objects.equals(this.descriptions, announcementSupplier.descriptions) && Objects.equals(this.showTitle, announcementSupplier.showTitle) && Objects.equals(this.showAlways, announcementSupplier.showAlways);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdDate, this.lastUpdate, this.version, this.hotelIdentifier, this.startDate, this.endDate, this.descriptions, this.showTitle, this.showAlways);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnnouncementSupplier {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    showTitle: ").append(this.toIndentedString(this.showTitle)).append("\n");
        sb.append("    showAlways: ").append(this.toIndentedString(this.showAlways)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

