/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.property.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"hotelIdentifier", "name", "urlName", "currencyCode", "status", "externalStatus", "stars", "numberOfRooms", "active", "propertyActive", "platformActive"})
@JsonTypeName(value="PropertyLightweight_Supplier")
public class PropertyLightweightSupplier {
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    @Nonnull
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_URL_NAME = "urlName";
    @Nonnull
    private String urlName;
    public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
    @Nonnull
    private String currencyCode;
    public static final String JSON_PROPERTY_STATUS = "status";
    @Nonnull
    private StatusEnum status = StatusEnum.APPROVED;
    public static final String JSON_PROPERTY_EXTERNAL_STATUS = "externalStatus";
    @Nonnull
    private ExternalStatusEnum externalStatus = ExternalStatusEnum.ACTIVE;
    public static final String JSON_PROPERTY_STARS = "stars";
    @Nullable
    private Integer stars;
    public static final String JSON_PROPERTY_NUMBER_OF_ROOMS = "numberOfRooms";
    @Nonnull
    private Integer numberOfRooms;
    public static final String JSON_PROPERTY_ACTIVE = "active";
    @Nullable
    private Boolean active;
    public static final String JSON_PROPERTY_PROPERTY_ACTIVE = "propertyActive";
    @Nullable
    private Boolean propertyActive;
    public static final String JSON_PROPERTY_PLATFORM_ACTIVE = "platformActive";
    @Nullable
    private Boolean platformActive;

    public PropertyLightweightSupplier hotelIdentifier(@Nonnull UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(@Nonnull UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public PropertyLightweightSupplier name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public PropertyLightweightSupplier urlName(@Nonnull String urlName) {
        this.urlName = urlName;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="urlName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getUrlName() {
        return this.urlName;
    }

    @JsonProperty(value="urlName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUrlName(@Nonnull String urlName) {
        this.urlName = urlName;
    }

    public PropertyLightweightSupplier currencyCode(@Nonnull String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrencyCode(@Nonnull String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public PropertyLightweightSupplier status(@Nonnull StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(@Nonnull StatusEnum status) {
        this.status = status;
    }

    public PropertyLightweightSupplier externalStatus(@Nonnull ExternalStatusEnum externalStatus) {
        this.externalStatus = externalStatus;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="externalStatus")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ExternalStatusEnum getExternalStatus() {
        return this.externalStatus;
    }

    @JsonProperty(value="externalStatus")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExternalStatus(@Nonnull ExternalStatusEnum externalStatus) {
        this.externalStatus = externalStatus;
    }

    public PropertyLightweightSupplier stars(@Nullable Integer stars) {
        this.stars = stars;
        return this;
    }

    @Nullable
    @Min(value=0L)
    @Max(value=6L)
    @JsonProperty(value="stars")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Min(value=0L) @Max(value=6L) Integer getStars() {
        return this.stars;
    }

    @JsonProperty(value="stars")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStars(@Nullable Integer stars) {
        this.stars = stars;
    }

    public PropertyLightweightSupplier numberOfRooms(@Nonnull Integer numberOfRooms) {
        this.numberOfRooms = numberOfRooms;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="numberOfRooms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getNumberOfRooms() {
        return this.numberOfRooms;
    }

    @JsonProperty(value="numberOfRooms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNumberOfRooms(@Nonnull Integer numberOfRooms) {
        this.numberOfRooms = numberOfRooms;
    }

    public PropertyLightweightSupplier active(@Nullable Boolean active) {
        this.active = active;
        return this;
    }

    @Nullable
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActive(@Nullable Boolean active) {
        this.active = active;
    }

    public PropertyLightweightSupplier propertyActive(@Nullable Boolean propertyActive) {
        this.propertyActive = propertyActive;
        return this;
    }

    @Nullable
    @JsonProperty(value="propertyActive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPropertyActive() {
        return this.propertyActive;
    }

    @JsonProperty(value="propertyActive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPropertyActive(@Nullable Boolean propertyActive) {
        this.propertyActive = propertyActive;
    }

    public PropertyLightweightSupplier platformActive(@Nullable Boolean platformActive) {
        this.platformActive = platformActive;
        return this;
    }

    @Nullable
    @JsonProperty(value="platformActive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPlatformActive() {
        return this.platformActive;
    }

    @JsonProperty(value="platformActive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlatformActive(@Nullable Boolean platformActive) {
        this.platformActive = platformActive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyLightweightSupplier propertyLightweightSupplier = (PropertyLightweightSupplier)o;
        return Objects.equals(this.hotelIdentifier, propertyLightweightSupplier.hotelIdentifier) && Objects.equals(this.name, propertyLightweightSupplier.name) && Objects.equals(this.urlName, propertyLightweightSupplier.urlName) && Objects.equals(this.currencyCode, propertyLightweightSupplier.currencyCode) && Objects.equals((Object)this.status, (Object)propertyLightweightSupplier.status) && Objects.equals((Object)this.externalStatus, (Object)propertyLightweightSupplier.externalStatus) && Objects.equals(this.stars, propertyLightweightSupplier.stars) && Objects.equals(this.numberOfRooms, propertyLightweightSupplier.numberOfRooms) && Objects.equals(this.active, propertyLightweightSupplier.active) && Objects.equals(this.propertyActive, propertyLightweightSupplier.propertyActive) && Objects.equals(this.platformActive, propertyLightweightSupplier.platformActive);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hotelIdentifier, this.name, this.urlName, this.currencyCode, this.status, this.externalStatus, this.stars, this.numberOfRooms, this.active, this.propertyActive, this.platformActive});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PropertyLightweightSupplier {\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    urlName: ").append(this.toIndentedString(this.urlName)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    externalStatus: ").append(this.toIndentedString((Object)this.externalStatus)).append("\n");
        sb.append("    stars: ").append(this.toIndentedString(this.stars)).append("\n");
        sb.append("    numberOfRooms: ").append(this.toIndentedString(this.numberOfRooms)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    propertyActive: ").append(this.toIndentedString(this.propertyActive)).append("\n");
        sb.append("    platformActive: ").append(this.toIndentedString(this.platformActive)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        PENDING_APPROVAL(String.valueOf("PENDING_APPROVAL")),
        APPROVED(String.valueOf("APPROVED")),
        UNDER_REVIEW(String.valueOf("UNDER_REVIEW")),
        SUSPENDED(String.valueOf("SUSPENDED")),
        REMOVED(String.valueOf("REMOVED"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ExternalStatusEnum {
        ACTIVE(String.valueOf("ACTIVE")),
        INACTIVE(String.valueOf("INACTIVE"));

        private String value;

        private ExternalStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ExternalStatusEnum fromValue(String value) {
            for (ExternalStatusEnum b : ExternalStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

