/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.property.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import travel.wink.sdk.extranet.property.model.AddressSupplier;
import travel.wink.sdk.extranet.property.model.AggregateGreendexAnswersSupplier;
import travel.wink.sdk.extranet.property.model.ContactSupplier;
import travel.wink.sdk.extranet.property.model.GeneralManagerSupplier;
import travel.wink.sdk.extranet.property.model.GeoJsonPointSupplier;
import travel.wink.sdk.extranet.property.model.KeyValuePairSupplier;
import travel.wink.sdk.extranet.property.model.PropertyPolicySupplier;
import travel.wink.sdk.extranet.property.model.SimpleDescriptionSupplier;
import travel.wink.sdk.extranet.property.model.SimpleMultimediaSupplier;
import travel.wink.sdk.extranet.property.model.SocialSupplier;
import travel.wink.sdk.extranet.property.model.TravelInventoryRecognitionSupplier;

@JsonPropertyOrder(value={"id", "createdDate", "lastUpdate", "version", "name", "hotelCode", "localName", "legalName", "urlName", "currencyCode", "status", "externalStatus", "multimedias", "recognitionList", "locationCategory", "segmentCategory", "hotelCategory", "architecturalStyle", "whenBuilt", "hotelChain", "hotelBrand", "otherChannelManager", "licenseNumber", "stars", "generalManager", "descriptions", "hotelAmenityCodes", "propertyAccessibilityCodes", "propertySecurityCodes", "locationPoint", "policy", "socials", "ownerContact", "reservationsContact", "revenueContact", "marketingContact", "lifestyleTypes", "greenIndexScores", "agreementAccepted", "marketingOptinAllowed", "logo", "numberOfRooms", "address", "reservationDeskStartTime", "reservationDeskEndTime", "website", "googleMapsUrl", "metadata", "rateProvider", "previousUrlNameList", "active", "propertyActive", "platformActive", "socialNetworks", "lifestyles", "fullAddress", "contractSignerFullName"})
@JsonTypeName(value="Property_Supplier")
public class PropertySupplier {
    public static final String JSON_PROPERTY_ID = "id";
    @Nullable
    private String id;
    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    @Nullable
    private LocalDateTime createdDate;
    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    @Nullable
    private LocalDateTime lastUpdate;
    public static final String JSON_PROPERTY_VERSION = "version";
    @Nullable
    private Long version;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_HOTEL_CODE = "hotelCode";
    @Nonnull
    private String hotelCode;
    public static final String JSON_PROPERTY_LOCAL_NAME = "localName";
    @Nullable
    private String localName;
    public static final String JSON_PROPERTY_LEGAL_NAME = "legalName";
    @Nonnull
    private String legalName;
    public static final String JSON_PROPERTY_URL_NAME = "urlName";
    @Nonnull
    private String urlName;
    public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
    @Nonnull
    private String currencyCode;
    public static final String JSON_PROPERTY_STATUS = "status";
    @Nonnull
    private StatusEnum status = StatusEnum.APPROVED;
    public static final String JSON_PROPERTY_EXTERNAL_STATUS = "externalStatus";
    @Nonnull
    private ExternalStatusEnum externalStatus = ExternalStatusEnum.ACTIVE;
    public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
    @Nullable
    private List<@Valid SimpleMultimediaSupplier> multimedias = new ArrayList<SimpleMultimediaSupplier>();
    public static final String JSON_PROPERTY_RECOGNITION_LIST = "recognitionList";
    @Nullable
    private List<@Valid TravelInventoryRecognitionSupplier> recognitionList = new ArrayList<TravelInventoryRecognitionSupplier>();
    public static final String JSON_PROPERTY_LOCATION_CATEGORY = "locationCategory";
    @Nullable
    private String locationCategory;
    public static final String JSON_PROPERTY_SEGMENT_CATEGORY = "segmentCategory";
    @Nullable
    private String segmentCategory;
    public static final String JSON_PROPERTY_HOTEL_CATEGORY = "hotelCategory";
    @Nullable
    private String hotelCategory;
    public static final String JSON_PROPERTY_ARCHITECTURAL_STYLE = "architecturalStyle";
    @Nullable
    private String architecturalStyle;
    public static final String JSON_PROPERTY_WHEN_BUILT = "whenBuilt";
    @Nullable
    private String whenBuilt;
    public static final String JSON_PROPERTY_HOTEL_CHAIN = "hotelChain";
    @Nullable
    private String hotelChain;
    public static final String JSON_PROPERTY_HOTEL_BRAND = "hotelBrand";
    @Nullable
    private String hotelBrand;
    public static final String JSON_PROPERTY_OTHER_CHANNEL_MANAGER = "otherChannelManager";
    @Nullable
    private String otherChannelManager;
    public static final String JSON_PROPERTY_LICENSE_NUMBER = "licenseNumber";
    @Nullable
    private String licenseNumber;
    public static final String JSON_PROPERTY_STARS = "stars";
    @Nullable
    private Integer stars;
    public static final String JSON_PROPERTY_GENERAL_MANAGER = "generalManager";
    @Nullable
    private GeneralManagerSupplier generalManager;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    @Nullable
    private List<@Valid SimpleDescriptionSupplier> descriptions = new ArrayList<SimpleDescriptionSupplier>();
    public static final String JSON_PROPERTY_HOTEL_AMENITY_CODES = "hotelAmenityCodes";
    @Nullable
    private List<String> hotelAmenityCodes = new ArrayList<String>();
    public static final String JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES = "propertyAccessibilityCodes";
    @Nullable
    private List<String> propertyAccessibilityCodes = new ArrayList<String>();
    public static final String JSON_PROPERTY_PROPERTY_SECURITY_CODES = "propertySecurityCodes";
    @Nullable
    private List<String> propertySecurityCodes = new ArrayList<String>();
    public static final String JSON_PROPERTY_LOCATION_POINT = "locationPoint";
    @Nullable
    private GeoJsonPointSupplier locationPoint;
    public static final String JSON_PROPERTY_POLICY = "policy";
    @Nullable
    private PropertyPolicySupplier policy;
    public static final String JSON_PROPERTY_SOCIALS = "socials";
    @Nullable
    private List<@Valid SocialSupplier> socials = new ArrayList<SocialSupplier>();
    public static final String JSON_PROPERTY_OWNER_CONTACT = "ownerContact";
    @Nullable
    private ContactSupplier ownerContact;
    public static final String JSON_PROPERTY_RESERVATIONS_CONTACT = "reservationsContact";
    @Nullable
    private ContactSupplier reservationsContact;
    public static final String JSON_PROPERTY_REVENUE_CONTACT = "revenueContact";
    @Nullable
    private ContactSupplier revenueContact;
    public static final String JSON_PROPERTY_MARKETING_CONTACT = "marketingContact";
    @Nullable
    private ContactSupplier marketingContact;
    public static final String JSON_PROPERTY_LIFESTYLE_TYPES = "lifestyleTypes";
    @Nullable
    private List<LifestyleTypesEnum> lifestyleTypes = new ArrayList<LifestyleTypesEnum>();
    public static final String JSON_PROPERTY_GREEN_INDEX_SCORES = "greenIndexScores";
    @Nullable
    private AggregateGreendexAnswersSupplier greenIndexScores;
    public static final String JSON_PROPERTY_AGREEMENT_ACCEPTED = "agreementAccepted";
    @Nonnull
    private Boolean agreementAccepted;
    public static final String JSON_PROPERTY_MARKETING_OPTIN_ALLOWED = "marketingOptinAllowed";
    @Nullable
    private Boolean marketingOptinAllowed;
    public static final String JSON_PROPERTY_LOGO = "logo";
    @Nullable
    private SimpleMultimediaSupplier logo;
    public static final String JSON_PROPERTY_NUMBER_OF_ROOMS = "numberOfRooms";
    @Nonnull
    private Integer numberOfRooms;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    @Nullable
    private AddressSupplier address;
    public static final String JSON_PROPERTY_RESERVATION_DESK_START_TIME = "reservationDeskStartTime";
    @Nullable
    private String reservationDeskStartTime;
    public static final String JSON_PROPERTY_RESERVATION_DESK_END_TIME = "reservationDeskEndTime";
    @Nullable
    private String reservationDeskEndTime;
    public static final String JSON_PROPERTY_WEBSITE = "website";
    @Nullable
    private String website;
    public static final String JSON_PROPERTY_GOOGLE_MAPS_URL = "googleMapsUrl";
    @Nullable
    private String googleMapsUrl;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    @Nullable
    private Map<String, Object> metadata = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_RATE_PROVIDER = "rateProvider";
    @Nullable
    private KeyValuePairSupplier rateProvider;
    public static final String JSON_PROPERTY_PREVIOUS_URL_NAME_LIST = "previousUrlNameList";
    @Nullable
    private List<Object> previousUrlNameList = new ArrayList<Object>();
    public static final String JSON_PROPERTY_ACTIVE = "active";
    @Nullable
    private Boolean active;
    public static final String JSON_PROPERTY_PROPERTY_ACTIVE = "propertyActive";
    @Nullable
    private Boolean propertyActive;
    public static final String JSON_PROPERTY_PLATFORM_ACTIVE = "platformActive";
    @Nullable
    private Boolean platformActive;
    public static final String JSON_PROPERTY_SOCIAL_NETWORKS = "socialNetworks";
    @Nullable
    private Boolean socialNetworks;
    public static final String JSON_PROPERTY_LIFESTYLES = "lifestyles";
    @Nullable
    private Boolean lifestyles;
    public static final String JSON_PROPERTY_FULL_ADDRESS = "fullAddress";
    @Nullable
    private String fullAddress;
    public static final String JSON_PROPERTY_CONTRACT_SIGNER_FULL_NAME = "contractSignerFullName";
    @Nullable
    private String contractSignerFullName;

    public PropertySupplier id(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(@Nullable String id) {
        this.id = id;
    }

    public PropertySupplier createdDate(@Nullable LocalDateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedDate(@Nullable LocalDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public PropertySupplier lastUpdate(@Nullable LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastUpdate(@Nullable LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public PropertySupplier version(@Nullable Long version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(@Nullable Long version) {
        this.version = version;
    }

    public PropertySupplier name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public PropertySupplier hotelCode(@Nonnull String hotelCode) {
        this.hotelCode = hotelCode;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="hotelCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getHotelCode() {
        return this.hotelCode;
    }

    @JsonProperty(value="hotelCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelCode(@Nonnull String hotelCode) {
        this.hotelCode = hotelCode;
    }

    public PropertySupplier localName(@Nullable String localName) {
        this.localName = localName;
        return this;
    }

    @Nullable
    @JsonProperty(value="localName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocalName() {
        return this.localName;
    }

    @JsonProperty(value="localName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocalName(@Nullable String localName) {
        this.localName = localName;
    }

    public PropertySupplier legalName(@Nonnull String legalName) {
        this.legalName = legalName;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="legalName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getLegalName() {
        return this.legalName;
    }

    @JsonProperty(value="legalName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLegalName(@Nonnull String legalName) {
        this.legalName = legalName;
    }

    public PropertySupplier urlName(@Nonnull String urlName) {
        this.urlName = urlName;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="urlName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getUrlName() {
        return this.urlName;
    }

    @JsonProperty(value="urlName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUrlName(@Nonnull String urlName) {
        this.urlName = urlName;
    }

    public PropertySupplier currencyCode(@Nonnull String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrencyCode(@Nonnull String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public PropertySupplier status(@Nonnull StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(@Nonnull StatusEnum status) {
        this.status = status;
    }

    public PropertySupplier externalStatus(@Nonnull ExternalStatusEnum externalStatus) {
        this.externalStatus = externalStatus;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="externalStatus")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) ExternalStatusEnum getExternalStatus() {
        return this.externalStatus;
    }

    @JsonProperty(value="externalStatus")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExternalStatus(@Nonnull ExternalStatusEnum externalStatus) {
        this.externalStatus = externalStatus;
    }

    public PropertySupplier multimedias(@Nullable List<@Valid SimpleMultimediaSupplier> multimedias) {
        this.multimedias = multimedias;
        return this;
    }

    public PropertySupplier addMultimediasItem(SimpleMultimediaSupplier multimediasItem) {
        if (this.multimedias == null) {
            this.multimedias = new ArrayList<SimpleMultimediaSupplier>();
        }
        this.multimedias.add(multimediasItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid SimpleMultimediaSupplier> getMultimedias() {
        return this.multimedias;
    }

    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMultimedias(@Nullable List<@Valid SimpleMultimediaSupplier> multimedias) {
        this.multimedias = multimedias;
    }

    public PropertySupplier recognitionList(@Nullable List<@Valid TravelInventoryRecognitionSupplier> recognitionList) {
        this.recognitionList = recognitionList;
        return this;
    }

    public PropertySupplier addRecognitionListItem(TravelInventoryRecognitionSupplier recognitionListItem) {
        if (this.recognitionList == null) {
            this.recognitionList = new ArrayList<TravelInventoryRecognitionSupplier>();
        }
        this.recognitionList.add(recognitionListItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="recognitionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid TravelInventoryRecognitionSupplier> getRecognitionList() {
        return this.recognitionList;
    }

    @JsonProperty(value="recognitionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecognitionList(@Nullable List<@Valid TravelInventoryRecognitionSupplier> recognitionList) {
        this.recognitionList = recognitionList;
    }

    public PropertySupplier locationCategory(@Nullable String locationCategory) {
        this.locationCategory = locationCategory;
        return this;
    }

    @Nullable
    @JsonProperty(value="locationCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocationCategory() {
        return this.locationCategory;
    }

    @JsonProperty(value="locationCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocationCategory(@Nullable String locationCategory) {
        this.locationCategory = locationCategory;
    }

    public PropertySupplier segmentCategory(@Nullable String segmentCategory) {
        this.segmentCategory = segmentCategory;
        return this;
    }

    @Nullable
    @JsonProperty(value="segmentCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSegmentCategory() {
        return this.segmentCategory;
    }

    @JsonProperty(value="segmentCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSegmentCategory(@Nullable String segmentCategory) {
        this.segmentCategory = segmentCategory;
    }

    public PropertySupplier hotelCategory(@Nullable String hotelCategory) {
        this.hotelCategory = hotelCategory;
        return this;
    }

    @Nullable
    @JsonProperty(value="hotelCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHotelCategory() {
        return this.hotelCategory;
    }

    @JsonProperty(value="hotelCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelCategory(@Nullable String hotelCategory) {
        this.hotelCategory = hotelCategory;
    }

    public PropertySupplier architecturalStyle(@Nullable String architecturalStyle) {
        this.architecturalStyle = architecturalStyle;
        return this;
    }

    @Nullable
    @JsonProperty(value="architecturalStyle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getArchitecturalStyle() {
        return this.architecturalStyle;
    }

    @JsonProperty(value="architecturalStyle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setArchitecturalStyle(@Nullable String architecturalStyle) {
        this.architecturalStyle = architecturalStyle;
    }

    public PropertySupplier whenBuilt(@Nullable String whenBuilt) {
        this.whenBuilt = whenBuilt;
        return this;
    }

    @Nullable
    @JsonProperty(value="whenBuilt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWhenBuilt() {
        return this.whenBuilt;
    }

    @JsonProperty(value="whenBuilt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWhenBuilt(@Nullable String whenBuilt) {
        this.whenBuilt = whenBuilt;
    }

    public PropertySupplier hotelChain(@Nullable String hotelChain) {
        this.hotelChain = hotelChain;
        return this;
    }

    @Nullable
    @JsonProperty(value="hotelChain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHotelChain() {
        return this.hotelChain;
    }

    @JsonProperty(value="hotelChain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelChain(@Nullable String hotelChain) {
        this.hotelChain = hotelChain;
    }

    public PropertySupplier hotelBrand(@Nullable String hotelBrand) {
        this.hotelBrand = hotelBrand;
        return this;
    }

    @Nullable
    @JsonProperty(value="hotelBrand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHotelBrand() {
        return this.hotelBrand;
    }

    @JsonProperty(value="hotelBrand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelBrand(@Nullable String hotelBrand) {
        this.hotelBrand = hotelBrand;
    }

    public PropertySupplier otherChannelManager(@Nullable String otherChannelManager) {
        this.otherChannelManager = otherChannelManager;
        return this;
    }

    @Nullable
    @JsonProperty(value="otherChannelManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOtherChannelManager() {
        return this.otherChannelManager;
    }

    @JsonProperty(value="otherChannelManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOtherChannelManager(@Nullable String otherChannelManager) {
        this.otherChannelManager = otherChannelManager;
    }

    public PropertySupplier licenseNumber(@Nullable String licenseNumber) {
        this.licenseNumber = licenseNumber;
        return this;
    }

    @Nullable
    @JsonProperty(value="licenseNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLicenseNumber() {
        return this.licenseNumber;
    }

    @JsonProperty(value="licenseNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLicenseNumber(@Nullable String licenseNumber) {
        this.licenseNumber = licenseNumber;
    }

    public PropertySupplier stars(@Nullable Integer stars) {
        this.stars = stars;
        return this;
    }

    @Nullable
    @Min(value=0L)
    @Max(value=6L)
    @JsonProperty(value="stars")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Min(value=0L) @Max(value=6L) Integer getStars() {
        return this.stars;
    }

    @JsonProperty(value="stars")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStars(@Nullable Integer stars) {
        this.stars = stars;
    }

    public PropertySupplier generalManager(@Nullable GeneralManagerSupplier generalManager) {
        this.generalManager = generalManager;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="generalManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GeneralManagerSupplier getGeneralManager() {
        return this.generalManager;
    }

    @JsonProperty(value="generalManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGeneralManager(@Nullable GeneralManagerSupplier generalManager) {
        this.generalManager = generalManager;
    }

    public PropertySupplier descriptions(@Nullable List<@Valid SimpleDescriptionSupplier> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public PropertySupplier addDescriptionsItem(SimpleDescriptionSupplier descriptionsItem) {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<SimpleDescriptionSupplier>();
        }
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid SimpleDescriptionSupplier> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescriptions(@Nullable List<@Valid SimpleDescriptionSupplier> descriptions) {
        this.descriptions = descriptions;
    }

    public PropertySupplier hotelAmenityCodes(@Nullable List<String> hotelAmenityCodes) {
        this.hotelAmenityCodes = hotelAmenityCodes;
        return this;
    }

    public PropertySupplier addHotelAmenityCodesItem(String hotelAmenityCodesItem) {
        if (this.hotelAmenityCodes == null) {
            this.hotelAmenityCodes = new ArrayList<String>();
        }
        this.hotelAmenityCodes.add(hotelAmenityCodesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="hotelAmenityCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getHotelAmenityCodes() {
        return this.hotelAmenityCodes;
    }

    @JsonProperty(value="hotelAmenityCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelAmenityCodes(@Nullable List<String> hotelAmenityCodes) {
        this.hotelAmenityCodes = hotelAmenityCodes;
    }

    public PropertySupplier propertyAccessibilityCodes(@Nullable List<String> propertyAccessibilityCodes) {
        this.propertyAccessibilityCodes = propertyAccessibilityCodes;
        return this;
    }

    public PropertySupplier addPropertyAccessibilityCodesItem(String propertyAccessibilityCodesItem) {
        if (this.propertyAccessibilityCodes == null) {
            this.propertyAccessibilityCodes = new ArrayList<String>();
        }
        this.propertyAccessibilityCodes.add(propertyAccessibilityCodesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="propertyAccessibilityCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPropertyAccessibilityCodes() {
        return this.propertyAccessibilityCodes;
    }

    @JsonProperty(value="propertyAccessibilityCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPropertyAccessibilityCodes(@Nullable List<String> propertyAccessibilityCodes) {
        this.propertyAccessibilityCodes = propertyAccessibilityCodes;
    }

    public PropertySupplier propertySecurityCodes(@Nullable List<String> propertySecurityCodes) {
        this.propertySecurityCodes = propertySecurityCodes;
        return this;
    }

    public PropertySupplier addPropertySecurityCodesItem(String propertySecurityCodesItem) {
        if (this.propertySecurityCodes == null) {
            this.propertySecurityCodes = new ArrayList<String>();
        }
        this.propertySecurityCodes.add(propertySecurityCodesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="propertySecurityCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPropertySecurityCodes() {
        return this.propertySecurityCodes;
    }

    @JsonProperty(value="propertySecurityCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPropertySecurityCodes(@Nullable List<String> propertySecurityCodes) {
        this.propertySecurityCodes = propertySecurityCodes;
    }

    public PropertySupplier locationPoint(@Nullable GeoJsonPointSupplier locationPoint) {
        this.locationPoint = locationPoint;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="locationPoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GeoJsonPointSupplier getLocationPoint() {
        return this.locationPoint;
    }

    @JsonProperty(value="locationPoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocationPoint(@Nullable GeoJsonPointSupplier locationPoint) {
        this.locationPoint = locationPoint;
    }

    public PropertySupplier policy(@Nullable PropertyPolicySupplier policy) {
        this.policy = policy;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PropertyPolicySupplier getPolicy() {
        return this.policy;
    }

    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolicy(@Nullable PropertyPolicySupplier policy) {
        this.policy = policy;
    }

    public PropertySupplier socials(@Nullable List<@Valid SocialSupplier> socials) {
        this.socials = socials;
        return this;
    }

    public PropertySupplier addSocialsItem(SocialSupplier socialsItem) {
        if (this.socials == null) {
            this.socials = new ArrayList<SocialSupplier>();
        }
        this.socials.add(socialsItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid SocialSupplier> getSocials() {
        return this.socials;
    }

    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocials(@Nullable List<@Valid SocialSupplier> socials) {
        this.socials = socials;
    }

    public PropertySupplier ownerContact(@Nullable ContactSupplier ownerContact) {
        this.ownerContact = ownerContact;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="ownerContact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContactSupplier getOwnerContact() {
        return this.ownerContact;
    }

    @JsonProperty(value="ownerContact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerContact(@Nullable ContactSupplier ownerContact) {
        this.ownerContact = ownerContact;
    }

    public PropertySupplier reservationsContact(@Nullable ContactSupplier reservationsContact) {
        this.reservationsContact = reservationsContact;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="reservationsContact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContactSupplier getReservationsContact() {
        return this.reservationsContact;
    }

    @JsonProperty(value="reservationsContact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReservationsContact(@Nullable ContactSupplier reservationsContact) {
        this.reservationsContact = reservationsContact;
    }

    public PropertySupplier revenueContact(@Nullable ContactSupplier revenueContact) {
        this.revenueContact = revenueContact;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="revenueContact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContactSupplier getRevenueContact() {
        return this.revenueContact;
    }

    @JsonProperty(value="revenueContact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRevenueContact(@Nullable ContactSupplier revenueContact) {
        this.revenueContact = revenueContact;
    }

    public PropertySupplier marketingContact(@Nullable ContactSupplier marketingContact) {
        this.marketingContact = marketingContact;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="marketingContact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContactSupplier getMarketingContact() {
        return this.marketingContact;
    }

    @JsonProperty(value="marketingContact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMarketingContact(@Nullable ContactSupplier marketingContact) {
        this.marketingContact = marketingContact;
    }

    public PropertySupplier lifestyleTypes(@Nullable List<LifestyleTypesEnum> lifestyleTypes) {
        this.lifestyleTypes = lifestyleTypes;
        return this;
    }

    public PropertySupplier addLifestyleTypesItem(LifestyleTypesEnum lifestyleTypesItem) {
        if (this.lifestyleTypes == null) {
            this.lifestyleTypes = new ArrayList<LifestyleTypesEnum>();
        }
        this.lifestyleTypes.add(lifestyleTypesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="lifestyleTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LifestyleTypesEnum> getLifestyleTypes() {
        return this.lifestyleTypes;
    }

    @JsonProperty(value="lifestyleTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifestyleTypes(@Nullable List<LifestyleTypesEnum> lifestyleTypes) {
        this.lifestyleTypes = lifestyleTypes;
    }

    public PropertySupplier greenIndexScores(@Nullable AggregateGreendexAnswersSupplier greenIndexScores) {
        this.greenIndexScores = greenIndexScores;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="greenIndexScores")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AggregateGreendexAnswersSupplier getGreenIndexScores() {
        return this.greenIndexScores;
    }

    @JsonProperty(value="greenIndexScores")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGreenIndexScores(@Nullable AggregateGreendexAnswersSupplier greenIndexScores) {
        this.greenIndexScores = greenIndexScores;
    }

    public PropertySupplier agreementAccepted(@Nonnull Boolean agreementAccepted) {
        this.agreementAccepted = agreementAccepted;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="agreementAccepted")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getAgreementAccepted() {
        return this.agreementAccepted;
    }

    @JsonProperty(value="agreementAccepted")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAgreementAccepted(@Nonnull Boolean agreementAccepted) {
        this.agreementAccepted = agreementAccepted;
    }

    public PropertySupplier marketingOptinAllowed(@Nullable Boolean marketingOptinAllowed) {
        this.marketingOptinAllowed = marketingOptinAllowed;
        return this;
    }

    @Nullable
    @JsonProperty(value="marketingOptinAllowed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMarketingOptinAllowed() {
        return this.marketingOptinAllowed;
    }

    @JsonProperty(value="marketingOptinAllowed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMarketingOptinAllowed(@Nullable Boolean marketingOptinAllowed) {
        this.marketingOptinAllowed = marketingOptinAllowed;
    }

    public PropertySupplier logo(@Nullable SimpleMultimediaSupplier logo) {
        this.logo = logo;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="logo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SimpleMultimediaSupplier getLogo() {
        return this.logo;
    }

    @JsonProperty(value="logo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogo(@Nullable SimpleMultimediaSupplier logo) {
        this.logo = logo;
    }

    public PropertySupplier numberOfRooms(@Nonnull Integer numberOfRooms) {
        this.numberOfRooms = numberOfRooms;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="numberOfRooms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getNumberOfRooms() {
        return this.numberOfRooms;
    }

    @JsonProperty(value="numberOfRooms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNumberOfRooms(@Nonnull Integer numberOfRooms) {
        this.numberOfRooms = numberOfRooms;
    }

    public PropertySupplier address(@Nullable AddressSupplier address) {
        this.address = address;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AddressSupplier getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(@Nullable AddressSupplier address) {
        this.address = address;
    }

    public PropertySupplier reservationDeskStartTime(@Nullable String reservationDeskStartTime) {
        this.reservationDeskStartTime = reservationDeskStartTime;
        return this;
    }

    @Nullable
    @JsonProperty(value="reservationDeskStartTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReservationDeskStartTime() {
        return this.reservationDeskStartTime;
    }

    @JsonProperty(value="reservationDeskStartTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReservationDeskStartTime(@Nullable String reservationDeskStartTime) {
        this.reservationDeskStartTime = reservationDeskStartTime;
    }

    public PropertySupplier reservationDeskEndTime(@Nullable String reservationDeskEndTime) {
        this.reservationDeskEndTime = reservationDeskEndTime;
        return this;
    }

    @Nullable
    @JsonProperty(value="reservationDeskEndTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReservationDeskEndTime() {
        return this.reservationDeskEndTime;
    }

    @JsonProperty(value="reservationDeskEndTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReservationDeskEndTime(@Nullable String reservationDeskEndTime) {
        this.reservationDeskEndTime = reservationDeskEndTime;
    }

    public PropertySupplier website(@Nullable String website) {
        this.website = website;
        return this;
    }

    @Nullable
    @JsonProperty(value="website")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWebsite() {
        return this.website;
    }

    @JsonProperty(value="website")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWebsite(@Nullable String website) {
        this.website = website;
    }

    public PropertySupplier googleMapsUrl(@Nullable String googleMapsUrl) {
        this.googleMapsUrl = googleMapsUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="googleMapsUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGoogleMapsUrl() {
        return this.googleMapsUrl;
    }

    @JsonProperty(value="googleMapsUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGoogleMapsUrl(@Nullable String googleMapsUrl) {
        this.googleMapsUrl = googleMapsUrl;
    }

    public PropertySupplier metadata(@Nullable Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    public PropertySupplier putMetadataItem(String key, Object metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, Object>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(@Nullable Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public PropertySupplier rateProvider(@Nullable KeyValuePairSupplier rateProvider) {
        this.rateProvider = rateProvider;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="rateProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public KeyValuePairSupplier getRateProvider() {
        return this.rateProvider;
    }

    @JsonProperty(value="rateProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRateProvider(@Nullable KeyValuePairSupplier rateProvider) {
        this.rateProvider = rateProvider;
    }

    public PropertySupplier previousUrlNameList(@Nullable List<Object> previousUrlNameList) {
        this.previousUrlNameList = previousUrlNameList;
        return this;
    }

    public PropertySupplier addPreviousUrlNameListItem(Object previousUrlNameListItem) {
        if (this.previousUrlNameList == null) {
            this.previousUrlNameList = new ArrayList<Object>();
        }
        this.previousUrlNameList.add(previousUrlNameListItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="previousUrlNameList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Object> getPreviousUrlNameList() {
        return this.previousUrlNameList;
    }

    @JsonProperty(value="previousUrlNameList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPreviousUrlNameList(@Nullable List<Object> previousUrlNameList) {
        this.previousUrlNameList = previousUrlNameList;
    }

    public PropertySupplier active(@Nullable Boolean active) {
        this.active = active;
        return this;
    }

    @Nullable
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActive(@Nullable Boolean active) {
        this.active = active;
    }

    public PropertySupplier propertyActive(@Nullable Boolean propertyActive) {
        this.propertyActive = propertyActive;
        return this;
    }

    @Nullable
    @JsonProperty(value="propertyActive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPropertyActive() {
        return this.propertyActive;
    }

    @JsonProperty(value="propertyActive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPropertyActive(@Nullable Boolean propertyActive) {
        this.propertyActive = propertyActive;
    }

    public PropertySupplier platformActive(@Nullable Boolean platformActive) {
        this.platformActive = platformActive;
        return this;
    }

    @Nullable
    @JsonProperty(value="platformActive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPlatformActive() {
        return this.platformActive;
    }

    @JsonProperty(value="platformActive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlatformActive(@Nullable Boolean platformActive) {
        this.platformActive = platformActive;
    }

    public PropertySupplier socialNetworks(@Nullable Boolean socialNetworks) {
        this.socialNetworks = socialNetworks;
        return this;
    }

    @Nullable
    @JsonProperty(value="socialNetworks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSocialNetworks() {
        return this.socialNetworks;
    }

    @JsonProperty(value="socialNetworks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocialNetworks(@Nullable Boolean socialNetworks) {
        this.socialNetworks = socialNetworks;
    }

    public PropertySupplier lifestyles(@Nullable Boolean lifestyles) {
        this.lifestyles = lifestyles;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifestyles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getLifestyles() {
        return this.lifestyles;
    }

    @JsonProperty(value="lifestyles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifestyles(@Nullable Boolean lifestyles) {
        this.lifestyles = lifestyles;
    }

    public PropertySupplier fullAddress(@Nullable String fullAddress) {
        this.fullAddress = fullAddress;
        return this;
    }

    @Nullable
    @JsonProperty(value="fullAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullAddress() {
        return this.fullAddress;
    }

    @JsonProperty(value="fullAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullAddress(@Nullable String fullAddress) {
        this.fullAddress = fullAddress;
    }

    public PropertySupplier contractSignerFullName(@Nullable String contractSignerFullName) {
        this.contractSignerFullName = contractSignerFullName;
        return this;
    }

    @Nullable
    @JsonProperty(value="contractSignerFullName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContractSignerFullName() {
        return this.contractSignerFullName;
    }

    @JsonProperty(value="contractSignerFullName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContractSignerFullName(@Nullable String contractSignerFullName) {
        this.contractSignerFullName = contractSignerFullName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertySupplier propertySupplier = (PropertySupplier)o;
        return Objects.equals(this.id, propertySupplier.id) && Objects.equals(this.createdDate, propertySupplier.createdDate) && Objects.equals(this.lastUpdate, propertySupplier.lastUpdate) && Objects.equals(this.version, propertySupplier.version) && Objects.equals(this.name, propertySupplier.name) && Objects.equals(this.hotelCode, propertySupplier.hotelCode) && Objects.equals(this.localName, propertySupplier.localName) && Objects.equals(this.legalName, propertySupplier.legalName) && Objects.equals(this.urlName, propertySupplier.urlName) && Objects.equals(this.currencyCode, propertySupplier.currencyCode) && Objects.equals((Object)this.status, (Object)propertySupplier.status) && Objects.equals((Object)this.externalStatus, (Object)propertySupplier.externalStatus) && Objects.equals(this.multimedias, propertySupplier.multimedias) && Objects.equals(this.recognitionList, propertySupplier.recognitionList) && Objects.equals(this.locationCategory, propertySupplier.locationCategory) && Objects.equals(this.segmentCategory, propertySupplier.segmentCategory) && Objects.equals(this.hotelCategory, propertySupplier.hotelCategory) && Objects.equals(this.architecturalStyle, propertySupplier.architecturalStyle) && Objects.equals(this.whenBuilt, propertySupplier.whenBuilt) && Objects.equals(this.hotelChain, propertySupplier.hotelChain) && Objects.equals(this.hotelBrand, propertySupplier.hotelBrand) && Objects.equals(this.otherChannelManager, propertySupplier.otherChannelManager) && Objects.equals(this.licenseNumber, propertySupplier.licenseNumber) && Objects.equals(this.stars, propertySupplier.stars) && Objects.equals(this.generalManager, propertySupplier.generalManager) && Objects.equals(this.descriptions, propertySupplier.descriptions) && Objects.equals(this.hotelAmenityCodes, propertySupplier.hotelAmenityCodes) && Objects.equals(this.propertyAccessibilityCodes, propertySupplier.propertyAccessibilityCodes) && Objects.equals(this.propertySecurityCodes, propertySupplier.propertySecurityCodes) && Objects.equals(this.locationPoint, propertySupplier.locationPoint) && Objects.equals(this.policy, propertySupplier.policy) && Objects.equals(this.socials, propertySupplier.socials) && Objects.equals(this.ownerContact, propertySupplier.ownerContact) && Objects.equals(this.reservationsContact, propertySupplier.reservationsContact) && Objects.equals(this.revenueContact, propertySupplier.revenueContact) && Objects.equals(this.marketingContact, propertySupplier.marketingContact) && Objects.equals(this.lifestyleTypes, propertySupplier.lifestyleTypes) && Objects.equals(this.greenIndexScores, propertySupplier.greenIndexScores) && Objects.equals(this.agreementAccepted, propertySupplier.agreementAccepted) && Objects.equals(this.marketingOptinAllowed, propertySupplier.marketingOptinAllowed) && Objects.equals(this.logo, propertySupplier.logo) && Objects.equals(this.numberOfRooms, propertySupplier.numberOfRooms) && Objects.equals(this.address, propertySupplier.address) && Objects.equals(this.reservationDeskStartTime, propertySupplier.reservationDeskStartTime) && Objects.equals(this.reservationDeskEndTime, propertySupplier.reservationDeskEndTime) && Objects.equals(this.website, propertySupplier.website) && Objects.equals(this.googleMapsUrl, propertySupplier.googleMapsUrl) && Objects.equals(this.metadata, propertySupplier.metadata) && Objects.equals(this.rateProvider, propertySupplier.rateProvider) && Objects.equals(this.previousUrlNameList, propertySupplier.previousUrlNameList) && Objects.equals(this.active, propertySupplier.active) && Objects.equals(this.propertyActive, propertySupplier.propertyActive) && Objects.equals(this.platformActive, propertySupplier.platformActive) && Objects.equals(this.socialNetworks, propertySupplier.socialNetworks) && Objects.equals(this.lifestyles, propertySupplier.lifestyles) && Objects.equals(this.fullAddress, propertySupplier.fullAddress) && Objects.equals(this.contractSignerFullName, propertySupplier.contractSignerFullName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.createdDate, this.lastUpdate, this.version, this.name, this.hotelCode, this.localName, this.legalName, this.urlName, this.currencyCode, this.status, this.externalStatus, this.multimedias, this.recognitionList, this.locationCategory, this.segmentCategory, this.hotelCategory, this.architecturalStyle, this.whenBuilt, this.hotelChain, this.hotelBrand, this.otherChannelManager, this.licenseNumber, this.stars, this.generalManager, this.descriptions, this.hotelAmenityCodes, this.propertyAccessibilityCodes, this.propertySecurityCodes, this.locationPoint, this.policy, this.socials, this.ownerContact, this.reservationsContact, this.revenueContact, this.marketingContact, this.lifestyleTypes, this.greenIndexScores, this.agreementAccepted, this.marketingOptinAllowed, this.logo, this.numberOfRooms, this.address, this.reservationDeskStartTime, this.reservationDeskEndTime, this.website, this.googleMapsUrl, this.metadata, this.rateProvider, this.previousUrlNameList, this.active, this.propertyActive, this.platformActive, this.socialNetworks, this.lifestyles, this.fullAddress, this.contractSignerFullName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PropertySupplier {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    hotelCode: ").append(this.toIndentedString(this.hotelCode)).append("\n");
        sb.append("    localName: ").append(this.toIndentedString(this.localName)).append("\n");
        sb.append("    legalName: ").append(this.toIndentedString(this.legalName)).append("\n");
        sb.append("    urlName: ").append(this.toIndentedString(this.urlName)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    externalStatus: ").append(this.toIndentedString((Object)this.externalStatus)).append("\n");
        sb.append("    multimedias: ").append(this.toIndentedString(this.multimedias)).append("\n");
        sb.append("    recognitionList: ").append(this.toIndentedString(this.recognitionList)).append("\n");
        sb.append("    locationCategory: ").append(this.toIndentedString(this.locationCategory)).append("\n");
        sb.append("    segmentCategory: ").append(this.toIndentedString(this.segmentCategory)).append("\n");
        sb.append("    hotelCategory: ").append(this.toIndentedString(this.hotelCategory)).append("\n");
        sb.append("    architecturalStyle: ").append(this.toIndentedString(this.architecturalStyle)).append("\n");
        sb.append("    whenBuilt: ").append(this.toIndentedString(this.whenBuilt)).append("\n");
        sb.append("    hotelChain: ").append(this.toIndentedString(this.hotelChain)).append("\n");
        sb.append("    hotelBrand: ").append(this.toIndentedString(this.hotelBrand)).append("\n");
        sb.append("    otherChannelManager: ").append(this.toIndentedString(this.otherChannelManager)).append("\n");
        sb.append("    licenseNumber: ").append(this.toIndentedString(this.licenseNumber)).append("\n");
        sb.append("    stars: ").append(this.toIndentedString(this.stars)).append("\n");
        sb.append("    generalManager: ").append(this.toIndentedString(this.generalManager)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    hotelAmenityCodes: ").append(this.toIndentedString(this.hotelAmenityCodes)).append("\n");
        sb.append("    propertyAccessibilityCodes: ").append(this.toIndentedString(this.propertyAccessibilityCodes)).append("\n");
        sb.append("    propertySecurityCodes: ").append(this.toIndentedString(this.propertySecurityCodes)).append("\n");
        sb.append("    locationPoint: ").append(this.toIndentedString(this.locationPoint)).append("\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("    socials: ").append(this.toIndentedString(this.socials)).append("\n");
        sb.append("    ownerContact: ").append(this.toIndentedString(this.ownerContact)).append("\n");
        sb.append("    reservationsContact: ").append(this.toIndentedString(this.reservationsContact)).append("\n");
        sb.append("    revenueContact: ").append(this.toIndentedString(this.revenueContact)).append("\n");
        sb.append("    marketingContact: ").append(this.toIndentedString(this.marketingContact)).append("\n");
        sb.append("    lifestyleTypes: ").append(this.toIndentedString(this.lifestyleTypes)).append("\n");
        sb.append("    greenIndexScores: ").append(this.toIndentedString(this.greenIndexScores)).append("\n");
        sb.append("    agreementAccepted: ").append(this.toIndentedString(this.agreementAccepted)).append("\n");
        sb.append("    marketingOptinAllowed: ").append(this.toIndentedString(this.marketingOptinAllowed)).append("\n");
        sb.append("    logo: ").append(this.toIndentedString(this.logo)).append("\n");
        sb.append("    numberOfRooms: ").append(this.toIndentedString(this.numberOfRooms)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    reservationDeskStartTime: ").append(this.toIndentedString(this.reservationDeskStartTime)).append("\n");
        sb.append("    reservationDeskEndTime: ").append(this.toIndentedString(this.reservationDeskEndTime)).append("\n");
        sb.append("    website: ").append(this.toIndentedString(this.website)).append("\n");
        sb.append("    googleMapsUrl: ").append(this.toIndentedString(this.googleMapsUrl)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    rateProvider: ").append(this.toIndentedString(this.rateProvider)).append("\n");
        sb.append("    previousUrlNameList: ").append(this.toIndentedString(this.previousUrlNameList)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    propertyActive: ").append(this.toIndentedString(this.propertyActive)).append("\n");
        sb.append("    platformActive: ").append(this.toIndentedString(this.platformActive)).append("\n");
        sb.append("    socialNetworks: ").append(this.toIndentedString(this.socialNetworks)).append("\n");
        sb.append("    lifestyles: ").append(this.toIndentedString(this.lifestyles)).append("\n");
        sb.append("    fullAddress: ").append(this.toIndentedString(this.fullAddress)).append("\n");
        sb.append("    contractSignerFullName: ").append(this.toIndentedString(this.contractSignerFullName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        PENDING_APPROVAL(String.valueOf("PENDING_APPROVAL")),
        APPROVED(String.valueOf("APPROVED")),
        UNDER_REVIEW(String.valueOf("UNDER_REVIEW")),
        SUSPENDED(String.valueOf("SUSPENDED")),
        REMOVED(String.valueOf("REMOVED"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ExternalStatusEnum {
        ACTIVE(String.valueOf("ACTIVE")),
        INACTIVE(String.valueOf("INACTIVE"));

        private String value;

        private ExternalStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ExternalStatusEnum fromValue(String value) {
            for (ExternalStatusEnum b : ExternalStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum LifestyleTypesEnum {
        LIFESTYLE_HEALTH_FITNESS(String.valueOf("LIFESTYLE_HEALTH_FITNESS")),
        LIFESTYLE_RELAX(String.valueOf("LIFESTYLE_RELAX")),
        LIFESTYLE_ADULT_ONLY(String.valueOf("LIFESTYLE_ADULT_ONLY")),
        LIFESTYLE_ADVENTURE(String.valueOf("LIFESTYLE_ADVENTURE")),
        LIFESTYLE_BUSINESS(String.valueOf("LIFESTYLE_BUSINESS")),
        LIFESTYLE_LGBT(String.valueOf("LIFESTYLE_LGBT")),
        LIFESTYLE_SINGLE_PARENT(String.valueOf("LIFESTYLE_SINGLE_PARENT")),
        LIFESTYLE_SOLO_FEMALE(String.valueOf("LIFESTYLE_SOLO_FEMALE")),
        LIFESTYLE_BEAUTY(String.valueOf("LIFESTYLE_BEAUTY")),
        LIFESTYLE_FOODIE(String.valueOf("LIFESTYLE_FOODIE")),
        LIFESTYLE_FAMILY(String.valueOf("LIFESTYLE_FAMILY")),
        LIFESTYLE_ROMANCE(String.valueOf("LIFESTYLE_ROMANCE")),
        LIFESTYLE_COUPLE(String.valueOf("LIFESTYLE_COUPLE")),
        LIFESTYLE_SOLO(String.valueOf("LIFESTYLE_SOLO")),
        LIFESTYLE_BACKPACKER(String.valueOf("LIFESTYLE_BACKPACKER")),
        LIFESTYLE_SHOPPING(String.valueOf("LIFESTYLE_SHOPPING")),
        LIFESTYLE_SPORTS(String.valueOf("LIFESTYLE_SPORTS")),
        LIFESTYLE_MOUNTAIN(String.valueOf("LIFESTYLE_MOUNTAIN")),
        LIFESTYLE_BEACH(String.valueOf("LIFESTYLE_BEACH")),
        LIFESTYLE_CITY(String.valueOf("LIFESTYLE_CITY")),
        LIFESTYLE_COUNTRY(String.valueOf("LIFESTYLE_COUNTRY")),
        LIFESTYLE_CULTURE(String.valueOf("LIFESTYLE_CULTURE")),
        LIFESTYLE_ECO(String.valueOf("LIFESTYLE_ECO"));

        private String value;

        private LifestyleTypesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LifestyleTypesEnum fromValue(String value) {
            for (LifestyleTypesEnum b : LifestyleTypesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

