package travel.wink.extranet.api;

import travel.wink.extranet.invoker.ApiClient;

import travel.wink.extranet.model.GenericErrorMessage;
import travel.wink.extranet.model.RateModifierBundle;
import travel.wink.extranet.model.RateModifierBundleView;
import travel.wink.extranet.model.RemoveEntryResponse;
import travel.wink.extranet.model.ShowHotelStatus400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-24T12:59:34.424118+07:00[Asia/Bangkok]")
public class PromotionBundleApi {
    private ApiClient apiClient;

    public PromotionBundleApi() {
        this(new ApiClient());
    }

    @Autowired
    public PromotionBundleApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Delete Promotion Bundle
     * Delete a rate modifier bundle by its identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param promotionBundleIdentifier The promotionBundleIdentifier parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeRateModifierBundleRequestCreation(String hotelIdentifier, String promotionBundleIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'promotionBundleIdentifier' is set
        if (promotionBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'promotionBundleIdentifier' when calling removeRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("promotionBundleIdentifier", promotionBundleIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/bundle/{promotionBundleIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Promotion Bundle
     * Delete a rate modifier bundle by its identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param promotionBundleIdentifier The promotionBundleIdentifier parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeRateModifierBundle(String hotelIdentifier, String promotionBundleIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeRateModifierBundleWithHttpInfo(String hotelIdentifier, String promotionBundleIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Create Promotion Bundle
     * Create a new rate modifier bundle
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param rateModifierBundle The rateModifierBundle parameter
     * @return RateModifierBundleView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec saveRateModifierBundleRequestCreation(String hotelIdentifier, RateModifierBundle rateModifierBundle) throws WebClientResponseException {
        Object postBody = rateModifierBundle;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling saveRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'rateModifierBundle' is set
        if (rateModifierBundle == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierBundle' when calling saveRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RateModifierBundleView> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/bundle", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Promotion Bundle
     * Create a new rate modifier bundle
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param rateModifierBundle The rateModifierBundle parameter
     * @return RateModifierBundleView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RateModifierBundleView> saveRateModifierBundle(String hotelIdentifier, RateModifierBundle rateModifierBundle) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleView> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleView>() {};
        return saveRateModifierBundleRequestCreation(hotelIdentifier, rateModifierBundle).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RateModifierBundleView>> saveRateModifierBundleWithHttpInfo(String hotelIdentifier, RateModifierBundle rateModifierBundle) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleView> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleView>() {};
        return saveRateModifierBundleRequestCreation(hotelIdentifier, rateModifierBundle).toEntity(localVarReturnType);
    }
    /**
     * Show Promotion Bundle
     * Retrieve a rate modifier bundle by its identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param promotionBundleIdentifier The promotionBundleIdentifier parameter
     * @param accept The accept parameter
     * @return RateModifierBundleView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showRateModifierBundleRequestCreation(String hotelIdentifier, String promotionBundleIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'promotionBundleIdentifier' is set
        if (promotionBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'promotionBundleIdentifier' when calling showRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("promotionBundleIdentifier", promotionBundleIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RateModifierBundleView> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/bundle/{promotionBundleIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Promotion Bundle
     * Retrieve a rate modifier bundle by its identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param promotionBundleIdentifier The promotionBundleIdentifier parameter
     * @param accept The accept parameter
     * @return RateModifierBundleView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RateModifierBundleView> showRateModifierBundle(String hotelIdentifier, String promotionBundleIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleView> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleView>() {};
        return showRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RateModifierBundleView>> showRateModifierBundleWithHttpInfo(String hotelIdentifier, String promotionBundleIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleView> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleView>() {};
        return showRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Promotion Bundles
     * Retrieve list of rate modifier bundles
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param accept The accept parameter
     * @return List&lt;RateModifierBundleView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showRateModifierBundlesRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRateModifierBundles", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RateModifierBundleView> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/bundle/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Promotion Bundles
     * Retrieve list of rate modifier bundles
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param accept The accept parameter
     * @return List&lt;RateModifierBundleView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<RateModifierBundleView> showRateModifierBundles(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleView> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleView>() {};
        return showRateModifierBundlesRequestCreation(hotelIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<RateModifierBundleView>>> showRateModifierBundlesWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleView> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleView>() {};
        return showRateModifierBundlesRequestCreation(hotelIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Update Promotion Bundle
     * Update a rate modifier bundle by its identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param promotionBundleIdentifier The promotionBundleIdentifier parameter
     * @param rateModifierBundle The rateModifierBundle parameter
     * @return RateModifierBundleView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateRateModifierBundleRequestCreation(String hotelIdentifier, String promotionBundleIdentifier, RateModifierBundle rateModifierBundle) throws WebClientResponseException {
        Object postBody = rateModifierBundle;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'promotionBundleIdentifier' is set
        if (promotionBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'promotionBundleIdentifier' when calling updateRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'rateModifierBundle' is set
        if (rateModifierBundle == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierBundle' when calling updateRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("promotionBundleIdentifier", promotionBundleIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RateModifierBundleView> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/bundle/{promotionBundleIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Promotion Bundle
     * Update a rate modifier bundle by its identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param promotionBundleIdentifier The promotionBundleIdentifier parameter
     * @param rateModifierBundle The rateModifierBundle parameter
     * @return RateModifierBundleView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RateModifierBundleView> updateRateModifierBundle(String hotelIdentifier, String promotionBundleIdentifier, RateModifierBundle rateModifierBundle) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleView> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleView>() {};
        return updateRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, rateModifierBundle).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RateModifierBundleView>> updateRateModifierBundleWithHttpInfo(String hotelIdentifier, String promotionBundleIdentifier, RateModifierBundle rateModifierBundle) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleView> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleView>() {};
        return updateRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, rateModifierBundle).toEntity(localVarReturnType);
    }
}
