package travel.wink.extranet.api;

import travel.wink.extranet.invoker.ApiClient;

import travel.wink.extranet.model.BasicHotelInformation;
import travel.wink.extranet.model.GenericErrorMessage;
import travel.wink.extranet.model.HotelStatus;
import travel.wink.extranet.model.HotelView;
import travel.wink.extranet.model.PropertyAmenities;
import travel.wink.extranet.model.ShowHotelStatus400Response;
import travel.wink.extranet.model.UniqueResult;
import travel.wink.extranet.model.Wizard;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-24T12:59:34.424118+07:00[Asia/Bangkok]")
public class PropertyApi {
    private ApiClient apiClient;

    public PropertyApi() {
        this(new ApiClient());
    }

    @Autowired
    public PropertyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Check hotel name uniqueness
     * Check if hotel name is a unique.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param key Search for uniqueness for this hotel name.
     * @param hotelIdentifier Optional, existing hotel identifier
     * @param accept The accept parameter
     * @return UniqueResult
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec isHotelNameUniqueRequestCreation(String key, String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new WebClientResponseException("Missing the required parameter 'key' when calling isHotelNameUnique", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "key", key));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "hotelIdentifier", hotelIdentifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>() {};
        return apiClient.invokeAPI("/api/hotel/uniquename", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Check hotel name uniqueness
     * Check if hotel name is a unique.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param key Search for uniqueness for this hotel name.
     * @param hotelIdentifier Optional, existing hotel identifier
     * @param accept The accept parameter
     * @return UniqueResult
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UniqueResult> isHotelNameUnique(String key, String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>() {};
        return isHotelNameUniqueRequestCreation(key, hotelIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<UniqueResult>> isHotelNameUniqueWithHttpInfo(String key, String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>() {};
        return isHotelNameUniqueRequestCreation(key, hotelIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Begin Property Verification
     * KYC required for properties in the U.S..
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @return Wizard
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec onboardToKYCPathRequestCreation(String hotelIdentifier) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling onboardToKYCPath", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Wizard> localVarReturnType = new ParameterizedTypeReference<Wizard>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/invite/kyc", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Begin Property Verification
     * KYC required for properties in the U.S..
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @return Wizard
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Wizard> onboardToKYCPath(String hotelIdentifier) throws WebClientResponseException {
        ParameterizedTypeReference<Wizard> localVarReturnType = new ParameterizedTypeReference<Wizard>() {};
        return onboardToKYCPathRequestCreation(hotelIdentifier).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Wizard>> onboardToKYCPathWithHttpInfo(String hotelIdentifier) throws WebClientResponseException {
        ParameterizedTypeReference<Wizard> localVarReturnType = new ParameterizedTypeReference<Wizard>() {};
        return onboardToKYCPathRequestCreation(hotelIdentifier).toEntity(localVarReturnType);
    }
    /**
     * Show hotel
     * Retrieve hotel by hotel identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Retrieve property record for this hotel identifier
     * @param accept The accept parameter
     * @return HotelView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showHotelByManagerRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showHotelByManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show hotel
     * Retrieve hotel by hotel identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Retrieve property record for this hotel identifier
     * @param accept The accept parameter
     * @return HotelView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelView> showHotelByManager(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return showHotelByManagerRequestCreation(hotelIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<HotelView>> showHotelByManagerWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return showHotelByManagerRequestCreation(hotelIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show hotel status
     * Retrieve hotel status
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show property status for this hotel identifier
     * @param accept The accept parameter
     * @return HotelStatus
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showHotelStatusRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showHotelStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<HotelStatus> localVarReturnType = new ParameterizedTypeReference<HotelStatus>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/status", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show hotel status
     * Retrieve hotel status
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show property status for this hotel identifier
     * @param accept The accept parameter
     * @return HotelStatus
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelStatus> showHotelStatus(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelStatus> localVarReturnType = new ParameterizedTypeReference<HotelStatus>() {};
        return showHotelStatusRequestCreation(hotelIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<HotelStatus>> showHotelStatusWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelStatus> localVarReturnType = new ParameterizedTypeReference<HotelStatus>() {};
        return showHotelStatusRequestCreation(hotelIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show hotels
     * Retrieve a list of all your hotels
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param accept The accept parameter
     * @return List&lt;HotelView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showHotelsByManagerRequestCreation(String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return apiClient.invokeAPI("/api/hotel/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show hotels
     * Retrieve a list of all your hotels
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param accept The accept parameter
     * @return List&lt;HotelView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<HotelView> showHotelsByManager(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return showHotelsByManagerRequestCreation(accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<HotelView>>> showHotelsByManagerWithHttpInfo(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelView> localVarReturnType = new ParameterizedTypeReference<HotelView>() {};
        return showHotelsByManagerRequestCreation(accept).toEntityList(localVarReturnType);
    }
    /**
     * Update information
     * Update basic property information
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update basic information for this hotel identifier
     * @param basicHotelInformation The basicHotelInformation parameter
     * @return BasicHotelInformation
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateBasicsRequestCreation(String hotelIdentifier, BasicHotelInformation basicHotelInformation) throws WebClientResponseException {
        Object postBody = basicHotelInformation;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateBasics", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'basicHotelInformation' is set
        if (basicHotelInformation == null) {
            throw new WebClientResponseException("Missing the required parameter 'basicHotelInformation' when calling updateBasics", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<BasicHotelInformation> localVarReturnType = new ParameterizedTypeReference<BasicHotelInformation>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/info", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update information
     * Update basic property information
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update basic information for this hotel identifier
     * @param basicHotelInformation The basicHotelInformation parameter
     * @return BasicHotelInformation
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BasicHotelInformation> updateBasics(String hotelIdentifier, BasicHotelInformation basicHotelInformation) throws WebClientResponseException {
        ParameterizedTypeReference<BasicHotelInformation> localVarReturnType = new ParameterizedTypeReference<BasicHotelInformation>() {};
        return updateBasicsRequestCreation(hotelIdentifier, basicHotelInformation).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BasicHotelInformation>> updateBasicsWithHttpInfo(String hotelIdentifier, BasicHotelInformation basicHotelInformation) throws WebClientResponseException {
        ParameterizedTypeReference<BasicHotelInformation> localVarReturnType = new ParameterizedTypeReference<BasicHotelInformation>() {};
        return updateBasicsRequestCreation(hotelIdentifier, basicHotelInformation).toEntity(localVarReturnType);
    }
    /**
     * Update hotel status
     * Update hotel status
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Change status for this hotel identifier
     * @param hotelStatus The hotelStatus parameter
     * @return HotelStatus
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateHotelStatusRequestCreation(String hotelIdentifier, HotelStatus hotelStatus) throws WebClientResponseException {
        Object postBody = hotelStatus;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateHotelStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'hotelStatus' is set
        if (hotelStatus == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelStatus' when calling updateHotelStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<HotelStatus> localVarReturnType = new ParameterizedTypeReference<HotelStatus>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/status", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update hotel status
     * Update hotel status
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Change status for this hotel identifier
     * @param hotelStatus The hotelStatus parameter
     * @return HotelStatus
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelStatus> updateHotelStatus(String hotelIdentifier, HotelStatus hotelStatus) throws WebClientResponseException {
        ParameterizedTypeReference<HotelStatus> localVarReturnType = new ParameterizedTypeReference<HotelStatus>() {};
        return updateHotelStatusRequestCreation(hotelIdentifier, hotelStatus).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<HotelStatus>> updateHotelStatusWithHttpInfo(String hotelIdentifier, HotelStatus hotelStatus) throws WebClientResponseException {
        ParameterizedTypeReference<HotelStatus> localVarReturnType = new ParameterizedTypeReference<HotelStatus>() {};
        return updateHotelStatusRequestCreation(hotelIdentifier, hotelStatus).toEntity(localVarReturnType);
    }
    /**
     * Update property services
     * Manage property amenity, accessibility and security features.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Set services for this hotel identifier
     * @param propertyAmenities The propertyAmenities parameter
     * @return PropertyAmenities
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateServicesRequestCreation(String hotelIdentifier, PropertyAmenities propertyAmenities) throws WebClientResponseException {
        Object postBody = propertyAmenities;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateServices", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'propertyAmenities' is set
        if (propertyAmenities == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyAmenities' when calling updateServices", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<PropertyAmenities> localVarReturnType = new ParameterizedTypeReference<PropertyAmenities>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/services", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update property services
     * Manage property amenity, accessibility and security features.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Set services for this hotel identifier
     * @param propertyAmenities The propertyAmenities parameter
     * @return PropertyAmenities
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PropertyAmenities> updateServices(String hotelIdentifier, PropertyAmenities propertyAmenities) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyAmenities> localVarReturnType = new ParameterizedTypeReference<PropertyAmenities>() {};
        return updateServicesRequestCreation(hotelIdentifier, propertyAmenities).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PropertyAmenities>> updateServicesWithHttpInfo(String hotelIdentifier, PropertyAmenities propertyAmenities) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyAmenities> localVarReturnType = new ParameterizedTypeReference<PropertyAmenities>() {};
        return updateServicesRequestCreation(hotelIdentifier, propertyAmenities).toEntity(localVarReturnType);
    }
}
