/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink platform. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 19.0.10-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import travel.wink.extranet.model.Moneys;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Beneficiary
 */
@JsonPropertyOrder({
  Beneficiary.JSON_PROPERTY_ACCOUNT_IDENTIFIER,
  Beneficiary.JSON_PROPERTY_TYPE,
  Beneficiary.JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_CURRENCY,
  Beneficiary.JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_CURRENCY,
  Beneficiary.JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_CURRENCY,
  Beneficiary.JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_CURRENCY,
  Beneficiary.JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_CURRENCY
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-24T12:59:34.424118+07:00[Asia/Bangkok]")
public class Beneficiary {
  public static final String JSON_PROPERTY_ACCOUNT_IDENTIFIER = "accountIdentifier";
  private String accountIdentifier;

  /**
   * The type of beneficiary payment.
   */
  public enum TypeEnum {
    COMMISSION("COMMISSION"),
    
    PLATFORM_FEE("PLATFORM_FEE"),
    
    SALE("SALE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_CURRENCY = "amountDueInSourceCurrency";
  private Moneys amountDueInSourceCurrency;

  public static final String JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_CURRENCY = "amountDueInDisplayCurrency";
  private Moneys amountDueInDisplayCurrency;

  public static final String JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_CURRENCY = "amountDueInSupplierCurrency";
  private Moneys amountDueInSupplierCurrency;

  public static final String JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_CURRENCY = "amountDueInInternalCurrency";
  private Moneys amountDueInInternalCurrency;

  public static final String JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_CURRENCY = "amountDueInCaptureCurrency";
  private Moneys amountDueInCaptureCurrency;

  public Beneficiary() { 
  }

  public Beneficiary accountIdentifier(String accountIdentifier) {
    
    this.accountIdentifier = accountIdentifier;
    return this;
  }

   /**
   * accountIdentifier of beneficiary from payment
   * @return accountIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "external-account-1", required = true, value = "accountIdentifier of beneficiary from payment")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAccountIdentifier() {
    return accountIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAccountIdentifier(String accountIdentifier) {
    this.accountIdentifier = accountIdentifier;
  }


  public Beneficiary type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of beneficiary payment.
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "The type of beneficiary payment.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public Beneficiary amountDueInSourceCurrency(Moneys amountDueInSourceCurrency) {
    
    this.amountDueInSourceCurrency = amountDueInSourceCurrency;
    return this;
  }

   /**
   * Get amountDueInSourceCurrency
   * @return amountDueInSourceCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getAmountDueInSourceCurrency() {
    return amountDueInSourceCurrency;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmountDueInSourceCurrency(Moneys amountDueInSourceCurrency) {
    this.amountDueInSourceCurrency = amountDueInSourceCurrency;
  }


  public Beneficiary amountDueInDisplayCurrency(Moneys amountDueInDisplayCurrency) {
    
    this.amountDueInDisplayCurrency = amountDueInDisplayCurrency;
    return this;
  }

   /**
   * Get amountDueInDisplayCurrency
   * @return amountDueInDisplayCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getAmountDueInDisplayCurrency() {
    return amountDueInDisplayCurrency;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmountDueInDisplayCurrency(Moneys amountDueInDisplayCurrency) {
    this.amountDueInDisplayCurrency = amountDueInDisplayCurrency;
  }


  public Beneficiary amountDueInSupplierCurrency(Moneys amountDueInSupplierCurrency) {
    
    this.amountDueInSupplierCurrency = amountDueInSupplierCurrency;
    return this;
  }

   /**
   * Get amountDueInSupplierCurrency
   * @return amountDueInSupplierCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getAmountDueInSupplierCurrency() {
    return amountDueInSupplierCurrency;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmountDueInSupplierCurrency(Moneys amountDueInSupplierCurrency) {
    this.amountDueInSupplierCurrency = amountDueInSupplierCurrency;
  }


  public Beneficiary amountDueInInternalCurrency(Moneys amountDueInInternalCurrency) {
    
    this.amountDueInInternalCurrency = amountDueInInternalCurrency;
    return this;
  }

   /**
   * Get amountDueInInternalCurrency
   * @return amountDueInInternalCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getAmountDueInInternalCurrency() {
    return amountDueInInternalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmountDueInInternalCurrency(Moneys amountDueInInternalCurrency) {
    this.amountDueInInternalCurrency = amountDueInInternalCurrency;
  }


  public Beneficiary amountDueInCaptureCurrency(Moneys amountDueInCaptureCurrency) {
    
    this.amountDueInCaptureCurrency = amountDueInCaptureCurrency;
    return this;
  }

   /**
   * Get amountDueInCaptureCurrency
   * @return amountDueInCaptureCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getAmountDueInCaptureCurrency() {
    return amountDueInCaptureCurrency;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmountDueInCaptureCurrency(Moneys amountDueInCaptureCurrency) {
    this.amountDueInCaptureCurrency = amountDueInCaptureCurrency;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Beneficiary beneficiary = (Beneficiary) o;
    return Objects.equals(this.accountIdentifier, beneficiary.accountIdentifier) &&
        Objects.equals(this.type, beneficiary.type) &&
        Objects.equals(this.amountDueInSourceCurrency, beneficiary.amountDueInSourceCurrency) &&
        Objects.equals(this.amountDueInDisplayCurrency, beneficiary.amountDueInDisplayCurrency) &&
        Objects.equals(this.amountDueInSupplierCurrency, beneficiary.amountDueInSupplierCurrency) &&
        Objects.equals(this.amountDueInInternalCurrency, beneficiary.amountDueInInternalCurrency) &&
        Objects.equals(this.amountDueInCaptureCurrency, beneficiary.amountDueInCaptureCurrency);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountIdentifier, type, amountDueInSourceCurrency, amountDueInDisplayCurrency, amountDueInSupplierCurrency, amountDueInInternalCurrency, amountDueInCaptureCurrency);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Beneficiary {\n");
    sb.append("    accountIdentifier: ").append(toIndentedString(accountIdentifier)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    amountDueInSourceCurrency: ").append(toIndentedString(amountDueInSourceCurrency)).append("\n");
    sb.append("    amountDueInDisplayCurrency: ").append(toIndentedString(amountDueInDisplayCurrency)).append("\n");
    sb.append("    amountDueInSupplierCurrency: ").append(toIndentedString(amountDueInSupplierCurrency)).append("\n");
    sb.append("    amountDueInInternalCurrency: ").append(toIndentedString(amountDueInInternalCurrency)).append("\n");
    sb.append("    amountDueInCaptureCurrency: ").append(toIndentedString(amountDueInCaptureCurrency)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

