/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.extranet.invoker.ApiClient;
import travel.wink.extranet.model.CountResponse;
import travel.wink.extranet.model.HotelInternalMessage;
import travel.wink.extranet.model.HotelInternalMessageView;
import travel.wink.extranet.model.RemoveEntryResponse;

public class NotificationApi {
    private ApiClient apiClient;

    public NotificationApi() {
        this(new ApiClient());
    }

    @Autowired
    public NotificationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec removeHotelInternalMessageViewRequestCreation(String hotelIdentifier, String hotelInternalMessageIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeHotelInternalMessageView", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (hotelInternalMessageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelInternalMessageIdentifier' when calling removeHotelInternalMessageView", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("hotelInternalMessageIdentifier", hotelInternalMessageIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/account/message/{hotelInternalMessageIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removeHotelInternalMessageView(String hotelIdentifier, String hotelInternalMessageIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeHotelInternalMessageViewRequestCreation(hotelIdentifier, hotelInternalMessageIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeHotelInternalMessageViewWithHttpInfo(String hotelIdentifier, String hotelInternalMessageIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeHotelInternalMessageViewRequestCreation(hotelIdentifier, hotelInternalMessageIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showHotelInternalMessageRequestCreation(String hotelIdentifier, String hotelInternalMessageIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showHotelInternalMessage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (hotelInternalMessageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelInternalMessageIdentifier' when calling showHotelInternalMessage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("hotelInternalMessageIdentifier", hotelInternalMessageIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<HotelInternalMessageView> localVarReturnType = new ParameterizedTypeReference<HotelInternalMessageView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/account/message/{hotelInternalMessageIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelInternalMessageView> showHotelInternalMessage(String hotelIdentifier, String hotelInternalMessageIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInternalMessageView> localVarReturnType = new ParameterizedTypeReference<HotelInternalMessageView>(){};
        return this.showHotelInternalMessageRequestCreation(hotelIdentifier, hotelInternalMessageIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelInternalMessageView>> showHotelInternalMessageWithHttpInfo(String hotelIdentifier, String hotelInternalMessageIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInternalMessageView> localVarReturnType = new ParameterizedTypeReference<HotelInternalMessageView>(){};
        return this.showHotelInternalMessageRequestCreation(hotelIdentifier, hotelInternalMessageIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showHotelInternalMessagesRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showHotelInternalMessages", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<HotelInternalMessageView> localVarReturnType = new ParameterizedTypeReference<HotelInternalMessageView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/account/message/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<HotelInternalMessageView> showHotelInternalMessages(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInternalMessageView> localVarReturnType = new ParameterizedTypeReference<HotelInternalMessageView>(){};
        return this.showHotelInternalMessagesRequestCreation(hotelIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<HotelInternalMessageView>>> showHotelInternalMessagesWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInternalMessageView> localVarReturnType = new ParameterizedTypeReference<HotelInternalMessageView>(){};
        return this.showHotelInternalMessagesRequestCreation(hotelIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showUnreadMessageCountRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showUnreadMessageCount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<CountResponse> localVarReturnType = new ParameterizedTypeReference<CountResponse>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/account/message/count", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CountResponse> showUnreadMessageCount(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponse> localVarReturnType = new ParameterizedTypeReference<CountResponse>(){};
        return this.showUnreadMessageCountRequestCreation(hotelIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CountResponse>> showUnreadMessageCountWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponse> localVarReturnType = new ParameterizedTypeReference<CountResponse>(){};
        return this.showUnreadMessageCountRequestCreation(hotelIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateHotelInternalMessageRequestCreation(String hotelIdentifier, String hotelInternalMessageIdentifier, HotelInternalMessage hotelInternalMessage) throws WebClientResponseException {
        HotelInternalMessage postBody = hotelInternalMessage;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateHotelInternalMessage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (hotelInternalMessageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelInternalMessageIdentifier' when calling updateHotelInternalMessage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (hotelInternalMessage == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelInternalMessage' when calling updateHotelInternalMessage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("hotelInternalMessageIdentifier", hotelInternalMessageIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<HotelInternalMessageView> localVarReturnType = new ParameterizedTypeReference<HotelInternalMessageView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/account/message/{hotelInternalMessageIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelInternalMessageView> updateHotelInternalMessage(String hotelIdentifier, String hotelInternalMessageIdentifier, HotelInternalMessage hotelInternalMessage) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInternalMessageView> localVarReturnType = new ParameterizedTypeReference<HotelInternalMessageView>(){};
        return this.updateHotelInternalMessageRequestCreation(hotelIdentifier, hotelInternalMessageIdentifier, hotelInternalMessage).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelInternalMessageView>> updateHotelInternalMessageWithHttpInfo(String hotelIdentifier, String hotelInternalMessageIdentifier, HotelInternalMessage hotelInternalMessage) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInternalMessageView> localVarReturnType = new ParameterizedTypeReference<HotelInternalMessageView>(){};
        return this.updateHotelInternalMessageRequestCreation(hotelIdentifier, hotelInternalMessageIdentifier, hotelInternalMessage).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

