/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.extranet.api;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.extranet.invoker.ApiClient;
import travel.wink.extranet.model.KeyValuePair;
import travel.wink.extranet.model.RefPoint;
import travel.wink.extranet.model.RefPointView;
import travel.wink.extranet.model.RemoveEntryResponse;

public class PlaceApi {
    private ApiClient apiClient;

    public PlaceApi() {
        this(new ApiClient());
    }

    @Autowired
    public PlaceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec removePlaceRequestCreation(String hotelIdentifier, String placeIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removePlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (placeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'placeIdentifier' when calling removePlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("placeIdentifier", placeIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place/{placeIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removePlace(String hotelIdentifier, String placeIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removePlaceRequestCreation(hotelIdentifier, placeIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removePlaceWithHttpInfo(String hotelIdentifier, String placeIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removePlaceRequestCreation(hotelIdentifier, placeIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec savePlaceRequestCreation(String hotelIdentifier, RefPoint refPoint) throws WebClientResponseException {
        RefPoint postBody = refPoint;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling savePlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (refPoint == null) {
            throw new WebClientResponseException("Missing the required parameter 'refPoint' when calling savePlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RefPointView> savePlace(String hotelIdentifier, RefPoint refPoint) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>(){};
        return this.savePlaceRequestCreation(hotelIdentifier, refPoint).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RefPointView>> savePlaceWithHttpInfo(String hotelIdentifier, RefPoint refPoint) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>(){};
        return this.savePlaceRequestCreation(hotelIdentifier, refPoint).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showPlaceRequestCreation(String hotelIdentifier, String placeIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (placeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'placeIdentifier' when calling showPlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("placeIdentifier", placeIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place/{placeIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RefPointView> showPlace(String hotelIdentifier, String placeIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>(){};
        return this.showPlaceRequestCreation(hotelIdentifier, placeIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RefPointView>> showPlaceWithHttpInfo(String hotelIdentifier, String placeIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>(){};
        return this.showPlaceRequestCreation(hotelIdentifier, placeIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showPlacePairsRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPlacePairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place/list/pair", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePair> showPlacePairs(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showPlacePairsRequestCreation(hotelIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> showPlacePairsWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showPlacePairsRequestCreation(hotelIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showPlacesRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPlaces", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<RefPointView> showPlaces(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>(){};
        return this.showPlacesRequestCreation(hotelIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<RefPointView>>> showPlacesWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>(){};
        return this.showPlacesRequestCreation(hotelIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateRefPointRequestCreation(String hotelIdentifier, String placeIdentifier, RefPoint refPoint) throws WebClientResponseException {
        RefPoint postBody = refPoint;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateRefPoint", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (placeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'placeIdentifier' when calling updateRefPoint", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (refPoint == null) {
            throw new WebClientResponseException("Missing the required parameter 'refPoint' when calling updateRefPoint", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("placeIdentifier", placeIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place/{placeIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RefPointView> updateRefPoint(String hotelIdentifier, String placeIdentifier, RefPoint refPoint) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>(){};
        return this.updateRefPointRequestCreation(hotelIdentifier, placeIdentifier, refPoint).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RefPointView>> updateRefPointWithHttpInfo(String hotelIdentifier, String placeIdentifier, RefPoint refPoint) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>(){};
        return this.updateRefPointRequestCreation(hotelIdentifier, placeIdentifier, refPoint).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec uploadPlaceMediaRequestCreation(String hotelIdentifier, String placeIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadPlaceMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (placeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'placeIdentifier' when calling uploadPlaceMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadPlaceMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("placeIdentifier", placeIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (files != null) {
            formParams.addAll((Object)"files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place/{placeIdentifier}/multimedia", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RefPointView> uploadPlaceMedia(String hotelIdentifier, String placeIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>(){};
        return this.uploadPlaceMediaRequestCreation(hotelIdentifier, placeIdentifier, files).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RefPointView>> uploadPlaceMediaWithHttpInfo(String hotelIdentifier, String placeIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointView> localVarReturnType = new ParameterizedTypeReference<RefPointView>(){};
        return this.uploadPlaceMediaRequestCreation(hotelIdentifier, placeIdentifier, files).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

