/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.extranet.invoker.ApiClient;
import travel.wink.extranet.model.RatePlan;
import travel.wink.extranet.model.RatePlanRemovableResponse;
import travel.wink.extranet.model.RatePlanView;
import travel.wink.extranet.model.RemoveEntryResponse;

public class RatePlanApi {
    private ApiClient apiClient;

    public RatePlanApi() {
        this(new ApiClient());
    }

    @Autowired
    public RatePlanApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec removableImprovedRatePlanRequestCreation(String hotelIdentifier, String ratePlanIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removableImprovedRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (ratePlanIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlanIdentifier' when calling removableImprovedRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("ratePlanIdentifier", ratePlanIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<RatePlanRemovableResponse> localVarReturnType = new ParameterizedTypeReference<RatePlanRemovableResponse>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/rateplan/{ratePlanIdentifier}/removable", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RatePlanRemovableResponse> removableImprovedRatePlan(String hotelIdentifier, String ratePlanIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanRemovableResponse> localVarReturnType = new ParameterizedTypeReference<RatePlanRemovableResponse>(){};
        return this.removableImprovedRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RatePlanRemovableResponse>> removableImprovedRatePlanWithHttpInfo(String hotelIdentifier, String ratePlanIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanRemovableResponse> localVarReturnType = new ParameterizedTypeReference<RatePlanRemovableResponse>(){};
        return this.removableImprovedRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removeRatePlanRequestCreation(String hotelIdentifier, String ratePlanIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (ratePlanIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlanIdentifier' when calling removeRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("ratePlanIdentifier", ratePlanIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/rateplan/{ratePlanIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removeRatePlan(String hotelIdentifier, String ratePlanIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeRatePlanWithHttpInfo(String hotelIdentifier, String ratePlanIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec saveRatePlanRequestCreation(String hotelIdentifier, RatePlan ratePlan) throws WebClientResponseException {
        RatePlan postBody = ratePlan;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling saveRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (ratePlan == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlan' when calling saveRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<RatePlanView> localVarReturnType = new ParameterizedTypeReference<RatePlanView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/rateplan", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RatePlanView> saveRatePlan(String hotelIdentifier, RatePlan ratePlan) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanView> localVarReturnType = new ParameterizedTypeReference<RatePlanView>(){};
        return this.saveRatePlanRequestCreation(hotelIdentifier, ratePlan).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RatePlanView>> saveRatePlanWithHttpInfo(String hotelIdentifier, RatePlan ratePlan) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanView> localVarReturnType = new ParameterizedTypeReference<RatePlanView>(){};
        return this.saveRatePlanRequestCreation(hotelIdentifier, ratePlan).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showRatePlanRequestCreation(String hotelIdentifier, String ratePlanIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (ratePlanIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlanIdentifier' when calling showRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("ratePlanIdentifier", ratePlanIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<RatePlanView> localVarReturnType = new ParameterizedTypeReference<RatePlanView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/rateplan/{ratePlanIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RatePlanView> showRatePlan(String hotelIdentifier, String ratePlanIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanView> localVarReturnType = new ParameterizedTypeReference<RatePlanView>(){};
        return this.showRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RatePlanView>> showRatePlanWithHttpInfo(String hotelIdentifier, String ratePlanIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanView> localVarReturnType = new ParameterizedTypeReference<RatePlanView>(){};
        return this.showRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showRatePlansRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRatePlans", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<RatePlanView> localVarReturnType = new ParameterizedTypeReference<RatePlanView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/rateplan/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<RatePlanView> showRatePlans(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanView> localVarReturnType = new ParameterizedTypeReference<RatePlanView>(){};
        return this.showRatePlansRequestCreation(hotelIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<RatePlanView>>> showRatePlansWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanView> localVarReturnType = new ParameterizedTypeReference<RatePlanView>(){};
        return this.showRatePlansRequestCreation(hotelIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateRatePlanRequestCreation(String hotelIdentifier, String ratePlanIdentifier, RatePlan ratePlan) throws WebClientResponseException {
        RatePlan postBody = ratePlan;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (ratePlanIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlanIdentifier' when calling updateRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (ratePlan == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlan' when calling updateRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("ratePlanIdentifier", ratePlanIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<RatePlanView> localVarReturnType = new ParameterizedTypeReference<RatePlanView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/rateplan/{ratePlanIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RatePlanView> updateRatePlan(String hotelIdentifier, String ratePlanIdentifier, RatePlan ratePlan) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanView> localVarReturnType = new ParameterizedTypeReference<RatePlanView>(){};
        return this.updateRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, ratePlan).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RatePlanView>> updateRatePlanWithHttpInfo(String hotelIdentifier, String ratePlanIdentifier, RatePlan ratePlan) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanView> localVarReturnType = new ParameterizedTypeReference<RatePlanView>(){};
        return this.updateRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, ratePlan).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

