/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@ApiModel(description="Short reason for cancellation.")
@JsonPropertyOrder(value={"name", "description", "language"})
@JsonTypeName(value="cancellationDetailDescription")
public class CancellationDetailDescription {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private String language = "en";

    public CancellationDetailDescription name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="An example title", value="Use as title or short text description")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public CancellationDetailDescription description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(example="This is a longer description that explains its relationship to parent nicely.", required=true, value="Longer text description")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1, max=0x7FFFFFFF) String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CancellationDetailDescription language(String language) {
        this.language = language;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=2, max=2)
    @ApiModelProperty(example="en", required=true, value="Indicate which language this description is written in.")
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=2, max=2) String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CancellationDetailDescription cancellationDetailDescription = (CancellationDetailDescription)o;
        return Objects.equals(this.name, cancellationDetailDescription.name) && Objects.equals(this.description, cancellationDetailDescription.description) && Objects.equals(this.language, cancellationDetailDescription.language);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.language);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CancellationDetailDescription {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

