/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"roomTypeIdentifier", "ratePlanIdentifier", "perkTypes"})
public class CreateMasterRateRequest {
    public static final String JSON_PROPERTY_ROOM_TYPE_IDENTIFIER = "roomTypeIdentifier";
    private String roomTypeIdentifier;
    public static final String JSON_PROPERTY_RATE_PLAN_IDENTIFIER = "ratePlanIdentifier";
    private String ratePlanIdentifier;
    public static final String JSON_PROPERTY_PERK_TYPES = "perkTypes";
    private List<PerkTypesEnum> perkTypes = null;

    public CreateMasterRateRequest roomTypeIdentifier(String roomTypeIdentifier) {
        this.roomTypeIdentifier = roomTypeIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="room-type-1", required=true, value="Room type identifier")
    @JsonProperty(value="roomTypeIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRoomTypeIdentifier() {
        return this.roomTypeIdentifier;
    }

    @JsonProperty(value="roomTypeIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomTypeIdentifier(String roomTypeIdentifier) {
        this.roomTypeIdentifier = roomTypeIdentifier;
    }

    public CreateMasterRateRequest ratePlanIdentifier(String ratePlanIdentifier) {
        this.ratePlanIdentifier = ratePlanIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="rate-plan-1", required=true, value="Rate plan identifier")
    @JsonProperty(value="ratePlanIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRatePlanIdentifier() {
        return this.ratePlanIdentifier;
    }

    @JsonProperty(value="ratePlanIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRatePlanIdentifier(String ratePlanIdentifier) {
        this.ratePlanIdentifier = ratePlanIdentifier;
    }

    public CreateMasterRateRequest perkTypes(List<PerkTypesEnum> perkTypes) {
        this.perkTypes = perkTypes;
        return this;
    }

    public CreateMasterRateRequest addPerkTypesItem(PerkTypesEnum perkTypesItem) {
        if (this.perkTypes == null) {
            this.perkTypes = new ArrayList<PerkTypesEnum>();
        }
        this.perkTypes.add(perkTypesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional perks")
    @JsonProperty(value="perkTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PerkTypesEnum> getPerkTypes() {
        return this.perkTypes;
    }

    @JsonProperty(value="perkTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPerkTypes(List<PerkTypesEnum> perkTypes) {
        this.perkTypes = perkTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateMasterRateRequest createMasterRateRequest = (CreateMasterRateRequest)o;
        return Objects.equals(this.roomTypeIdentifier, createMasterRateRequest.roomTypeIdentifier) && Objects.equals(this.ratePlanIdentifier, createMasterRateRequest.ratePlanIdentifier) && Objects.equals(this.perkTypes, createMasterRateRequest.perkTypes);
    }

    public int hashCode() {
        return Objects.hash(this.roomTypeIdentifier, this.ratePlanIdentifier, this.perkTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateMasterRateRequest {\n");
        sb.append("    roomTypeIdentifier: ").append(this.toIndentedString(this.roomTypeIdentifier)).append("\n");
        sb.append("    ratePlanIdentifier: ").append(this.toIndentedString(this.ratePlanIdentifier)).append("\n");
        sb.append("    perkTypes: ").append(this.toIndentedString(this.perkTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PerkTypesEnum {
        LOYALTY_POINTS("PERK_LOYALTY_POINTS"),
        WINE("PERK_WINE"),
        FREE_DRINK_VOUCHER("PERK_FREE_DRINK_VOUCHER"),
        FREE_MEAL_TWO_PEOPLE("PERK_FREE_MEAL_TWO_PEOPLE"),
        FREE_ONE_HOUR_MASSAGE("PERK_FREE_ONE_HOUR_MASSAGE"),
        TWENTY_PERCENT_FOOD_BEVERAGE_DISCOUNT("PERK_TWENTY_PERCENT_FOOD_BEVERAGE_DISCOUNT"),
        TWENTY_PERCENT_SPA_DISCOUNT_VOUCHER("PERK_TWENTY_PERCENT_SPA_DISCOUNT_VOUCHER"),
        GUARANTEED_UPGRADE("PERK_GUARANTEED_UPGRADE"),
        EARLY_CHECKIN("PERK_EARLY_CHECKIN"),
        ROOM_UPGRADE("PERK_ROOM_UPGRADE"),
        LATE_CHECKOUT("PERK_LATE_CHECKOUT"),
        AIRPORT_TRANSFER("PERK_AIRPORT_TRANSFER"),
        AIRPORT_PICK_UP("PERK_AIRPORT_PICK_UP"),
        BOTTLE_CHAMPAGNE_ON_ARRIVAL("PERK_BOTTLE_CHAMPAGNE_ON_ARRIVAL"),
        BOTTLE_SPARKLING_WINE_ON_ARRIVAL("PERK_BOTTLE_SPARKLING_WINE_ON_ARRIVAL"),
        BOTTLE_WINE_ON_ARRIVAL("PERK_BOTTLE_WINE_ON_ARRIVAL");

        private String value;

        private PerkTypesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PerkTypesEnum fromValue(String value) {
            for (PerkTypesEnum b : PerkTypesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

