/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@ApiModel(description="Property profile")
@JsonPropertyOrder(value={"stars", "channelManager", "otherChannelManager", "localName", "hotelChain", "hotelBrand", "whenBuilt", "licenseNumber", "locationCategory", "segmentCategory", "hotelCategory", "architecturalStyle"})
public class HotelProfile {
    public static final String JSON_PROPERTY_STARS = "stars";
    private Integer stars;
    public static final String JSON_PROPERTY_CHANNEL_MANAGER = "channelManager";
    private ChannelManagerEnum channelManager = ChannelManagerEnum.TRAVELIKO;
    public static final String JSON_PROPERTY_OTHER_CHANNEL_MANAGER = "otherChannelManager";
    private String otherChannelManager;
    public static final String JSON_PROPERTY_LOCAL_NAME = "localName";
    private String localName;
    public static final String JSON_PROPERTY_HOTEL_CHAIN = "hotelChain";
    private String hotelChain;
    public static final String JSON_PROPERTY_HOTEL_BRAND = "hotelBrand";
    private String hotelBrand;
    public static final String JSON_PROPERTY_WHEN_BUILT = "whenBuilt";
    private String whenBuilt;
    public static final String JSON_PROPERTY_LICENSE_NUMBER = "licenseNumber";
    private String licenseNumber;
    public static final String JSON_PROPERTY_LOCATION_CATEGORY = "locationCategory";
    private String locationCategory;
    public static final String JSON_PROPERTY_SEGMENT_CATEGORY = "segmentCategory";
    private String segmentCategory;
    public static final String JSON_PROPERTY_HOTEL_CATEGORY = "hotelCategory";
    private String hotelCategory;
    public static final String JSON_PROPERTY_ARCHITECTURAL_STYLE = "architecturalStyle";
    private String architecturalStyle;

    public HotelProfile stars(Integer stars) {
        this.stars = stars;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @Max(value=6L)
    @ApiModelProperty(example="4", required=true, value="Hotel star rating.")
    @JsonProperty(value="stars")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) @Max(value=6L) Integer getStars() {
        return this.stars;
    }

    @JsonProperty(value="stars")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStars(Integer stars) {
        this.stars = stars;
    }

    public HotelProfile channelManager(ChannelManagerEnum channelManager) {
        this.channelManager = channelManager;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="OTHER_CHANNEL_MANAGER", value="Property's channel manager. Rate ownership is decided based on the channel manager selected. Defaults to `TRAVELIKO` which is the same as no channel manager and rate ownership goes to the platform.")
    @JsonProperty(value="channelManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChannelManagerEnum getChannelManager() {
        return this.channelManager;
    }

    @JsonProperty(value="channelManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChannelManager(ChannelManagerEnum channelManager) {
        this.channelManager = channelManager;
    }

    public HotelProfile otherChannelManager(String otherChannelManager) {
        this.otherChannelManager = otherChannelManager;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="CM X", value="If the property is currently using a channel manager but it isn't yet part of our list, chose 'OTHER_CHANNEL_MANAGER' as channelManager and fill in the name of the channel manager here")
    @JsonProperty(value="otherChannelManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOtherChannelManager() {
        return this.otherChannelManager;
    }

    @JsonProperty(value="otherChannelManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOtherChannelManager(String otherChannelManager) {
        this.otherChannelManager = otherChannelManager;
    }

    public HotelProfile localName(String localName) {
        this.localName = localName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Resor Ubud Getaway", value="Name of the hotel in its local language if you use it for domestic guests.")
    @JsonProperty(value="localName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocalName() {
        return this.localName;
    }

    @JsonProperty(value="localName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public HotelProfile hotelChain(String hotelChain) {
        this.hotelChain = hotelChain;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Getaway Resorts", value="Hotel chain name if property is part of that chain.")
    @JsonProperty(value="hotelChain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHotelChain() {
        return this.hotelChain;
    }

    @JsonProperty(value="hotelChain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelChain(String hotelChain) {
        this.hotelChain = hotelChain;
    }

    public HotelProfile hotelBrand(String hotelBrand) {
        this.hotelBrand = hotelBrand;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Happy Resorts", value="Hotel brand name if property is part of that brand.")
    @JsonProperty(value="hotelBrand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHotelBrand() {
        return this.hotelBrand;
    }

    @JsonProperty(value="hotelBrand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelBrand(String hotelBrand) {
        this.hotelBrand = hotelBrand;
    }

    public HotelProfile whenBuilt(String whenBuilt) {
        this.whenBuilt = whenBuilt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1927", value="Year the property was constructed.")
    @JsonProperty(value="whenBuilt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWhenBuilt() {
        return this.whenBuilt;
    }

    @JsonProperty(value="whenBuilt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWhenBuilt(String whenBuilt) {
        this.whenBuilt = whenBuilt;
    }

    public HotelProfile licenseNumber(String licenseNumber) {
        this.licenseNumber = licenseNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ABC1234", value="If the property has a valid license number to run a hotel in their country, add it here.")
    @JsonProperty(value="licenseNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLicenseNumber() {
        return this.licenseNumber;
    }

    @JsonProperty(value="licenseNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLicenseNumber(String licenseNumber) {
        this.licenseNumber = licenseNumber;
    }

    public HotelProfile locationCategory(String locationCategory) {
        this.locationCategory = locationCategory;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="34", required=true, value="Supported OTA specification `LOC` code. See [OTA reference data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="locationCategory")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLocationCategory() {
        return this.locationCategory;
    }

    @JsonProperty(value="locationCategory")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLocationCategory(String locationCategory) {
        this.locationCategory = locationCategory;
    }

    public HotelProfile segmentCategory(String segmentCategory) {
        this.segmentCategory = segmentCategory;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="7", required=true, value="Supported OTA specification `SEG` code. See [OTA reference data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="segmentCategory")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSegmentCategory() {
        return this.segmentCategory;
    }

    @JsonProperty(value="segmentCategory")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSegmentCategory(String segmentCategory) {
        this.segmentCategory = segmentCategory;
    }

    public HotelProfile hotelCategory(String hotelCategory) {
        this.hotelCategory = hotelCategory;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="45", required=true, value="Supported OTA specification `PCT` code. See [OTA reference data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="hotelCategory")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getHotelCategory() {
        return this.hotelCategory;
    }

    @JsonProperty(value="hotelCategory")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelCategory(String hotelCategory) {
        this.hotelCategory = hotelCategory;
    }

    public HotelProfile architecturalStyle(String architecturalStyle) {
        this.architecturalStyle = architecturalStyle;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="7", required=true, value="Supported OTA specification `ARC` code. See [OTA reference data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="architecturalStyle")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getArchitecturalStyle() {
        return this.architecturalStyle;
    }

    @JsonProperty(value="architecturalStyle")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setArchitecturalStyle(String architecturalStyle) {
        this.architecturalStyle = architecturalStyle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HotelProfile hotelProfile = (HotelProfile)o;
        return Objects.equals(this.stars, hotelProfile.stars) && Objects.equals((Object)this.channelManager, (Object)hotelProfile.channelManager) && Objects.equals(this.otherChannelManager, hotelProfile.otherChannelManager) && Objects.equals(this.localName, hotelProfile.localName) && Objects.equals(this.hotelChain, hotelProfile.hotelChain) && Objects.equals(this.hotelBrand, hotelProfile.hotelBrand) && Objects.equals(this.whenBuilt, hotelProfile.whenBuilt) && Objects.equals(this.licenseNumber, hotelProfile.licenseNumber) && Objects.equals(this.locationCategory, hotelProfile.locationCategory) && Objects.equals(this.segmentCategory, hotelProfile.segmentCategory) && Objects.equals(this.hotelCategory, hotelProfile.hotelCategory) && Objects.equals(this.architecturalStyle, hotelProfile.architecturalStyle);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.stars, this.channelManager, this.otherChannelManager, this.localName, this.hotelChain, this.hotelBrand, this.whenBuilt, this.licenseNumber, this.locationCategory, this.segmentCategory, this.hotelCategory, this.architecturalStyle});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HotelProfile {\n");
        sb.append("    stars: ").append(this.toIndentedString(this.stars)).append("\n");
        sb.append("    channelManager: ").append(this.toIndentedString((Object)this.channelManager)).append("\n");
        sb.append("    otherChannelManager: ").append(this.toIndentedString(this.otherChannelManager)).append("\n");
        sb.append("    localName: ").append(this.toIndentedString(this.localName)).append("\n");
        sb.append("    hotelChain: ").append(this.toIndentedString(this.hotelChain)).append("\n");
        sb.append("    hotelBrand: ").append(this.toIndentedString(this.hotelBrand)).append("\n");
        sb.append("    whenBuilt: ").append(this.toIndentedString(this.whenBuilt)).append("\n");
        sb.append("    licenseNumber: ").append(this.toIndentedString(this.licenseNumber)).append("\n");
        sb.append("    locationCategory: ").append(this.toIndentedString(this.locationCategory)).append("\n");
        sb.append("    segmentCategory: ").append(this.toIndentedString(this.segmentCategory)).append("\n");
        sb.append("    hotelCategory: ").append(this.toIndentedString(this.hotelCategory)).append("\n");
        sb.append("    architecturalStyle: ").append(this.toIndentedString(this.architecturalStyle)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ChannelManagerEnum {
        TRAVELIKO("TRAVELIKO"),
        SITEMINDER("SITEMINDER"),
        FASTBOOKING("FASTBOOKING"),
        RATEGAIN("RATEGAIN"),
        CLOUD_BEDS("CLOUD_BEDS"),
        YIELD_PLANET("YIELD_PLANET"),
        TRAVELCLICK("TRAVELCLICK"),
        HOTEL_GURU("HOTEL_GURU"),
        OTHER_CHANNEL_MANAGER("OTHER_CHANNEL_MANAGER"),
        BOOKING_JINI("BOOKING_JINI"),
        HOTEL_LINK_SOLUTIONS("HOTEL_LINK_SOLUTIONS"),
        ALLOTZ("ALLOTZ"),
        DEDGE("DEDGE"),
        RATE_TIGER("RATE_TIGER"),
        RESAVENUE("RESAVENUE"),
        COMANCHE("COMANCHE"),
        OMNIBEES("OMNIBEES"),
        EZEE("EZEE"),
        SYNXIS("SYNXIS");

        private String value;

        private ChannelManagerEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChannelManagerEnum fromValue(String value) {
            for (ChannelManagerEnum b : ChannelManagerEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

