/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.extranet.model.GeoJsonPoint;
import travel.wink.extranet.model.GeoName;
import travel.wink.extranet.model.HotelOnMap;
import travel.wink.extranet.model.Moneys;
import travel.wink.extranet.model.SalesChannel;

@JsonPropertyOrder(value={"identifier", "salesChannel", "inventoryType", "inventoryIdentifier", "inventoryName", "enabled", "imageIdentifier", "basePrice", "commonBasePrice", "location", "city", "quantity", "commissionable", "bookable", "hotel"})
public class Inventory {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_SALES_CHANNEL = "salesChannel";
    private SalesChannel salesChannel;
    public static final String JSON_PROPERTY_INVENTORY_TYPE = "inventoryType";
    private InventoryTypeEnum inventoryType;
    public static final String JSON_PROPERTY_INVENTORY_IDENTIFIER = "inventoryIdentifier";
    private String inventoryIdentifier;
    public static final String JSON_PROPERTY_INVENTORY_NAME = "inventoryName";
    private String inventoryName;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = true;
    public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
    private String imageIdentifier;
    public static final String JSON_PROPERTY_BASE_PRICE = "basePrice";
    private Moneys basePrice;
    public static final String JSON_PROPERTY_COMMON_BASE_PRICE = "commonBasePrice";
    private Moneys commonBasePrice;
    public static final String JSON_PROPERTY_LOCATION = "location";
    private GeoJsonPoint location;
    public static final String JSON_PROPERTY_CITY = "city";
    private GeoName city;
    public static final String JSON_PROPERTY_QUANTITY = "quantity";
    private Integer quantity = 0;
    public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
    private Boolean commissionable = false;
    public static final String JSON_PROPERTY_BOOKABLE = "bookable";
    private Boolean bookable = true;
    public static final String JSON_PROPERTY_HOTEL = "hotel";
    private HotelOnMap hotel;

    public Inventory identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Inventory salesChannel(SalesChannel salesChannel) {
        this.salesChannel = salesChannel;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="salesChannel")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SalesChannel getSalesChannel() {
        return this.salesChannel;
    }

    @JsonProperty(value="salesChannel")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSalesChannel(SalesChannel salesChannel) {
        this.salesChannel = salesChannel;
    }

    public Inventory inventoryType(InventoryTypeEnum inventoryType) {
        this.inventoryType = inventoryType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Inventory type")
    @JsonProperty(value="inventoryType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public InventoryTypeEnum getInventoryType() {
        return this.inventoryType;
    }

    @JsonProperty(value="inventoryType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInventoryType(InventoryTypeEnum inventoryType) {
        this.inventoryType = inventoryType;
    }

    public Inventory inventoryIdentifier(String inventoryIdentifier) {
        this.inventoryIdentifier = inventoryIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Inventory identifier")
    @JsonProperty(value="inventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getInventoryIdentifier() {
        return this.inventoryIdentifier;
    }

    @JsonProperty(value="inventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInventoryIdentifier(String inventoryIdentifier) {
        this.inventoryIdentifier = inventoryIdentifier;
    }

    public Inventory inventoryName(String inventoryName) {
        this.inventoryName = inventoryName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Name of inventory as hotel is seeing it")
    @JsonProperty(value="inventoryName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getInventoryName() {
        return this.inventoryName;
    }

    @JsonProperty(value="inventoryName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInventoryName(String inventoryName) {
        this.inventoryName = inventoryName;
    }

    public Inventory enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Whether this inventory is enabled or not")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Inventory imageIdentifier(String imageIdentifier) {
        this.imageIdentifier = imageIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Main image of inventory")
    @JsonProperty(value="imageIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getImageIdentifier() {
        return this.imageIdentifier;
    }

    @JsonProperty(value="imageIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setImageIdentifier(String imageIdentifier) {
        this.imageIdentifier = imageIdentifier;
    }

    public Inventory basePrice(Moneys basePrice) {
        this.basePrice = basePrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="basePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getBasePrice() {
        return this.basePrice;
    }

    @JsonProperty(value="basePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBasePrice(Moneys basePrice) {
        this.basePrice = basePrice;
    }

    public Inventory commonBasePrice(Moneys commonBasePrice) {
        this.commonBasePrice = commonBasePrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="commonBasePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getCommonBasePrice() {
        return this.commonBasePrice;
    }

    @JsonProperty(value="commonBasePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommonBasePrice(Moneys commonBasePrice) {
        this.commonBasePrice = commonBasePrice;
    }

    public Inventory location(GeoJsonPoint location) {
        this.location = location;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GeoJsonPoint getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocation(GeoJsonPoint location) {
        this.location = location;
    }

    public Inventory city(GeoName city) {
        this.city = city;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GeoName getCity() {
        return this.city;
    }

    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCity(GeoName city) {
        this.city = city;
    }

    public Inventory quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="100", value="quantity")
    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Inventory commissionable(Boolean commissionable) {
        this.commissionable = commissionable;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether this is commissionable or not")
    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCommissionable() {
        return this.commissionable;
    }

    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionable(Boolean commissionable) {
        this.commissionable = commissionable;
    }

    public Inventory bookable(Boolean bookable) {
        this.bookable = bookable;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether inventory can be booked")
    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getBookable() {
        return this.bookable;
    }

    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBookable(Boolean bookable) {
        this.bookable = bookable;
    }

    public Inventory hotel(HotelOnMap hotel) {
        this.hotel = hotel;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="hotel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HotelOnMap getHotel() {
        return this.hotel;
    }

    @JsonProperty(value="hotel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotel(HotelOnMap hotel) {
        this.hotel = hotel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Inventory inventory = (Inventory)o;
        return Objects.equals(this.identifier, inventory.identifier) && Objects.equals(this.salesChannel, inventory.salesChannel) && Objects.equals((Object)this.inventoryType, (Object)inventory.inventoryType) && Objects.equals(this.inventoryIdentifier, inventory.inventoryIdentifier) && Objects.equals(this.inventoryName, inventory.inventoryName) && Objects.equals(this.enabled, inventory.enabled) && Objects.equals(this.imageIdentifier, inventory.imageIdentifier) && Objects.equals(this.basePrice, inventory.basePrice) && Objects.equals(this.commonBasePrice, inventory.commonBasePrice) && Objects.equals(this.location, inventory.location) && Objects.equals(this.city, inventory.city) && Objects.equals(this.quantity, inventory.quantity) && Objects.equals(this.commissionable, inventory.commissionable) && Objects.equals(this.bookable, inventory.bookable) && Objects.equals(this.hotel, inventory.hotel);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.salesChannel, this.inventoryType, this.inventoryIdentifier, this.inventoryName, this.enabled, this.imageIdentifier, this.basePrice, this.commonBasePrice, this.location, this.city, this.quantity, this.commissionable, this.bookable, this.hotel});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Inventory {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    salesChannel: ").append(this.toIndentedString(this.salesChannel)).append("\n");
        sb.append("    inventoryType: ").append(this.toIndentedString((Object)this.inventoryType)).append("\n");
        sb.append("    inventoryIdentifier: ").append(this.toIndentedString(this.inventoryIdentifier)).append("\n");
        sb.append("    inventoryName: ").append(this.toIndentedString(this.inventoryName)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    imageIdentifier: ").append(this.toIndentedString(this.imageIdentifier)).append("\n");
        sb.append("    basePrice: ").append(this.toIndentedString(this.basePrice)).append("\n");
        sb.append("    commonBasePrice: ").append(this.toIndentedString(this.commonBasePrice)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    commissionable: ").append(this.toIndentedString(this.commissionable)).append("\n");
        sb.append("    bookable: ").append(this.toIndentedString(this.bookable)).append("\n");
        sb.append("    hotel: ").append(this.toIndentedString(this.hotel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum InventoryTypeEnum {
        GUEST_ROOM("GUEST_ROOM"),
        PACKAGE("PACKAGE"),
        ADD_ON("ADD_ON"),
        MEETING_ROOM("MEETING_ROOM"),
        RESTAURANT("RESTAURANT"),
        SPA("SPA"),
        ATTRACTION("ATTRACTION"),
        PLACE("PLACE"),
        ACTIVITY("ACTIVITY");

        private String value;

        private InventoryTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InventoryTypeEnum fromValue(String value) {
            for (InventoryTypeEnum b : InventoryTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

