/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;

@ApiModel(description="Property legal information.")
@JsonPropertyOrder(value={"firstName", "lastName", "email", "phoneNumber"})
public class Legal {
    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    private String firstName;
    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    private String lastName;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
    private String phoneNumber;

    public Legal firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="First name of legal signer for this property. This is the person who agrees to the terms and conditions.")
    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public Legal lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Last name of legal signer for this property. This is the person who agrees to the terms and conditions.")
    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public Legal email(String email) {
        this.email = email;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Email of legal signer for this property. This is the person who agrees to the terms and conditions.")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEmail(String email) {
        this.email = email;
    }

    public Legal phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Phone number of legal signer for this property. This is the person who agrees to the terms and conditions.")
    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Legal legal = (Legal)o;
        return Objects.equals(this.firstName, legal.firstName) && Objects.equals(this.lastName, legal.lastName) && Objects.equals(this.email, legal.email) && Objects.equals(this.phoneNumber, legal.phoneNumber);
    }

    public int hashCode() {
        return Objects.hash(this.firstName, this.lastName, this.email, this.phoneNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Legal {\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

