/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.extranet.model.IdentifierNamePair;

@JsonPropertyOrder(value={"hotelIdentifier", "ratePlanIdentifier", "removable", "masterRateList", "packageList", "addOnList"})
public class RatePlanRemovableResponse {
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private String hotelIdentifier;
    public static final String JSON_PROPERTY_RATE_PLAN_IDENTIFIER = "ratePlanIdentifier";
    private String ratePlanIdentifier;
    public static final String JSON_PROPERTY_REMOVABLE = "removable";
    private Boolean removable;
    public static final String JSON_PROPERTY_MASTER_RATE_LIST = "masterRateList";
    private List<IdentifierNamePair> masterRateList = null;
    public static final String JSON_PROPERTY_PACKAGE_LIST = "packageList";
    private List<IdentifierNamePair> packageList = null;
    public static final String JSON_PROPERTY_ADD_ON_LIST = "addOnList";
    private List<IdentifierNamePair> addOnList = null;

    public RatePlanRemovableResponse hotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="hotel-1", required=true, value="Rate plan's owner.")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public RatePlanRemovableResponse ratePlanIdentifier(String ratePlanIdentifier) {
        this.ratePlanIdentifier = ratePlanIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="rate-plan-1", value="Rate plan identifier seeking to be removed.")
    @JsonProperty(value="ratePlanIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRatePlanIdentifier() {
        return this.ratePlanIdentifier;
    }

    @JsonProperty(value="ratePlanIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRatePlanIdentifier(String ratePlanIdentifier) {
        this.ratePlanIdentifier = ratePlanIdentifier;
    }

    public RatePlanRemovableResponse removable(Boolean removable) {
        this.removable = removable;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Returns true if rate plan can be removed.")
    @JsonProperty(value="removable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRemovable() {
        return this.removable;
    }

    @JsonProperty(value="removable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRemovable(Boolean removable) {
        this.removable = removable;
    }

    public RatePlanRemovableResponse masterRateList(List<IdentifierNamePair> masterRateList) {
        this.masterRateList = masterRateList;
        return this;
    }

    public RatePlanRemovableResponse addMasterRateListItem(IdentifierNamePair masterRateListItem) {
        if (this.masterRateList == null) {
            this.masterRateList = new ArrayList<IdentifierNamePair>();
        }
        this.masterRateList.add(masterRateListItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="masterRateList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IdentifierNamePair> getMasterRateList() {
        return this.masterRateList;
    }

    @JsonProperty(value="masterRateList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMasterRateList(List<IdentifierNamePair> masterRateList) {
        this.masterRateList = masterRateList;
    }

    public RatePlanRemovableResponse packageList(List<IdentifierNamePair> packageList) {
        this.packageList = packageList;
        return this;
    }

    public RatePlanRemovableResponse addPackageListItem(IdentifierNamePair packageListItem) {
        if (this.packageList == null) {
            this.packageList = new ArrayList<IdentifierNamePair>();
        }
        this.packageList.add(packageListItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="packageList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IdentifierNamePair> getPackageList() {
        return this.packageList;
    }

    @JsonProperty(value="packageList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPackageList(List<IdentifierNamePair> packageList) {
        this.packageList = packageList;
    }

    public RatePlanRemovableResponse addOnList(List<IdentifierNamePair> addOnList) {
        this.addOnList = addOnList;
        return this;
    }

    public RatePlanRemovableResponse addAddOnListItem(IdentifierNamePair addOnListItem) {
        if (this.addOnList == null) {
            this.addOnList = new ArrayList<IdentifierNamePair>();
        }
        this.addOnList.add(addOnListItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="addOnList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IdentifierNamePair> getAddOnList() {
        return this.addOnList;
    }

    @JsonProperty(value="addOnList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddOnList(List<IdentifierNamePair> addOnList) {
        this.addOnList = addOnList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RatePlanRemovableResponse ratePlanRemovableResponse = (RatePlanRemovableResponse)o;
        return Objects.equals(this.hotelIdentifier, ratePlanRemovableResponse.hotelIdentifier) && Objects.equals(this.ratePlanIdentifier, ratePlanRemovableResponse.ratePlanIdentifier) && Objects.equals(this.removable, ratePlanRemovableResponse.removable) && Objects.equals(this.masterRateList, ratePlanRemovableResponse.masterRateList) && Objects.equals(this.packageList, ratePlanRemovableResponse.packageList) && Objects.equals(this.addOnList, ratePlanRemovableResponse.addOnList);
    }

    public int hashCode() {
        return Objects.hash(this.hotelIdentifier, this.ratePlanIdentifier, this.removable, this.masterRateList, this.packageList, this.addOnList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RatePlanRemovableResponse {\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    ratePlanIdentifier: ").append(this.toIndentedString(this.ratePlanIdentifier)).append("\n");
        sb.append("    removable: ").append(this.toIndentedString(this.removable)).append("\n");
        sb.append("    masterRateList: ").append(this.toIndentedString(this.masterRateList)).append("\n");
        sb.append("    packageList: ").append(this.toIndentedString(this.packageList)).append("\n");
        sb.append("    addOnList: ").append(this.toIndentedString(this.addOnList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

