/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.extranet.model.IdentifierNamePair;

@JsonPropertyOrder(value={"hotelIdentifier", "masterRateIdentifier", "removable", "rateModifiers"})
public class RoomRateRemovableResponse {
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private String hotelIdentifier;
    public static final String JSON_PROPERTY_MASTER_RATE_IDENTIFIER = "masterRateIdentifier";
    private String masterRateIdentifier;
    public static final String JSON_PROPERTY_REMOVABLE = "removable";
    private Boolean removable;
    public static final String JSON_PROPERTY_RATE_MODIFIERS = "rateModifiers";
    private List<IdentifierNamePair> rateModifiers = null;

    public RoomRateRemovableResponse hotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="hotel-1", required=true, value="Master rate owner identifier.")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public RoomRateRemovableResponse masterRateIdentifier(String masterRateIdentifier) {
        this.masterRateIdentifier = masterRateIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="master-rate-1", value="Master rate identifier seeking to be removed.")
    @JsonProperty(value="masterRateIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMasterRateIdentifier() {
        return this.masterRateIdentifier;
    }

    @JsonProperty(value="masterRateIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMasterRateIdentifier(String masterRateIdentifier) {
        this.masterRateIdentifier = masterRateIdentifier;
    }

    public RoomRateRemovableResponse removable(Boolean removable) {
        this.removable = removable;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Returns true if master rate can be removed.")
    @JsonProperty(value="removable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRemovable() {
        return this.removable;
    }

    @JsonProperty(value="removable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRemovable(Boolean removable) {
        this.removable = removable;
    }

    public RoomRateRemovableResponse rateModifiers(List<IdentifierNamePair> rateModifiers) {
        this.rateModifiers = rateModifiers;
        return this;
    }

    public RoomRateRemovableResponse addRateModifiersItem(IdentifierNamePair rateModifiersItem) {
        if (this.rateModifiers == null) {
            this.rateModifiers = new ArrayList<IdentifierNamePair>();
        }
        this.rateModifiers.add(rateModifiersItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Promotions")
    @JsonProperty(value="rateModifiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IdentifierNamePair> getRateModifiers() {
        return this.rateModifiers;
    }

    @JsonProperty(value="rateModifiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRateModifiers(List<IdentifierNamePair> rateModifiers) {
        this.rateModifiers = rateModifiers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoomRateRemovableResponse roomRateRemovableResponse = (RoomRateRemovableResponse)o;
        return Objects.equals(this.hotelIdentifier, roomRateRemovableResponse.hotelIdentifier) && Objects.equals(this.masterRateIdentifier, roomRateRemovableResponse.masterRateIdentifier) && Objects.equals(this.removable, roomRateRemovableResponse.removable) && Objects.equals(this.rateModifiers, roomRateRemovableResponse.rateModifiers);
    }

    public int hashCode() {
        return Objects.hash(this.hotelIdentifier, this.masterRateIdentifier, this.removable, this.rateModifiers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoomRateRemovableResponse {\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    masterRateIdentifier: ").append(this.toIndentedString(this.masterRateIdentifier)).append("\n");
        sb.append("    removable: ").append(this.toIndentedString(this.removable)).append("\n");
        sb.append("    rateModifiers: ").append(this.toIndentedString(this.rateModifiers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

