/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.extranet.model.AddOn;

@ApiModel(description="Ancillary inventory to upsell a room booking.")
@JsonPropertyOrder(value={"id", "createdDate", "lastUpdate", "version", "upgrade", "featuredImageIdentifier"})
public class UpgradeView {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    private OffsetDateTime createdDate;
    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    private OffsetDateTime lastUpdate;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Long version;
    public static final String JSON_PROPERTY_UPGRADE = "upgrade";
    private AddOn upgrade;
    public static final String JSON_PROPERTY_FEATURED_IMAGE_IDENTIFIER = "featuredImageIdentifier";
    private String featuredImageIdentifier = "noimage.png";

    public UpgradeView() {
    }

    @JsonCreator
    public UpgradeView(@JsonProperty(value="id") String id, @JsonProperty(value="createdDate") OffsetDateTime createdDate, @JsonProperty(value="lastUpdate") OffsetDateTime lastUpdate, @JsonProperty(value="version") Long version) {
        this();
        this.id = id;
        this.createdDate = createdDate;
        this.lastUpdate = lastUpdate;
        this.version = version;
    }

    @Nullable
    @ApiModelProperty(example="document-1", value="Unique document identifier")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Datetime this record was first created")
    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedDate() {
        return this.createdDate;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Datetime this record was last updated")
    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    @Nullable
    @ApiModelProperty(example="12", value="Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.")
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersion() {
        return this.version;
    }

    public UpgradeView upgrade(AddOn upgrade) {
        this.upgrade = upgrade;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="upgrade")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AddOn getUpgrade() {
        return this.upgrade;
    }

    @JsonProperty(value="upgrade")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpgrade(AddOn upgrade) {
        this.upgrade = upgrade;
    }

    public UpgradeView featuredImageIdentifier(String featuredImageIdentifier) {
        this.featuredImageIdentifier = featuredImageIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="cloudinary-image-1", value="Convenience method to easily access the featured image without having to go through the entire list of images. Defaults to placeholder image if no image is present.")
    @JsonProperty(value="featuredImageIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFeaturedImageIdentifier() {
        return this.featuredImageIdentifier;
    }

    @JsonProperty(value="featuredImageIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFeaturedImageIdentifier(String featuredImageIdentifier) {
        this.featuredImageIdentifier = featuredImageIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpgradeView upgradeView = (UpgradeView)o;
        return Objects.equals(this.id, upgradeView.id) && Objects.equals(this.createdDate, upgradeView.createdDate) && Objects.equals(this.lastUpdate, upgradeView.lastUpdate) && Objects.equals(this.version, upgradeView.version) && Objects.equals(this.upgrade, upgradeView.upgrade) && Objects.equals(this.featuredImageIdentifier, upgradeView.featuredImageIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdDate, this.lastUpdate, this.version, this.upgrade, this.featuredImageIdentifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpgradeView {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    upgrade: ").append(this.toIndentedString(this.upgrade)).append("\n");
        sb.append("    featuredImageIdentifier: ").append(this.toIndentedString(this.featuredImageIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

