package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.RateModifier;
import travel.wink.sdk.extranet.model.RateModifierView;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.ShowHotelStatus400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-27T09:29:05.118372+07:00[Asia/Bangkok]")
public class PromotionApi {
    private ApiClient apiClient;

    public PromotionApi() {
        this(new ApiClient());
    }

    @Autowired
    public PromotionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Delete Promotion
     * Delete a promotion by its identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a promotion owned by this hotel identifier.
     * @param promotionIdentifier Remove a promotion with this identifier.
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeRateModifierRequestCreation(String hotelIdentifier, String promotionIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeRateModifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'promotionIdentifier' is set
        if (promotionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'promotionIdentifier' when calling removeRateModifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("promotionIdentifier", promotionIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/{promotionIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Promotion
     * Delete a promotion by its identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a promotion owned by this hotel identifier.
     * @param promotionIdentifier Remove a promotion with this identifier.
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeRateModifier(String hotelIdentifier, String promotionIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeRateModifierRequestCreation(hotelIdentifier, promotionIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeRateModifierWithHttpInfo(String hotelIdentifier, String promotionIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeRateModifierRequestCreation(hotelIdentifier, promotionIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Create Promotion
     * Create a new promotion
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create new promotion and associate with this hotel identifier.
     * @param rateModifier The rateModifier parameter
     * @return RateModifierView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec savePromotionRequestCreation(String hotelIdentifier, RateModifier rateModifier) throws WebClientResponseException {
        Object postBody = rateModifier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling savePromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'rateModifier' is set
        if (rateModifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifier' when calling savePromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RateModifierView> localVarReturnType = new ParameterizedTypeReference<RateModifierView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Promotion
     * Create a new promotion
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create new promotion and associate with this hotel identifier.
     * @param rateModifier The rateModifier parameter
     * @return RateModifierView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RateModifierView> savePromotion(String hotelIdentifier, RateModifier rateModifier) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierView> localVarReturnType = new ParameterizedTypeReference<RateModifierView>() {};
        return savePromotionRequestCreation(hotelIdentifier, rateModifier).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RateModifierView>> savePromotionWithHttpInfo(String hotelIdentifier, RateModifier rateModifier) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierView> localVarReturnType = new ParameterizedTypeReference<RateModifierView>() {};
        return savePromotionRequestCreation(hotelIdentifier, rateModifier).toEntity(localVarReturnType);
    }
    /**
     * Show Promotion
     * Retrieve a rate modifier by its identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single promotion owned by this hotel identifier.
     * @param promotionIdentifier Show single promotion with this identifier.
     * @param accept The accept parameter
     * @return RateModifierView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPromotionRequestCreation(String hotelIdentifier, String promotionIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'promotionIdentifier' is set
        if (promotionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'promotionIdentifier' when calling showPromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("promotionIdentifier", promotionIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RateModifierView> localVarReturnType = new ParameterizedTypeReference<RateModifierView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/{promotionIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Promotion
     * Retrieve a rate modifier by its identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single promotion owned by this hotel identifier.
     * @param promotionIdentifier Show single promotion with this identifier.
     * @param accept The accept parameter
     * @return RateModifierView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RateModifierView> showPromotion(String hotelIdentifier, String promotionIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierView> localVarReturnType = new ParameterizedTypeReference<RateModifierView>() {};
        return showPromotionRequestCreation(hotelIdentifier, promotionIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RateModifierView>> showPromotionWithHttpInfo(String hotelIdentifier, String promotionIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierView> localVarReturnType = new ParameterizedTypeReference<RateModifierView>() {};
        return showPromotionRequestCreation(hotelIdentifier, promotionIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Promotions
     * Retrieve list of promotions for property
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all promotions owned by this hotel identifier.
     * @param accept The accept parameter
     * @return List&lt;RateModifierView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPromotionsRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPromotions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RateModifierView> localVarReturnType = new ParameterizedTypeReference<RateModifierView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Promotions
     * Retrieve list of promotions for property
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all promotions owned by this hotel identifier.
     * @param accept The accept parameter
     * @return List&lt;RateModifierView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<RateModifierView> showPromotions(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierView> localVarReturnType = new ParameterizedTypeReference<RateModifierView>() {};
        return showPromotionsRequestCreation(hotelIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<RateModifierView>>> showPromotionsWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierView> localVarReturnType = new ParameterizedTypeReference<RateModifierView>() {};
        return showPromotionsRequestCreation(hotelIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Update Promotion
     * Update an existing promotion by its identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing promotion owned by this hotel identifier.
     * @param promotionIdentifier Update existing promotion with this identifier.
     * @param rateModifier The rateModifier parameter
     * @return RateModifierView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updatePromotionRequestCreation(String hotelIdentifier, String promotionIdentifier, RateModifier rateModifier) throws WebClientResponseException {
        Object postBody = rateModifier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updatePromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'promotionIdentifier' is set
        if (promotionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'promotionIdentifier' when calling updatePromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'rateModifier' is set
        if (rateModifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifier' when calling updatePromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("promotionIdentifier", promotionIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RateModifierView> localVarReturnType = new ParameterizedTypeReference<RateModifierView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/{promotionIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Promotion
     * Update an existing promotion by its identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing promotion owned by this hotel identifier.
     * @param promotionIdentifier Update existing promotion with this identifier.
     * @param rateModifier The rateModifier parameter
     * @return RateModifierView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RateModifierView> updatePromotion(String hotelIdentifier, String promotionIdentifier, RateModifier rateModifier) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierView> localVarReturnType = new ParameterizedTypeReference<RateModifierView>() {};
        return updatePromotionRequestCreation(hotelIdentifier, promotionIdentifier, rateModifier).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RateModifierView>> updatePromotionWithHttpInfo(String hotelIdentifier, String promotionIdentifier, RateModifier rateModifier) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierView> localVarReturnType = new ParameterizedTypeReference<RateModifierView>() {};
        return updatePromotionRequestCreation(hotelIdentifier, promotionIdentifier, rateModifier).toEntity(localVarReturnType);
    }
}
