/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink platform. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 19.0.10-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import travel.wink.sdk.extranet.model.ChartValueAxisLabels;
import travel.wink.sdk.extranet.model.ChartValueAxisLine;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * The configuration options of the value axis.
 */
@ApiModel(description = "The configuration options of the value axis.")
@JsonPropertyOrder({
  ChartValueAxis.JSON_PROPERTY_LABELS,
  ChartValueAxis.JSON_PROPERTY_LINE,
  ChartValueAxis.JSON_PROPERTY_AXIS_CROSSING_VALUE,
  ChartValueAxis.JSON_PROPERTY_MAJOR_UNIT
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-27T09:29:05.118372+07:00[Asia/Bangkok]")
public class ChartValueAxis {
  public static final String JSON_PROPERTY_LABELS = "labels";
  private ChartValueAxisLabels labels;

  public static final String JSON_PROPERTY_LINE = "line";
  private ChartValueAxisLine line;

  public static final String JSON_PROPERTY_AXIS_CROSSING_VALUE = "axisCrossingValue";
  private Integer axisCrossingValue;

  public static final String JSON_PROPERTY_MAJOR_UNIT = "majorUnit";
  private Float majorUnit;

  public ChartValueAxis() { 
  }

  public ChartValueAxis labels(ChartValueAxisLabels labels) {
    
    this.labels = labels;
    return this;
  }

   /**
   * Get labels
   * @return labels
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LABELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartValueAxisLabels getLabels() {
    return labels;
  }


  @JsonProperty(JSON_PROPERTY_LABELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLabels(ChartValueAxisLabels labels) {
    this.labels = labels;
  }


  public ChartValueAxis line(ChartValueAxisLine line) {
    
    this.line = line;
    return this;
  }

   /**
   * Get line
   * @return line
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartValueAxisLine getLine() {
    return line;
  }


  @JsonProperty(JSON_PROPERTY_LINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLine(ChartValueAxisLine line) {
    this.line = line;
  }


  public ChartValueAxis axisCrossingValue(Integer axisCrossingValue) {
    
    this.axisCrossingValue = axisCrossingValue;
    return this;
  }

   /**
   * - (Only for objects) The value at which the category axis crosses this axis. - (Only for arrays) The value indices at which the category axes cross the value axis. - (Only for dates) The date at which the category axis crosses this axis.
   * @return axisCrossingValue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "- (Only for objects) The value at which the category axis crosses this axis. - (Only for arrays) The value indices at which the category axes cross the value axis. - (Only for dates) The date at which the category axis crosses this axis.")
  @JsonProperty(JSON_PROPERTY_AXIS_CROSSING_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAxisCrossingValue() {
    return axisCrossingValue;
  }


  @JsonProperty(JSON_PROPERTY_AXIS_CROSSING_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAxisCrossingValue(Integer axisCrossingValue) {
    this.axisCrossingValue = axisCrossingValue;
  }


  public ChartValueAxis majorUnit(Float majorUnit) {
    
    this.majorUnit = majorUnit;
    return this;
  }

   /**
   * The interval between major divisions. If &#x60;valueAxis.type&#x60; is set to &#x60;log&#x60;, the majorUnit value is used for the base of the logarithm.
   * @return majorUnit
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The interval between major divisions. If `valueAxis.type` is set to `log`, the majorUnit value is used for the base of the logarithm.")
  @JsonProperty(JSON_PROPERTY_MAJOR_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getMajorUnit() {
    return majorUnit;
  }


  @JsonProperty(JSON_PROPERTY_MAJOR_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMajorUnit(Float majorUnit) {
    this.majorUnit = majorUnit;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ChartValueAxis chartValueAxis = (ChartValueAxis) o;
    return Objects.equals(this.labels, chartValueAxis.labels) &&
        Objects.equals(this.line, chartValueAxis.line) &&
        Objects.equals(this.axisCrossingValue, chartValueAxis.axisCrossingValue) &&
        Objects.equals(this.majorUnit, chartValueAxis.majorUnit);
  }

  @Override
  public int hashCode() {
    return Objects.hash(labels, line, axisCrossingValue, majorUnit);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ChartValueAxis {\n");
    sb.append("    labels: ").append(toIndentedString(labels)).append("\n");
    sb.append("    line: ").append(toIndentedString(line)).append("\n");
    sb.append("    axisCrossingValue: ").append(toIndentedString(axisCrossingValue)).append("\n");
    sb.append("    majorUnit: ").append(toIndentedString(majorUnit)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

