/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink platform. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 19.0.10-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.extranet.model.DailyRate;
import travel.wink.sdk.extranet.model.Moneys;
import travel.wink.sdk.extranet.model.Quote;
import travel.wink.sdk.extranet.model.SimpleDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * DescriptiveStayRate
 */
@JsonPropertyOrder({
  DescriptiveStayRate.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL,
  DescriptiveStayRate.JSON_PROPERTY_SOURCE_BASE_TOTAL,
  DescriptiveStayRate.JSON_PROPERTY_INTERNAL_BASE_TOTAL,
  DescriptiveStayRate.JSON_PROPERTY_SOURCE_EXTRA_PAX_MODIFIER,
  DescriptiveStayRate.JSON_PROPERTY_INTERNAL_EXTRA_PAX_MODIFIER,
  DescriptiveStayRate.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_PAX_MODIFIER,
  DescriptiveStayRate.JSON_PROPERTY_SOURCE_EXTRA_CHILD_MODIFIER,
  DescriptiveStayRate.JSON_PROPERTY_INTERNAL_EXTRA_CHILD_MODIFIER,
  DescriptiveStayRate.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_CHILD_MODIFIER,
  DescriptiveStayRate.JSON_PROPERTY_SOURCE_SINGLE_OCCUPANT_MODIFIER,
  DescriptiveStayRate.JSON_PROPERTY_INTERNAL_SINGLE_OCCUPANT_MODIFIER,
  DescriptiveStayRate.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_SINGLE_OCCUPANT_MODIFIER,
  DescriptiveStayRate.JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER,
  DescriptiveStayRate.JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER,
  DescriptiveStayRate.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER,
  DescriptiveStayRate.JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER,
  DescriptiveStayRate.JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER,
  DescriptiveStayRate.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER,
  DescriptiveStayRate.JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER,
  DescriptiveStayRate.JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER,
  DescriptiveStayRate.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER,
  DescriptiveStayRate.JSON_PROPERTY_QUANTITY,
  DescriptiveStayRate.JSON_PROPERTY_MIN_OCCUPANCY,
  DescriptiveStayRate.JSON_PROPERTY_MAX_OCCUPANCY,
  DescriptiveStayRate.JSON_PROPERTY_RATE_SOURCE,
  DescriptiveStayRate.JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT,
  DescriptiveStayRate.JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT,
  DescriptiveStayRate.JSON_PROPERTY_PREMIUM_PERCENT,
  DescriptiveStayRate.JSON_PROPERTY_AVAILABLE,
  DescriptiveStayRate.JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE,
  DescriptiveStayRate.JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE,
  DescriptiveStayRate.JSON_PROPERTY_OFFER_DETAILS,
  DescriptiveStayRate.JSON_PROPERTY_PROMOTIONAL_CODES,
  DescriptiveStayRate.JSON_PROPERTY_LIST,
  DescriptiveStayRate.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL,
  DescriptiveStayRate.JSON_PROPERTY_SOURCE_TOTAL,
  DescriptiveStayRate.JSON_PROPERTY_INTERNAL_TOTAL,
  DescriptiveStayRate.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_AVERAGE_PRICE_PER_NIGHT,
  DescriptiveStayRate.JSON_PROPERTY_INTERNAL_AVERAGE_PRICE_PER_NIGHT,
  DescriptiveStayRate.JSON_PROPERTY_SOURCE_AVERAGE_PRICE_PER_NIGHT,
  DescriptiveStayRate.JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-27T09:29:05.118372+07:00[Asia/Bangkok]")
public class DescriptiveStayRate {
  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL = "userSpecifiedCurrencyBaseTotal";
  private Moneys userSpecifiedCurrencyBaseTotal;

  public static final String JSON_PROPERTY_SOURCE_BASE_TOTAL = "sourceBaseTotal";
  private Moneys sourceBaseTotal;

  public static final String JSON_PROPERTY_INTERNAL_BASE_TOTAL = "internalBaseTotal";
  private Moneys internalBaseTotal;

  public static final String JSON_PROPERTY_SOURCE_EXTRA_PAX_MODIFIER = "sourceExtraPaxModifier";
  private Double sourceExtraPaxModifier;

  public static final String JSON_PROPERTY_INTERNAL_EXTRA_PAX_MODIFIER = "internalExtraPaxModifier";
  private Double internalExtraPaxModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_PAX_MODIFIER = "userSpecifiedCurrencyExtraPaxModifier";
  private Double userSpecifiedCurrencyExtraPaxModifier;

  public static final String JSON_PROPERTY_SOURCE_EXTRA_CHILD_MODIFIER = "sourceExtraChildModifier";
  private Double sourceExtraChildModifier;

  public static final String JSON_PROPERTY_INTERNAL_EXTRA_CHILD_MODIFIER = "internalExtraChildModifier";
  private Double internalExtraChildModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_CHILD_MODIFIER = "userSpecifiedCurrencyExtraChildModifier";
  private Double userSpecifiedCurrencyExtraChildModifier;

  public static final String JSON_PROPERTY_SOURCE_SINGLE_OCCUPANT_MODIFIER = "sourceSingleOccupantModifier";
  private Double sourceSingleOccupantModifier;

  public static final String JSON_PROPERTY_INTERNAL_SINGLE_OCCUPANT_MODIFIER = "internalSingleOccupantModifier";
  private Double internalSingleOccupantModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_SINGLE_OCCUPANT_MODIFIER = "userSpecifiedCurrencySingleOccupantModifier";
  private Double userSpecifiedCurrencySingleOccupantModifier;

  public static final String JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER = "sourcePromotionalModifier";
  private Double sourcePromotionalModifier;

  public static final String JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER = "internalPromotionalModifier";
  private Double internalPromotionalModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER = "userSpecifiedCurrencyPromotionalModifier";
  private Double userSpecifiedCurrencyPromotionalModifier;

  public static final String JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER = "sourcePremiumModifier";
  private Double sourcePremiumModifier;

  public static final String JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER = "internalPremiumModifier";
  private Double internalPremiumModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER = "userSpecifiedCurrencyPremiumModifier";
  private Double userSpecifiedCurrencyPremiumModifier;

  public static final String JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER = "sourceChannelModifier";
  private Double sourceChannelModifier;

  public static final String JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER = "internalChannelModifier";
  private Double internalChannelModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER = "userSpecifiedCurrencyChannelModifier";
  private Double userSpecifiedCurrencyChannelModifier;

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  private Integer quantity;

  public static final String JSON_PROPERTY_MIN_OCCUPANCY = "minOccupancy";
  private Integer minOccupancy;

  public static final String JSON_PROPERTY_MAX_OCCUPANCY = "maxOccupancy";
  private Integer maxOccupancy;

  /**
   * Source
   */
  public enum RateSourceEnum {
    TRAVELIKO("TRAVELIKO"),
    
    SITEMINDER("SITEMINDER"),
    
    FASTBOOKING("FASTBOOKING"),
    
    RATEGAIN("RATEGAIN"),
    
    CLOUD_BEDS("CLOUD_BEDS"),
    
    YIELD_PLANET("YIELD_PLANET"),
    
    TRAVELCLICK("TRAVELCLICK"),
    
    HOTEL_GURU("HOTEL_GURU"),
    
    OTHER_CHANNEL_MANAGER("OTHER_CHANNEL_MANAGER"),
    
    BOOKING_JINI("BOOKING_JINI"),
    
    HOTEL_LINK_SOLUTIONS("HOTEL_LINK_SOLUTIONS"),
    
    ALLOTZ("ALLOTZ"),
    
    DEDGE("DEDGE"),
    
    RATE_TIGER("RATE_TIGER"),
    
    RESAVENUE("RESAVENUE"),
    
    COMANCHE("COMANCHE"),
    
    OMNIBEES("OMNIBEES"),
    
    EZEE("EZEE"),
    
    SYNXIS("SYNXIS");

    private String value;

    RateSourceEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RateSourceEnum fromValue(String value) {
      for (RateSourceEnum b : RateSourceEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
  private RateSourceEnum rateSource;

  public static final String JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT = "promotionalDiscountPercent";
  private Float promotionalDiscountPercent;

  public static final String JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT = "channelDiscountPercent";
  private Float channelDiscountPercent;

  public static final String JSON_PROPERTY_PREMIUM_PERCENT = "premiumPercent";
  private Float premiumPercent;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Boolean available;

  public static final String JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE = "sourceToUserCurrencyQuote";
  private Quote sourceToUserCurrencyQuote;

  public static final String JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE = "sourceToInternalCurrencyQuote";
  private Quote sourceToInternalCurrencyQuote;

  public static final String JSON_PROPERTY_OFFER_DETAILS = "offerDetails";
  private List<SimpleDescription> offerDetails = null;

  public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
  private List<String> promotionalCodes = null;

  public static final String JSON_PROPERTY_LIST = "list";
  private List<DailyRate> _list = null;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
  private Moneys userSpecifiedCurrencyTotal;

  public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
  private Moneys sourceTotal;

  public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
  private Moneys internalTotal;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_AVERAGE_PRICE_PER_NIGHT = "userSpecifiedCurrencyAveragePricePerNight";
  private Moneys userSpecifiedCurrencyAveragePricePerNight;

  public static final String JSON_PROPERTY_INTERNAL_AVERAGE_PRICE_PER_NIGHT = "internalAveragePricePerNight";
  private Moneys internalAveragePricePerNight;

  public static final String JSON_PROPERTY_SOURCE_AVERAGE_PRICE_PER_NIGHT = "sourceAveragePricePerNight";
  private Moneys sourceAveragePricePerNight;

  public static final String JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT = "totalDiscountPercent";
  private Float totalDiscountPercent;

  public DescriptiveStayRate() { 
  }

  public DescriptiveStayRate userSpecifiedCurrencyBaseTotal(Moneys userSpecifiedCurrencyBaseTotal) {
    
    this.userSpecifiedCurrencyBaseTotal = userSpecifiedCurrencyBaseTotal;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyBaseTotal
   * @return userSpecifiedCurrencyBaseTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getUserSpecifiedCurrencyBaseTotal() {
    return userSpecifiedCurrencyBaseTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyBaseTotal(Moneys userSpecifiedCurrencyBaseTotal) {
    this.userSpecifiedCurrencyBaseTotal = userSpecifiedCurrencyBaseTotal;
  }


  public DescriptiveStayRate sourceBaseTotal(Moneys sourceBaseTotal) {
    
    this.sourceBaseTotal = sourceBaseTotal;
    return this;
  }

   /**
   * Get sourceBaseTotal
   * @return sourceBaseTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getSourceBaseTotal() {
    return sourceBaseTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceBaseTotal(Moneys sourceBaseTotal) {
    this.sourceBaseTotal = sourceBaseTotal;
  }


  public DescriptiveStayRate internalBaseTotal(Moneys internalBaseTotal) {
    
    this.internalBaseTotal = internalBaseTotal;
    return this;
  }

   /**
   * Get internalBaseTotal
   * @return internalBaseTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getInternalBaseTotal() {
    return internalBaseTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalBaseTotal(Moneys internalBaseTotal) {
    this.internalBaseTotal = internalBaseTotal;
  }


  public DescriptiveStayRate sourceExtraPaxModifier(Double sourceExtraPaxModifier) {
    
    this.sourceExtraPaxModifier = sourceExtraPaxModifier;
    return this;
  }

   /**
   * Extra person modifier in hotel currency.
   * @return sourceExtraPaxModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "15", value = "Extra person modifier in hotel currency.")
  @JsonProperty(JSON_PROPERTY_SOURCE_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourceExtraPaxModifier() {
    return sourceExtraPaxModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceExtraPaxModifier(Double sourceExtraPaxModifier) {
    this.sourceExtraPaxModifier = sourceExtraPaxModifier;
  }


  public DescriptiveStayRate internalExtraPaxModifier(Double internalExtraPaxModifier) {
    
    this.internalExtraPaxModifier = internalExtraPaxModifier;
    return this;
  }

   /**
   * Extra person modifier in traveliko currency
   * @return internalExtraPaxModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "15", value = "Extra person modifier in traveliko currency")
  @JsonProperty(JSON_PROPERTY_INTERNAL_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalExtraPaxModifier() {
    return internalExtraPaxModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalExtraPaxModifier(Double internalExtraPaxModifier) {
    this.internalExtraPaxModifier = internalExtraPaxModifier;
  }


  public DescriptiveStayRate userSpecifiedCurrencyExtraPaxModifier(Double userSpecifiedCurrencyExtraPaxModifier) {
    
    this.userSpecifiedCurrencyExtraPaxModifier = userSpecifiedCurrencyExtraPaxModifier;
    return this;
  }

   /**
   * Extra person modifier in user specified currency
   * @return userSpecifiedCurrencyExtraPaxModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "15", value = "Extra person modifier in user specified currency")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUserSpecifiedCurrencyExtraPaxModifier() {
    return userSpecifiedCurrencyExtraPaxModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyExtraPaxModifier(Double userSpecifiedCurrencyExtraPaxModifier) {
    this.userSpecifiedCurrencyExtraPaxModifier = userSpecifiedCurrencyExtraPaxModifier;
  }


  public DescriptiveStayRate sourceExtraChildModifier(Double sourceExtraChildModifier) {
    
    this.sourceExtraChildModifier = sourceExtraChildModifier;
    return this;
  }

   /**
   * Extra child modifier in hotel currency
   * @return sourceExtraChildModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "15", value = "Extra child modifier in hotel currency")
  @JsonProperty(JSON_PROPERTY_SOURCE_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourceExtraChildModifier() {
    return sourceExtraChildModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceExtraChildModifier(Double sourceExtraChildModifier) {
    this.sourceExtraChildModifier = sourceExtraChildModifier;
  }


  public DescriptiveStayRate internalExtraChildModifier(Double internalExtraChildModifier) {
    
    this.internalExtraChildModifier = internalExtraChildModifier;
    return this;
  }

   /**
   * Extra child modifier in traveliko currency
   * @return internalExtraChildModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "15", value = "Extra child modifier in traveliko currency")
  @JsonProperty(JSON_PROPERTY_INTERNAL_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalExtraChildModifier() {
    return internalExtraChildModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalExtraChildModifier(Double internalExtraChildModifier) {
    this.internalExtraChildModifier = internalExtraChildModifier;
  }


  public DescriptiveStayRate userSpecifiedCurrencyExtraChildModifier(Double userSpecifiedCurrencyExtraChildModifier) {
    
    this.userSpecifiedCurrencyExtraChildModifier = userSpecifiedCurrencyExtraChildModifier;
    return this;
  }

   /**
   * Extra child modifier in user specified currcency
   * @return userSpecifiedCurrencyExtraChildModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "15", value = "Extra child modifier in user specified currcency")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUserSpecifiedCurrencyExtraChildModifier() {
    return userSpecifiedCurrencyExtraChildModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyExtraChildModifier(Double userSpecifiedCurrencyExtraChildModifier) {
    this.userSpecifiedCurrencyExtraChildModifier = userSpecifiedCurrencyExtraChildModifier;
  }


  public DescriptiveStayRate sourceSingleOccupantModifier(Double sourceSingleOccupantModifier) {
    
    this.sourceSingleOccupantModifier = sourceSingleOccupantModifier;
    return this;
  }

   /**
   * Single occupant modifier in hotel currency
   * @return sourceSingleOccupantModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "-15", value = "Single occupant modifier in hotel currency")
  @JsonProperty(JSON_PROPERTY_SOURCE_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourceSingleOccupantModifier() {
    return sourceSingleOccupantModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceSingleOccupantModifier(Double sourceSingleOccupantModifier) {
    this.sourceSingleOccupantModifier = sourceSingleOccupantModifier;
  }


  public DescriptiveStayRate internalSingleOccupantModifier(Double internalSingleOccupantModifier) {
    
    this.internalSingleOccupantModifier = internalSingleOccupantModifier;
    return this;
  }

   /**
   * Singe occupant modifier in traveliko currency
   * @return internalSingleOccupantModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "-15", value = "Singe occupant modifier in traveliko currency")
  @JsonProperty(JSON_PROPERTY_INTERNAL_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalSingleOccupantModifier() {
    return internalSingleOccupantModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalSingleOccupantModifier(Double internalSingleOccupantModifier) {
    this.internalSingleOccupantModifier = internalSingleOccupantModifier;
  }


  public DescriptiveStayRate userSpecifiedCurrencySingleOccupantModifier(Double userSpecifiedCurrencySingleOccupantModifier) {
    
    this.userSpecifiedCurrencySingleOccupantModifier = userSpecifiedCurrencySingleOccupantModifier;
    return this;
  }

   /**
   * Single occupant modifier in user specified currency
   * @return userSpecifiedCurrencySingleOccupantModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "-15", value = "Single occupant modifier in user specified currency")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUserSpecifiedCurrencySingleOccupantModifier() {
    return userSpecifiedCurrencySingleOccupantModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencySingleOccupantModifier(Double userSpecifiedCurrencySingleOccupantModifier) {
    this.userSpecifiedCurrencySingleOccupantModifier = userSpecifiedCurrencySingleOccupantModifier;
  }


  public DescriptiveStayRate sourcePromotionalModifier(Double sourcePromotionalModifier) {
    
    this.sourcePromotionalModifier = sourcePromotionalModifier;
    return this;
  }

   /**
   * Rate discount modifiers in hotel currency
   * @return sourcePromotionalModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "-40", value = "Rate discount modifiers in hotel currency")
  @JsonProperty(JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourcePromotionalModifier() {
    return sourcePromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourcePromotionalModifier(Double sourcePromotionalModifier) {
    this.sourcePromotionalModifier = sourcePromotionalModifier;
  }


  public DescriptiveStayRate internalPromotionalModifier(Double internalPromotionalModifier) {
    
    this.internalPromotionalModifier = internalPromotionalModifier;
    return this;
  }

   /**
   * Rate discount modifiers in traveliko currency
   * @return internalPromotionalModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "-40", value = "Rate discount modifiers in traveliko currency")
  @JsonProperty(JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalPromotionalModifier() {
    return internalPromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalPromotionalModifier(Double internalPromotionalModifier) {
    this.internalPromotionalModifier = internalPromotionalModifier;
  }


  public DescriptiveStayRate userSpecifiedCurrencyPromotionalModifier(Double userSpecifiedCurrencyPromotionalModifier) {
    
    this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
    return this;
  }

   /**
   * Rate discount modifiers in user specified currency
   * @return userSpecifiedCurrencyPromotionalModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "-40", value = "Rate discount modifiers in user specified currency")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUserSpecifiedCurrencyPromotionalModifier() {
    return userSpecifiedCurrencyPromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyPromotionalModifier(Double userSpecifiedCurrencyPromotionalModifier) {
    this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
  }


  public DescriptiveStayRate sourcePremiumModifier(Double sourcePremiumModifier) {
    
    this.sourcePremiumModifier = sourcePremiumModifier;
    return this;
  }

   /**
   * Rate premiums modifiers in hotel currency
   * @return sourcePremiumModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "40", value = "Rate premiums modifiers in hotel currency")
  @JsonProperty(JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourcePremiumModifier() {
    return sourcePremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourcePremiumModifier(Double sourcePremiumModifier) {
    this.sourcePremiumModifier = sourcePremiumModifier;
  }


  public DescriptiveStayRate internalPremiumModifier(Double internalPremiumModifier) {
    
    this.internalPremiumModifier = internalPremiumModifier;
    return this;
  }

   /**
   * Rate premiums modifiers in traveliko currency
   * @return internalPremiumModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "40", value = "Rate premiums modifiers in traveliko currency")
  @JsonProperty(JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalPremiumModifier() {
    return internalPremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalPremiumModifier(Double internalPremiumModifier) {
    this.internalPremiumModifier = internalPremiumModifier;
  }


  public DescriptiveStayRate userSpecifiedCurrencyPremiumModifier(Double userSpecifiedCurrencyPremiumModifier) {
    
    this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
    return this;
  }

   /**
   * Rate premiums modifiers in user specified currency
   * @return userSpecifiedCurrencyPremiumModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "40", value = "Rate premiums modifiers in user specified currency")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUserSpecifiedCurrencyPremiumModifier() {
    return userSpecifiedCurrencyPremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyPremiumModifier(Double userSpecifiedCurrencyPremiumModifier) {
    this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
  }


  public DescriptiveStayRate sourceChannelModifier(Double sourceChannelModifier) {
    
    this.sourceChannelModifier = sourceChannelModifier;
    return this;
  }

   /**
   * Channel / Membership modifier in hotel currency
   * @return sourceChannelModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "-10", value = "Channel / Membership modifier in hotel currency")
  @JsonProperty(JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourceChannelModifier() {
    return sourceChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceChannelModifier(Double sourceChannelModifier) {
    this.sourceChannelModifier = sourceChannelModifier;
  }


  public DescriptiveStayRate internalChannelModifier(Double internalChannelModifier) {
    
    this.internalChannelModifier = internalChannelModifier;
    return this;
  }

   /**
   * Channel / Membership modifier in traveliko currency
   * @return internalChannelModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "-10", value = "Channel / Membership modifier in traveliko currency")
  @JsonProperty(JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalChannelModifier() {
    return internalChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalChannelModifier(Double internalChannelModifier) {
    this.internalChannelModifier = internalChannelModifier;
  }


  public DescriptiveStayRate userSpecifiedCurrencyChannelModifier(Double userSpecifiedCurrencyChannelModifier) {
    
    this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
    return this;
  }

   /**
   * Channel / Membership modifier in user specified currency
   * @return userSpecifiedCurrencyChannelModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "-10", value = "Channel / Membership modifier in user specified currency")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUserSpecifiedCurrencyChannelModifier() {
    return userSpecifiedCurrencyChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyChannelModifier(Double userSpecifiedCurrencyChannelModifier) {
    this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
  }


  public DescriptiveStayRate quantity(Integer quantity) {
    
    this.quantity = quantity;
    return this;
  }

   /**
   * Quantity
   * @return quantity
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Quantity")
  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }


  public DescriptiveStayRate minOccupancy(Integer minOccupancy) {
    
    this.minOccupancy = minOccupancy;
    return this;
  }

   /**
   * Minimum occupancy
   * @return minOccupancy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Minimum occupancy")
  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinOccupancy() {
    return minOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinOccupancy(Integer minOccupancy) {
    this.minOccupancy = minOccupancy;
  }


  public DescriptiveStayRate maxOccupancy(Integer maxOccupancy) {
    
    this.maxOccupancy = maxOccupancy;
    return this;
  }

   /**
   * Maximum occupancy
   * @return maxOccupancy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Maximum occupancy")
  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxOccupancy() {
    return maxOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxOccupancy(Integer maxOccupancy) {
    this.maxOccupancy = maxOccupancy;
  }


  public DescriptiveStayRate rateSource(RateSourceEnum rateSource) {
    
    this.rateSource = rateSource;
    return this;
  }

   /**
   * Source
   * @return rateSource
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Source")
  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RateSourceEnum getRateSource() {
    return rateSource;
  }


  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateSource(RateSourceEnum rateSource) {
    this.rateSource = rateSource;
  }


  public DescriptiveStayRate promotionalDiscountPercent(Float promotionalDiscountPercent) {
    
    this.promotionalDiscountPercent = promotionalDiscountPercent;
    return this;
  }

   /**
   * Promotional discount percent
   * @return promotionalDiscountPercent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Promotional discount percent")
  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPromotionalDiscountPercent() {
    return promotionalDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalDiscountPercent(Float promotionalDiscountPercent) {
    this.promotionalDiscountPercent = promotionalDiscountPercent;
  }


  public DescriptiveStayRate channelDiscountPercent(Float channelDiscountPercent) {
    
    this.channelDiscountPercent = channelDiscountPercent;
    return this;
  }

   /**
   * Chanel discount percent
   * @return channelDiscountPercent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Chanel discount percent")
  @JsonProperty(JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getChannelDiscountPercent() {
    return channelDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannelDiscountPercent(Float channelDiscountPercent) {
    this.channelDiscountPercent = channelDiscountPercent;
  }


  public DescriptiveStayRate premiumPercent(Float premiumPercent) {
    
    this.premiumPercent = premiumPercent;
    return this;
  }

   /**
   * Premium percent
   * @return premiumPercent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Premium percent")
  @JsonProperty(JSON_PROPERTY_PREMIUM_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPremiumPercent() {
    return premiumPercent;
  }


  @JsonProperty(JSON_PROPERTY_PREMIUM_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPremiumPercent(Float premiumPercent) {
    this.premiumPercent = premiumPercent;
  }


  public DescriptiveStayRate available(Boolean available) {
    
    this.available = available;
    return this;
  }

   /**
   * Available
   * @return available
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Available")
  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(Boolean available) {
    this.available = available;
  }


  public DescriptiveStayRate sourceToUserCurrencyQuote(Quote sourceToUserCurrencyQuote) {
    
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
    return this;
  }

   /**
   * Get sourceToUserCurrencyQuote
   * @return sourceToUserCurrencyQuote
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Quote getSourceToUserCurrencyQuote() {
    return sourceToUserCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceToUserCurrencyQuote(Quote sourceToUserCurrencyQuote) {
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
  }


  public DescriptiveStayRate sourceToInternalCurrencyQuote(Quote sourceToInternalCurrencyQuote) {
    
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
    return this;
  }

   /**
   * Get sourceToInternalCurrencyQuote
   * @return sourceToInternalCurrencyQuote
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Quote getSourceToInternalCurrencyQuote() {
    return sourceToInternalCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceToInternalCurrencyQuote(Quote sourceToInternalCurrencyQuote) {
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
  }


  public DescriptiveStayRate offerDetails(List<SimpleDescription> offerDetails) {
    
    this.offerDetails = offerDetails;
    return this;
  }

  public DescriptiveStayRate addOfferDetailsItem(SimpleDescription offerDetailsItem) {
    if (this.offerDetails == null) {
      this.offerDetails = new ArrayList<>();
    }
    this.offerDetails.add(offerDetailsItem);
    return this;
  }

   /**
   * Localized text of the discount
   * @return offerDetails
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Localized text of the discount")
  @JsonProperty(JSON_PROPERTY_OFFER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleDescription> getOfferDetails() {
    return offerDetails;
  }


  @JsonProperty(JSON_PROPERTY_OFFER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOfferDetails(List<SimpleDescription> offerDetails) {
    this.offerDetails = offerDetails;
  }


  public DescriptiveStayRate promotionalCodes(List<String> promotionalCodes) {
    
    this.promotionalCodes = promotionalCodes;
    return this;
  }

  public DescriptiveStayRate addPromotionalCodesItem(String promotionalCodesItem) {
    if (this.promotionalCodes == null) {
      this.promotionalCodes = new ArrayList<>();
    }
    this.promotionalCodes.add(promotionalCodesItem);
    return this;
  }

   /**
   * Promotional codes
   * @return promotionalCodes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Promotional codes")
  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPromotionalCodes() {
    return promotionalCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalCodes(List<String> promotionalCodes) {
    this.promotionalCodes = promotionalCodes;
  }


  public DescriptiveStayRate _list(List<DailyRate> _list) {
    
    this._list = _list;
    return this;
  }

  public DescriptiveStayRate addListItem(DailyRate _listItem) {
    if (this._list == null) {
      this._list = new ArrayList<>();
    }
    this._list.add(_listItem);
    return this;
  }

   /**
   * Daily rates
   * @return _list
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Daily rates")
  @JsonProperty(JSON_PROPERTY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DailyRate> getList() {
    return _list;
  }


  @JsonProperty(JSON_PROPERTY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setList(List<DailyRate> _list) {
    this._list = _list;
  }


  public DescriptiveStayRate userSpecifiedCurrencyTotal(Moneys userSpecifiedCurrencyTotal) {
    
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyTotal
   * @return userSpecifiedCurrencyTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getUserSpecifiedCurrencyTotal() {
    return userSpecifiedCurrencyTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyTotal(Moneys userSpecifiedCurrencyTotal) {
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
  }


  public DescriptiveStayRate sourceTotal(Moneys sourceTotal) {
    
    this.sourceTotal = sourceTotal;
    return this;
  }

   /**
   * Get sourceTotal
   * @return sourceTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getSourceTotal() {
    return sourceTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceTotal(Moneys sourceTotal) {
    this.sourceTotal = sourceTotal;
  }


  public DescriptiveStayRate internalTotal(Moneys internalTotal) {
    
    this.internalTotal = internalTotal;
    return this;
  }

   /**
   * Get internalTotal
   * @return internalTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getInternalTotal() {
    return internalTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalTotal(Moneys internalTotal) {
    this.internalTotal = internalTotal;
  }


  public DescriptiveStayRate userSpecifiedCurrencyAveragePricePerNight(Moneys userSpecifiedCurrencyAveragePricePerNight) {
    
    this.userSpecifiedCurrencyAveragePricePerNight = userSpecifiedCurrencyAveragePricePerNight;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyAveragePricePerNight
   * @return userSpecifiedCurrencyAveragePricePerNight
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_AVERAGE_PRICE_PER_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getUserSpecifiedCurrencyAveragePricePerNight() {
    return userSpecifiedCurrencyAveragePricePerNight;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_AVERAGE_PRICE_PER_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyAveragePricePerNight(Moneys userSpecifiedCurrencyAveragePricePerNight) {
    this.userSpecifiedCurrencyAveragePricePerNight = userSpecifiedCurrencyAveragePricePerNight;
  }


  public DescriptiveStayRate internalAveragePricePerNight(Moneys internalAveragePricePerNight) {
    
    this.internalAveragePricePerNight = internalAveragePricePerNight;
    return this;
  }

   /**
   * Get internalAveragePricePerNight
   * @return internalAveragePricePerNight
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_AVERAGE_PRICE_PER_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getInternalAveragePricePerNight() {
    return internalAveragePricePerNight;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_AVERAGE_PRICE_PER_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalAveragePricePerNight(Moneys internalAveragePricePerNight) {
    this.internalAveragePricePerNight = internalAveragePricePerNight;
  }


  public DescriptiveStayRate sourceAveragePricePerNight(Moneys sourceAveragePricePerNight) {
    
    this.sourceAveragePricePerNight = sourceAveragePricePerNight;
    return this;
  }

   /**
   * Get sourceAveragePricePerNight
   * @return sourceAveragePricePerNight
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_AVERAGE_PRICE_PER_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getSourceAveragePricePerNight() {
    return sourceAveragePricePerNight;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_AVERAGE_PRICE_PER_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceAveragePricePerNight(Moneys sourceAveragePricePerNight) {
    this.sourceAveragePricePerNight = sourceAveragePricePerNight;
  }


  public DescriptiveStayRate totalDiscountPercent(Float totalDiscountPercent) {
    
    this.totalDiscountPercent = totalDiscountPercent;
    return this;
  }

   /**
   * Stay discount
   * @return totalDiscountPercent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Stay discount")
  @JsonProperty(JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalDiscountPercent() {
    return totalDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalDiscountPercent(Float totalDiscountPercent) {
    this.totalDiscountPercent = totalDiscountPercent;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DescriptiveStayRate descriptiveStayRate = (DescriptiveStayRate) o;
    return Objects.equals(this.userSpecifiedCurrencyBaseTotal, descriptiveStayRate.userSpecifiedCurrencyBaseTotal) &&
        Objects.equals(this.sourceBaseTotal, descriptiveStayRate.sourceBaseTotal) &&
        Objects.equals(this.internalBaseTotal, descriptiveStayRate.internalBaseTotal) &&
        Objects.equals(this.sourceExtraPaxModifier, descriptiveStayRate.sourceExtraPaxModifier) &&
        Objects.equals(this.internalExtraPaxModifier, descriptiveStayRate.internalExtraPaxModifier) &&
        Objects.equals(this.userSpecifiedCurrencyExtraPaxModifier, descriptiveStayRate.userSpecifiedCurrencyExtraPaxModifier) &&
        Objects.equals(this.sourceExtraChildModifier, descriptiveStayRate.sourceExtraChildModifier) &&
        Objects.equals(this.internalExtraChildModifier, descriptiveStayRate.internalExtraChildModifier) &&
        Objects.equals(this.userSpecifiedCurrencyExtraChildModifier, descriptiveStayRate.userSpecifiedCurrencyExtraChildModifier) &&
        Objects.equals(this.sourceSingleOccupantModifier, descriptiveStayRate.sourceSingleOccupantModifier) &&
        Objects.equals(this.internalSingleOccupantModifier, descriptiveStayRate.internalSingleOccupantModifier) &&
        Objects.equals(this.userSpecifiedCurrencySingleOccupantModifier, descriptiveStayRate.userSpecifiedCurrencySingleOccupantModifier) &&
        Objects.equals(this.sourcePromotionalModifier, descriptiveStayRate.sourcePromotionalModifier) &&
        Objects.equals(this.internalPromotionalModifier, descriptiveStayRate.internalPromotionalModifier) &&
        Objects.equals(this.userSpecifiedCurrencyPromotionalModifier, descriptiveStayRate.userSpecifiedCurrencyPromotionalModifier) &&
        Objects.equals(this.sourcePremiumModifier, descriptiveStayRate.sourcePremiumModifier) &&
        Objects.equals(this.internalPremiumModifier, descriptiveStayRate.internalPremiumModifier) &&
        Objects.equals(this.userSpecifiedCurrencyPremiumModifier, descriptiveStayRate.userSpecifiedCurrencyPremiumModifier) &&
        Objects.equals(this.sourceChannelModifier, descriptiveStayRate.sourceChannelModifier) &&
        Objects.equals(this.internalChannelModifier, descriptiveStayRate.internalChannelModifier) &&
        Objects.equals(this.userSpecifiedCurrencyChannelModifier, descriptiveStayRate.userSpecifiedCurrencyChannelModifier) &&
        Objects.equals(this.quantity, descriptiveStayRate.quantity) &&
        Objects.equals(this.minOccupancy, descriptiveStayRate.minOccupancy) &&
        Objects.equals(this.maxOccupancy, descriptiveStayRate.maxOccupancy) &&
        Objects.equals(this.rateSource, descriptiveStayRate.rateSource) &&
        Objects.equals(this.promotionalDiscountPercent, descriptiveStayRate.promotionalDiscountPercent) &&
        Objects.equals(this.channelDiscountPercent, descriptiveStayRate.channelDiscountPercent) &&
        Objects.equals(this.premiumPercent, descriptiveStayRate.premiumPercent) &&
        Objects.equals(this.available, descriptiveStayRate.available) &&
        Objects.equals(this.sourceToUserCurrencyQuote, descriptiveStayRate.sourceToUserCurrencyQuote) &&
        Objects.equals(this.sourceToInternalCurrencyQuote, descriptiveStayRate.sourceToInternalCurrencyQuote) &&
        Objects.equals(this.offerDetails, descriptiveStayRate.offerDetails) &&
        Objects.equals(this.promotionalCodes, descriptiveStayRate.promotionalCodes) &&
        Objects.equals(this._list, descriptiveStayRate._list) &&
        Objects.equals(this.userSpecifiedCurrencyTotal, descriptiveStayRate.userSpecifiedCurrencyTotal) &&
        Objects.equals(this.sourceTotal, descriptiveStayRate.sourceTotal) &&
        Objects.equals(this.internalTotal, descriptiveStayRate.internalTotal) &&
        Objects.equals(this.userSpecifiedCurrencyAveragePricePerNight, descriptiveStayRate.userSpecifiedCurrencyAveragePricePerNight) &&
        Objects.equals(this.internalAveragePricePerNight, descriptiveStayRate.internalAveragePricePerNight) &&
        Objects.equals(this.sourceAveragePricePerNight, descriptiveStayRate.sourceAveragePricePerNight) &&
        Objects.equals(this.totalDiscountPercent, descriptiveStayRate.totalDiscountPercent);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userSpecifiedCurrencyBaseTotal, sourceBaseTotal, internalBaseTotal, sourceExtraPaxModifier, internalExtraPaxModifier, userSpecifiedCurrencyExtraPaxModifier, sourceExtraChildModifier, internalExtraChildModifier, userSpecifiedCurrencyExtraChildModifier, sourceSingleOccupantModifier, internalSingleOccupantModifier, userSpecifiedCurrencySingleOccupantModifier, sourcePromotionalModifier, internalPromotionalModifier, userSpecifiedCurrencyPromotionalModifier, sourcePremiumModifier, internalPremiumModifier, userSpecifiedCurrencyPremiumModifier, sourceChannelModifier, internalChannelModifier, userSpecifiedCurrencyChannelModifier, quantity, minOccupancy, maxOccupancy, rateSource, promotionalDiscountPercent, channelDiscountPercent, premiumPercent, available, sourceToUserCurrencyQuote, sourceToInternalCurrencyQuote, offerDetails, promotionalCodes, _list, userSpecifiedCurrencyTotal, sourceTotal, internalTotal, userSpecifiedCurrencyAveragePricePerNight, internalAveragePricePerNight, sourceAveragePricePerNight, totalDiscountPercent);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DescriptiveStayRate {\n");
    sb.append("    userSpecifiedCurrencyBaseTotal: ").append(toIndentedString(userSpecifiedCurrencyBaseTotal)).append("\n");
    sb.append("    sourceBaseTotal: ").append(toIndentedString(sourceBaseTotal)).append("\n");
    sb.append("    internalBaseTotal: ").append(toIndentedString(internalBaseTotal)).append("\n");
    sb.append("    sourceExtraPaxModifier: ").append(toIndentedString(sourceExtraPaxModifier)).append("\n");
    sb.append("    internalExtraPaxModifier: ").append(toIndentedString(internalExtraPaxModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyExtraPaxModifier: ").append(toIndentedString(userSpecifiedCurrencyExtraPaxModifier)).append("\n");
    sb.append("    sourceExtraChildModifier: ").append(toIndentedString(sourceExtraChildModifier)).append("\n");
    sb.append("    internalExtraChildModifier: ").append(toIndentedString(internalExtraChildModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyExtraChildModifier: ").append(toIndentedString(userSpecifiedCurrencyExtraChildModifier)).append("\n");
    sb.append("    sourceSingleOccupantModifier: ").append(toIndentedString(sourceSingleOccupantModifier)).append("\n");
    sb.append("    internalSingleOccupantModifier: ").append(toIndentedString(internalSingleOccupantModifier)).append("\n");
    sb.append("    userSpecifiedCurrencySingleOccupantModifier: ").append(toIndentedString(userSpecifiedCurrencySingleOccupantModifier)).append("\n");
    sb.append("    sourcePromotionalModifier: ").append(toIndentedString(sourcePromotionalModifier)).append("\n");
    sb.append("    internalPromotionalModifier: ").append(toIndentedString(internalPromotionalModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyPromotionalModifier: ").append(toIndentedString(userSpecifiedCurrencyPromotionalModifier)).append("\n");
    sb.append("    sourcePremiumModifier: ").append(toIndentedString(sourcePremiumModifier)).append("\n");
    sb.append("    internalPremiumModifier: ").append(toIndentedString(internalPremiumModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyPremiumModifier: ").append(toIndentedString(userSpecifiedCurrencyPremiumModifier)).append("\n");
    sb.append("    sourceChannelModifier: ").append(toIndentedString(sourceChannelModifier)).append("\n");
    sb.append("    internalChannelModifier: ").append(toIndentedString(internalChannelModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyChannelModifier: ").append(toIndentedString(userSpecifiedCurrencyChannelModifier)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    minOccupancy: ").append(toIndentedString(minOccupancy)).append("\n");
    sb.append("    maxOccupancy: ").append(toIndentedString(maxOccupancy)).append("\n");
    sb.append("    rateSource: ").append(toIndentedString(rateSource)).append("\n");
    sb.append("    promotionalDiscountPercent: ").append(toIndentedString(promotionalDiscountPercent)).append("\n");
    sb.append("    channelDiscountPercent: ").append(toIndentedString(channelDiscountPercent)).append("\n");
    sb.append("    premiumPercent: ").append(toIndentedString(premiumPercent)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("    sourceToUserCurrencyQuote: ").append(toIndentedString(sourceToUserCurrencyQuote)).append("\n");
    sb.append("    sourceToInternalCurrencyQuote: ").append(toIndentedString(sourceToInternalCurrencyQuote)).append("\n");
    sb.append("    offerDetails: ").append(toIndentedString(offerDetails)).append("\n");
    sb.append("    promotionalCodes: ").append(toIndentedString(promotionalCodes)).append("\n");
    sb.append("    _list: ").append(toIndentedString(_list)).append("\n");
    sb.append("    userSpecifiedCurrencyTotal: ").append(toIndentedString(userSpecifiedCurrencyTotal)).append("\n");
    sb.append("    sourceTotal: ").append(toIndentedString(sourceTotal)).append("\n");
    sb.append("    internalTotal: ").append(toIndentedString(internalTotal)).append("\n");
    sb.append("    userSpecifiedCurrencyAveragePricePerNight: ").append(toIndentedString(userSpecifiedCurrencyAveragePricePerNight)).append("\n");
    sb.append("    internalAveragePricePerNight: ").append(toIndentedString(internalAveragePricePerNight)).append("\n");
    sb.append("    sourceAveragePricePerNight: ").append(toIndentedString(sourceAveragePricePerNight)).append("\n");
    sb.append("    totalDiscountPercent: ").append(toIndentedString(totalDiscountPercent)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

