/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink platform. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 19.0.10-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Choose how you want our web components to look and more closely match with your own site style.
 */
@ApiModel(description = "Choose how you want our web components to look and more closely match with your own site style.")
@JsonPropertyOrder({
  EngineConfigurationTheme.JSON_PROPERTY_PRIMARY,
  EngineConfigurationTheme.JSON_PROPERTY_SECONDARY,
  EngineConfigurationTheme.JSON_PROPERTY_SUCCESS,
  EngineConfigurationTheme.JSON_PROPERTY_DANGER,
  EngineConfigurationTheme.JSON_PROPERTY_WARNING,
  EngineConfigurationTheme.JSON_PROPERTY_INFO,
  EngineConfigurationTheme.JSON_PROPERTY_LIGHT,
  EngineConfigurationTheme.JSON_PROPERTY_DARK,
  EngineConfigurationTheme.JSON_PROPERTY_BODY,
  EngineConfigurationTheme.JSON_PROPERTY_MUTED,
  EngineConfigurationTheme.JSON_PROPERTY_WHITE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-27T09:29:05.118372+07:00[Asia/Bangkok]")
public class EngineConfigurationTheme {
  public static final String JSON_PROPERTY_PRIMARY = "primary";
  private String primary = "#dc3545";

  public static final String JSON_PROPERTY_SECONDARY = "secondary";
  private String secondary = "#6c757d";

  public static final String JSON_PROPERTY_SUCCESS = "success";
  private String success = "#28a745";

  public static final String JSON_PROPERTY_DANGER = "danger";
  private String danger = "#dc3545";

  public static final String JSON_PROPERTY_WARNING = "warning";
  private String warning = "#ffc107";

  public static final String JSON_PROPERTY_INFO = "info";
  private String info = "#17a2b8";

  public static final String JSON_PROPERTY_LIGHT = "light";
  private String light = "#f8f9fa";

  public static final String JSON_PROPERTY_DARK = "dark";
  private String dark = "#343a40";

  public static final String JSON_PROPERTY_BODY = "body";
  private String body = "#212529";

  public static final String JSON_PROPERTY_MUTED = "muted";
  private String muted = "#6c757d";

  public static final String JSON_PROPERTY_WHITE = "white";
  private String white = "#ffffff";

  public EngineConfigurationTheme() { 
  }

  public EngineConfigurationTheme primary(String primary) {
    
    this.primary = primary;
    return this;
  }

   /**
   * Primary color
   * @return primary
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "#dc3545", value = "Primary color")
  @JsonProperty(JSON_PROPERTY_PRIMARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPrimary() {
    return primary;
  }


  @JsonProperty(JSON_PROPERTY_PRIMARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrimary(String primary) {
    this.primary = primary;
  }


  public EngineConfigurationTheme secondary(String secondary) {
    
    this.secondary = secondary;
    return this;
  }

   /**
   * Secondary color
   * @return secondary
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "#6c757d", value = "Secondary color")
  @JsonProperty(JSON_PROPERTY_SECONDARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSecondary() {
    return secondary;
  }


  @JsonProperty(JSON_PROPERTY_SECONDARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecondary(String secondary) {
    this.secondary = secondary;
  }


  public EngineConfigurationTheme success(String success) {
    
    this.success = success;
    return this;
  }

   /**
   * Success color
   * @return success
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "#28a745", value = "Success color")
  @JsonProperty(JSON_PROPERTY_SUCCESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSuccess() {
    return success;
  }


  @JsonProperty(JSON_PROPERTY_SUCCESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSuccess(String success) {
    this.success = success;
  }


  public EngineConfigurationTheme danger(String danger) {
    
    this.danger = danger;
    return this;
  }

   /**
   * Danger color
   * @return danger
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "#dc3545", value = "Danger color")
  @JsonProperty(JSON_PROPERTY_DANGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDanger() {
    return danger;
  }


  @JsonProperty(JSON_PROPERTY_DANGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDanger(String danger) {
    this.danger = danger;
  }


  public EngineConfigurationTheme warning(String warning) {
    
    this.warning = warning;
    return this;
  }

   /**
   * Warning color
   * @return warning
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "#ffc107", value = "Warning color")
  @JsonProperty(JSON_PROPERTY_WARNING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWarning() {
    return warning;
  }


  @JsonProperty(JSON_PROPERTY_WARNING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWarning(String warning) {
    this.warning = warning;
  }


  public EngineConfigurationTheme info(String info) {
    
    this.info = info;
    return this;
  }

   /**
   * Info color
   * @return info
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "#17a2b8", value = "Info color")
  @JsonProperty(JSON_PROPERTY_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInfo() {
    return info;
  }


  @JsonProperty(JSON_PROPERTY_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInfo(String info) {
    this.info = info;
  }


  public EngineConfigurationTheme light(String light) {
    
    this.light = light;
    return this;
  }

   /**
   * Light color
   * @return light
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "#f8f9fa", value = "Light color")
  @JsonProperty(JSON_PROPERTY_LIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLight() {
    return light;
  }


  @JsonProperty(JSON_PROPERTY_LIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLight(String light) {
    this.light = light;
  }


  public EngineConfigurationTheme dark(String dark) {
    
    this.dark = dark;
    return this;
  }

   /**
   * Dark color
   * @return dark
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "#343a40", value = "Dark color")
  @JsonProperty(JSON_PROPERTY_DARK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDark() {
    return dark;
  }


  @JsonProperty(JSON_PROPERTY_DARK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDark(String dark) {
    this.dark = dark;
  }


  public EngineConfigurationTheme body(String body) {
    
    this.body = body;
    return this;
  }

   /**
   * Body color
   * @return body
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "#212529", value = "Body color")
  @JsonProperty(JSON_PROPERTY_BODY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBody() {
    return body;
  }


  @JsonProperty(JSON_PROPERTY_BODY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBody(String body) {
    this.body = body;
  }


  public EngineConfigurationTheme muted(String muted) {
    
    this.muted = muted;
    return this;
  }

   /**
   * Muted color
   * @return muted
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "#6c757d", value = "Muted color")
  @JsonProperty(JSON_PROPERTY_MUTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMuted() {
    return muted;
  }


  @JsonProperty(JSON_PROPERTY_MUTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMuted(String muted) {
    this.muted = muted;
  }


  public EngineConfigurationTheme white(String white) {
    
    this.white = white;
    return this;
  }

   /**
   * White color
   * @return white
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "#ffffff", value = "White color")
  @JsonProperty(JSON_PROPERTY_WHITE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWhite() {
    return white;
  }


  @JsonProperty(JSON_PROPERTY_WHITE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWhite(String white) {
    this.white = white;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EngineConfigurationTheme engineConfigurationTheme = (EngineConfigurationTheme) o;
    return Objects.equals(this.primary, engineConfigurationTheme.primary) &&
        Objects.equals(this.secondary, engineConfigurationTheme.secondary) &&
        Objects.equals(this.success, engineConfigurationTheme.success) &&
        Objects.equals(this.danger, engineConfigurationTheme.danger) &&
        Objects.equals(this.warning, engineConfigurationTheme.warning) &&
        Objects.equals(this.info, engineConfigurationTheme.info) &&
        Objects.equals(this.light, engineConfigurationTheme.light) &&
        Objects.equals(this.dark, engineConfigurationTheme.dark) &&
        Objects.equals(this.body, engineConfigurationTheme.body) &&
        Objects.equals(this.muted, engineConfigurationTheme.muted) &&
        Objects.equals(this.white, engineConfigurationTheme.white);
  }

  @Override
  public int hashCode() {
    return Objects.hash(primary, secondary, success, danger, warning, info, light, dark, body, muted, white);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EngineConfigurationTheme {\n");
    sb.append("    primary: ").append(toIndentedString(primary)).append("\n");
    sb.append("    secondary: ").append(toIndentedString(secondary)).append("\n");
    sb.append("    success: ").append(toIndentedString(success)).append("\n");
    sb.append("    danger: ").append(toIndentedString(danger)).append("\n");
    sb.append("    warning: ").append(toIndentedString(warning)).append("\n");
    sb.append("    info: ").append(toIndentedString(info)).append("\n");
    sb.append("    light: ").append(toIndentedString(light)).append("\n");
    sb.append("    dark: ").append(toIndentedString(dark)).append("\n");
    sb.append("    body: ").append(toIndentedString(body)).append("\n");
    sb.append("    muted: ").append(toIndentedString(muted)).append("\n");
    sb.append("    white: ").append(toIndentedString(white)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

