/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink platform. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 19.0.10-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import travel.wink.sdk.extranet.model.GeoJsonPoint;
import travel.wink.sdk.extranet.model.GeoName;
import travel.wink.sdk.extranet.model.HotelOnMap;
import travel.wink.sdk.extranet.model.Moneys;
import travel.wink.sdk.extranet.model.SalesChannel;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Inventory
 */
@JsonPropertyOrder({
  Inventory.JSON_PROPERTY_IDENTIFIER,
  Inventory.JSON_PROPERTY_SALES_CHANNEL,
  Inventory.JSON_PROPERTY_INVENTORY_TYPE,
  Inventory.JSON_PROPERTY_INVENTORY_IDENTIFIER,
  Inventory.JSON_PROPERTY_INVENTORY_NAME,
  Inventory.JSON_PROPERTY_ENABLED,
  Inventory.JSON_PROPERTY_IMAGE_IDENTIFIER,
  Inventory.JSON_PROPERTY_BASE_PRICE,
  Inventory.JSON_PROPERTY_COMMON_BASE_PRICE,
  Inventory.JSON_PROPERTY_LOCATION,
  Inventory.JSON_PROPERTY_CITY,
  Inventory.JSON_PROPERTY_QUANTITY,
  Inventory.JSON_PROPERTY_COMMISSIONABLE,
  Inventory.JSON_PROPERTY_BOOKABLE,
  Inventory.JSON_PROPERTY_HOTEL
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-27T09:29:05.118372+07:00[Asia/Bangkok]")
public class Inventory {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_SALES_CHANNEL = "salesChannel";
  private SalesChannel salesChannel;

  /**
   * Inventory type
   */
  public enum InventoryTypeEnum {
    GUEST_ROOM("GUEST_ROOM"),
    
    PACKAGE("PACKAGE"),
    
    ADD_ON("ADD_ON"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    RESTAURANT("RESTAURANT"),
    
    SPA("SPA"),
    
    ATTRACTION("ATTRACTION"),
    
    PLACE("PLACE"),
    
    ACTIVITY("ACTIVITY");

    private String value;

    InventoryTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InventoryTypeEnum fromValue(String value) {
      for (InventoryTypeEnum b : InventoryTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INVENTORY_TYPE = "inventoryType";
  private InventoryTypeEnum inventoryType;

  public static final String JSON_PROPERTY_INVENTORY_IDENTIFIER = "inventoryIdentifier";
  private String inventoryIdentifier;

  public static final String JSON_PROPERTY_INVENTORY_NAME = "inventoryName";
  private String inventoryName;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled = true;

  public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
  private String imageIdentifier;

  public static final String JSON_PROPERTY_BASE_PRICE = "basePrice";
  private Moneys basePrice;

  public static final String JSON_PROPERTY_COMMON_BASE_PRICE = "commonBasePrice";
  private Moneys commonBasePrice;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPoint location;

  public static final String JSON_PROPERTY_CITY = "city";
  private GeoName city;

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  private Integer quantity = 0;

  public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
  private Boolean commissionable = false;

  public static final String JSON_PROPERTY_BOOKABLE = "bookable";
  private Boolean bookable = true;

  public static final String JSON_PROPERTY_HOTEL = "hotel";
  private HotelOnMap hotel;

  public Inventory() { 
  }

  public Inventory identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Get identifier
   * @return identifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public Inventory salesChannel(SalesChannel salesChannel) {
    
    this.salesChannel = salesChannel;
    return this;
  }

   /**
   * Get salesChannel
   * @return salesChannel
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SalesChannel getSalesChannel() {
    return salesChannel;
  }


  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSalesChannel(SalesChannel salesChannel) {
    this.salesChannel = salesChannel;
  }


  public Inventory inventoryType(InventoryTypeEnum inventoryType) {
    
    this.inventoryType = inventoryType;
    return this;
  }

   /**
   * Inventory type
   * @return inventoryType
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "Inventory type")
  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public InventoryTypeEnum getInventoryType() {
    return inventoryType;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryType(InventoryTypeEnum inventoryType) {
    this.inventoryType = inventoryType;
  }


  public Inventory inventoryIdentifier(String inventoryIdentifier) {
    
    this.inventoryIdentifier = inventoryIdentifier;
    return this;
  }

   /**
   * Inventory identifier
   * @return inventoryIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "Inventory identifier")
  @JsonProperty(JSON_PROPERTY_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getInventoryIdentifier() {
    return inventoryIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryIdentifier(String inventoryIdentifier) {
    this.inventoryIdentifier = inventoryIdentifier;
  }


  public Inventory inventoryName(String inventoryName) {
    
    this.inventoryName = inventoryName;
    return this;
  }

   /**
   * Name of inventory as hotel is seeing it
   * @return inventoryName
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "Name of inventory as hotel is seeing it")
  @JsonProperty(JSON_PROPERTY_INVENTORY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getInventoryName() {
    return inventoryName;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryName(String inventoryName) {
    this.inventoryName = inventoryName;
  }


  public Inventory enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Whether this inventory is enabled or not
   * @return enabled
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Whether this inventory is enabled or not")
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public Inventory imageIdentifier(String imageIdentifier) {
    
    this.imageIdentifier = imageIdentifier;
    return this;
  }

   /**
   * Main image of inventory
   * @return imageIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Main image of inventory")
  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImageIdentifier() {
    return imageIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageIdentifier(String imageIdentifier) {
    this.imageIdentifier = imageIdentifier;
  }


  public Inventory basePrice(Moneys basePrice) {
    
    this.basePrice = basePrice;
    return this;
  }

   /**
   * Get basePrice
   * @return basePrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BASE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getBasePrice() {
    return basePrice;
  }


  @JsonProperty(JSON_PROPERTY_BASE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBasePrice(Moneys basePrice) {
    this.basePrice = basePrice;
  }


  public Inventory commonBasePrice(Moneys commonBasePrice) {
    
    this.commonBasePrice = commonBasePrice;
    return this;
  }

   /**
   * Get commonBasePrice
   * @return commonBasePrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COMMON_BASE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getCommonBasePrice() {
    return commonBasePrice;
  }


  @JsonProperty(JSON_PROPERTY_COMMON_BASE_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommonBasePrice(Moneys commonBasePrice) {
    this.commonBasePrice = commonBasePrice;
  }


  public Inventory location(GeoJsonPoint location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoJsonPoint getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocation(GeoJsonPoint location) {
    this.location = location;
  }


  public Inventory city(GeoName city) {
    
    this.city = city;
    return this;
  }

   /**
   * Get city
   * @return city
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoName getCity() {
    return city;
  }


  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCity(GeoName city) {
    this.city = city;
  }


  public Inventory quantity(Integer quantity) {
    
    this.quantity = quantity;
    return this;
  }

   /**
   * quantity
   * @return quantity
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "100", value = "quantity")
  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }


  public Inventory commissionable(Boolean commissionable) {
    
    this.commissionable = commissionable;
    return this;
  }

   /**
   * Whether this is commissionable or not
   * @return commissionable
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Whether this is commissionable or not")
  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCommissionable() {
    return commissionable;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionable(Boolean commissionable) {
    this.commissionable = commissionable;
  }


  public Inventory bookable(Boolean bookable) {
    
    this.bookable = bookable;
    return this;
  }

   /**
   * Whether inventory can be booked
   * @return bookable
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Whether inventory can be booked")
  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getBookable() {
    return bookable;
  }


  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookable(Boolean bookable) {
    this.bookable = bookable;
  }


  public Inventory hotel(HotelOnMap hotel) {
    
    this.hotel = hotel;
    return this;
  }

   /**
   * Get hotel
   * @return hotel
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public HotelOnMap getHotel() {
    return hotel;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotel(HotelOnMap hotel) {
    this.hotel = hotel;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Inventory inventory = (Inventory) o;
    return Objects.equals(this.identifier, inventory.identifier) &&
        Objects.equals(this.salesChannel, inventory.salesChannel) &&
        Objects.equals(this.inventoryType, inventory.inventoryType) &&
        Objects.equals(this.inventoryIdentifier, inventory.inventoryIdentifier) &&
        Objects.equals(this.inventoryName, inventory.inventoryName) &&
        Objects.equals(this.enabled, inventory.enabled) &&
        Objects.equals(this.imageIdentifier, inventory.imageIdentifier) &&
        Objects.equals(this.basePrice, inventory.basePrice) &&
        Objects.equals(this.commonBasePrice, inventory.commonBasePrice) &&
        Objects.equals(this.location, inventory.location) &&
        Objects.equals(this.city, inventory.city) &&
        Objects.equals(this.quantity, inventory.quantity) &&
        Objects.equals(this.commissionable, inventory.commissionable) &&
        Objects.equals(this.bookable, inventory.bookable) &&
        Objects.equals(this.hotel, inventory.hotel);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, salesChannel, inventoryType, inventoryIdentifier, inventoryName, enabled, imageIdentifier, basePrice, commonBasePrice, location, city, quantity, commissionable, bookable, hotel);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Inventory {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    salesChannel: ").append(toIndentedString(salesChannel)).append("\n");
    sb.append("    inventoryType: ").append(toIndentedString(inventoryType)).append("\n");
    sb.append("    inventoryIdentifier: ").append(toIndentedString(inventoryIdentifier)).append("\n");
    sb.append("    inventoryName: ").append(toIndentedString(inventoryName)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    imageIdentifier: ").append(toIndentedString(imageIdentifier)).append("\n");
    sb.append("    basePrice: ").append(toIndentedString(basePrice)).append("\n");
    sb.append("    commonBasePrice: ").append(toIndentedString(commonBasePrice)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    commissionable: ").append(toIndentedString(commissionable)).append("\n");
    sb.append("    bookable: ").append(toIndentedString(bookable)).append("\n");
    sb.append("    hotel: ").append(toIndentedString(hotel)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

