/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink platform. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 19.0.10-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import travel.wink.sdk.extranet.model.Moneys;
import travel.wink.sdk.extranet.model.Quote;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Localized unit price (per person)
 */
@ApiModel(description = "Localized unit price (per person)")
@JsonPropertyOrder({
  LocalizedPrice.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL,
  LocalizedPrice.JSON_PROPERTY_SOURCE_BASE_TOTAL,
  LocalizedPrice.JSON_PROPERTY_INTERNAL_BASE_TOTAL,
  LocalizedPrice.JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER,
  LocalizedPrice.JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER,
  LocalizedPrice.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER,
  LocalizedPrice.JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER,
  LocalizedPrice.JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER,
  LocalizedPrice.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER,
  LocalizedPrice.JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER,
  LocalizedPrice.JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER,
  LocalizedPrice.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER,
  LocalizedPrice.JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT,
  LocalizedPrice.JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT,
  LocalizedPrice.JSON_PROPERTY_PREMIUM_PERCENT,
  LocalizedPrice.JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE,
  LocalizedPrice.JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE,
  LocalizedPrice.JSON_PROPERTY_SOURCE_TOTAL,
  LocalizedPrice.JSON_PROPERTY_INTERNAL_TOTAL,
  LocalizedPrice.JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT,
  LocalizedPrice.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-27T09:29:05.118372+07:00[Asia/Bangkok]")
public class LocalizedPrice {
  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL = "userSpecifiedCurrencyBaseTotal";
  private Moneys userSpecifiedCurrencyBaseTotal;

  public static final String JSON_PROPERTY_SOURCE_BASE_TOTAL = "sourceBaseTotal";
  private Moneys sourceBaseTotal;

  public static final String JSON_PROPERTY_INTERNAL_BASE_TOTAL = "internalBaseTotal";
  private Moneys internalBaseTotal;

  public static final String JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER = "sourcePromotionalModifier";
  private Double sourcePromotionalModifier;

  public static final String JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER = "internalPromotionalModifier";
  private Double internalPromotionalModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER = "userSpecifiedCurrencyPromotionalModifier";
  private Double userSpecifiedCurrencyPromotionalModifier;

  public static final String JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER = "sourcePremiumModifier";
  private Double sourcePremiumModifier;

  public static final String JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER = "internalPremiumModifier";
  private Double internalPremiumModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER = "userSpecifiedCurrencyPremiumModifier";
  private Double userSpecifiedCurrencyPremiumModifier;

  public static final String JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER = "sourceChannelModifier";
  private Double sourceChannelModifier;

  public static final String JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER = "internalChannelModifier";
  private Double internalChannelModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER = "userSpecifiedCurrencyChannelModifier";
  private Double userSpecifiedCurrencyChannelModifier;

  public static final String JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT = "promotionalDiscountPercent";
  private Float promotionalDiscountPercent;

  public static final String JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT = "channelDiscountPercent";
  private Float channelDiscountPercent;

  public static final String JSON_PROPERTY_PREMIUM_PERCENT = "premiumPercent";
  private Float premiumPercent;

  public static final String JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE = "sourceToUserCurrencyQuote";
  private Quote sourceToUserCurrencyQuote;

  public static final String JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE = "sourceToInternalCurrencyQuote";
  private Quote sourceToInternalCurrencyQuote;

  public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
  private Moneys sourceTotal;

  public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
  private Moneys internalTotal;

  public static final String JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT = "totalDiscountPercent";
  private Float totalDiscountPercent;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
  private Moneys userSpecifiedCurrencyTotal;

  public LocalizedPrice() { 
  }

  public LocalizedPrice userSpecifiedCurrencyBaseTotal(Moneys userSpecifiedCurrencyBaseTotal) {
    
    this.userSpecifiedCurrencyBaseTotal = userSpecifiedCurrencyBaseTotal;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyBaseTotal
   * @return userSpecifiedCurrencyBaseTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getUserSpecifiedCurrencyBaseTotal() {
    return userSpecifiedCurrencyBaseTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyBaseTotal(Moneys userSpecifiedCurrencyBaseTotal) {
    this.userSpecifiedCurrencyBaseTotal = userSpecifiedCurrencyBaseTotal;
  }


  public LocalizedPrice sourceBaseTotal(Moneys sourceBaseTotal) {
    
    this.sourceBaseTotal = sourceBaseTotal;
    return this;
  }

   /**
   * Get sourceBaseTotal
   * @return sourceBaseTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getSourceBaseTotal() {
    return sourceBaseTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceBaseTotal(Moneys sourceBaseTotal) {
    this.sourceBaseTotal = sourceBaseTotal;
  }


  public LocalizedPrice internalBaseTotal(Moneys internalBaseTotal) {
    
    this.internalBaseTotal = internalBaseTotal;
    return this;
  }

   /**
   * Get internalBaseTotal
   * @return internalBaseTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getInternalBaseTotal() {
    return internalBaseTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalBaseTotal(Moneys internalBaseTotal) {
    this.internalBaseTotal = internalBaseTotal;
  }


  public LocalizedPrice sourcePromotionalModifier(Double sourcePromotionalModifier) {
    
    this.sourcePromotionalModifier = sourcePromotionalModifier;
    return this;
  }

   /**
   * Promotional modifiers in hotel currency
   * @return sourcePromotionalModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "-40", value = "Promotional modifiers in hotel currency")
  @JsonProperty(JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourcePromotionalModifier() {
    return sourcePromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourcePromotionalModifier(Double sourcePromotionalModifier) {
    this.sourcePromotionalModifier = sourcePromotionalModifier;
  }


  public LocalizedPrice internalPromotionalModifier(Double internalPromotionalModifier) {
    
    this.internalPromotionalModifier = internalPromotionalModifier;
    return this;
  }

   /**
   * Promotional modifiers in traveliko currency
   * @return internalPromotionalModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "-40", value = "Promotional modifiers in traveliko currency")
  @JsonProperty(JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalPromotionalModifier() {
    return internalPromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalPromotionalModifier(Double internalPromotionalModifier) {
    this.internalPromotionalModifier = internalPromotionalModifier;
  }


  public LocalizedPrice userSpecifiedCurrencyPromotionalModifier(Double userSpecifiedCurrencyPromotionalModifier) {
    
    this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
    return this;
  }

   /**
   * Promotional modifiers in user specified currency
   * @return userSpecifiedCurrencyPromotionalModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "-40", value = "Promotional modifiers in user specified currency")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUserSpecifiedCurrencyPromotionalModifier() {
    return userSpecifiedCurrencyPromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyPromotionalModifier(Double userSpecifiedCurrencyPromotionalModifier) {
    this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
  }


  public LocalizedPrice sourcePremiumModifier(Double sourcePremiumModifier) {
    
    this.sourcePremiumModifier = sourcePremiumModifier;
    return this;
  }

   /**
   * Premium modifiers in hotel currency
   * @return sourcePremiumModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "40", value = "Premium modifiers in hotel currency")
  @JsonProperty(JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourcePremiumModifier() {
    return sourcePremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourcePremiumModifier(Double sourcePremiumModifier) {
    this.sourcePremiumModifier = sourcePremiumModifier;
  }


  public LocalizedPrice internalPremiumModifier(Double internalPremiumModifier) {
    
    this.internalPremiumModifier = internalPremiumModifier;
    return this;
  }

   /**
   * Premium modifiers in traveliko currency
   * @return internalPremiumModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "40", value = "Premium modifiers in traveliko currency")
  @JsonProperty(JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalPremiumModifier() {
    return internalPremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalPremiumModifier(Double internalPremiumModifier) {
    this.internalPremiumModifier = internalPremiumModifier;
  }


  public LocalizedPrice userSpecifiedCurrencyPremiumModifier(Double userSpecifiedCurrencyPremiumModifier) {
    
    this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
    return this;
  }

   /**
   * Premium modifiers in user specified currency
   * @return userSpecifiedCurrencyPremiumModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "40", value = "Premium modifiers in user specified currency")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUserSpecifiedCurrencyPremiumModifier() {
    return userSpecifiedCurrencyPremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyPremiumModifier(Double userSpecifiedCurrencyPremiumModifier) {
    this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
  }


  public LocalizedPrice sourceChannelModifier(Double sourceChannelModifier) {
    
    this.sourceChannelModifier = sourceChannelModifier;
    return this;
  }

   /**
   * Channel / Membership modifier in hotel currency
   * @return sourceChannelModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "-10", value = "Channel / Membership modifier in hotel currency")
  @JsonProperty(JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourceChannelModifier() {
    return sourceChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceChannelModifier(Double sourceChannelModifier) {
    this.sourceChannelModifier = sourceChannelModifier;
  }


  public LocalizedPrice internalChannelModifier(Double internalChannelModifier) {
    
    this.internalChannelModifier = internalChannelModifier;
    return this;
  }

   /**
   * Channel / Membership modifier in traveliko currency
   * @return internalChannelModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "-10", value = "Channel / Membership modifier in traveliko currency")
  @JsonProperty(JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalChannelModifier() {
    return internalChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalChannelModifier(Double internalChannelModifier) {
    this.internalChannelModifier = internalChannelModifier;
  }


  public LocalizedPrice userSpecifiedCurrencyChannelModifier(Double userSpecifiedCurrencyChannelModifier) {
    
    this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
    return this;
  }

   /**
   * Channel / Membership modifier in user specified currency
   * @return userSpecifiedCurrencyChannelModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "-10", value = "Channel / Membership modifier in user specified currency")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUserSpecifiedCurrencyChannelModifier() {
    return userSpecifiedCurrencyChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyChannelModifier(Double userSpecifiedCurrencyChannelModifier) {
    this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
  }


  public LocalizedPrice promotionalDiscountPercent(Float promotionalDiscountPercent) {
    
    this.promotionalDiscountPercent = promotionalDiscountPercent;
    return this;
  }

   /**
   * Promotional discount percent
   * @return promotionalDiscountPercent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Promotional discount percent")
  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPromotionalDiscountPercent() {
    return promotionalDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalDiscountPercent(Float promotionalDiscountPercent) {
    this.promotionalDiscountPercent = promotionalDiscountPercent;
  }


  public LocalizedPrice channelDiscountPercent(Float channelDiscountPercent) {
    
    this.channelDiscountPercent = channelDiscountPercent;
    return this;
  }

   /**
   * Channel discount percent
   * @return channelDiscountPercent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Channel discount percent")
  @JsonProperty(JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getChannelDiscountPercent() {
    return channelDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannelDiscountPercent(Float channelDiscountPercent) {
    this.channelDiscountPercent = channelDiscountPercent;
  }


  public LocalizedPrice premiumPercent(Float premiumPercent) {
    
    this.premiumPercent = premiumPercent;
    return this;
  }

   /**
   * Premium percent
   * @return premiumPercent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Premium percent")
  @JsonProperty(JSON_PROPERTY_PREMIUM_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPremiumPercent() {
    return premiumPercent;
  }


  @JsonProperty(JSON_PROPERTY_PREMIUM_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPremiumPercent(Float premiumPercent) {
    this.premiumPercent = premiumPercent;
  }


  public LocalizedPrice sourceToUserCurrencyQuote(Quote sourceToUserCurrencyQuote) {
    
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
    return this;
  }

   /**
   * Get sourceToUserCurrencyQuote
   * @return sourceToUserCurrencyQuote
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Quote getSourceToUserCurrencyQuote() {
    return sourceToUserCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceToUserCurrencyQuote(Quote sourceToUserCurrencyQuote) {
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
  }


  public LocalizedPrice sourceToInternalCurrencyQuote(Quote sourceToInternalCurrencyQuote) {
    
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
    return this;
  }

   /**
   * Get sourceToInternalCurrencyQuote
   * @return sourceToInternalCurrencyQuote
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Quote getSourceToInternalCurrencyQuote() {
    return sourceToInternalCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceToInternalCurrencyQuote(Quote sourceToInternalCurrencyQuote) {
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
  }


  public LocalizedPrice sourceTotal(Moneys sourceTotal) {
    
    this.sourceTotal = sourceTotal;
    return this;
  }

   /**
   * Get sourceTotal
   * @return sourceTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getSourceTotal() {
    return sourceTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceTotal(Moneys sourceTotal) {
    this.sourceTotal = sourceTotal;
  }


  public LocalizedPrice internalTotal(Moneys internalTotal) {
    
    this.internalTotal = internalTotal;
    return this;
  }

   /**
   * Get internalTotal
   * @return internalTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getInternalTotal() {
    return internalTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalTotal(Moneys internalTotal) {
    this.internalTotal = internalTotal;
  }


  public LocalizedPrice totalDiscountPercent(Float totalDiscountPercent) {
    
    this.totalDiscountPercent = totalDiscountPercent;
    return this;
  }

   /**
   * Get totalDiscountPercent
   * @return totalDiscountPercent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalDiscountPercent() {
    return totalDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalDiscountPercent(Float totalDiscountPercent) {
    this.totalDiscountPercent = totalDiscountPercent;
  }


  public LocalizedPrice userSpecifiedCurrencyTotal(Moneys userSpecifiedCurrencyTotal) {
    
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyTotal
   * @return userSpecifiedCurrencyTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getUserSpecifiedCurrencyTotal() {
    return userSpecifiedCurrencyTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyTotal(Moneys userSpecifiedCurrencyTotal) {
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LocalizedPrice localizedPrice = (LocalizedPrice) o;
    return Objects.equals(this.userSpecifiedCurrencyBaseTotal, localizedPrice.userSpecifiedCurrencyBaseTotal) &&
        Objects.equals(this.sourceBaseTotal, localizedPrice.sourceBaseTotal) &&
        Objects.equals(this.internalBaseTotal, localizedPrice.internalBaseTotal) &&
        Objects.equals(this.sourcePromotionalModifier, localizedPrice.sourcePromotionalModifier) &&
        Objects.equals(this.internalPromotionalModifier, localizedPrice.internalPromotionalModifier) &&
        Objects.equals(this.userSpecifiedCurrencyPromotionalModifier, localizedPrice.userSpecifiedCurrencyPromotionalModifier) &&
        Objects.equals(this.sourcePremiumModifier, localizedPrice.sourcePremiumModifier) &&
        Objects.equals(this.internalPremiumModifier, localizedPrice.internalPremiumModifier) &&
        Objects.equals(this.userSpecifiedCurrencyPremiumModifier, localizedPrice.userSpecifiedCurrencyPremiumModifier) &&
        Objects.equals(this.sourceChannelModifier, localizedPrice.sourceChannelModifier) &&
        Objects.equals(this.internalChannelModifier, localizedPrice.internalChannelModifier) &&
        Objects.equals(this.userSpecifiedCurrencyChannelModifier, localizedPrice.userSpecifiedCurrencyChannelModifier) &&
        Objects.equals(this.promotionalDiscountPercent, localizedPrice.promotionalDiscountPercent) &&
        Objects.equals(this.channelDiscountPercent, localizedPrice.channelDiscountPercent) &&
        Objects.equals(this.premiumPercent, localizedPrice.premiumPercent) &&
        Objects.equals(this.sourceToUserCurrencyQuote, localizedPrice.sourceToUserCurrencyQuote) &&
        Objects.equals(this.sourceToInternalCurrencyQuote, localizedPrice.sourceToInternalCurrencyQuote) &&
        Objects.equals(this.sourceTotal, localizedPrice.sourceTotal) &&
        Objects.equals(this.internalTotal, localizedPrice.internalTotal) &&
        Objects.equals(this.totalDiscountPercent, localizedPrice.totalDiscountPercent) &&
        Objects.equals(this.userSpecifiedCurrencyTotal, localizedPrice.userSpecifiedCurrencyTotal);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userSpecifiedCurrencyBaseTotal, sourceBaseTotal, internalBaseTotal, sourcePromotionalModifier, internalPromotionalModifier, userSpecifiedCurrencyPromotionalModifier, sourcePremiumModifier, internalPremiumModifier, userSpecifiedCurrencyPremiumModifier, sourceChannelModifier, internalChannelModifier, userSpecifiedCurrencyChannelModifier, promotionalDiscountPercent, channelDiscountPercent, premiumPercent, sourceToUserCurrencyQuote, sourceToInternalCurrencyQuote, sourceTotal, internalTotal, totalDiscountPercent, userSpecifiedCurrencyTotal);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LocalizedPrice {\n");
    sb.append("    userSpecifiedCurrencyBaseTotal: ").append(toIndentedString(userSpecifiedCurrencyBaseTotal)).append("\n");
    sb.append("    sourceBaseTotal: ").append(toIndentedString(sourceBaseTotal)).append("\n");
    sb.append("    internalBaseTotal: ").append(toIndentedString(internalBaseTotal)).append("\n");
    sb.append("    sourcePromotionalModifier: ").append(toIndentedString(sourcePromotionalModifier)).append("\n");
    sb.append("    internalPromotionalModifier: ").append(toIndentedString(internalPromotionalModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyPromotionalModifier: ").append(toIndentedString(userSpecifiedCurrencyPromotionalModifier)).append("\n");
    sb.append("    sourcePremiumModifier: ").append(toIndentedString(sourcePremiumModifier)).append("\n");
    sb.append("    internalPremiumModifier: ").append(toIndentedString(internalPremiumModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyPremiumModifier: ").append(toIndentedString(userSpecifiedCurrencyPremiumModifier)).append("\n");
    sb.append("    sourceChannelModifier: ").append(toIndentedString(sourceChannelModifier)).append("\n");
    sb.append("    internalChannelModifier: ").append(toIndentedString(internalChannelModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyChannelModifier: ").append(toIndentedString(userSpecifiedCurrencyChannelModifier)).append("\n");
    sb.append("    promotionalDiscountPercent: ").append(toIndentedString(promotionalDiscountPercent)).append("\n");
    sb.append("    channelDiscountPercent: ").append(toIndentedString(channelDiscountPercent)).append("\n");
    sb.append("    premiumPercent: ").append(toIndentedString(premiumPercent)).append("\n");
    sb.append("    sourceToUserCurrencyQuote: ").append(toIndentedString(sourceToUserCurrencyQuote)).append("\n");
    sb.append("    sourceToInternalCurrencyQuote: ").append(toIndentedString(sourceToInternalCurrencyQuote)).append("\n");
    sb.append("    sourceTotal: ").append(toIndentedString(sourceTotal)).append("\n");
    sb.append("    internalTotal: ").append(toIndentedString(internalTotal)).append("\n");
    sb.append("    totalDiscountPercent: ").append(toIndentedString(totalDiscountPercent)).append("\n");
    sb.append("    userSpecifiedCurrencyTotal: ").append(toIndentedString(userSpecifiedCurrencyTotal)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

