/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.sdk.extranet.model.SimpleDescription;

@ApiModel(description="Multimedia")
@JsonPropertyOrder(value={"multimediaIdentifier", "identifier", "hotelIdentifier", "type", "source", "sort", "published", "category", "captions", "lifestyleType", "angle", "width", "height", "isLandscape"})
public class Multimedia {
    public static final String JSON_PROPERTY_MULTIMEDIA_IDENTIFIER = "multimediaIdentifier";
    private String multimediaIdentifier;
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private String hotelIdentifier;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_SOURCE = "source";
    private SourceEnum source = SourceEnum.CLOUDINARY;
    public static final String JSON_PROPERTY_SORT = "sort";
    private Integer sort = 999;
    public static final String JSON_PROPERTY_PUBLISHED = "published";
    private Boolean published = false;
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private String category;
    public static final String JSON_PROPERTY_CAPTIONS = "captions";
    private List<SimpleDescription> captions = null;
    public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
    private LifestyleTypeEnum lifestyleType;
    public static final String JSON_PROPERTY_ANGLE = "angle";
    private String angle;
    public static final String JSON_PROPERTY_WIDTH = "width";
    private Integer width;
    public static final String JSON_PROPERTY_HEIGHT = "height";
    private Integer height;
    public static final String JSON_PROPERTY_IS_LANDSCAPE = "isLandscape";
    private Boolean isLandscape;

    public Multimedia multimediaIdentifier(String multimediaIdentifier) {
        this.multimediaIdentifier = multimediaIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="image-1", value="Document identifier")
    @JsonProperty(value="multimediaIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMultimediaIdentifier() {
        return this.multimediaIdentifier;
    }

    @JsonProperty(value="multimediaIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMultimediaIdentifier(String multimediaIdentifier) {
        this.multimediaIdentifier = multimediaIdentifier;
    }

    public Multimedia identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="cloudinary-image-1", value="Use this identifier to communicate with Cloudinary.")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Multimedia hotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="hotel-1", value="Owner identifier of property that owns the multimedia record.")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public Multimedia type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="IMAGE", value="Whether Cloudinary media is a VIDEO or IMAGE.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Multimedia source(SourceEnum source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="CLOUDINARY", value="Currently ONLY using Cloudinary to store all image / video assets.")
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SourceEnum getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSource(SourceEnum source) {
        this.source = source;
    }

    public Multimedia sort(Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="Sort allows you to control how you want to sort this record in a list of media records.")
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Multimedia published(Boolean published) {
        this.published = published;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Instead of deleting the media, choose to un-publish it instead for later re-use. Could be you keep seasonal images of the property.")
    @JsonProperty(value="published")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPublished() {
        return this.published;
    }

    @JsonProperty(value="published")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPublished(Boolean published) {
        this.published = published;
    }

    public Multimedia category(String category) {
        this.category = category;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="Supported OTA specification `PIC` code. See [OTA reference data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategory(String category) {
        this.category = category;
    }

    public Multimedia captions(List<SimpleDescription> captions) {
        this.captions = captions;
        return this;
    }

    public Multimedia addCaptionsItem(SimpleDescription captionsItem) {
        if (this.captions == null) {
            this.captions = new ArrayList<SimpleDescription>();
        }
        this.captions.add(captionsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Localized media captions to give user some context about where this media was taken.")
    @JsonProperty(value="captions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SimpleDescription> getCaptions() {
        return this.captions;
    }

    @JsonProperty(value="captions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCaptions(List<SimpleDescription> captions) {
        this.captions = captions;
    }

    public Multimedia lifestyleType(LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="LIFESTYLE_HEALTH_FITNESS", value="Associate this media with a specific lifestyle type. A user searching and filtering inventory based on lifestyles can be shown relevant media first.")
    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifestyleTypeEnum getLifestyleType() {
        return this.lifestyleType;
    }

    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifestyleType(LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
    }

    public Multimedia angle(String angle) {
        this.angle = angle;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-90", value="Media angle")
    @JsonProperty(value="angle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAngle() {
        return this.angle;
    }

    @JsonProperty(value="angle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAngle(String angle) {
        this.angle = angle;
    }

    public Multimedia width(Integer width) {
        this.width = width;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2560", value="Media width in pixels.")
    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getWidth() {
        return this.width;
    }

    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWidth(Integer width) {
        this.width = width;
    }

    public Multimedia height(Integer height) {
        this.height = height;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1600", value="Media height in pixels.")
    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getHeight() {
        return this.height;
    }

    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeight(Integer height) {
        this.height = height;
    }

    public Multimedia isLandscape(Boolean isLandscape) {
        this.isLandscape = isLandscape;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="True if media width is greater or equal to height")
    @JsonProperty(value="isLandscape")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsLandscape() {
        return this.isLandscape;
    }

    @JsonProperty(value="isLandscape")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsLandscape(Boolean isLandscape) {
        this.isLandscape = isLandscape;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Multimedia multimedia = (Multimedia)o;
        return Objects.equals(this.multimediaIdentifier, multimedia.multimediaIdentifier) && Objects.equals(this.identifier, multimedia.identifier) && Objects.equals(this.hotelIdentifier, multimedia.hotelIdentifier) && Objects.equals((Object)this.type, (Object)multimedia.type) && Objects.equals((Object)this.source, (Object)multimedia.source) && Objects.equals(this.sort, multimedia.sort) && Objects.equals(this.published, multimedia.published) && Objects.equals(this.category, multimedia.category) && Objects.equals(this.captions, multimedia.captions) && Objects.equals((Object)this.lifestyleType, (Object)multimedia.lifestyleType) && Objects.equals(this.angle, multimedia.angle) && Objects.equals(this.width, multimedia.width) && Objects.equals(this.height, multimedia.height) && Objects.equals(this.isLandscape, multimedia.isLandscape);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.multimediaIdentifier, this.identifier, this.hotelIdentifier, this.type, this.source, this.sort, this.published, this.category, this.captions, this.lifestyleType, this.angle, this.width, this.height, this.isLandscape});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Multimedia {\n");
        sb.append("    multimediaIdentifier: ").append(this.toIndentedString(this.multimediaIdentifier)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    published: ").append(this.toIndentedString(this.published)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    captions: ").append(this.toIndentedString(this.captions)).append("\n");
        sb.append("    lifestyleType: ").append(this.toIndentedString((Object)this.lifestyleType)).append("\n");
        sb.append("    angle: ").append(this.toIndentedString(this.angle)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    isLandscape: ").append(this.toIndentedString(this.isLandscape)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SourceEnum {
        YOUTUBE("YOUTUBE"),
        CLOUDINARY("CLOUDINARY");

        private String value;

        private SourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SourceEnum fromValue(String value) {
            for (SourceEnum b : SourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        IMAGE("IMAGE"),
        VIDEO("VIDEO");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum LifestyleTypeEnum {
        HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
        RELAX("LIFESTYLE_RELAX"),
        ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
        ADVENTURE("LIFESTYLE_ADVENTURE"),
        BUSINESS("LIFESTYLE_BUSINESS"),
        LGBT("LIFESTYLE_LGBT"),
        SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
        SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
        BEAUTY("LIFESTYLE_BEAUTY"),
        FOODIE("LIFESTYLE_FOODIE"),
        FAMILY("LIFESTYLE_FAMILY"),
        ROMANCE("LIFESTYLE_ROMANCE"),
        COUPLE("LIFESTYLE_COUPLE"),
        SOLO("LIFESTYLE_SOLO"),
        BACKPACKER("LIFESTYLE_BACKPACKER"),
        SHOPPING("LIFESTYLE_SHOPPING"),
        SPORTS("LIFESTYLE_SPORTS"),
        MOUNTAIN("LIFESTYLE_MOUNTAIN"),
        BEACH("LIFESTYLE_BEACH"),
        CITY("LIFESTYLE_CITY"),
        COUNTRY("LIFESTYLE_COUNTRY"),
        CULTURE("LIFESTYLE_CULTURE"),
        ECO("LIFESTYLE_ECO");

        private String value;

        private LifestyleTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LifestyleTypeEnum fromValue(String value) {
            for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

