package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.Bundle;
import travel.wink.sdk.extranet.model.BundleView;
import java.io.File;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.Multimedia;
import travel.wink.sdk.extranet.model.PackageRemovableResponse;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.ShowHotelStatus400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-27T09:47:48.902297+07:00[Asia/Bangkok]")
public class PackageApi {
    private ApiClient apiClient;

    public PackageApi() {
        this(new ApiClient());
    }

    @Autowired
    public PackageApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Add Multimedia
     * Add a media record for a video and/or image to a package identified by its identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Add package media for hotel associated with this hotel identifier
     * @param packageIdentifier Add package media to package with this identifier
     * @param multimedia The multimedia parameter
     * @return BundleView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec addMediaRequestCreation(String hotelIdentifier, String packageIdentifier, Multimedia multimedia) throws WebClientResponseException {
        Object postBody = multimedia;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling addMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'packageIdentifier' is set
        if (packageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'packageIdentifier' when calling addMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'multimedia' is set
        if (multimedia == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimedia' when calling addMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("packageIdentifier", packageIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/bundle/{packageIdentifier}/multimedia", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Add Multimedia
     * Add a media record for a video and/or image to a package identified by its identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Add package media for hotel associated with this hotel identifier
     * @param packageIdentifier Add package media to package with this identifier
     * @param multimedia The multimedia parameter
     * @return BundleView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BundleView> addMedia(String hotelIdentifier, String packageIdentifier, Multimedia multimedia) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>() {};
        return addMediaRequestCreation(hotelIdentifier, packageIdentifier, multimedia).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BundleView>> addMediaWithHttpInfo(String hotelIdentifier, String packageIdentifier, Multimedia multimedia) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>() {};
        return addMediaRequestCreation(hotelIdentifier, packageIdentifier, multimedia).toEntity(localVarReturnType);
    }
    /**
     * Verify Removable
     * Check if an package is removable. If an package is associated / linked with a promotion or rate plan, it cannot be removed until the associated entity removes it first.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Verify if package is removable for package associated with this hotel identifier
     * @param packageIdentifier Verify if package with this identifier is removable
     * @param accept The accept parameter
     * @return PackageRemovableResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removableBundleRequestCreation(String hotelIdentifier, String packageIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removableBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'packageIdentifier' is set
        if (packageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'packageIdentifier' when calling removableBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("packageIdentifier", packageIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<PackageRemovableResponse> localVarReturnType = new ParameterizedTypeReference<PackageRemovableResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/bundle/{packageIdentifier}/removable", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Verify Removable
     * Check if an package is removable. If an package is associated / linked with a promotion or rate plan, it cannot be removed until the associated entity removes it first.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Verify if package is removable for package associated with this hotel identifier
     * @param packageIdentifier Verify if package with this identifier is removable
     * @param accept The accept parameter
     * @return PackageRemovableResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PackageRemovableResponse> removableBundle(String hotelIdentifier, String packageIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PackageRemovableResponse> localVarReturnType = new ParameterizedTypeReference<PackageRemovableResponse>() {};
        return removableBundleRequestCreation(hotelIdentifier, packageIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PackageRemovableResponse>> removableBundleWithHttpInfo(String hotelIdentifier, String packageIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PackageRemovableResponse> localVarReturnType = new ParameterizedTypeReference<PackageRemovableResponse>() {};
        return removableBundleRequestCreation(hotelIdentifier, packageIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Delete Multimedia
     * Remove package image / video by its identifier. Returns the updated package record.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove package media associated with this hotel identifier
     * @param packageIdentifier Remove package media for this package identifier
     * @param multimediaIdentifier Remove package media with this identifier
     * @param accept The accept parameter
     * @return BundleView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeMultimedia5RequestCreation(String hotelIdentifier, String packageIdentifier, String multimediaIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeMultimedia5", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'packageIdentifier' is set
        if (packageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'packageIdentifier' when calling removeMultimedia5", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'multimediaIdentifier' is set
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling removeMultimedia5", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("packageIdentifier", packageIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/bundle/{packageIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Multimedia
     * Remove package image / video by its identifier. Returns the updated package record.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove package media associated with this hotel identifier
     * @param packageIdentifier Remove package media for this package identifier
     * @param multimediaIdentifier Remove package media with this identifier
     * @param accept The accept parameter
     * @return BundleView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BundleView> removeMultimedia5(String hotelIdentifier, String packageIdentifier, String multimediaIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>() {};
        return removeMultimedia5RequestCreation(hotelIdentifier, packageIdentifier, multimediaIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BundleView>> removeMultimedia5WithHttpInfo(String hotelIdentifier, String packageIdentifier, String multimediaIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>() {};
        return removeMultimedia5RequestCreation(hotelIdentifier, packageIdentifier, multimediaIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Delete Package
     * Remove a package by its identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove package owned by this hotel identifier
     * @param packageIdentifier Remove package with this identifier
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removePackageRequestCreation(String hotelIdentifier, String packageIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removePackage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'packageIdentifier' is set
        if (packageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'packageIdentifier' when calling removePackage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("packageIdentifier", packageIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/bundle/{packageIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Package
     * Remove a package by its identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove package owned by this hotel identifier
     * @param packageIdentifier Remove package with this identifier
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removePackage(String hotelIdentifier, String packageIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removePackageRequestCreation(hotelIdentifier, packageIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removePackageWithHttpInfo(String hotelIdentifier, String packageIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removePackageRequestCreation(hotelIdentifier, packageIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Create Package
     * Create a new package
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create new package and associated with this hotel identifier
     * @param bundle The bundle parameter
     * @return BundleView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec savePackageRequestCreation(String hotelIdentifier, Bundle bundle) throws WebClientResponseException {
        Object postBody = bundle;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling savePackage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bundle' is set
        if (bundle == null) {
            throw new WebClientResponseException("Missing the required parameter 'bundle' when calling savePackage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/bundle", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Package
     * Create a new package
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create new package and associated with this hotel identifier
     * @param bundle The bundle parameter
     * @return BundleView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BundleView> savePackage(String hotelIdentifier, Bundle bundle) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>() {};
        return savePackageRequestCreation(hotelIdentifier, bundle).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BundleView>> savePackageWithHttpInfo(String hotelIdentifier, Bundle bundle) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>() {};
        return savePackageRequestCreation(hotelIdentifier, bundle).toEntity(localVarReturnType);
    }
    /**
     * Show Package
     * Retrieve a package by its identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show package associated with this hotel identifier
     * @param packageIdentifier Show package with this identifier
     * @param accept The accept parameter
     * @return BundleView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPackageRequestCreation(String hotelIdentifier, String packageIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPackage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'packageIdentifier' is set
        if (packageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'packageIdentifier' when calling showPackage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("packageIdentifier", packageIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/bundle/{packageIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Package
     * Retrieve a package by its identifier
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show package associated with this hotel identifier
     * @param packageIdentifier Show package with this identifier
     * @param accept The accept parameter
     * @return BundleView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BundleView> showPackage(String hotelIdentifier, String packageIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>() {};
        return showPackageRequestCreation(hotelIdentifier, packageIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BundleView>> showPackageWithHttpInfo(String hotelIdentifier, String packageIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>() {};
        return showPackageRequestCreation(hotelIdentifier, packageIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Packages
     * Retrieve list of packages for property.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show packages associated with this hotel identifier
     * @param accept The accept parameter
     * @return List&lt;BundleView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPackagesRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPackages", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/bundle/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Packages
     * Retrieve list of packages for property.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show packages associated with this hotel identifier
     * @param accept The accept parameter
     * @return List&lt;BundleView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BundleView> showPackages(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>() {};
        return showPackagesRequestCreation(hotelIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<BundleView>>> showPackagesWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>() {};
        return showPackagesRequestCreation(hotelIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Update Multimedia
     * Update media meta data for a specific package media entry.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update package media associated with this hotel identifier
     * @param packageIdentifier Update package media for this package identifier
     * @param multimediaIdentifier Update package media with this identifier
     * @param multimedia The multimedia parameter
     * @return BundleView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateMultimedia1RequestCreation(String hotelIdentifier, String packageIdentifier, String multimediaIdentifier, Multimedia multimedia) throws WebClientResponseException {
        Object postBody = multimedia;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateMultimedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'packageIdentifier' is set
        if (packageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'packageIdentifier' when calling updateMultimedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'multimediaIdentifier' is set
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling updateMultimedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'multimedia' is set
        if (multimedia == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimedia' when calling updateMultimedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("packageIdentifier", packageIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/bundle/{packageIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Multimedia
     * Update media meta data for a specific package media entry.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update package media associated with this hotel identifier
     * @param packageIdentifier Update package media for this package identifier
     * @param multimediaIdentifier Update package media with this identifier
     * @param multimedia The multimedia parameter
     * @return BundleView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BundleView> updateMultimedia1(String hotelIdentifier, String packageIdentifier, String multimediaIdentifier, Multimedia multimedia) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>() {};
        return updateMultimedia1RequestCreation(hotelIdentifier, packageIdentifier, multimediaIdentifier, multimedia).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BundleView>> updateMultimedia1WithHttpInfo(String hotelIdentifier, String packageIdentifier, String multimediaIdentifier, Multimedia multimedia) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>() {};
        return updateMultimedia1RequestCreation(hotelIdentifier, packageIdentifier, multimediaIdentifier, multimedia).toEntity(localVarReturnType);
    }
    /**
     * Update Package
     * Update an existing package
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update package associated with this hotel identifier
     * @param packageIdentifier Update package with this identifier
     * @param bundle The bundle parameter
     * @return BundleView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updatePackageRequestCreation(String hotelIdentifier, String packageIdentifier, Bundle bundle) throws WebClientResponseException {
        Object postBody = bundle;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updatePackage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'packageIdentifier' is set
        if (packageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'packageIdentifier' when calling updatePackage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bundle' is set
        if (bundle == null) {
            throw new WebClientResponseException("Missing the required parameter 'bundle' when calling updatePackage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("packageIdentifier", packageIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/bundle/{packageIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Package
     * Update an existing package
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update package associated with this hotel identifier
     * @param packageIdentifier Update package with this identifier
     * @param bundle The bundle parameter
     * @return BundleView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BundleView> updatePackage(String hotelIdentifier, String packageIdentifier, Bundle bundle) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>() {};
        return updatePackageRequestCreation(hotelIdentifier, packageIdentifier, bundle).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BundleView>> updatePackageWithHttpInfo(String hotelIdentifier, String packageIdentifier, Bundle bundle) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>() {};
        return updatePackageRequestCreation(hotelIdentifier, packageIdentifier, bundle).toEntity(localVarReturnType);
    }
    /**
     * Upload Binary Multimedia
     * Upload a list of binary / multipart videos and/or images to an existing package.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload package media associated with this hotel identifier
     * @param packageIdentifier Upload package media for this package identifier
     * @param files The files parameter
     * @return BundleView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec uploadBinaryPackageMediaRequestCreation(String hotelIdentifier, String packageIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadBinaryPackageMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'packageIdentifier' is set
        if (packageIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'packageIdentifier' when calling uploadBinaryPackageMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'files' is set
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadBinaryPackageMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("packageIdentifier", packageIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (files != null)
            formParams.addAll("files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "multipart/form-data"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/bundle/{packageIdentifier}/multimedia", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Upload Binary Multimedia
     * Upload a list of binary / multipart videos and/or images to an existing package.
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload package media associated with this hotel identifier
     * @param packageIdentifier Upload package media for this package identifier
     * @param files The files parameter
     * @return BundleView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BundleView> uploadBinaryPackageMedia(String hotelIdentifier, String packageIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>() {};
        return uploadBinaryPackageMediaRequestCreation(hotelIdentifier, packageIdentifier, files).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<BundleView>> uploadBinaryPackageMediaWithHttpInfo(String hotelIdentifier, String packageIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<BundleView> localVarReturnType = new ParameterizedTypeReference<BundleView>() {};
        return uploadBinaryPackageMediaRequestCreation(hotelIdentifier, packageIdentifier, files).toEntity(localVarReturnType);
    }
}
