/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"hotelIdentifier", "bookingIdentifier", "cancellable"})
public class BookingCancellable {
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private String hotelIdentifier;
    public static final String JSON_PROPERTY_BOOKING_IDENTIFIER = "bookingIdentifier";
    private String bookingIdentifier;
    public static final String JSON_PROPERTY_CANCELLABLE = "cancellable";
    private Boolean cancellable;

    public BookingCancellable hotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="hotel-1", required=true, value="Owner identifier of booking.")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public BookingCancellable bookingIdentifier(String bookingIdentifier) {
        this.bookingIdentifier = bookingIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="booking-1", required=true, value="Booking unique identifier.")
    @JsonProperty(value="bookingIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getBookingIdentifier() {
        return this.bookingIdentifier;
    }

    @JsonProperty(value="bookingIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBookingIdentifier(String bookingIdentifier) {
        this.bookingIdentifier = bookingIdentifier;
    }

    public BookingCancellable cancellable(Boolean cancellable) {
        this.cancellable = cancellable;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Whether booking can be cancelled or not.")
    @JsonProperty(value="cancellable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCancellable() {
        return this.cancellable;
    }

    @JsonProperty(value="cancellable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCancellable(Boolean cancellable) {
        this.cancellable = cancellable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookingCancellable bookingCancellable = (BookingCancellable)o;
        return Objects.equals(this.hotelIdentifier, bookingCancellable.hotelIdentifier) && Objects.equals(this.bookingIdentifier, bookingCancellable.bookingIdentifier) && Objects.equals(this.cancellable, bookingCancellable.cancellable);
    }

    public int hashCode() {
        return Objects.hash(this.hotelIdentifier, this.bookingIdentifier, this.cancellable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookingCancellable {\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    bookingIdentifier: ").append(this.toIndentedString(this.bookingIdentifier)).append("\n");
        sb.append("    cancellable: ").append(this.toIndentedString(this.cancellable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

