/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import travel.wink.sdk.extranet.model.BookingContractItem;
import travel.wink.sdk.extranet.model.BookingContractPaymentDetails;
import travel.wink.sdk.extranet.model.Moneys;
import travel.wink.sdk.extranet.model.QuoteData;

@ApiModel(description="Booking contract created by TripPay")
@JsonPropertyOrder(value={"id", "createdDate", "lastUpdate", "ipAddress", "traceId", "sourceUrl", "identifier", "supplierIdentifier", "supplierName", "displayPriceQuote", "supplierPriceQuote", "internalPriceQuote", "capturePriceQuote", "itemList", "externalSupplierIdentifier", "externalSupplierBookingCode", "payment", "cancelled", "cancelledOn", "canceller", "cancellationType", "cancellerUserIdentifier", "cancelReason", "totalSourcePrice", "totalDisplayPrice", "totalSupplierPrice", "totalInternalPrice", "totalCapturePrice", "totalSourcePriceAfterCancellation", "totalDisplayPriceAfterCancellation", "totalSupplierPriceAfterCancellation", "totalInternalPriceAfterCancellation", "totalCapturePriceAfterCancellation", "refundedSourcePrice", "refundedDisplayPrice", "refundedSupplierPrice", "refundedInternalPrice", "refundedCapturePrice", "totalTokensEarned", "cancellableBySupplier", "cancellableByTraveler", "cancellableWithNoCharges", "commissionableTotalSourceAmount", "commissionableTotalCaptureAmount", "commissionableTotalDisplayAmount", "commissionableTotalInternalAmount", "cancellationChargesIncurred", "commissionableTotalSupplierAmount"})
public class BookingContract {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    private OffsetDateTime createdDate;
    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    private OffsetDateTime lastUpdate;
    public static final String JSON_PROPERTY_IP_ADDRESS = "ipAddress";
    private String ipAddress;
    public static final String JSON_PROPERTY_TRACE_ID = "traceId";
    private String traceId;
    public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
    private String sourceUrl;
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
    private String supplierIdentifier;
    public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
    private String supplierName;
    public static final String JSON_PROPERTY_DISPLAY_PRICE_QUOTE = "displayPriceQuote";
    private QuoteData displayPriceQuote;
    public static final String JSON_PROPERTY_SUPPLIER_PRICE_QUOTE = "supplierPriceQuote";
    private QuoteData supplierPriceQuote;
    public static final String JSON_PROPERTY_INTERNAL_PRICE_QUOTE = "internalPriceQuote";
    private QuoteData internalPriceQuote;
    public static final String JSON_PROPERTY_CAPTURE_PRICE_QUOTE = "capturePriceQuote";
    private QuoteData capturePriceQuote;
    public static final String JSON_PROPERTY_ITEM_LIST = "itemList";
    private List<BookingContractItem> itemList = new ArrayList<BookingContractItem>();
    public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER = "externalSupplierIdentifier";
    private String externalSupplierIdentifier;
    public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
    private String externalSupplierBookingCode;
    public static final String JSON_PROPERTY_PAYMENT = "payment";
    private BookingContractPaymentDetails payment;
    public static final String JSON_PROPERTY_CANCELLED = "cancelled";
    private Boolean cancelled = false;
    public static final String JSON_PROPERTY_CANCELLED_ON = "cancelledOn";
    private OffsetDateTime cancelledOn;
    public static final String JSON_PROPERTY_CANCELLER = "canceller";
    private CancellerEnum canceller;
    public static final String JSON_PROPERTY_CANCELLATION_TYPE = "cancellationType";
    private CancellationTypeEnum cancellationType;
    public static final String JSON_PROPERTY_CANCELLER_USER_IDENTIFIER = "cancellerUserIdentifier";
    private String cancellerUserIdentifier;
    public static final String JSON_PROPERTY_CANCEL_REASON = "cancelReason";
    private String cancelReason;
    public static final String JSON_PROPERTY_TOTAL_SOURCE_PRICE = "totalSourcePrice";
    private Moneys totalSourcePrice;
    public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE = "totalDisplayPrice";
    private Moneys totalDisplayPrice;
    public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE = "totalSupplierPrice";
    private Moneys totalSupplierPrice;
    public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE = "totalInternalPrice";
    private Moneys totalInternalPrice;
    public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE = "totalCapturePrice";
    private Moneys totalCapturePrice;
    public static final String JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_CANCELLATION = "totalSourcePriceAfterCancellation";
    private Moneys totalSourcePriceAfterCancellation;
    public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_CANCELLATION = "totalDisplayPriceAfterCancellation";
    private Moneys totalDisplayPriceAfterCancellation;
    public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_CANCELLATION = "totalSupplierPriceAfterCancellation";
    private Moneys totalSupplierPriceAfterCancellation;
    public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_CANCELLATION = "totalInternalPriceAfterCancellation";
    private Moneys totalInternalPriceAfterCancellation;
    public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_CANCELLATION = "totalCapturePriceAfterCancellation";
    private Moneys totalCapturePriceAfterCancellation;
    public static final String JSON_PROPERTY_REFUNDED_SOURCE_PRICE = "refundedSourcePrice";
    private Moneys refundedSourcePrice;
    public static final String JSON_PROPERTY_REFUNDED_DISPLAY_PRICE = "refundedDisplayPrice";
    private Moneys refundedDisplayPrice;
    public static final String JSON_PROPERTY_REFUNDED_SUPPLIER_PRICE = "refundedSupplierPrice";
    private Moneys refundedSupplierPrice;
    public static final String JSON_PROPERTY_REFUNDED_INTERNAL_PRICE = "refundedInternalPrice";
    private Moneys refundedInternalPrice;
    public static final String JSON_PROPERTY_REFUNDED_CAPTURE_PRICE = "refundedCapturePrice";
    private Moneys refundedCapturePrice;
    public static final String JSON_PROPERTY_TOTAL_TOKENS_EARNED = "totalTokensEarned";
    private Long totalTokensEarned;
    public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
    private Boolean cancellableBySupplier;
    public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
    private Boolean cancellableByTraveler;
    public static final String JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES = "cancellableWithNoCharges";
    private Boolean cancellableWithNoCharges;
    public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT = "commissionableTotalSourceAmount";
    private Moneys commissionableTotalSourceAmount;
    public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT = "commissionableTotalCaptureAmount";
    private Moneys commissionableTotalCaptureAmount;
    public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT = "commissionableTotalDisplayAmount";
    private Moneys commissionableTotalDisplayAmount;
    public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT = "commissionableTotalInternalAmount";
    private Moneys commissionableTotalInternalAmount;
    public static final String JSON_PROPERTY_CANCELLATION_CHARGES_INCURRED = "cancellationChargesIncurred";
    private Boolean cancellationChargesIncurred;
    public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT = "commissionableTotalSupplierAmount";
    private Moneys commissionableTotalSupplierAmount;

    public BookingContract() {
    }

    @JsonCreator
    public BookingContract(@JsonProperty(value="id") String id, @JsonProperty(value="createdDate") OffsetDateTime createdDate, @JsonProperty(value="lastUpdate") OffsetDateTime lastUpdate, @JsonProperty(value="traceId") String traceId, @JsonProperty(value="sourceUrl") String sourceUrl, @JsonProperty(value="identifier") String identifier, @JsonProperty(value="supplierIdentifier") String supplierIdentifier, @JsonProperty(value="supplierName") String supplierName, @JsonProperty(value="itemList") List<BookingContractItem> itemList, @JsonProperty(value="externalSupplierIdentifier") String externalSupplierIdentifier, @JsonProperty(value="externalSupplierBookingCode") String externalSupplierBookingCode) {
        this();
        this.id = id;
        this.createdDate = createdDate;
        this.lastUpdate = lastUpdate;
        this.traceId = traceId;
        this.sourceUrl = sourceUrl;
        this.identifier = identifier;
        this.supplierIdentifier = supplierIdentifier;
        this.supplierName = supplierName;
        this.itemList = itemList;
        this.externalSupplierIdentifier = externalSupplierIdentifier;
        this.externalSupplierBookingCode = externalSupplierBookingCode;
    }

    @Nullable
    @ApiModelProperty(example="doc-1", value="Document UUID")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Datetime this record was first created")
    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedDate() {
        return this.createdDate;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Datetime this record was last updated")
    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public BookingContract ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="111.222.333.444", required=true, value="Caller's IP address")
    @JsonProperty(value="ipAddress")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIpAddress() {
        return this.ipAddress;
    }

    @JsonProperty(value="ipAddress")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Nonnull
    @ApiModelProperty(example="T-123456", required=true, value="Way to track which booking contracts were made together")
    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTraceId() {
        return this.traceId;
    }

    @Nonnull
    @ApiModelProperty(example="https://www.traveliko.com", required=true, value="Where did the booking occur")
    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @Nonnull
    @ApiModelProperty(example="unique-supplier-booking-contract-1", required=true, value="Unique identifier used to track the contract. Create a UUID for this purpose.")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIdentifier() {
        return this.identifier;
    }

    @Nonnull
    @ApiModelProperty(example="supplier-1", required=true, value="Supplier identifier")
    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSupplierIdentifier() {
        return this.supplierIdentifier;
    }

    @Nonnull
    @ApiModelProperty(example="Supplier One", required=true, value="Supplier name")
    @JsonProperty(value="supplierName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSupplierName() {
        return this.supplierName;
    }

    public BookingContract displayPriceQuote(QuoteData displayPriceQuote) {
        this.displayPriceQuote = displayPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="displayPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteData getDisplayPriceQuote() {
        return this.displayPriceQuote;
    }

    @JsonProperty(value="displayPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayPriceQuote(QuoteData displayPriceQuote) {
        this.displayPriceQuote = displayPriceQuote;
    }

    public BookingContract supplierPriceQuote(QuoteData supplierPriceQuote) {
        this.supplierPriceQuote = supplierPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="supplierPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteData getSupplierPriceQuote() {
        return this.supplierPriceQuote;
    }

    @JsonProperty(value="supplierPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierPriceQuote(QuoteData supplierPriceQuote) {
        this.supplierPriceQuote = supplierPriceQuote;
    }

    public BookingContract internalPriceQuote(QuoteData internalPriceQuote) {
        this.internalPriceQuote = internalPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="internalPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteData getInternalPriceQuote() {
        return this.internalPriceQuote;
    }

    @JsonProperty(value="internalPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalPriceQuote(QuoteData internalPriceQuote) {
        this.internalPriceQuote = internalPriceQuote;
    }

    public BookingContract capturePriceQuote(QuoteData capturePriceQuote) {
        this.capturePriceQuote = capturePriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="capturePriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteData getCapturePriceQuote() {
        return this.capturePriceQuote;
    }

    @JsonProperty(value="capturePriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCapturePriceQuote(QuoteData capturePriceQuote) {
        this.capturePriceQuote = capturePriceQuote;
    }

    @Nonnull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(required=true, value="Holds one booking line item for a specific supplier.")
    @JsonProperty(value="itemList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @Valid @Size(min=1, max=0x7FFFFFFF) List<BookingContractItem> getItemList() {
        return this.itemList;
    }

    @Nullable
    @ApiModelProperty(example="supplier-a", value="Contract creator can choose to reference this record with her own identifier")
    @JsonProperty(value="externalSupplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalSupplierIdentifier() {
        return this.externalSupplierIdentifier;
    }

    @Nullable
    @ApiModelProperty(example="external-booking-code-1", value="External booking code generated by the affiliate")
    @JsonProperty(value="externalSupplierBookingCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalSupplierBookingCode() {
        return this.externalSupplierBookingCode;
    }

    public BookingContract payment(BookingContractPaymentDetails payment) {
        this.payment = payment;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="payment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BookingContractPaymentDetails getPayment() {
        return this.payment;
    }

    @JsonProperty(value="payment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayment(BookingContractPaymentDetails payment) {
        this.payment = payment;
    }

    public BookingContract cancelled(Boolean cancelled) {
        this.cancelled = cancelled;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Optional reference externalIdentifier to remote inventory.")
    @JsonProperty(value="cancelled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancelled() {
        return this.cancelled;
    }

    @JsonProperty(value="cancelled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancelled(Boolean cancelled) {
        this.cancelled = cancelled;
    }

    public BookingContract cancelledOn(OffsetDateTime cancelledOn) {
        this.cancelledOn = cancelledOn;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="When the booking was cancelled.")
    @JsonProperty(value="cancelledOn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCancelledOn() {
        return this.cancelledOn;
    }

    @JsonProperty(value="cancelledOn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancelledOn(OffsetDateTime cancelledOn) {
        this.cancelledOn = cancelledOn;
    }

    public BookingContract canceller(CancellerEnum canceller) {
        this.canceller = canceller;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type of entity that cancelled the booking.")
    @JsonProperty(value="canceller")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CancellerEnum getCanceller() {
        return this.canceller;
    }

    @JsonProperty(value="canceller")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanceller(CancellerEnum canceller) {
        this.canceller = canceller;
    }

    public BookingContract cancellationType(CancellationTypeEnum cancellationType) {
        this.cancellationType = cancellationType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Reason type.")
    @JsonProperty(value="cancellationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CancellationTypeEnum getCancellationType() {
        return this.cancellationType;
    }

    @JsonProperty(value="cancellationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellationType(CancellationTypeEnum cancellationType) {
        this.cancellationType = cancellationType;
    }

    public BookingContract cancellerUserIdentifier(String cancellerUserIdentifier) {
        this.cancellerUserIdentifier = cancellerUserIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="User identifier that cancelled the entity.")
    @JsonProperty(value="cancellerUserIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCancellerUserIdentifier() {
        return this.cancellerUserIdentifier;
    }

    @JsonProperty(value="cancellerUserIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellerUserIdentifier(String cancellerUserIdentifier) {
        this.cancellerUserIdentifier = cancellerUserIdentifier;
    }

    public BookingContract cancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Reason for cancellation.")
    @JsonProperty(value="cancelReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCancelReason() {
        return this.cancelReason;
    }

    @JsonProperty(value="cancelReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
    }

    public BookingContract totalSourcePrice(Moneys totalSourcePrice) {
        this.totalSourcePrice = totalSourcePrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalSourcePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalSourcePrice() {
        return this.totalSourcePrice;
    }

    @JsonProperty(value="totalSourcePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSourcePrice(Moneys totalSourcePrice) {
        this.totalSourcePrice = totalSourcePrice;
    }

    public BookingContract totalDisplayPrice(Moneys totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalDisplayPrice() {
        return this.totalDisplayPrice;
    }

    @JsonProperty(value="totalDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalDisplayPrice(Moneys totalDisplayPrice) {
        this.totalDisplayPrice = totalDisplayPrice;
    }

    public BookingContract totalSupplierPrice(Moneys totalSupplierPrice) {
        this.totalSupplierPrice = totalSupplierPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalSupplierPrice() {
        return this.totalSupplierPrice;
    }

    @JsonProperty(value="totalSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSupplierPrice(Moneys totalSupplierPrice) {
        this.totalSupplierPrice = totalSupplierPrice;
    }

    public BookingContract totalInternalPrice(Moneys totalInternalPrice) {
        this.totalInternalPrice = totalInternalPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalInternalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalInternalPrice() {
        return this.totalInternalPrice;
    }

    @JsonProperty(value="totalInternalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalInternalPrice(Moneys totalInternalPrice) {
        this.totalInternalPrice = totalInternalPrice;
    }

    public BookingContract totalCapturePrice(Moneys totalCapturePrice) {
        this.totalCapturePrice = totalCapturePrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalCapturePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalCapturePrice() {
        return this.totalCapturePrice;
    }

    @JsonProperty(value="totalCapturePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalCapturePrice(Moneys totalCapturePrice) {
        this.totalCapturePrice = totalCapturePrice;
    }

    public BookingContract totalSourcePriceAfterCancellation(Moneys totalSourcePriceAfterCancellation) {
        this.totalSourcePriceAfterCancellation = totalSourcePriceAfterCancellation;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalSourcePriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalSourcePriceAfterCancellation() {
        return this.totalSourcePriceAfterCancellation;
    }

    @JsonProperty(value="totalSourcePriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSourcePriceAfterCancellation(Moneys totalSourcePriceAfterCancellation) {
        this.totalSourcePriceAfterCancellation = totalSourcePriceAfterCancellation;
    }

    public BookingContract totalDisplayPriceAfterCancellation(Moneys totalDisplayPriceAfterCancellation) {
        this.totalDisplayPriceAfterCancellation = totalDisplayPriceAfterCancellation;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalDisplayPriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalDisplayPriceAfterCancellation() {
        return this.totalDisplayPriceAfterCancellation;
    }

    @JsonProperty(value="totalDisplayPriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalDisplayPriceAfterCancellation(Moneys totalDisplayPriceAfterCancellation) {
        this.totalDisplayPriceAfterCancellation = totalDisplayPriceAfterCancellation;
    }

    public BookingContract totalSupplierPriceAfterCancellation(Moneys totalSupplierPriceAfterCancellation) {
        this.totalSupplierPriceAfterCancellation = totalSupplierPriceAfterCancellation;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalSupplierPriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalSupplierPriceAfterCancellation() {
        return this.totalSupplierPriceAfterCancellation;
    }

    @JsonProperty(value="totalSupplierPriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSupplierPriceAfterCancellation(Moneys totalSupplierPriceAfterCancellation) {
        this.totalSupplierPriceAfterCancellation = totalSupplierPriceAfterCancellation;
    }

    public BookingContract totalInternalPriceAfterCancellation(Moneys totalInternalPriceAfterCancellation) {
        this.totalInternalPriceAfterCancellation = totalInternalPriceAfterCancellation;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalInternalPriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalInternalPriceAfterCancellation() {
        return this.totalInternalPriceAfterCancellation;
    }

    @JsonProperty(value="totalInternalPriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalInternalPriceAfterCancellation(Moneys totalInternalPriceAfterCancellation) {
        this.totalInternalPriceAfterCancellation = totalInternalPriceAfterCancellation;
    }

    public BookingContract totalCapturePriceAfterCancellation(Moneys totalCapturePriceAfterCancellation) {
        this.totalCapturePriceAfterCancellation = totalCapturePriceAfterCancellation;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="totalCapturePriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getTotalCapturePriceAfterCancellation() {
        return this.totalCapturePriceAfterCancellation;
    }

    @JsonProperty(value="totalCapturePriceAfterCancellation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalCapturePriceAfterCancellation(Moneys totalCapturePriceAfterCancellation) {
        this.totalCapturePriceAfterCancellation = totalCapturePriceAfterCancellation;
    }

    public BookingContract refundedSourcePrice(Moneys refundedSourcePrice) {
        this.refundedSourcePrice = refundedSourcePrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="refundedSourcePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getRefundedSourcePrice() {
        return this.refundedSourcePrice;
    }

    @JsonProperty(value="refundedSourcePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefundedSourcePrice(Moneys refundedSourcePrice) {
        this.refundedSourcePrice = refundedSourcePrice;
    }

    public BookingContract refundedDisplayPrice(Moneys refundedDisplayPrice) {
        this.refundedDisplayPrice = refundedDisplayPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="refundedDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getRefundedDisplayPrice() {
        return this.refundedDisplayPrice;
    }

    @JsonProperty(value="refundedDisplayPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefundedDisplayPrice(Moneys refundedDisplayPrice) {
        this.refundedDisplayPrice = refundedDisplayPrice;
    }

    public BookingContract refundedSupplierPrice(Moneys refundedSupplierPrice) {
        this.refundedSupplierPrice = refundedSupplierPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="refundedSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getRefundedSupplierPrice() {
        return this.refundedSupplierPrice;
    }

    @JsonProperty(value="refundedSupplierPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefundedSupplierPrice(Moneys refundedSupplierPrice) {
        this.refundedSupplierPrice = refundedSupplierPrice;
    }

    public BookingContract refundedInternalPrice(Moneys refundedInternalPrice) {
        this.refundedInternalPrice = refundedInternalPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="refundedInternalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getRefundedInternalPrice() {
        return this.refundedInternalPrice;
    }

    @JsonProperty(value="refundedInternalPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefundedInternalPrice(Moneys refundedInternalPrice) {
        this.refundedInternalPrice = refundedInternalPrice;
    }

    public BookingContract refundedCapturePrice(Moneys refundedCapturePrice) {
        this.refundedCapturePrice = refundedCapturePrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="refundedCapturePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getRefundedCapturePrice() {
        return this.refundedCapturePrice;
    }

    @JsonProperty(value="refundedCapturePrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefundedCapturePrice(Moneys refundedCapturePrice) {
        this.refundedCapturePrice = refundedCapturePrice;
    }

    public BookingContract totalTokensEarned(Long totalTokensEarned) {
        this.totalTokensEarned = totalTokensEarned;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total amount of tokens minted on this contract.")
    @JsonProperty(value="totalTokensEarned")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTotalTokensEarned() {
        return this.totalTokensEarned;
    }

    @JsonProperty(value="totalTokensEarned")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalTokensEarned(Long totalTokensEarned) {
        this.totalTokensEarned = totalTokensEarned;
    }

    public BookingContract cancellableBySupplier(Boolean cancellableBySupplier) {
        this.cancellableBySupplier = cancellableBySupplier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the booking can still be cancelled completely by the supplier.")
    @JsonProperty(value="cancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableBySupplier() {
        return this.cancellableBySupplier;
    }

    @JsonProperty(value="cancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableBySupplier(Boolean cancellableBySupplier) {
        this.cancellableBySupplier = cancellableBySupplier;
    }

    public BookingContract cancellableByTraveler(Boolean cancellableByTraveler) {
        this.cancellableByTraveler = cancellableByTraveler;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the booking can still be cancelled completely by the traveller.")
    @JsonProperty(value="cancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableByTraveler() {
        return this.cancellableByTraveler;
    }

    @JsonProperty(value="cancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableByTraveler(Boolean cancellableByTraveler) {
        this.cancellableByTraveler = cancellableByTraveler;
    }

    public BookingContract cancellableWithNoCharges(Boolean cancellableWithNoCharges) {
        this.cancellableWithNoCharges = cancellableWithNoCharges;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the cancellation comes at no cost to the traveler.")
    @JsonProperty(value="cancellableWithNoCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableWithNoCharges() {
        return this.cancellableWithNoCharges;
    }

    @JsonProperty(value="cancellableWithNoCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableWithNoCharges(Boolean cancellableWithNoCharges) {
        this.cancellableWithNoCharges = cancellableWithNoCharges;
    }

    public BookingContract commissionableTotalSourceAmount(Moneys commissionableTotalSourceAmount) {
        this.commissionableTotalSourceAmount = commissionableTotalSourceAmount;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="commissionableTotalSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getCommissionableTotalSourceAmount() {
        return this.commissionableTotalSourceAmount;
    }

    @JsonProperty(value="commissionableTotalSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionableTotalSourceAmount(Moneys commissionableTotalSourceAmount) {
        this.commissionableTotalSourceAmount = commissionableTotalSourceAmount;
    }

    public BookingContract commissionableTotalCaptureAmount(Moneys commissionableTotalCaptureAmount) {
        this.commissionableTotalCaptureAmount = commissionableTotalCaptureAmount;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="commissionableTotalCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getCommissionableTotalCaptureAmount() {
        return this.commissionableTotalCaptureAmount;
    }

    @JsonProperty(value="commissionableTotalCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionableTotalCaptureAmount(Moneys commissionableTotalCaptureAmount) {
        this.commissionableTotalCaptureAmount = commissionableTotalCaptureAmount;
    }

    public BookingContract commissionableTotalDisplayAmount(Moneys commissionableTotalDisplayAmount) {
        this.commissionableTotalDisplayAmount = commissionableTotalDisplayAmount;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="commissionableTotalDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getCommissionableTotalDisplayAmount() {
        return this.commissionableTotalDisplayAmount;
    }

    @JsonProperty(value="commissionableTotalDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionableTotalDisplayAmount(Moneys commissionableTotalDisplayAmount) {
        this.commissionableTotalDisplayAmount = commissionableTotalDisplayAmount;
    }

    public BookingContract commissionableTotalInternalAmount(Moneys commissionableTotalInternalAmount) {
        this.commissionableTotalInternalAmount = commissionableTotalInternalAmount;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="commissionableTotalInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getCommissionableTotalInternalAmount() {
        return this.commissionableTotalInternalAmount;
    }

    @JsonProperty(value="commissionableTotalInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionableTotalInternalAmount(Moneys commissionableTotalInternalAmount) {
        this.commissionableTotalInternalAmount = commissionableTotalInternalAmount;
    }

    public BookingContract cancellationChargesIncurred(Boolean cancellationChargesIncurred) {
        this.cancellationChargesIncurred = cancellationChargesIncurred;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="cancellationChargesIncurred")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellationChargesIncurred() {
        return this.cancellationChargesIncurred;
    }

    @JsonProperty(value="cancellationChargesIncurred")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellationChargesIncurred(Boolean cancellationChargesIncurred) {
        this.cancellationChargesIncurred = cancellationChargesIncurred;
    }

    public BookingContract commissionableTotalSupplierAmount(Moneys commissionableTotalSupplierAmount) {
        this.commissionableTotalSupplierAmount = commissionableTotalSupplierAmount;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="commissionableTotalSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getCommissionableTotalSupplierAmount() {
        return this.commissionableTotalSupplierAmount;
    }

    @JsonProperty(value="commissionableTotalSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionableTotalSupplierAmount(Moneys commissionableTotalSupplierAmount) {
        this.commissionableTotalSupplierAmount = commissionableTotalSupplierAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookingContract bookingContract = (BookingContract)o;
        return Objects.equals(this.id, bookingContract.id) && Objects.equals(this.createdDate, bookingContract.createdDate) && Objects.equals(this.lastUpdate, bookingContract.lastUpdate) && Objects.equals(this.ipAddress, bookingContract.ipAddress) && Objects.equals(this.traceId, bookingContract.traceId) && Objects.equals(this.sourceUrl, bookingContract.sourceUrl) && Objects.equals(this.identifier, bookingContract.identifier) && Objects.equals(this.supplierIdentifier, bookingContract.supplierIdentifier) && Objects.equals(this.supplierName, bookingContract.supplierName) && Objects.equals(this.displayPriceQuote, bookingContract.displayPriceQuote) && Objects.equals(this.supplierPriceQuote, bookingContract.supplierPriceQuote) && Objects.equals(this.internalPriceQuote, bookingContract.internalPriceQuote) && Objects.equals(this.capturePriceQuote, bookingContract.capturePriceQuote) && Objects.equals(this.itemList, bookingContract.itemList) && Objects.equals(this.externalSupplierIdentifier, bookingContract.externalSupplierIdentifier) && Objects.equals(this.externalSupplierBookingCode, bookingContract.externalSupplierBookingCode) && Objects.equals(this.payment, bookingContract.payment) && Objects.equals(this.cancelled, bookingContract.cancelled) && Objects.equals(this.cancelledOn, bookingContract.cancelledOn) && Objects.equals((Object)this.canceller, (Object)bookingContract.canceller) && Objects.equals((Object)this.cancellationType, (Object)bookingContract.cancellationType) && Objects.equals(this.cancellerUserIdentifier, bookingContract.cancellerUserIdentifier) && Objects.equals(this.cancelReason, bookingContract.cancelReason) && Objects.equals(this.totalSourcePrice, bookingContract.totalSourcePrice) && Objects.equals(this.totalDisplayPrice, bookingContract.totalDisplayPrice) && Objects.equals(this.totalSupplierPrice, bookingContract.totalSupplierPrice) && Objects.equals(this.totalInternalPrice, bookingContract.totalInternalPrice) && Objects.equals(this.totalCapturePrice, bookingContract.totalCapturePrice) && Objects.equals(this.totalSourcePriceAfterCancellation, bookingContract.totalSourcePriceAfterCancellation) && Objects.equals(this.totalDisplayPriceAfterCancellation, bookingContract.totalDisplayPriceAfterCancellation) && Objects.equals(this.totalSupplierPriceAfterCancellation, bookingContract.totalSupplierPriceAfterCancellation) && Objects.equals(this.totalInternalPriceAfterCancellation, bookingContract.totalInternalPriceAfterCancellation) && Objects.equals(this.totalCapturePriceAfterCancellation, bookingContract.totalCapturePriceAfterCancellation) && Objects.equals(this.refundedSourcePrice, bookingContract.refundedSourcePrice) && Objects.equals(this.refundedDisplayPrice, bookingContract.refundedDisplayPrice) && Objects.equals(this.refundedSupplierPrice, bookingContract.refundedSupplierPrice) && Objects.equals(this.refundedInternalPrice, bookingContract.refundedInternalPrice) && Objects.equals(this.refundedCapturePrice, bookingContract.refundedCapturePrice) && Objects.equals(this.totalTokensEarned, bookingContract.totalTokensEarned) && Objects.equals(this.cancellableBySupplier, bookingContract.cancellableBySupplier) && Objects.equals(this.cancellableByTraveler, bookingContract.cancellableByTraveler) && Objects.equals(this.cancellableWithNoCharges, bookingContract.cancellableWithNoCharges) && Objects.equals(this.commissionableTotalSourceAmount, bookingContract.commissionableTotalSourceAmount) && Objects.equals(this.commissionableTotalCaptureAmount, bookingContract.commissionableTotalCaptureAmount) && Objects.equals(this.commissionableTotalDisplayAmount, bookingContract.commissionableTotalDisplayAmount) && Objects.equals(this.commissionableTotalInternalAmount, bookingContract.commissionableTotalInternalAmount) && Objects.equals(this.cancellationChargesIncurred, bookingContract.cancellationChargesIncurred) && Objects.equals(this.commissionableTotalSupplierAmount, bookingContract.commissionableTotalSupplierAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.createdDate, this.lastUpdate, this.ipAddress, this.traceId, this.sourceUrl, this.identifier, this.supplierIdentifier, this.supplierName, this.displayPriceQuote, this.supplierPriceQuote, this.internalPriceQuote, this.capturePriceQuote, this.itemList, this.externalSupplierIdentifier, this.externalSupplierBookingCode, this.payment, this.cancelled, this.cancelledOn, this.canceller, this.cancellationType, this.cancellerUserIdentifier, this.cancelReason, this.totalSourcePrice, this.totalDisplayPrice, this.totalSupplierPrice, this.totalInternalPrice, this.totalCapturePrice, this.totalSourcePriceAfterCancellation, this.totalDisplayPriceAfterCancellation, this.totalSupplierPriceAfterCancellation, this.totalInternalPriceAfterCancellation, this.totalCapturePriceAfterCancellation, this.refundedSourcePrice, this.refundedDisplayPrice, this.refundedSupplierPrice, this.refundedInternalPrice, this.refundedCapturePrice, this.totalTokensEarned, this.cancellableBySupplier, this.cancellableByTraveler, this.cancellableWithNoCharges, this.commissionableTotalSourceAmount, this.commissionableTotalCaptureAmount, this.commissionableTotalDisplayAmount, this.commissionableTotalInternalAmount, this.cancellationChargesIncurred, this.commissionableTotalSupplierAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookingContract {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    traceId: ").append(this.toIndentedString(this.traceId)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    supplierIdentifier: ").append(this.toIndentedString(this.supplierIdentifier)).append("\n");
        sb.append("    supplierName: ").append(this.toIndentedString(this.supplierName)).append("\n");
        sb.append("    displayPriceQuote: ").append(this.toIndentedString(this.displayPriceQuote)).append("\n");
        sb.append("    supplierPriceQuote: ").append(this.toIndentedString(this.supplierPriceQuote)).append("\n");
        sb.append("    internalPriceQuote: ").append(this.toIndentedString(this.internalPriceQuote)).append("\n");
        sb.append("    capturePriceQuote: ").append(this.toIndentedString(this.capturePriceQuote)).append("\n");
        sb.append("    itemList: ").append(this.toIndentedString(this.itemList)).append("\n");
        sb.append("    externalSupplierIdentifier: ").append(this.toIndentedString(this.externalSupplierIdentifier)).append("\n");
        sb.append("    externalSupplierBookingCode: ").append(this.toIndentedString(this.externalSupplierBookingCode)).append("\n");
        sb.append("    payment: ").append(this.toIndentedString(this.payment)).append("\n");
        sb.append("    cancelled: ").append(this.toIndentedString(this.cancelled)).append("\n");
        sb.append("    cancelledOn: ").append(this.toIndentedString(this.cancelledOn)).append("\n");
        sb.append("    canceller: ").append(this.toIndentedString((Object)this.canceller)).append("\n");
        sb.append("    cancellationType: ").append(this.toIndentedString((Object)this.cancellationType)).append("\n");
        sb.append("    cancellerUserIdentifier: ").append(this.toIndentedString(this.cancellerUserIdentifier)).append("\n");
        sb.append("    cancelReason: ").append(this.toIndentedString(this.cancelReason)).append("\n");
        sb.append("    totalSourcePrice: ").append(this.toIndentedString(this.totalSourcePrice)).append("\n");
        sb.append("    totalDisplayPrice: ").append(this.toIndentedString(this.totalDisplayPrice)).append("\n");
        sb.append("    totalSupplierPrice: ").append(this.toIndentedString(this.totalSupplierPrice)).append("\n");
        sb.append("    totalInternalPrice: ").append(this.toIndentedString(this.totalInternalPrice)).append("\n");
        sb.append("    totalCapturePrice: ").append(this.toIndentedString(this.totalCapturePrice)).append("\n");
        sb.append("    totalSourcePriceAfterCancellation: ").append(this.toIndentedString(this.totalSourcePriceAfterCancellation)).append("\n");
        sb.append("    totalDisplayPriceAfterCancellation: ").append(this.toIndentedString(this.totalDisplayPriceAfterCancellation)).append("\n");
        sb.append("    totalSupplierPriceAfterCancellation: ").append(this.toIndentedString(this.totalSupplierPriceAfterCancellation)).append("\n");
        sb.append("    totalInternalPriceAfterCancellation: ").append(this.toIndentedString(this.totalInternalPriceAfterCancellation)).append("\n");
        sb.append("    totalCapturePriceAfterCancellation: ").append(this.toIndentedString(this.totalCapturePriceAfterCancellation)).append("\n");
        sb.append("    refundedSourcePrice: ").append(this.toIndentedString(this.refundedSourcePrice)).append("\n");
        sb.append("    refundedDisplayPrice: ").append(this.toIndentedString(this.refundedDisplayPrice)).append("\n");
        sb.append("    refundedSupplierPrice: ").append(this.toIndentedString(this.refundedSupplierPrice)).append("\n");
        sb.append("    refundedInternalPrice: ").append(this.toIndentedString(this.refundedInternalPrice)).append("\n");
        sb.append("    refundedCapturePrice: ").append(this.toIndentedString(this.refundedCapturePrice)).append("\n");
        sb.append("    totalTokensEarned: ").append(this.toIndentedString(this.totalTokensEarned)).append("\n");
        sb.append("    cancellableBySupplier: ").append(this.toIndentedString(this.cancellableBySupplier)).append("\n");
        sb.append("    cancellableByTraveler: ").append(this.toIndentedString(this.cancellableByTraveler)).append("\n");
        sb.append("    cancellableWithNoCharges: ").append(this.toIndentedString(this.cancellableWithNoCharges)).append("\n");
        sb.append("    commissionableTotalSourceAmount: ").append(this.toIndentedString(this.commissionableTotalSourceAmount)).append("\n");
        sb.append("    commissionableTotalCaptureAmount: ").append(this.toIndentedString(this.commissionableTotalCaptureAmount)).append("\n");
        sb.append("    commissionableTotalDisplayAmount: ").append(this.toIndentedString(this.commissionableTotalDisplayAmount)).append("\n");
        sb.append("    commissionableTotalInternalAmount: ").append(this.toIndentedString(this.commissionableTotalInternalAmount)).append("\n");
        sb.append("    cancellationChargesIncurred: ").append(this.toIndentedString(this.cancellationChargesIncurred)).append("\n");
        sb.append("    commissionableTotalSupplierAmount: ").append(this.toIndentedString(this.commissionableTotalSupplierAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CancellerEnum {
        SALES_CHANNEL("SALES_CHANNEL"),
        SUPPLIER("SUPPLIER"),
        TRAVELER("TRAVELER"),
        ADMINISTRATOR("ADMINISTRATOR");

        private String value;

        private CancellerEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CancellerEnum fromValue(String value) {
            for (CancellerEnum b : CancellerEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CancellationTypeEnum {
        DUPLICATE("DUPLICATE"),
        CANCELLATION("CANCELLATION"),
        NO_SHOW("NO_SHOW"),
        CC_INVALID("CC_INVALID"),
        CC_INSUFFICIENT("CC_INSUFFICIENT"),
        DISCRETIONARY("DISCRETIONARY");

        private String value;

        private CancellationTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CancellationTypeEnum fromValue(String value) {
            for (CancellationTypeEnum b : CancellationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

