/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.extranet.model.DailyRateUpdateRate;

@JsonPropertyOrder(value={"startDate", "endDate", "hotelIdentifier", "masterRateIdentifier", "rateSource", "master", "closedOnArrival", "closedOnDeparture", "numberOfUnits", "rate", "minLengthOfStay", "maxLengthOfStay"})
public class DailyRateUpdate {
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private LocalDate startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private LocalDate endDate;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private String hotelIdentifier;
    public static final String JSON_PROPERTY_MASTER_RATE_IDENTIFIER = "masterRateIdentifier";
    private String masterRateIdentifier;
    public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
    private RateSourceEnum rateSource = RateSourceEnum.TRAVELIKO;
    public static final String JSON_PROPERTY_MASTER = "master";
    private Boolean master = true;
    public static final String JSON_PROPERTY_CLOSED_ON_ARRIVAL = "closedOnArrival";
    private Boolean closedOnArrival = false;
    public static final String JSON_PROPERTY_CLOSED_ON_DEPARTURE = "closedOnDeparture";
    private Boolean closedOnDeparture = false;
    public static final String JSON_PROPERTY_NUMBER_OF_UNITS = "numberOfUnits";
    private Integer numberOfUnits;
    public static final String JSON_PROPERTY_RATE = "rate";
    private DailyRateUpdateRate rate;
    public static final String JSON_PROPERTY_MIN_LENGTH_OF_STAY = "minLengthOfStay";
    private Integer minLengthOfStay;
    public static final String JSON_PROPERTY_MAX_LENGTH_OF_STAY = "maxLengthOfStay";
    private Integer maxLengthOfStay;

    public DailyRateUpdate startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(example="Mon Aug 24 07:00:00 ICT 2020", required=true, value="Start date for where you want to begin updating rates")
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public DailyRateUpdate endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(example="Wed Aug 26 07:00:00 ICT 2020", required=true, value="End date for where you want to stop updating rates")
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public DailyRateUpdate hotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="hotel-1", required=true, value="Owner of this rate date range.")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public DailyRateUpdate masterRateIdentifier(String masterRateIdentifier) {
        this.masterRateIdentifier = masterRateIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="master-rate-1", required=true, value="The master rate you wish to update daily rates for.")
    @JsonProperty(value="masterRateIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMasterRateIdentifier() {
        return this.masterRateIdentifier;
    }

    @JsonProperty(value="masterRateIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMasterRateIdentifier(String masterRateIdentifier) {
        this.masterRateIdentifier = masterRateIdentifier;
    }

    public DailyRateUpdate rateSource(RateSourceEnum rateSource) {
        this.rateSource = rateSource;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="TRAVELIKO", required=true, value="Indicate where this rate originated from. Leave as TRAVELIKO unless you are a channel manager and responsible for the property's rates externally of this platform.")
    @JsonProperty(value="rateSource")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RateSourceEnum getRateSource() {
        return this.rateSource;
    }

    @JsonProperty(value="rateSource")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRateSource(RateSourceEnum rateSource) {
        this.rateSource = rateSource;
    }

    public DailyRateUpdate master(Boolean master) {
        this.master = master;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="This flag indicates whether this rate is available for this date.")
    @JsonProperty(value="master")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getMaster() {
        return this.master;
    }

    @JsonProperty(value="master")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaster(Boolean master) {
        this.master = master;
    }

    public DailyRateUpdate closedOnArrival(Boolean closedOnArrival) {
        this.closedOnArrival = closedOnArrival;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="This flag indicates whether a guest can arrive at the property on this date.")
    @JsonProperty(value="closedOnArrival")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getClosedOnArrival() {
        return this.closedOnArrival;
    }

    @JsonProperty(value="closedOnArrival")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setClosedOnArrival(Boolean closedOnArrival) {
        this.closedOnArrival = closedOnArrival;
    }

    public DailyRateUpdate closedOnDeparture(Boolean closedOnDeparture) {
        this.closedOnDeparture = closedOnDeparture;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="This flag indicates whether a guest can leave the property on this date.")
    @JsonProperty(value="closedOnDeparture")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getClosedOnDeparture() {
        return this.closedOnDeparture;
    }

    @JsonProperty(value="closedOnDeparture")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setClosedOnDeparture(Boolean closedOnDeparture) {
        this.closedOnDeparture = closedOnDeparture;
    }

    public DailyRateUpdate numberOfUnits(Integer numberOfUnits) {
        this.numberOfUnits = numberOfUnits;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="Update the amount of rooms available for this date range. Leave empty if you don't want to update this property.")
    @JsonProperty(value="numberOfUnits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNumberOfUnits() {
        return this.numberOfUnits;
    }

    @JsonProperty(value="numberOfUnits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumberOfUnits(Integer numberOfUnits) {
        this.numberOfUnits = numberOfUnits;
    }

    public DailyRateUpdate rate(DailyRateUpdateRate rate) {
        this.rate = rate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="rate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DailyRateUpdateRate getRate() {
        return this.rate;
    }

    @JsonProperty(value="rate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRate(DailyRateUpdateRate rate) {
        this.rate = rate;
    }

    public DailyRateUpdate minLengthOfStay(Integer minLengthOfStay) {
        this.minLengthOfStay = minLengthOfStay;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="4", value="Control the minimum length of stay at the day-level. This means that a guest arriving within this date range is required to stay at least these number of days in order to get this rate. Leave empty if you don't want to update this property.")
    @JsonProperty(value="minLengthOfStay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMinLengthOfStay() {
        return this.minLengthOfStay;
    }

    @JsonProperty(value="minLengthOfStay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinLengthOfStay(Integer minLengthOfStay) {
        this.minLengthOfStay = minLengthOfStay;
    }

    public DailyRateUpdate maxLengthOfStay(Integer maxLengthOfStay) {
        this.maxLengthOfStay = maxLengthOfStay;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8", value="Control the maximum length of stay at the day-level. This means that a guest arriving within this date range is required to stay no longer than these number of days in order to get this rate. Leave empty if you don't want to update this property.")
    @JsonProperty(value="maxLengthOfStay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxLengthOfStay() {
        return this.maxLengthOfStay;
    }

    @JsonProperty(value="maxLengthOfStay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxLengthOfStay(Integer maxLengthOfStay) {
        this.maxLengthOfStay = maxLengthOfStay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DailyRateUpdate dailyRateUpdate = (DailyRateUpdate)o;
        return Objects.equals(this.startDate, dailyRateUpdate.startDate) && Objects.equals(this.endDate, dailyRateUpdate.endDate) && Objects.equals(this.hotelIdentifier, dailyRateUpdate.hotelIdentifier) && Objects.equals(this.masterRateIdentifier, dailyRateUpdate.masterRateIdentifier) && Objects.equals((Object)this.rateSource, (Object)dailyRateUpdate.rateSource) && Objects.equals(this.master, dailyRateUpdate.master) && Objects.equals(this.closedOnArrival, dailyRateUpdate.closedOnArrival) && Objects.equals(this.closedOnDeparture, dailyRateUpdate.closedOnDeparture) && Objects.equals(this.numberOfUnits, dailyRateUpdate.numberOfUnits) && Objects.equals(this.rate, dailyRateUpdate.rate) && Objects.equals(this.minLengthOfStay, dailyRateUpdate.minLengthOfStay) && Objects.equals(this.maxLengthOfStay, dailyRateUpdate.maxLengthOfStay);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.startDate, this.endDate, this.hotelIdentifier, this.masterRateIdentifier, this.rateSource, this.master, this.closedOnArrival, this.closedOnDeparture, this.numberOfUnits, this.rate, this.minLengthOfStay, this.maxLengthOfStay});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DailyRateUpdate {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    masterRateIdentifier: ").append(this.toIndentedString(this.masterRateIdentifier)).append("\n");
        sb.append("    rateSource: ").append(this.toIndentedString((Object)this.rateSource)).append("\n");
        sb.append("    master: ").append(this.toIndentedString(this.master)).append("\n");
        sb.append("    closedOnArrival: ").append(this.toIndentedString(this.closedOnArrival)).append("\n");
        sb.append("    closedOnDeparture: ").append(this.toIndentedString(this.closedOnDeparture)).append("\n");
        sb.append("    numberOfUnits: ").append(this.toIndentedString(this.numberOfUnits)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    minLengthOfStay: ").append(this.toIndentedString(this.minLengthOfStay)).append("\n");
        sb.append("    maxLengthOfStay: ").append(this.toIndentedString(this.maxLengthOfStay)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RateSourceEnum {
        TRAVELIKO("TRAVELIKO"),
        SITEMINDER("SITEMINDER"),
        FASTBOOKING("FASTBOOKING"),
        RATEGAIN("RATEGAIN"),
        CLOUD_BEDS("CLOUD_BEDS"),
        YIELD_PLANET("YIELD_PLANET"),
        TRAVELCLICK("TRAVELCLICK"),
        HOTEL_GURU("HOTEL_GURU"),
        OTHER_CHANNEL_MANAGER("OTHER_CHANNEL_MANAGER"),
        BOOKING_JINI("BOOKING_JINI"),
        HOTEL_LINK_SOLUTIONS("HOTEL_LINK_SOLUTIONS"),
        ALLOTZ("ALLOTZ"),
        DEDGE("DEDGE"),
        RATE_TIGER("RATE_TIGER"),
        RESAVENUE("RESAVENUE"),
        COMANCHE("COMANCHE"),
        OMNIBEES("OMNIBEES"),
        EZEE("EZEE"),
        SYNXIS("SYNXIS");

        private String value;

        private RateSourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RateSourceEnum fromValue(String value) {
            for (RateSourceEnum b : RateSourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

