/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.sdk.extranet.model.SimpleDescription;

@ApiModel(description="General manager")
@JsonPropertyOrder(value={"fullName", "imageIdentifier", "message"})
public class GeneralManager {
    public static final String JSON_PROPERTY_FULL_NAME = "fullName";
    private String fullName;
    public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
    private String imageIdentifier;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private List<SimpleDescription> message = null;

    public GeneralManager fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Jane Doe", value="Name of GM currently managing the property.")
    @JsonProperty(value="fullName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullName() {
        return this.fullName;
    }

    @JsonProperty(value="fullName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public GeneralManager imageIdentifier(String imageIdentifier) {
        this.imageIdentifier = imageIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="cl-image-1", value="Cloudinary image identifier of GM currently managing the property.")
    @JsonProperty(value="imageIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getImageIdentifier() {
        return this.imageIdentifier;
    }

    @JsonProperty(value="imageIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setImageIdentifier(String imageIdentifier) {
        this.imageIdentifier = imageIdentifier;
    }

    public GeneralManager message(List<SimpleDescription> message) {
        this.message = message;
        return this;
    }

    public GeneralManager addMessageItem(SimpleDescription messageItem) {
        if (this.message == null) {
            this.message = new ArrayList<SimpleDescription>();
        }
        this.message.add(messageItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Personal welcome message from GM.")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SimpleDescription> getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMessage(List<SimpleDescription> message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneralManager generalManager = (GeneralManager)o;
        return Objects.equals(this.fullName, generalManager.fullName) && Objects.equals(this.imageIdentifier, generalManager.imageIdentifier) && Objects.equals(this.message, generalManager.message);
    }

    public int hashCode() {
        return Objects.hash(this.fullName, this.imageIdentifier, this.message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeneralManager {\n");
        sb.append("    fullName: ").append(this.toIndentedString(this.fullName)).append("\n");
        sb.append("    imageIdentifier: ").append(this.toIndentedString(this.imageIdentifier)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

