/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.extranet.model.AddressDto;
import travel.wink.sdk.extranet.model.AggregateGreendexAnswers;
import travel.wink.sdk.extranet.model.ContactDto;
import travel.wink.sdk.extranet.model.GeoJsonPoint;
import travel.wink.sdk.extranet.model.GeoName;
import travel.wink.sdk.extranet.model.Multimedia;
import travel.wink.sdk.extranet.model.PropertyPolicy;
import travel.wink.sdk.extranet.model.SimpleDescription;
import travel.wink.sdk.extranet.model.Social;

@ApiModel(description="Hotel data")
@JsonPropertyOrder(value={"hotelIdentifier", "name", "hotelCode", "hotelCodeContext", "localName", "legalName", "urlName", "currencyCode", "status", "statusLastUpdate", "externalStatus", "externalStatusLastUpdate", "multimediaIdentifier", "imageIdentifier", "imageAngle", "address1", "address2", "postalCode", "state", "vatId", "contractSignerFirstName", "contractSignerLastName", "contractSignerPhoneNumber", "contractSignerEmail", "locationCategory", "segmentCategory", "hotelCategory", "architecturalStyle", "whenBuilt", "hotelChain", "hotelBrand", "channelManager", "otherChannelManager", "licenseNumber", "stars", "fullNameOfGeneralManager", "profilePictureIdentifierGeneralManager", "messagesOfGeneralManager", "shortDescriptions", "longDescriptions", "hotelAmenityCodes", "propertyAccessibilityCodes", "propertySecurityCodes", "locationPoint", "policy", "socials", "reservationsContact", "accountingContact", "accountingAddress", "lifestyleTypes", "agreementAccepted", "marketingOptinAllowed", "logos", "city", "numberOfRooms", "active", "propertyActive", "platformActive", "contractSignerFullName", "socialNetworks", "lifestyles", "fullAddress", "generalManagerWelcomeMessage", "greenIndexScores"})
public class Hotel {
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private String hotelIdentifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_HOTEL_CODE = "hotelCode";
    private String hotelCode;
    public static final String JSON_PROPERTY_HOTEL_CODE_CONTEXT = "hotelCodeContext";
    private String hotelCodeContext;
    public static final String JSON_PROPERTY_LOCAL_NAME = "localName";
    private String localName;
    public static final String JSON_PROPERTY_LEGAL_NAME = "legalName";
    private String legalName;
    public static final String JSON_PROPERTY_URL_NAME = "urlName";
    private String urlName;
    public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
    private String currencyCode;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status = StatusEnum.WAITING_ON_CONTRACT;
    public static final String JSON_PROPERTY_STATUS_LAST_UPDATE = "statusLastUpdate";
    private OffsetDateTime statusLastUpdate;
    public static final String JSON_PROPERTY_EXTERNAL_STATUS = "externalStatus";
    private String externalStatus = "6";
    public static final String JSON_PROPERTY_EXTERNAL_STATUS_LAST_UPDATE = "externalStatusLastUpdate";
    private OffsetDateTime externalStatusLastUpdate;
    public static final String JSON_PROPERTY_MULTIMEDIA_IDENTIFIER = "multimediaIdentifier";
    private String multimediaIdentifier;
    public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
    private String imageIdentifier;
    public static final String JSON_PROPERTY_IMAGE_ANGLE = "imageAngle";
    private String imageAngle;
    public static final String JSON_PROPERTY_ADDRESS1 = "address1";
    private String address1;
    public static final String JSON_PROPERTY_ADDRESS2 = "address2";
    private String address2;
    public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
    private String postalCode;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;
    public static final String JSON_PROPERTY_VAT_ID = "vatId";
    private String vatId;
    public static final String JSON_PROPERTY_CONTRACT_SIGNER_FIRST_NAME = "contractSignerFirstName";
    private String contractSignerFirstName;
    public static final String JSON_PROPERTY_CONTRACT_SIGNER_LAST_NAME = "contractSignerLastName";
    private String contractSignerLastName;
    public static final String JSON_PROPERTY_CONTRACT_SIGNER_PHONE_NUMBER = "contractSignerPhoneNumber";
    private String contractSignerPhoneNumber;
    public static final String JSON_PROPERTY_CONTRACT_SIGNER_EMAIL = "contractSignerEmail";
    private String contractSignerEmail;
    public static final String JSON_PROPERTY_LOCATION_CATEGORY = "locationCategory";
    private String locationCategory;
    public static final String JSON_PROPERTY_SEGMENT_CATEGORY = "segmentCategory";
    private String segmentCategory;
    public static final String JSON_PROPERTY_HOTEL_CATEGORY = "hotelCategory";
    private String hotelCategory;
    public static final String JSON_PROPERTY_ARCHITECTURAL_STYLE = "architecturalStyle";
    private String architecturalStyle;
    public static final String JSON_PROPERTY_WHEN_BUILT = "whenBuilt";
    private String whenBuilt;
    public static final String JSON_PROPERTY_HOTEL_CHAIN = "hotelChain";
    private String hotelChain;
    public static final String JSON_PROPERTY_HOTEL_BRAND = "hotelBrand";
    private String hotelBrand;
    public static final String JSON_PROPERTY_CHANNEL_MANAGER = "channelManager";
    private ChannelManagerEnum channelManager = ChannelManagerEnum.TRAVELIKO;
    public static final String JSON_PROPERTY_OTHER_CHANNEL_MANAGER = "otherChannelManager";
    private String otherChannelManager;
    public static final String JSON_PROPERTY_LICENSE_NUMBER = "licenseNumber";
    private String licenseNumber;
    public static final String JSON_PROPERTY_STARS = "stars";
    private Integer stars;
    public static final String JSON_PROPERTY_FULL_NAME_OF_GENERAL_MANAGER = "fullNameOfGeneralManager";
    private String fullNameOfGeneralManager;
    public static final String JSON_PROPERTY_PROFILE_PICTURE_IDENTIFIER_GENERAL_MANAGER = "profilePictureIdentifierGeneralManager";
    private String profilePictureIdentifierGeneralManager;
    public static final String JSON_PROPERTY_MESSAGES_OF_GENERAL_MANAGER = "messagesOfGeneralManager";
    private List<SimpleDescription> messagesOfGeneralManager = null;
    public static final String JSON_PROPERTY_SHORT_DESCRIPTIONS = "shortDescriptions";
    private List<SimpleDescription> shortDescriptions = null;
    public static final String JSON_PROPERTY_LONG_DESCRIPTIONS = "longDescriptions";
    private List<SimpleDescription> longDescriptions = null;
    public static final String JSON_PROPERTY_HOTEL_AMENITY_CODES = "hotelAmenityCodes";
    private List<String> hotelAmenityCodes = null;
    public static final String JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES = "propertyAccessibilityCodes";
    private List<String> propertyAccessibilityCodes = null;
    public static final String JSON_PROPERTY_PROPERTY_SECURITY_CODES = "propertySecurityCodes";
    private List<String> propertySecurityCodes = null;
    public static final String JSON_PROPERTY_LOCATION_POINT = "locationPoint";
    private GeoJsonPoint locationPoint;
    public static final String JSON_PROPERTY_POLICY = "policy";
    private PropertyPolicy policy;
    public static final String JSON_PROPERTY_SOCIALS = "socials";
    private List<Social> socials = null;
    public static final String JSON_PROPERTY_RESERVATIONS_CONTACT = "reservationsContact";
    private ContactDto reservationsContact;
    public static final String JSON_PROPERTY_ACCOUNTING_CONTACT = "accountingContact";
    private ContactDto accountingContact;
    public static final String JSON_PROPERTY_ACCOUNTING_ADDRESS = "accountingAddress";
    private AddressDto accountingAddress;
    public static final String JSON_PROPERTY_LIFESTYLE_TYPES = "lifestyleTypes";
    private List<LifestyleTypesEnum> lifestyleTypes = null;
    public static final String JSON_PROPERTY_AGREEMENT_ACCEPTED = "agreementAccepted";
    private Boolean agreementAccepted;
    public static final String JSON_PROPERTY_MARKETING_OPTIN_ALLOWED = "marketingOptinAllowed";
    private Boolean marketingOptinAllowed;
    public static final String JSON_PROPERTY_LOGOS = "logos";
    private List<Multimedia> logos = null;
    public static final String JSON_PROPERTY_CITY = "city";
    private GeoName city;
    public static final String JSON_PROPERTY_NUMBER_OF_ROOMS = "numberOfRooms";
    private Integer numberOfRooms;
    public static final String JSON_PROPERTY_ACTIVE = "active";
    private Boolean active;
    public static final String JSON_PROPERTY_PROPERTY_ACTIVE = "propertyActive";
    private Boolean propertyActive;
    public static final String JSON_PROPERTY_PLATFORM_ACTIVE = "platformActive";
    private Boolean platformActive;
    public static final String JSON_PROPERTY_CONTRACT_SIGNER_FULL_NAME = "contractSignerFullName";
    private String contractSignerFullName;
    public static final String JSON_PROPERTY_SOCIAL_NETWORKS = "socialNetworks";
    private Boolean socialNetworks;
    public static final String JSON_PROPERTY_LIFESTYLES = "lifestyles";
    private Boolean lifestyles;
    public static final String JSON_PROPERTY_FULL_ADDRESS = "fullAddress";
    private String fullAddress;
    public static final String JSON_PROPERTY_GENERAL_MANAGER_WELCOME_MESSAGE = "generalManagerWelcomeMessage";
    private Boolean generalManagerWelcomeMessage;
    public static final String JSON_PROPERTY_GREEN_INDEX_SCORES = "greenIndexScores";
    private AggregateGreendexAnswers greenIndexScores;

    public Hotel hotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="hotel-1", required=true, value="Unique hotel identifier")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public Hotel name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="The Getaway resort - Ubud", required=true, value="Unique hotel trade name. The hotel name must be unique. If there are multiple hotels with the same name, we recommend appending destination to the name. [Verify uniqueness here](#operation/isHotelNameUnique).")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public Hotel hotelCode(String hotelCode) {
        this.hotelCode = hotelCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="IN00011", required=true, value="A shorter unique code to refer to the hotel. Country Code + 5 digit number")
    @JsonProperty(value="hotelCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getHotelCode() {
        return this.hotelCode;
    }

    @JsonProperty(value="hotelCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelCode(String hotelCode) {
        this.hotelCode = hotelCode;
    }

    public Hotel hotelCodeContext(String hotelCodeContext) {
        this.hotelCodeContext = hotelCodeContext;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="iko.travel", required=true, value="Origin of hotel data")
    @JsonProperty(value="hotelCodeContext")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getHotelCodeContext() {
        return this.hotelCodeContext;
    }

    @JsonProperty(value="hotelCodeContext")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelCodeContext(String hotelCodeContext) {
        this.hotelCodeContext = hotelCodeContext;
    }

    public Hotel localName(String localName) {
        this.localName = localName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Resor Ubud Getaway", value="Name of the hotel in its local language if you use it for domestic guests.")
    @JsonProperty(value="localName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocalName() {
        return this.localName;
    }

    @JsonProperty(value="localName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public Hotel legalName(String legalName) {
        this.legalName = legalName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Getaway Resorts Limited", required=true, value="Legal name of your hotel as it is registered.")
    @JsonProperty(value="legalName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLegalName() {
        return this.legalName;
    }

    @JsonProperty(value="legalName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public Hotel urlName(String urlName) {
        this.urlName = urlName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="the-getaway-resort-ubud-indonesia", required=true, value="Unique url-friendly slug to identify property")
    @JsonProperty(value="urlName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUrlName() {
        return this.urlName;
    }

    @JsonProperty(value="urlName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUrlName(String urlName) {
        this.urlName = urlName;
    }

    public Hotel currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="INR", required=true, value="Currency code")
    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public Hotel status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="ACTIVE", required=true, value="iko.travel sets this status as the hotel moves through the platform workflow and manually for approval.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Hotel statusLastUpdate(OffsetDateTime statusLastUpdate) {
        this.statusLastUpdate = statusLastUpdate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Last time the platform status changed.")
    @JsonProperty(value="statusLastUpdate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getStatusLastUpdate() {
        return this.statusLastUpdate;
    }

    @JsonProperty(value="statusLastUpdate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatusLastUpdate(OffsetDateTime statusLastUpdate) {
        this.statusLastUpdate = statusLastUpdate;
    }

    public Hotel externalStatus(String externalStatus) {
        this.externalStatus = externalStatus;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="1", required=true, value="Property goes active by changing externalStatus from 6 (Inactive) to 1 (Active) according to OTA property status.")
    @JsonProperty(value="externalStatus")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getExternalStatus() {
        return this.externalStatus;
    }

    @JsonProperty(value="externalStatus")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExternalStatus(String externalStatus) {
        this.externalStatus = externalStatus;
    }

    public Hotel externalStatusLastUpdate(OffsetDateTime externalStatusLastUpdate) {
        this.externalStatusLastUpdate = externalStatusLastUpdate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Last time the property status changed.")
    @JsonProperty(value="externalStatusLastUpdate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getExternalStatusLastUpdate() {
        return this.externalStatusLastUpdate;
    }

    @JsonProperty(value="externalStatusLastUpdate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExternalStatusLastUpdate(OffsetDateTime externalStatusLastUpdate) {
        this.externalStatusLastUpdate = externalStatusLastUpdate;
    }

    public Hotel multimediaIdentifier(String multimediaIdentifier) {
        this.multimediaIdentifier = multimediaIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="multimedia-1", value="Featured property image document identifier. This is the image that is ordered first in the list of property images.")
    @JsonProperty(value="multimediaIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMultimediaIdentifier() {
        return this.multimediaIdentifier;
    }

    @JsonProperty(value="multimediaIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMultimediaIdentifier(String multimediaIdentifier) {
        this.multimediaIdentifier = multimediaIdentifier;
    }

    public Hotel imageIdentifier(String imageIdentifier) {
        this.imageIdentifier = imageIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="cloudinary-image-1", value="Featured Cloudinary identifier that can be used directly to retrieve media from Cloudinary.")
    @JsonProperty(value="imageIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getImageIdentifier() {
        return this.imageIdentifier;
    }

    @JsonProperty(value="imageIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setImageIdentifier(String imageIdentifier) {
        this.imageIdentifier = imageIdentifier;
    }

    public Hotel imageAngle(String imageAngle) {
        this.imageAngle = imageAngle;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-90", value="Featured image angle (if available).")
    @JsonProperty(value="imageAngle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getImageAngle() {
        return this.imageAngle;
    }

    @JsonProperty(value="imageAngle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setImageAngle(String imageAngle) {
        this.imageAngle = imageAngle;
    }

    public Hotel address1(String address1) {
        this.address1 = address1;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="234 Near da beach", required=true, value="Property physical location address line 1")
    @JsonProperty(value="address1")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAddress1() {
        return this.address1;
    }

    @JsonProperty(value="address1")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    public Hotel address2(String address2) {
        this.address2 = address2;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Pebble #5001", value="Second line of property address.")
    @JsonProperty(value="address2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAddress2() {
        return this.address2;
    }

    @JsonProperty(value="address2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    public Hotel postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="90210", required=true, value="Postal / zip code")
    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPostalCode() {
        return this.postalCode;
    }

    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public Hotel state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="CA", value="Not all countries have states. Add the state if the property is in a country that contain states.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(String state) {
        this.state = state;
    }

    public Hotel vatId(String vatId) {
        this.vatId = vatId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ABC1234", value="If property country requires a VAT identification number to operate, enter it here.")
    @JsonProperty(value="vatId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVatId() {
        return this.vatId;
    }

    @JsonProperty(value="vatId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVatId(String vatId) {
        this.vatId = vatId;
    }

    public Hotel contractSignerFirstName(String contractSignerFirstName) {
        this.contractSignerFirstName = contractSignerFirstName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Jane", required=true, value="First name of legal signer for this property. This is the person who agrees to the terms and conditions.")
    @JsonProperty(value="contractSignerFirstName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getContractSignerFirstName() {
        return this.contractSignerFirstName;
    }

    @JsonProperty(value="contractSignerFirstName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContractSignerFirstName(String contractSignerFirstName) {
        this.contractSignerFirstName = contractSignerFirstName;
    }

    public Hotel contractSignerLastName(String contractSignerLastName) {
        this.contractSignerLastName = contractSignerLastName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Doe", required=true, value="Last name of legal signer for this property. This is the person who agrees to the terms and conditions.")
    @JsonProperty(value="contractSignerLastName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getContractSignerLastName() {
        return this.contractSignerLastName;
    }

    @JsonProperty(value="contractSignerLastName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContractSignerLastName(String contractSignerLastName) {
        this.contractSignerLastName = contractSignerLastName;
    }

    public Hotel contractSignerPhoneNumber(String contractSignerPhoneNumber) {
        this.contractSignerPhoneNumber = contractSignerPhoneNumber;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="+12125551212", required=true, value="Phone number of legal signer for this property. This is the person who agrees to the terms and conditions.")
    @JsonProperty(value="contractSignerPhoneNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getContractSignerPhoneNumber() {
        return this.contractSignerPhoneNumber;
    }

    @JsonProperty(value="contractSignerPhoneNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContractSignerPhoneNumber(String contractSignerPhoneNumber) {
        this.contractSignerPhoneNumber = contractSignerPhoneNumber;
    }

    public Hotel contractSignerEmail(String contractSignerEmail) {
        this.contractSignerEmail = contractSignerEmail;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="jane@doe.com", required=true, value="Email of legal signer for this property. This is the person who agrees to the terms and conditions.")
    @JsonProperty(value="contractSignerEmail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getContractSignerEmail() {
        return this.contractSignerEmail;
    }

    @JsonProperty(value="contractSignerEmail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContractSignerEmail(String contractSignerEmail) {
        this.contractSignerEmail = contractSignerEmail;
    }

    public Hotel locationCategory(String locationCategory) {
        this.locationCategory = locationCategory;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="34", value="Supported OTA specification `LOC` code. See [OTA reference data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="locationCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocationCategory() {
        return this.locationCategory;
    }

    @JsonProperty(value="locationCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocationCategory(String locationCategory) {
        this.locationCategory = locationCategory;
    }

    public Hotel segmentCategory(String segmentCategory) {
        this.segmentCategory = segmentCategory;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="7", value="Supported OTA specification `SEG` code. See [OTA reference data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="segmentCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSegmentCategory() {
        return this.segmentCategory;
    }

    @JsonProperty(value="segmentCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSegmentCategory(String segmentCategory) {
        this.segmentCategory = segmentCategory;
    }

    public Hotel hotelCategory(String hotelCategory) {
        this.hotelCategory = hotelCategory;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="45", value="Supported OTA specification `PCT` code. See [OTA reference data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="hotelCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHotelCategory() {
        return this.hotelCategory;
    }

    @JsonProperty(value="hotelCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelCategory(String hotelCategory) {
        this.hotelCategory = hotelCategory;
    }

    public Hotel architecturalStyle(String architecturalStyle) {
        this.architecturalStyle = architecturalStyle;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="7", value="Supported OTA specification `ARC` code. See [OTA reference data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="architecturalStyle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getArchitecturalStyle() {
        return this.architecturalStyle;
    }

    @JsonProperty(value="architecturalStyle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setArchitecturalStyle(String architecturalStyle) {
        this.architecturalStyle = architecturalStyle;
    }

    public Hotel whenBuilt(String whenBuilt) {
        this.whenBuilt = whenBuilt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1927", value="Year the property was constructed.")
    @JsonProperty(value="whenBuilt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWhenBuilt() {
        return this.whenBuilt;
    }

    @JsonProperty(value="whenBuilt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWhenBuilt(String whenBuilt) {
        this.whenBuilt = whenBuilt;
    }

    public Hotel hotelChain(String hotelChain) {
        this.hotelChain = hotelChain;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Getaway Resorts", value="Hotel chain name if property is part of that chain.")
    @JsonProperty(value="hotelChain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHotelChain() {
        return this.hotelChain;
    }

    @JsonProperty(value="hotelChain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelChain(String hotelChain) {
        this.hotelChain = hotelChain;
    }

    public Hotel hotelBrand(String hotelBrand) {
        this.hotelBrand = hotelBrand;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Happy Resorts", value="Hotel brand name if property is part of that brand.")
    @JsonProperty(value="hotelBrand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHotelBrand() {
        return this.hotelBrand;
    }

    @JsonProperty(value="hotelBrand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelBrand(String hotelBrand) {
        this.hotelBrand = hotelBrand;
    }

    public Hotel channelManager(ChannelManagerEnum channelManager) {
        this.channelManager = channelManager;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="OTHER_CHANNEL_MANAGER", value="Property's channel manager. Rate ownership is decided based on the channel manager selected. Defaults to `TRAVELIKO` which is the same as no channel manager and rate ownership goes to the platform.")
    @JsonProperty(value="channelManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChannelManagerEnum getChannelManager() {
        return this.channelManager;
    }

    @JsonProperty(value="channelManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChannelManager(ChannelManagerEnum channelManager) {
        this.channelManager = channelManager;
    }

    public Hotel otherChannelManager(String otherChannelManager) {
        this.otherChannelManager = otherChannelManager;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="CM X", value="If the property is currently using a channel manager but it isn't yet part of our list, chose 'OTHER_CHANNEL_MANAGER' as channelManager and fill in the name of the channel manager here")
    @JsonProperty(value="otherChannelManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOtherChannelManager() {
        return this.otherChannelManager;
    }

    @JsonProperty(value="otherChannelManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOtherChannelManager(String otherChannelManager) {
        this.otherChannelManager = otherChannelManager;
    }

    public Hotel licenseNumber(String licenseNumber) {
        this.licenseNumber = licenseNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ABC1234", value="If the property has a valid license number to run a hotel in their country, add it here.")
    @JsonProperty(value="licenseNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLicenseNumber() {
        return this.licenseNumber;
    }

    @JsonProperty(value="licenseNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLicenseNumber(String licenseNumber) {
        this.licenseNumber = licenseNumber;
    }

    public Hotel stars(Integer stars) {
        this.stars = stars;
        return this;
    }

    @Nullable
    @Min(value=0L)
    @Max(value=6L)
    @ApiModelProperty(value="Hotel star rating.")
    @JsonProperty(value="stars")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Min(value=0L) @Max(value=6L) Integer getStars() {
        return this.stars;
    }

    @JsonProperty(value="stars")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStars(Integer stars) {
        this.stars = stars;
    }

    public Hotel fullNameOfGeneralManager(String fullNameOfGeneralManager) {
        this.fullNameOfGeneralManager = fullNameOfGeneralManager;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of GM currently managing the property.")
    @JsonProperty(value="fullNameOfGeneralManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullNameOfGeneralManager() {
        return this.fullNameOfGeneralManager;
    }

    @JsonProperty(value="fullNameOfGeneralManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullNameOfGeneralManager(String fullNameOfGeneralManager) {
        this.fullNameOfGeneralManager = fullNameOfGeneralManager;
    }

    public Hotel profilePictureIdentifierGeneralManager(String profilePictureIdentifierGeneralManager) {
        this.profilePictureIdentifierGeneralManager = profilePictureIdentifierGeneralManager;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Cloudinary image identifier of GM currently managing the property.")
    @JsonProperty(value="profilePictureIdentifierGeneralManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProfilePictureIdentifierGeneralManager() {
        return this.profilePictureIdentifierGeneralManager;
    }

    @JsonProperty(value="profilePictureIdentifierGeneralManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfilePictureIdentifierGeneralManager(String profilePictureIdentifierGeneralManager) {
        this.profilePictureIdentifierGeneralManager = profilePictureIdentifierGeneralManager;
    }

    public Hotel messagesOfGeneralManager(List<SimpleDescription> messagesOfGeneralManager) {
        this.messagesOfGeneralManager = messagesOfGeneralManager;
        return this;
    }

    public Hotel addMessagesOfGeneralManagerItem(SimpleDescription messagesOfGeneralManagerItem) {
        if (this.messagesOfGeneralManager == null) {
            this.messagesOfGeneralManager = new ArrayList<SimpleDescription>();
        }
        this.messagesOfGeneralManager.add(messagesOfGeneralManagerItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Personal welcome message from GM.")
    @JsonProperty(value="messagesOfGeneralManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SimpleDescription> getMessagesOfGeneralManager() {
        return this.messagesOfGeneralManager;
    }

    @JsonProperty(value="messagesOfGeneralManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMessagesOfGeneralManager(List<SimpleDescription> messagesOfGeneralManager) {
        this.messagesOfGeneralManager = messagesOfGeneralManager;
    }

    public Hotel shortDescriptions(List<SimpleDescription> shortDescriptions) {
        this.shortDescriptions = shortDescriptions;
        return this;
    }

    public Hotel addShortDescriptionsItem(SimpleDescription shortDescriptionsItem) {
        if (this.shortDescriptions == null) {
            this.shortDescriptions = new ArrayList<SimpleDescription>();
        }
        this.shortDescriptions.add(shortDescriptionsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Localized short descriptions of property.")
    @JsonProperty(value="shortDescriptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SimpleDescription> getShortDescriptions() {
        return this.shortDescriptions;
    }

    @JsonProperty(value="shortDescriptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShortDescriptions(List<SimpleDescription> shortDescriptions) {
        this.shortDescriptions = shortDescriptions;
    }

    public Hotel longDescriptions(List<SimpleDescription> longDescriptions) {
        this.longDescriptions = longDescriptions;
        return this;
    }

    public Hotel addLongDescriptionsItem(SimpleDescription longDescriptionsItem) {
        if (this.longDescriptions == null) {
            this.longDescriptions = new ArrayList<SimpleDescription>();
        }
        this.longDescriptions.add(longDescriptionsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Localized long descriptions of property.")
    @JsonProperty(value="longDescriptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SimpleDescription> getLongDescriptions() {
        return this.longDescriptions;
    }

    @JsonProperty(value="longDescriptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLongDescriptions(List<SimpleDescription> longDescriptions) {
        this.longDescriptions = longDescriptions;
    }

    public Hotel hotelAmenityCodes(List<String> hotelAmenityCodes) {
        this.hotelAmenityCodes = hotelAmenityCodes;
        return this;
    }

    public Hotel addHotelAmenityCodesItem(String hotelAmenityCodesItem) {
        if (this.hotelAmenityCodes == null) {
            this.hotelAmenityCodes = new ArrayList<String>();
        }
        this.hotelAmenityCodes.add(hotelAmenityCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1\",\"7\"]", value="Supported OTA specification `HAC` code. See [OTA reference data](#operation/showAvailableCodesForCategory).")
    @JsonProperty(value="hotelAmenityCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getHotelAmenityCodes() {
        return this.hotelAmenityCodes;
    }

    @JsonProperty(value="hotelAmenityCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelAmenityCodes(List<String> hotelAmenityCodes) {
        this.hotelAmenityCodes = hotelAmenityCodes;
    }

    public Hotel propertyAccessibilityCodes(List<String> propertyAccessibilityCodes) {
        this.propertyAccessibilityCodes = propertyAccessibilityCodes;
        return this;
    }

    public Hotel addPropertyAccessibilityCodesItem(String propertyAccessibilityCodesItem) {
        if (this.propertyAccessibilityCodes == null) {
            this.propertyAccessibilityCodes = new ArrayList<String>();
        }
        this.propertyAccessibilityCodes.add(propertyAccessibilityCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1\",\"7\"]", value="Supported OTA specification `PHY` code. See [OTA reference data](#operation/showAvailableCodesForCategory).")
    @JsonProperty(value="propertyAccessibilityCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPropertyAccessibilityCodes() {
        return this.propertyAccessibilityCodes;
    }

    @JsonProperty(value="propertyAccessibilityCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPropertyAccessibilityCodes(List<String> propertyAccessibilityCodes) {
        this.propertyAccessibilityCodes = propertyAccessibilityCodes;
    }

    public Hotel propertySecurityCodes(List<String> propertySecurityCodes) {
        this.propertySecurityCodes = propertySecurityCodes;
        return this;
    }

    public Hotel addPropertySecurityCodesItem(String propertySecurityCodesItem) {
        if (this.propertySecurityCodes == null) {
            this.propertySecurityCodes = new ArrayList<String>();
        }
        this.propertySecurityCodes.add(propertySecurityCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1\",\"7\"]", value="Supported OTA specification `SEC` code. See [OTA reference data](#operation/showAvailableCodesForCategory).")
    @JsonProperty(value="propertySecurityCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPropertySecurityCodes() {
        return this.propertySecurityCodes;
    }

    @JsonProperty(value="propertySecurityCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPropertySecurityCodes(List<String> propertySecurityCodes) {
        this.propertySecurityCodes = propertySecurityCodes;
    }

    public Hotel locationPoint(GeoJsonPoint locationPoint) {
        this.locationPoint = locationPoint;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="locationPoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GeoJsonPoint getLocationPoint() {
        return this.locationPoint;
    }

    @JsonProperty(value="locationPoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocationPoint(GeoJsonPoint locationPoint) {
        this.locationPoint = locationPoint;
    }

    public Hotel policy(PropertyPolicy policy) {
        this.policy = policy;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PropertyPolicy getPolicy() {
        return this.policy;
    }

    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolicy(PropertyPolicy policy) {
        this.policy = policy;
    }

    public Hotel socials(List<Social> socials) {
        this.socials = socials;
        return this;
    }

    public Hotel addSocialsItem(Social socialsItem) {
        if (this.socials == null) {
            this.socials = new ArrayList<Social>();
        }
        this.socials.add(socialsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="List of all social network account property has.")
    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Social> getSocials() {
        return this.socials;
    }

    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocials(List<Social> socials) {
        this.socials = socials;
    }

    public Hotel reservationsContact(ContactDto reservationsContact) {
        this.reservationsContact = reservationsContact;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="reservationsContact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContactDto getReservationsContact() {
        return this.reservationsContact;
    }

    @JsonProperty(value="reservationsContact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReservationsContact(ContactDto reservationsContact) {
        this.reservationsContact = reservationsContact;
    }

    public Hotel accountingContact(ContactDto accountingContact) {
        this.accountingContact = accountingContact;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="accountingContact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContactDto getAccountingContact() {
        return this.accountingContact;
    }

    @JsonProperty(value="accountingContact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountingContact(ContactDto accountingContact) {
        this.accountingContact = accountingContact;
    }

    public Hotel accountingAddress(AddressDto accountingAddress) {
        this.accountingAddress = accountingAddress;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="accountingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AddressDto getAccountingAddress() {
        return this.accountingAddress;
    }

    @JsonProperty(value="accountingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountingAddress(AddressDto accountingAddress) {
        this.accountingAddress = accountingAddress;
    }

    public Hotel lifestyleTypes(List<LifestyleTypesEnum> lifestyleTypes) {
        this.lifestyleTypes = lifestyleTypes;
        return this;
    }

    public Hotel addLifestyleTypesItem(LifestyleTypesEnum lifestyleTypesItem) {
        if (this.lifestyleTypes == null) {
            this.lifestyleTypes = new ArrayList<LifestyleTypesEnum>();
        }
        this.lifestyleTypes.add(lifestyleTypesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of all lifestyles property has associated with. See [Lifestyle reference data](#operation/showLifestyles)")
    @JsonProperty(value="lifestyleTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LifestyleTypesEnum> getLifestyleTypes() {
        return this.lifestyleTypes;
    }

    @JsonProperty(value="lifestyleTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifestyleTypes(List<LifestyleTypesEnum> lifestyleTypes) {
        this.lifestyleTypes = lifestyleTypes;
    }

    public Hotel agreementAccepted(Boolean agreementAccepted) {
        this.agreementAccepted = agreementAccepted;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Property has accepted our terms and conditions.")
    @JsonProperty(value="agreementAccepted")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getAgreementAccepted() {
        return this.agreementAccepted;
    }

    @JsonProperty(value="agreementAccepted")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAgreementAccepted(Boolean agreementAccepted) {
        this.agreementAccepted = agreementAccepted;
    }

    public Hotel marketingOptinAllowed(Boolean marketingOptinAllowed) {
        this.marketingOptinAllowed = marketingOptinAllowed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Property agreed to let the platform use its logo and images for marketing purposes (with proper credits).")
    @JsonProperty(value="marketingOptinAllowed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMarketingOptinAllowed() {
        return this.marketingOptinAllowed;
    }

    @JsonProperty(value="marketingOptinAllowed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMarketingOptinAllowed(Boolean marketingOptinAllowed) {
        this.marketingOptinAllowed = marketingOptinAllowed;
    }

    public Hotel logos(List<Multimedia> logos) {
        this.logos = logos;
        return this;
    }

    public Hotel addLogosItem(Multimedia logosItem) {
        if (this.logos == null) {
            this.logos = new ArrayList<Multimedia>();
        }
        this.logos.add(logosItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="List of logo images of property")
    @JsonProperty(value="logos")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Multimedia> getLogos() {
        return this.logos;
    }

    @JsonProperty(value="logos")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogos(List<Multimedia> logos) {
        this.logos = logos;
    }

    public Hotel city(GeoName city) {
        this.city = city;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GeoName getCity() {
        return this.city;
    }

    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCity(GeoName city) {
        this.city = city;
    }

    public Hotel numberOfRooms(Integer numberOfRooms) {
        this.numberOfRooms = numberOfRooms;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @ApiModelProperty(example="40", required=true, value="Number of rooms / keys for property")
    @JsonProperty(value="numberOfRooms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getNumberOfRooms() {
        return this.numberOfRooms;
    }

    @JsonProperty(value="numberOfRooms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNumberOfRooms(Integer numberOfRooms) {
        this.numberOfRooms = numberOfRooms;
    }

    public Hotel active(Boolean active) {
        this.active = active;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Property is both approved and activated.")
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActive(Boolean active) {
        this.active = active;
    }

    public Hotel propertyActive(Boolean propertyActive) {
        this.propertyActive = propertyActive;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Property activated itself and went live.")
    @JsonProperty(value="propertyActive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPropertyActive() {
        return this.propertyActive;
    }

    @JsonProperty(value="propertyActive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPropertyActive(Boolean propertyActive) {
        this.propertyActive = propertyActive;
    }

    public Hotel platformActive(Boolean platformActive) {
        this.platformActive = platformActive;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Platform approved property.")
    @JsonProperty(value="platformActive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPlatformActive() {
        return this.platformActive;
    }

    @JsonProperty(value="platformActive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlatformActive(Boolean platformActive) {
        this.platformActive = platformActive;
    }

    public Hotel contractSignerFullName(String contractSignerFullName) {
        this.contractSignerFullName = contractSignerFullName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Jane Doe", value="Concatenated name of contract signer into one string.")
    @JsonProperty(value="contractSignerFullName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContractSignerFullName() {
        return this.contractSignerFullName;
    }

    @JsonProperty(value="contractSignerFullName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContractSignerFullName(String contractSignerFullName) {
        this.contractSignerFullName = contractSignerFullName;
    }

    public Hotel socialNetworks(Boolean socialNetworks) {
        this.socialNetworks = socialNetworks;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether property has any social networks associated with her profile.")
    @JsonProperty(value="socialNetworks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSocialNetworks() {
        return this.socialNetworks;
    }

    @JsonProperty(value="socialNetworks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocialNetworks(Boolean socialNetworks) {
        this.socialNetworks = socialNetworks;
    }

    public Hotel lifestyles(Boolean lifestyles) {
        this.lifestyles = lifestyles;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether property has any lifestyles associated with her profile.")
    @JsonProperty(value="lifestyles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getLifestyles() {
        return this.lifestyles;
    }

    @JsonProperty(value="lifestyles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifestyles(Boolean lifestyles) {
        this.lifestyles = lifestyles;
    }

    public Hotel fullAddress(String fullAddress) {
        this.fullAddress = fullAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="234 Near da beach, Pebble #5001, Los Angeles, CA 90210", value="Concatenated address into a single string")
    @JsonProperty(value="fullAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullAddress() {
        return this.fullAddress;
    }

    @JsonProperty(value="fullAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullAddress(String fullAddress) {
        this.fullAddress = fullAddress;
    }

    public Hotel generalManagerWelcomeMessage(Boolean generalManagerWelcomeMessage) {
        this.generalManagerWelcomeMessage = generalManagerWelcomeMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether property has any GM-created welcome messages.")
    @JsonProperty(value="generalManagerWelcomeMessage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getGeneralManagerWelcomeMessage() {
        return this.generalManagerWelcomeMessage;
    }

    @JsonProperty(value="generalManagerWelcomeMessage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGeneralManagerWelcomeMessage(Boolean generalManagerWelcomeMessage) {
        this.generalManagerWelcomeMessage = generalManagerWelcomeMessage;
    }

    public Hotel greenIndexScores(AggregateGreendexAnswers greenIndexScores) {
        this.greenIndexScores = greenIndexScores;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="greenIndexScores")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AggregateGreendexAnswers getGreenIndexScores() {
        return this.greenIndexScores;
    }

    @JsonProperty(value="greenIndexScores")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGreenIndexScores(AggregateGreendexAnswers greenIndexScores) {
        this.greenIndexScores = greenIndexScores;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hotel hotel = (Hotel)o;
        return Objects.equals(this.hotelIdentifier, hotel.hotelIdentifier) && Objects.equals(this.name, hotel.name) && Objects.equals(this.hotelCode, hotel.hotelCode) && Objects.equals(this.hotelCodeContext, hotel.hotelCodeContext) && Objects.equals(this.localName, hotel.localName) && Objects.equals(this.legalName, hotel.legalName) && Objects.equals(this.urlName, hotel.urlName) && Objects.equals(this.currencyCode, hotel.currencyCode) && Objects.equals((Object)this.status, (Object)hotel.status) && Objects.equals(this.statusLastUpdate, hotel.statusLastUpdate) && Objects.equals(this.externalStatus, hotel.externalStatus) && Objects.equals(this.externalStatusLastUpdate, hotel.externalStatusLastUpdate) && Objects.equals(this.multimediaIdentifier, hotel.multimediaIdentifier) && Objects.equals(this.imageIdentifier, hotel.imageIdentifier) && Objects.equals(this.imageAngle, hotel.imageAngle) && Objects.equals(this.address1, hotel.address1) && Objects.equals(this.address2, hotel.address2) && Objects.equals(this.postalCode, hotel.postalCode) && Objects.equals(this.state, hotel.state) && Objects.equals(this.vatId, hotel.vatId) && Objects.equals(this.contractSignerFirstName, hotel.contractSignerFirstName) && Objects.equals(this.contractSignerLastName, hotel.contractSignerLastName) && Objects.equals(this.contractSignerPhoneNumber, hotel.contractSignerPhoneNumber) && Objects.equals(this.contractSignerEmail, hotel.contractSignerEmail) && Objects.equals(this.locationCategory, hotel.locationCategory) && Objects.equals(this.segmentCategory, hotel.segmentCategory) && Objects.equals(this.hotelCategory, hotel.hotelCategory) && Objects.equals(this.architecturalStyle, hotel.architecturalStyle) && Objects.equals(this.whenBuilt, hotel.whenBuilt) && Objects.equals(this.hotelChain, hotel.hotelChain) && Objects.equals(this.hotelBrand, hotel.hotelBrand) && Objects.equals((Object)this.channelManager, (Object)hotel.channelManager) && Objects.equals(this.otherChannelManager, hotel.otherChannelManager) && Objects.equals(this.licenseNumber, hotel.licenseNumber) && Objects.equals(this.stars, hotel.stars) && Objects.equals(this.fullNameOfGeneralManager, hotel.fullNameOfGeneralManager) && Objects.equals(this.profilePictureIdentifierGeneralManager, hotel.profilePictureIdentifierGeneralManager) && Objects.equals(this.messagesOfGeneralManager, hotel.messagesOfGeneralManager) && Objects.equals(this.shortDescriptions, hotel.shortDescriptions) && Objects.equals(this.longDescriptions, hotel.longDescriptions) && Objects.equals(this.hotelAmenityCodes, hotel.hotelAmenityCodes) && Objects.equals(this.propertyAccessibilityCodes, hotel.propertyAccessibilityCodes) && Objects.equals(this.propertySecurityCodes, hotel.propertySecurityCodes) && Objects.equals(this.locationPoint, hotel.locationPoint) && Objects.equals(this.policy, hotel.policy) && Objects.equals(this.socials, hotel.socials) && Objects.equals(this.reservationsContact, hotel.reservationsContact) && Objects.equals(this.accountingContact, hotel.accountingContact) && Objects.equals(this.accountingAddress, hotel.accountingAddress) && Objects.equals(this.lifestyleTypes, hotel.lifestyleTypes) && Objects.equals(this.agreementAccepted, hotel.agreementAccepted) && Objects.equals(this.marketingOptinAllowed, hotel.marketingOptinAllowed) && Objects.equals(this.logos, hotel.logos) && Objects.equals(this.city, hotel.city) && Objects.equals(this.numberOfRooms, hotel.numberOfRooms) && Objects.equals(this.active, hotel.active) && Objects.equals(this.propertyActive, hotel.propertyActive) && Objects.equals(this.platformActive, hotel.platformActive) && Objects.equals(this.contractSignerFullName, hotel.contractSignerFullName) && Objects.equals(this.socialNetworks, hotel.socialNetworks) && Objects.equals(this.lifestyles, hotel.lifestyles) && Objects.equals(this.fullAddress, hotel.fullAddress) && Objects.equals(this.generalManagerWelcomeMessage, hotel.generalManagerWelcomeMessage) && Objects.equals(this.greenIndexScores, hotel.greenIndexScores);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hotelIdentifier, this.name, this.hotelCode, this.hotelCodeContext, this.localName, this.legalName, this.urlName, this.currencyCode, this.status, this.statusLastUpdate, this.externalStatus, this.externalStatusLastUpdate, this.multimediaIdentifier, this.imageIdentifier, this.imageAngle, this.address1, this.address2, this.postalCode, this.state, this.vatId, this.contractSignerFirstName, this.contractSignerLastName, this.contractSignerPhoneNumber, this.contractSignerEmail, this.locationCategory, this.segmentCategory, this.hotelCategory, this.architecturalStyle, this.whenBuilt, this.hotelChain, this.hotelBrand, this.channelManager, this.otherChannelManager, this.licenseNumber, this.stars, this.fullNameOfGeneralManager, this.profilePictureIdentifierGeneralManager, this.messagesOfGeneralManager, this.shortDescriptions, this.longDescriptions, this.hotelAmenityCodes, this.propertyAccessibilityCodes, this.propertySecurityCodes, this.locationPoint, this.policy, this.socials, this.reservationsContact, this.accountingContact, this.accountingAddress, this.lifestyleTypes, this.agreementAccepted, this.marketingOptinAllowed, this.logos, this.city, this.numberOfRooms, this.active, this.propertyActive, this.platformActive, this.contractSignerFullName, this.socialNetworks, this.lifestyles, this.fullAddress, this.generalManagerWelcomeMessage, this.greenIndexScores});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Hotel {\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    hotelCode: ").append(this.toIndentedString(this.hotelCode)).append("\n");
        sb.append("    hotelCodeContext: ").append(this.toIndentedString(this.hotelCodeContext)).append("\n");
        sb.append("    localName: ").append(this.toIndentedString(this.localName)).append("\n");
        sb.append("    legalName: ").append(this.toIndentedString(this.legalName)).append("\n");
        sb.append("    urlName: ").append(this.toIndentedString(this.urlName)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    statusLastUpdate: ").append(this.toIndentedString(this.statusLastUpdate)).append("\n");
        sb.append("    externalStatus: ").append(this.toIndentedString(this.externalStatus)).append("\n");
        sb.append("    externalStatusLastUpdate: ").append(this.toIndentedString(this.externalStatusLastUpdate)).append("\n");
        sb.append("    multimediaIdentifier: ").append(this.toIndentedString(this.multimediaIdentifier)).append("\n");
        sb.append("    imageIdentifier: ").append(this.toIndentedString(this.imageIdentifier)).append("\n");
        sb.append("    imageAngle: ").append(this.toIndentedString(this.imageAngle)).append("\n");
        sb.append("    address1: ").append(this.toIndentedString(this.address1)).append("\n");
        sb.append("    address2: ").append(this.toIndentedString(this.address2)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    vatId: ").append(this.toIndentedString(this.vatId)).append("\n");
        sb.append("    contractSignerFirstName: ").append(this.toIndentedString(this.contractSignerFirstName)).append("\n");
        sb.append("    contractSignerLastName: ").append(this.toIndentedString(this.contractSignerLastName)).append("\n");
        sb.append("    contractSignerPhoneNumber: ").append(this.toIndentedString(this.contractSignerPhoneNumber)).append("\n");
        sb.append("    contractSignerEmail: ").append(this.toIndentedString(this.contractSignerEmail)).append("\n");
        sb.append("    locationCategory: ").append(this.toIndentedString(this.locationCategory)).append("\n");
        sb.append("    segmentCategory: ").append(this.toIndentedString(this.segmentCategory)).append("\n");
        sb.append("    hotelCategory: ").append(this.toIndentedString(this.hotelCategory)).append("\n");
        sb.append("    architecturalStyle: ").append(this.toIndentedString(this.architecturalStyle)).append("\n");
        sb.append("    whenBuilt: ").append(this.toIndentedString(this.whenBuilt)).append("\n");
        sb.append("    hotelChain: ").append(this.toIndentedString(this.hotelChain)).append("\n");
        sb.append("    hotelBrand: ").append(this.toIndentedString(this.hotelBrand)).append("\n");
        sb.append("    channelManager: ").append(this.toIndentedString((Object)this.channelManager)).append("\n");
        sb.append("    otherChannelManager: ").append(this.toIndentedString(this.otherChannelManager)).append("\n");
        sb.append("    licenseNumber: ").append(this.toIndentedString(this.licenseNumber)).append("\n");
        sb.append("    stars: ").append(this.toIndentedString(this.stars)).append("\n");
        sb.append("    fullNameOfGeneralManager: ").append(this.toIndentedString(this.fullNameOfGeneralManager)).append("\n");
        sb.append("    profilePictureIdentifierGeneralManager: ").append(this.toIndentedString(this.profilePictureIdentifierGeneralManager)).append("\n");
        sb.append("    messagesOfGeneralManager: ").append(this.toIndentedString(this.messagesOfGeneralManager)).append("\n");
        sb.append("    shortDescriptions: ").append(this.toIndentedString(this.shortDescriptions)).append("\n");
        sb.append("    longDescriptions: ").append(this.toIndentedString(this.longDescriptions)).append("\n");
        sb.append("    hotelAmenityCodes: ").append(this.toIndentedString(this.hotelAmenityCodes)).append("\n");
        sb.append("    propertyAccessibilityCodes: ").append(this.toIndentedString(this.propertyAccessibilityCodes)).append("\n");
        sb.append("    propertySecurityCodes: ").append(this.toIndentedString(this.propertySecurityCodes)).append("\n");
        sb.append("    locationPoint: ").append(this.toIndentedString(this.locationPoint)).append("\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("    socials: ").append(this.toIndentedString(this.socials)).append("\n");
        sb.append("    reservationsContact: ").append(this.toIndentedString(this.reservationsContact)).append("\n");
        sb.append("    accountingContact: ").append(this.toIndentedString(this.accountingContact)).append("\n");
        sb.append("    accountingAddress: ").append(this.toIndentedString(this.accountingAddress)).append("\n");
        sb.append("    lifestyleTypes: ").append(this.toIndentedString(this.lifestyleTypes)).append("\n");
        sb.append("    agreementAccepted: ").append(this.toIndentedString(this.agreementAccepted)).append("\n");
        sb.append("    marketingOptinAllowed: ").append(this.toIndentedString(this.marketingOptinAllowed)).append("\n");
        sb.append("    logos: ").append(this.toIndentedString(this.logos)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    numberOfRooms: ").append(this.toIndentedString(this.numberOfRooms)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    propertyActive: ").append(this.toIndentedString(this.propertyActive)).append("\n");
        sb.append("    platformActive: ").append(this.toIndentedString(this.platformActive)).append("\n");
        sb.append("    contractSignerFullName: ").append(this.toIndentedString(this.contractSignerFullName)).append("\n");
        sb.append("    socialNetworks: ").append(this.toIndentedString(this.socialNetworks)).append("\n");
        sb.append("    lifestyles: ").append(this.toIndentedString(this.lifestyles)).append("\n");
        sb.append("    fullAddress: ").append(this.toIndentedString(this.fullAddress)).append("\n");
        sb.append("    generalManagerWelcomeMessage: ").append(this.toIndentedString(this.generalManagerWelcomeMessage)).append("\n");
        sb.append("    greenIndexScores: ").append(this.toIndentedString(this.greenIndexScores)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        DISABLED("DISABLED"),
        SUSPENDED("SUSPENDED"),
        REMOVED("REMOVED"),
        WAITING_ON_CONTRACT("WAITING_ON_CONTRACT"),
        CONTRACT_SIGNED("CONTRACT_SIGNED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ChannelManagerEnum {
        TRAVELIKO("TRAVELIKO"),
        SITEMINDER("SITEMINDER"),
        FASTBOOKING("FASTBOOKING"),
        RATEGAIN("RATEGAIN"),
        CLOUD_BEDS("CLOUD_BEDS"),
        YIELD_PLANET("YIELD_PLANET"),
        TRAVELCLICK("TRAVELCLICK"),
        HOTEL_GURU("HOTEL_GURU"),
        OTHER_CHANNEL_MANAGER("OTHER_CHANNEL_MANAGER"),
        BOOKING_JINI("BOOKING_JINI"),
        HOTEL_LINK_SOLUTIONS("HOTEL_LINK_SOLUTIONS"),
        ALLOTZ("ALLOTZ"),
        DEDGE("DEDGE"),
        RATE_TIGER("RATE_TIGER"),
        RESAVENUE("RESAVENUE"),
        COMANCHE("COMANCHE"),
        OMNIBEES("OMNIBEES"),
        EZEE("EZEE"),
        SYNXIS("SYNXIS");

        private String value;

        private ChannelManagerEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChannelManagerEnum fromValue(String value) {
            for (ChannelManagerEnum b : ChannelManagerEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum LifestyleTypesEnum {
        HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
        RELAX("LIFESTYLE_RELAX"),
        ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
        ADVENTURE("LIFESTYLE_ADVENTURE"),
        BUSINESS("LIFESTYLE_BUSINESS"),
        LGBT("LIFESTYLE_LGBT"),
        SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
        SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
        BEAUTY("LIFESTYLE_BEAUTY"),
        FOODIE("LIFESTYLE_FOODIE"),
        FAMILY("LIFESTYLE_FAMILY"),
        ROMANCE("LIFESTYLE_ROMANCE"),
        COUPLE("LIFESTYLE_COUPLE"),
        SOLO("LIFESTYLE_SOLO"),
        BACKPACKER("LIFESTYLE_BACKPACKER"),
        SHOPPING("LIFESTYLE_SHOPPING"),
        SPORTS("LIFESTYLE_SPORTS"),
        MOUNTAIN("LIFESTYLE_MOUNTAIN"),
        BEACH("LIFESTYLE_BEACH"),
        CITY("LIFESTYLE_CITY"),
        COUNTRY("LIFESTYLE_COUNTRY"),
        CULTURE("LIFESTYLE_CULTURE"),
        ECO("LIFESTYLE_ECO");

        private String value;

        private LifestyleTypesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LifestyleTypesEnum fromValue(String value) {
            for (LifestyleTypesEnum b : LifestyleTypesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

