package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.LifestylesResponse;
import travel.wink.sdk.extranet.model.ShowHotelStatus400Response;
import travel.wink.sdk.extranet.model.UpdateLifestylesRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-28T12:06:31.577230+07:00[Asia/Bangkok]")
public class LifestyleApi {
    private ApiClient apiClient;

    public LifestyleApi() {
        this(new ApiClient());
    }

    @Autowired
    public LifestyleApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show Lifestyles
     * Retrieve list of property lifestyles
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show Lifestyles for this hotel identifier
     * @param accept The accept parameter
     * @return LifestylesResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showLifestyles1RequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showLifestyles1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<LifestylesResponse> localVarReturnType = new ParameterizedTypeReference<LifestylesResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/lifestyles", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Lifestyles
     * Retrieve list of property lifestyles
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show Lifestyles for this hotel identifier
     * @param accept The accept parameter
     * @return LifestylesResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<LifestylesResponse> showLifestyles1(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LifestylesResponse> localVarReturnType = new ParameterizedTypeReference<LifestylesResponse>() {};
        return showLifestyles1RequestCreation(hotelIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<LifestylesResponse>> showLifestyles1WithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LifestylesResponse> localVarReturnType = new ParameterizedTypeReference<LifestylesResponse>() {};
        return showLifestyles1RequestCreation(hotelIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Update Lifestyles
     * Update selected lifestyles. See [Lifestyle reference data](#operation/showLifestyles) for supported lifestyles.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update lifestyles for this hotel identifier
     * @param updateLifestylesRequest The updateLifestylesRequest parameter
     * @return LifestylesResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateLifestylesRequestCreation(String hotelIdentifier, UpdateLifestylesRequest updateLifestylesRequest) throws WebClientResponseException {
        Object postBody = updateLifestylesRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateLifestyles", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updateLifestylesRequest' is set
        if (updateLifestylesRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateLifestylesRequest' when calling updateLifestyles", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<LifestylesResponse> localVarReturnType = new ParameterizedTypeReference<LifestylesResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/lifestyles", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Lifestyles
     * Update selected lifestyles. See [Lifestyle reference data](#operation/showLifestyles) for supported lifestyles.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update lifestyles for this hotel identifier
     * @param updateLifestylesRequest The updateLifestylesRequest parameter
     * @return LifestylesResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<LifestylesResponse> updateLifestyles(String hotelIdentifier, UpdateLifestylesRequest updateLifestylesRequest) throws WebClientResponseException {
        ParameterizedTypeReference<LifestylesResponse> localVarReturnType = new ParameterizedTypeReference<LifestylesResponse>() {};
        return updateLifestylesRequestCreation(hotelIdentifier, updateLifestylesRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<LifestylesResponse>> updateLifestylesWithHttpInfo(String hotelIdentifier, UpdateLifestylesRequest updateLifestylesRequest) throws WebClientResponseException {
        ParameterizedTypeReference<LifestylesResponse> localVarReturnType = new ParameterizedTypeReference<LifestylesResponse>() {};
        return updateLifestylesRequestCreation(hotelIdentifier, updateLifestylesRequest).toEntity(localVarReturnType);
    }
}
