package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.CreateMasterRateRequest;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.MasterRateView;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.RoomRateRemovableResponse;
import travel.wink.sdk.extranet.model.ShowHotelStatus400Response;
import travel.wink.sdk.extranet.model.UpdateMasterRateRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-28T12:06:31.577230+07:00[Asia/Bangkok]")
public class MasterRateApi {
    private ApiClient apiClient;

    public MasterRateApi() {
        this(new ApiClient());
    }

    @Autowired
    public MasterRateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Verify Removable
     * Check if a master rate is removable. If a master is associated / linked with a promotion, it cannot be removed until the associated entity removes it first.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Verify if master rate, owned by this hotel identifier, is removable.
     * @param masterRateIdentifier Verify if master rate, identified by this identifier, is removable.
     * @param accept The accept parameter
     * @return RoomRateRemovableResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removableMasterRateRequestCreation(String hotelIdentifier, String masterRateIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removableMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling removableMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RoomRateRemovableResponse> localVarReturnType = new ParameterizedTypeReference<RoomRateRemovableResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/roomrate/{masterRateIdentifier}/removable", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Verify Removable
     * Check if a master rate is removable. If a master is associated / linked with a promotion, it cannot be removed until the associated entity removes it first.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Verify if master rate, owned by this hotel identifier, is removable.
     * @param masterRateIdentifier Verify if master rate, identified by this identifier, is removable.
     * @param accept The accept parameter
     * @return RoomRateRemovableResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RoomRateRemovableResponse> removableMasterRate(String hotelIdentifier, String masterRateIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RoomRateRemovableResponse> localVarReturnType = new ParameterizedTypeReference<RoomRateRemovableResponse>() {};
        return removableMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RoomRateRemovableResponse>> removableMasterRateWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RoomRateRemovableResponse> localVarReturnType = new ParameterizedTypeReference<RoomRateRemovableResponse>() {};
        return removableMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Delete Master Rate
     * Delete a master rate by its identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove master rate owned by this hotel identifier.
     * @param masterRateIdentifier Remove master rate with this hotel identifier.
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeMasterRateRequestCreation(String hotelIdentifier, String masterRateIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling removeMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/roomrate/{masterRateIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Master Rate
     * Delete a master rate by its identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove master rate owned by this hotel identifier.
     * @param masterRateIdentifier Remove master rate with this hotel identifier.
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeMasterRate(String hotelIdentifier, String masterRateIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeMasterRateWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Create Master Rate
     * Create a new master rate
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create new master rate owned by this hotel identifier.
     * @param createMasterRateRequest The createMasterRateRequest parameter
     * @return MasterRateView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec saveMasterRateRequestCreation(String hotelIdentifier, CreateMasterRateRequest createMasterRateRequest) throws WebClientResponseException {
        Object postBody = createMasterRateRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling saveMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'createMasterRateRequest' is set
        if (createMasterRateRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createMasterRateRequest' when calling saveMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<MasterRateView> localVarReturnType = new ParameterizedTypeReference<MasterRateView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/roomrate", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Master Rate
     * Create a new master rate
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create new master rate owned by this hotel identifier.
     * @param createMasterRateRequest The createMasterRateRequest parameter
     * @return MasterRateView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MasterRateView> saveMasterRate(String hotelIdentifier, CreateMasterRateRequest createMasterRateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateView> localVarReturnType = new ParameterizedTypeReference<MasterRateView>() {};
        return saveMasterRateRequestCreation(hotelIdentifier, createMasterRateRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<MasterRateView>> saveMasterRateWithHttpInfo(String hotelIdentifier, CreateMasterRateRequest createMasterRateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateView> localVarReturnType = new ParameterizedTypeReference<MasterRateView>() {};
        return saveMasterRateRequestCreation(hotelIdentifier, createMasterRateRequest).toEntity(localVarReturnType);
    }
    /**
     * Show Master Rate
     * Retrieve a master rate by its identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single master rate owned by this hotel identifier.
     * @param masterRateIdentifier Show single master rate with this identifier.
     * @param accept The accept parameter
     * @return MasterRateView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showMasterRateRequestCreation(String hotelIdentifier, String masterRateIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling showMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<MasterRateView> localVarReturnType = new ParameterizedTypeReference<MasterRateView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/roomrate/{masterRateIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Master Rate
     * Retrieve a master rate by its identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single master rate owned by this hotel identifier.
     * @param masterRateIdentifier Show single master rate with this identifier.
     * @param accept The accept parameter
     * @return MasterRateView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MasterRateView> showMasterRate(String hotelIdentifier, String masterRateIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateView> localVarReturnType = new ParameterizedTypeReference<MasterRateView>() {};
        return showMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<MasterRateView>> showMasterRateWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateView> localVarReturnType = new ParameterizedTypeReference<MasterRateView>() {};
        return showMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Master Rates
     * Retrieve list of master rates
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all master rates owned by this hotel identifier.
     * @param accept The accept parameter
     * @return List&lt;MasterRateView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showMasterRates1RequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showMasterRates1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<MasterRateView> localVarReturnType = new ParameterizedTypeReference<MasterRateView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/roomrate/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Master Rates
     * Retrieve list of master rates
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all master rates owned by this hotel identifier.
     * @param accept The accept parameter
     * @return List&lt;MasterRateView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<MasterRateView> showMasterRates1(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateView> localVarReturnType = new ParameterizedTypeReference<MasterRateView>() {};
        return showMasterRates1RequestCreation(hotelIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<MasterRateView>>> showMasterRates1WithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateView> localVarReturnType = new ParameterizedTypeReference<MasterRateView>() {};
        return showMasterRates1RequestCreation(hotelIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Update Master Rate
     * Update a master rate by its identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing master rate owned by this hotel identifier.
     * @param masterRateIdentifier Update existing master rate with this identifier.
     * @param updateMasterRateRequest The updateMasterRateRequest parameter
     * @return MasterRateView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateMasterRateRequestCreation(String hotelIdentifier, String masterRateIdentifier, UpdateMasterRateRequest updateMasterRateRequest) throws WebClientResponseException {
        Object postBody = updateMasterRateRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling updateMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updateMasterRateRequest' is set
        if (updateMasterRateRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateMasterRateRequest' when calling updateMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<MasterRateView> localVarReturnType = new ParameterizedTypeReference<MasterRateView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/roomrate/{masterRateIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Master Rate
     * Update a master rate by its identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing master rate owned by this hotel identifier.
     * @param masterRateIdentifier Update existing master rate with this identifier.
     * @param updateMasterRateRequest The updateMasterRateRequest parameter
     * @return MasterRateView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MasterRateView> updateMasterRate(String hotelIdentifier, String masterRateIdentifier, UpdateMasterRateRequest updateMasterRateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateView> localVarReturnType = new ParameterizedTypeReference<MasterRateView>() {};
        return updateMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, updateMasterRateRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<MasterRateView>> updateMasterRateWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, UpdateMasterRateRequest updateMasterRateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateView> localVarReturnType = new ParameterizedTypeReference<MasterRateView>() {};
        return updateMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, updateMasterRateRequest).toEntity(localVarReturnType);
    }
}
