package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.HotelContacts;
import travel.wink.sdk.extranet.model.ShowHotelStatus400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-28T12:37:26.819025+07:00[Asia/Bangkok]")
public class ContactsApi {
    private ApiClient apiClient;

    public ContactsApi() {
        this(new ApiClient());
    }

    @Autowired
    public ContactsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Update contacts
     * Manage important property contacts via this endpoint. Update legal signer, reservation and accounting contacts.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update important contacts for this hotel identifier
     * @param hotelContacts The hotelContacts parameter
     * @return HotelContacts
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateContactsRequestCreation(String hotelIdentifier, HotelContacts hotelContacts) throws WebClientResponseException {
        Object postBody = hotelContacts;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateContacts", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'hotelContacts' is set
        if (hotelContacts == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelContacts' when calling updateContacts", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<HotelContacts> localVarReturnType = new ParameterizedTypeReference<HotelContacts>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/contacts", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update contacts
     * Manage important property contacts via this endpoint. Update legal signer, reservation and accounting contacts.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update important contacts for this hotel identifier
     * @param hotelContacts The hotelContacts parameter
     * @return HotelContacts
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelContacts> updateContacts(String hotelIdentifier, HotelContacts hotelContacts) throws WebClientResponseException {
        ParameterizedTypeReference<HotelContacts> localVarReturnType = new ParameterizedTypeReference<HotelContacts>() {};
        return updateContactsRequestCreation(hotelIdentifier, hotelContacts).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<HotelContacts>> updateContactsWithHttpInfo(String hotelIdentifier, HotelContacts hotelContacts) throws WebClientResponseException {
        ParameterizedTypeReference<HotelContacts> localVarReturnType = new ParameterizedTypeReference<HotelContacts>() {};
        return updateContactsRequestCreation(hotelIdentifier, hotelContacts).toEntity(localVarReturnType);
    }
}
