/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 19.0.14-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.extranet.model.DescriptiveReason;
import travel.wink.sdk.extranet.model.DescriptiveRoomTypeWithPriceConfigurations;
import travel.wink.sdk.extranet.model.Inventory;
import travel.wink.sdk.extranet.model.MasterRate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * DescriptiveRoom
 */
@JsonPropertyOrder({
  DescriptiveRoom.JSON_PROPERTY_IDENTIFIER,
  DescriptiveRoom.JSON_PROPERTY_ROOM_NAME,
  DescriptiveRoom.JSON_PROPERTY_ACCESSIBLE_MASTER_RATES,
  DescriptiveRoom.JSON_PROPERTY_INACCESSIBLE_MASTER_RATES,
  DescriptiveRoom.JSON_PROPERTY_ACCESSIBLE_INVENTORY,
  DescriptiveRoom.JSON_PROPERTY_ACCESSIBLE_RATE_PLANS,
  DescriptiveRoom.JSON_PROPERTY_INACCESSIBLE_RATE_PLANS,
  DescriptiveRoom.JSON_PROPERTY_ACCESSIBLE_AVAILABILITY,
  DescriptiveRoom.JSON_PROPERTY_INACCESSIBLE_AVAILABILITY
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-28T12:37:26.819025+07:00[Asia/Bangkok]")
public class DescriptiveRoom {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_ROOM_NAME = "roomName";
  private String roomName;

  public static final String JSON_PROPERTY_ACCESSIBLE_MASTER_RATES = "accessibleMasterRates";
  private List<MasterRate> accessibleMasterRates = null;

  public static final String JSON_PROPERTY_INACCESSIBLE_MASTER_RATES = "inaccessibleMasterRates";
  private List<DescriptiveReason> inaccessibleMasterRates = null;

  public static final String JSON_PROPERTY_ACCESSIBLE_INVENTORY = "accessibleInventory";
  private List<Inventory> accessibleInventory = null;

  public static final String JSON_PROPERTY_ACCESSIBLE_RATE_PLANS = "accessibleRatePlans";
  private List<DescriptiveReason> accessibleRatePlans = null;

  public static final String JSON_PROPERTY_INACCESSIBLE_RATE_PLANS = "inaccessibleRatePlans";
  private List<DescriptiveReason> inaccessibleRatePlans = null;

  public static final String JSON_PROPERTY_ACCESSIBLE_AVAILABILITY = "accessibleAvailability";
  private List<DescriptiveRoomTypeWithPriceConfigurations> accessibleAvailability = null;

  public static final String JSON_PROPERTY_INACCESSIBLE_AVAILABILITY = "inaccessibleAvailability";
  private List<DescriptiveReason> inaccessibleAvailability = null;

  public DescriptiveRoom() { 
  }

  public DescriptiveRoom identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Get identifier
   * @return identifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public DescriptiveRoom roomName(String roomName) {
    
    this.roomName = roomName;
    return this;
  }

   /**
   * Get roomName
   * @return roomName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ROOM_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoomName() {
    return roomName;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomName(String roomName) {
    this.roomName = roomName;
  }


  public DescriptiveRoom accessibleMasterRates(List<MasterRate> accessibleMasterRates) {
    
    this.accessibleMasterRates = accessibleMasterRates;
    return this;
  }

  public DescriptiveRoom addAccessibleMasterRatesItem(MasterRate accessibleMasterRatesItem) {
    if (this.accessibleMasterRates == null) {
      this.accessibleMasterRates = new ArrayList<>();
    }
    this.accessibleMasterRates.add(accessibleMasterRatesItem);
    return this;
  }

   /**
   * Get accessibleMasterRates
   * @return accessibleMasterRates
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACCESSIBLE_MASTER_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<MasterRate> getAccessibleMasterRates() {
    return accessibleMasterRates;
  }


  @JsonProperty(JSON_PROPERTY_ACCESSIBLE_MASTER_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccessibleMasterRates(List<MasterRate> accessibleMasterRates) {
    this.accessibleMasterRates = accessibleMasterRates;
  }


  public DescriptiveRoom inaccessibleMasterRates(List<DescriptiveReason> inaccessibleMasterRates) {
    
    this.inaccessibleMasterRates = inaccessibleMasterRates;
    return this;
  }

  public DescriptiveRoom addInaccessibleMasterRatesItem(DescriptiveReason inaccessibleMasterRatesItem) {
    if (this.inaccessibleMasterRates == null) {
      this.inaccessibleMasterRates = new ArrayList<>();
    }
    this.inaccessibleMasterRates.add(inaccessibleMasterRatesItem);
    return this;
  }

   /**
   * Get inaccessibleMasterRates
   * @return inaccessibleMasterRates
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INACCESSIBLE_MASTER_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DescriptiveReason> getInaccessibleMasterRates() {
    return inaccessibleMasterRates;
  }


  @JsonProperty(JSON_PROPERTY_INACCESSIBLE_MASTER_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInaccessibleMasterRates(List<DescriptiveReason> inaccessibleMasterRates) {
    this.inaccessibleMasterRates = inaccessibleMasterRates;
  }


  public DescriptiveRoom accessibleInventory(List<Inventory> accessibleInventory) {
    
    this.accessibleInventory = accessibleInventory;
    return this;
  }

  public DescriptiveRoom addAccessibleInventoryItem(Inventory accessibleInventoryItem) {
    if (this.accessibleInventory == null) {
      this.accessibleInventory = new ArrayList<>();
    }
    this.accessibleInventory.add(accessibleInventoryItem);
    return this;
  }

   /**
   * Get accessibleInventory
   * @return accessibleInventory
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACCESSIBLE_INVENTORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Inventory> getAccessibleInventory() {
    return accessibleInventory;
  }


  @JsonProperty(JSON_PROPERTY_ACCESSIBLE_INVENTORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccessibleInventory(List<Inventory> accessibleInventory) {
    this.accessibleInventory = accessibleInventory;
  }


  public DescriptiveRoom accessibleRatePlans(List<DescriptiveReason> accessibleRatePlans) {
    
    this.accessibleRatePlans = accessibleRatePlans;
    return this;
  }

  public DescriptiveRoom addAccessibleRatePlansItem(DescriptiveReason accessibleRatePlansItem) {
    if (this.accessibleRatePlans == null) {
      this.accessibleRatePlans = new ArrayList<>();
    }
    this.accessibleRatePlans.add(accessibleRatePlansItem);
    return this;
  }

   /**
   * Get accessibleRatePlans
   * @return accessibleRatePlans
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACCESSIBLE_RATE_PLANS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DescriptiveReason> getAccessibleRatePlans() {
    return accessibleRatePlans;
  }


  @JsonProperty(JSON_PROPERTY_ACCESSIBLE_RATE_PLANS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccessibleRatePlans(List<DescriptiveReason> accessibleRatePlans) {
    this.accessibleRatePlans = accessibleRatePlans;
  }


  public DescriptiveRoom inaccessibleRatePlans(List<DescriptiveReason> inaccessibleRatePlans) {
    
    this.inaccessibleRatePlans = inaccessibleRatePlans;
    return this;
  }

  public DescriptiveRoom addInaccessibleRatePlansItem(DescriptiveReason inaccessibleRatePlansItem) {
    if (this.inaccessibleRatePlans == null) {
      this.inaccessibleRatePlans = new ArrayList<>();
    }
    this.inaccessibleRatePlans.add(inaccessibleRatePlansItem);
    return this;
  }

   /**
   * Get inaccessibleRatePlans
   * @return inaccessibleRatePlans
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INACCESSIBLE_RATE_PLANS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DescriptiveReason> getInaccessibleRatePlans() {
    return inaccessibleRatePlans;
  }


  @JsonProperty(JSON_PROPERTY_INACCESSIBLE_RATE_PLANS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInaccessibleRatePlans(List<DescriptiveReason> inaccessibleRatePlans) {
    this.inaccessibleRatePlans = inaccessibleRatePlans;
  }


  public DescriptiveRoom accessibleAvailability(List<DescriptiveRoomTypeWithPriceConfigurations> accessibleAvailability) {
    
    this.accessibleAvailability = accessibleAvailability;
    return this;
  }

  public DescriptiveRoom addAccessibleAvailabilityItem(DescriptiveRoomTypeWithPriceConfigurations accessibleAvailabilityItem) {
    if (this.accessibleAvailability == null) {
      this.accessibleAvailability = new ArrayList<>();
    }
    this.accessibleAvailability.add(accessibleAvailabilityItem);
    return this;
  }

   /**
   * Get accessibleAvailability
   * @return accessibleAvailability
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACCESSIBLE_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DescriptiveRoomTypeWithPriceConfigurations> getAccessibleAvailability() {
    return accessibleAvailability;
  }


  @JsonProperty(JSON_PROPERTY_ACCESSIBLE_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccessibleAvailability(List<DescriptiveRoomTypeWithPriceConfigurations> accessibleAvailability) {
    this.accessibleAvailability = accessibleAvailability;
  }


  public DescriptiveRoom inaccessibleAvailability(List<DescriptiveReason> inaccessibleAvailability) {
    
    this.inaccessibleAvailability = inaccessibleAvailability;
    return this;
  }

  public DescriptiveRoom addInaccessibleAvailabilityItem(DescriptiveReason inaccessibleAvailabilityItem) {
    if (this.inaccessibleAvailability == null) {
      this.inaccessibleAvailability = new ArrayList<>();
    }
    this.inaccessibleAvailability.add(inaccessibleAvailabilityItem);
    return this;
  }

   /**
   * Get inaccessibleAvailability
   * @return inaccessibleAvailability
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INACCESSIBLE_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DescriptiveReason> getInaccessibleAvailability() {
    return inaccessibleAvailability;
  }


  @JsonProperty(JSON_PROPERTY_INACCESSIBLE_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInaccessibleAvailability(List<DescriptiveReason> inaccessibleAvailability) {
    this.inaccessibleAvailability = inaccessibleAvailability;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DescriptiveRoom descriptiveRoom = (DescriptiveRoom) o;
    return Objects.equals(this.identifier, descriptiveRoom.identifier) &&
        Objects.equals(this.roomName, descriptiveRoom.roomName) &&
        Objects.equals(this.accessibleMasterRates, descriptiveRoom.accessibleMasterRates) &&
        Objects.equals(this.inaccessibleMasterRates, descriptiveRoom.inaccessibleMasterRates) &&
        Objects.equals(this.accessibleInventory, descriptiveRoom.accessibleInventory) &&
        Objects.equals(this.accessibleRatePlans, descriptiveRoom.accessibleRatePlans) &&
        Objects.equals(this.inaccessibleRatePlans, descriptiveRoom.inaccessibleRatePlans) &&
        Objects.equals(this.accessibleAvailability, descriptiveRoom.accessibleAvailability) &&
        Objects.equals(this.inaccessibleAvailability, descriptiveRoom.inaccessibleAvailability);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, roomName, accessibleMasterRates, inaccessibleMasterRates, accessibleInventory, accessibleRatePlans, inaccessibleRatePlans, accessibleAvailability, inaccessibleAvailability);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DescriptiveRoom {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    roomName: ").append(toIndentedString(roomName)).append("\n");
    sb.append("    accessibleMasterRates: ").append(toIndentedString(accessibleMasterRates)).append("\n");
    sb.append("    inaccessibleMasterRates: ").append(toIndentedString(inaccessibleMasterRates)).append("\n");
    sb.append("    accessibleInventory: ").append(toIndentedString(accessibleInventory)).append("\n");
    sb.append("    accessibleRatePlans: ").append(toIndentedString(accessibleRatePlans)).append("\n");
    sb.append("    inaccessibleRatePlans: ").append(toIndentedString(inaccessibleRatePlans)).append("\n");
    sb.append("    accessibleAvailability: ").append(toIndentedString(accessibleAvailability)).append("\n");
    sb.append("    inaccessibleAvailability: ").append(toIndentedString(inaccessibleAvailability)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

