/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 19.0.14-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.extranet.model.ContactDto;
import travel.wink.sdk.extranet.model.GeoName;
import travel.wink.sdk.extranet.model.HotelOnMapLocation;
import travel.wink.sdk.extranet.model.Multimedia;
import travel.wink.sdk.extranet.model.PropertyPolicy;
import travel.wink.sdk.extranet.model.Recognition;
import travel.wink.sdk.extranet.model.SimpleDescription;
import travel.wink.sdk.extranet.model.Social;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Combined property data.
 */
@ApiModel(description = "Combined property data.")
@JsonPropertyOrder({
  HotelOnMap.JSON_PROPERTY_IDENTIFIER,
  HotelOnMap.JSON_PROPERTY_HOTEL_IDENTIFIER,
  HotelOnMap.JSON_PROPERTY_NAME,
  HotelOnMap.JSON_PROPERTY_LOCAL_NAME,
  HotelOnMap.JSON_PROPERTY_CHAIN,
  HotelOnMap.JSON_PROPERTY_BRAND,
  HotelOnMap.JSON_PROPERTY_URL_NAME,
  HotelOnMap.JSON_PROPERTY_STAR_RATING,
  HotelOnMap.JSON_PROPERTY_BOOKINGS,
  HotelOnMap.JSON_PROPERTY_AGGREGATE_REVIEW_RATING,
  HotelOnMap.JSON_PROPERTY_LOCATION,
  HotelOnMap.JSON_PROPERTY_SHORT_DESCRIPTIONS,
  HotelOnMap.JSON_PROPERTY_LONG_DESCRIPTIONS,
  HotelOnMap.JSON_PROPERTY_AGGREGATE_GREENDEX_RATING,
  HotelOnMap.JSON_PROPERTY_LIFESTYLE_TYPES,
  HotelOnMap.JSON_PROPERTY_TOTAL_REVIEWS,
  HotelOnMap.JSON_PROPERTY_AVAILABLE,
  HotelOnMap.JSON_PROPERTY_HOTEL_AVAILABLE,
  HotelOnMap.JSON_PROPERTY_RESERVATIONS,
  HotelOnMap.JSON_PROPERTY_SOCIALS,
  HotelOnMap.JSON_PROPERTY_IMAGES,
  HotelOnMap.JSON_PROPERTY_VIDEOS,
  HotelOnMap.JSON_PROPERTY_POLICY,
  HotelOnMap.JSON_PROPERTY_THIRD_PARTY_REVIEWS,
  HotelOnMap.JSON_PROPERTY_ATTRACTIONS,
  HotelOnMap.JSON_PROPERTY_RECREATIONS,
  HotelOnMap.JSON_PROPERTY_POIS,
  HotelOnMap.JSON_PROPERTY_RESTAURANTS,
  HotelOnMap.JSON_PROPERTY_MEETING_ROOMS,
  HotelOnMap.JSON_PROPERTY_SPAS,
  HotelOnMap.JSON_PROPERTY_BUNDLES,
  HotelOnMap.JSON_PROPERTY_UPGRADES,
  HotelOnMap.JSON_PROPERTY_FULL_NAME_OF_GENERAL_MANAGER,
  HotelOnMap.JSON_PROPERTY_PROFILE_PICTURE_IDENTIFIER_GENERAL_MANAGER,
  HotelOnMap.JSON_PROPERTY_MESSAGES_OF_GENERAL_MANAGER,
  HotelOnMap.JSON_PROPERTY_LOCATION_CATEGORY,
  HotelOnMap.JSON_PROPERTY_SEGMENT_CATEGORY,
  HotelOnMap.JSON_PROPERTY_HOTEL_CATEGORY,
  HotelOnMap.JSON_PROPERTY_ARCHITECTURAL_STYLE,
  HotelOnMap.JSON_PROPERTY_WHEN_BUILT,
  HotelOnMap.JSON_PROPERTY_MULTIMEDIA_IDENTIFIER,
  HotelOnMap.JSON_PROPERTY_IMAGE_IDENTIFIER,
  HotelOnMap.JSON_PROPERTY_IMAGE_ANGLE,
  HotelOnMap.JSON_PROPERTY_VIDEO_IDENTIFIER,
  HotelOnMap.JSON_PROPERTY_CURRENCY_CODE,
  HotelOnMap.JSON_PROPERTY_MEMBERSHIP_RATE_DISCOUNT,
  HotelOnMap.JSON_PROPERTY_PRICE_SCORE,
  HotelOnMap.JSON_PROPERTY_PERK_SCORE,
  HotelOnMap.JSON_PROPERTY_PACKAGE_SCORE,
  HotelOnMap.JSON_PROPERTY_LOYALTY_SCORE,
  HotelOnMap.JSON_PROPERTY_POPULAR_SCORE,
  HotelOnMap.JSON_PROPERTY_EXPERIENCE_SCORE,
  HotelOnMap.JSON_PROPERTY_AVAILABILITY_SCORE,
  HotelOnMap.JSON_PROPERTY_VIEWS,
  HotelOnMap.JSON_PROPERTY_ADDRESS1,
  HotelOnMap.JSON_PROPERTY_ADDRESS2,
  HotelOnMap.JSON_PROPERTY_POSTAL_CODE,
  HotelOnMap.JSON_PROPERTY_STATE,
  HotelOnMap.JSON_PROPERTY_CITY,
  HotelOnMap.JSON_PROPERTY_HOTEL_AMENITY_CODES,
  HotelOnMap.JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES,
  HotelOnMap.JSON_PROPERTY_PROPERTY_SECURITY_CODES,
  HotelOnMap.JSON_PROPERTY_NUMBER_OF_ROOMS,
  HotelOnMap.JSON_PROPERTY_ACTIVE,
  HotelOnMap.JSON_PROPERTY_URL_PARAMETERS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-28T12:37:26.819025+07:00[Asia/Bangkok]")
public class HotelOnMap {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private String hotelIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_LOCAL_NAME = "localName";
  private String localName;

  public static final String JSON_PROPERTY_CHAIN = "chain";
  private String chain;

  public static final String JSON_PROPERTY_BRAND = "brand";
  private String brand;

  public static final String JSON_PROPERTY_URL_NAME = "urlName";
  private String urlName;

  public static final String JSON_PROPERTY_STAR_RATING = "starRating";
  private Integer starRating;

  public static final String JSON_PROPERTY_BOOKINGS = "bookings";
  private Long bookings = 0l;

  public static final String JSON_PROPERTY_AGGREGATE_REVIEW_RATING = "aggregateReviewRating";
  private Float aggregateReviewRating = 0.0f;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private HotelOnMapLocation location;

  public static final String JSON_PROPERTY_SHORT_DESCRIPTIONS = "shortDescriptions";
  private List<SimpleDescription> shortDescriptions = null;

  public static final String JSON_PROPERTY_LONG_DESCRIPTIONS = "longDescriptions";
  private List<SimpleDescription> longDescriptions = null;

  public static final String JSON_PROPERTY_AGGREGATE_GREENDEX_RATING = "aggregateGreendexRating";
  private Float aggregateGreendexRating = 0.0f;

  /**
   * A list of lifestyles the property associates with.
   */
  public enum LifestyleTypesEnum {
    HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
    
    RELAX("LIFESTYLE_RELAX"),
    
    ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
    
    ADVENTURE("LIFESTYLE_ADVENTURE"),
    
    BUSINESS("LIFESTYLE_BUSINESS"),
    
    LGBT("LIFESTYLE_LGBT"),
    
    SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
    
    SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
    
    BEAUTY("LIFESTYLE_BEAUTY"),
    
    FOODIE("LIFESTYLE_FOODIE"),
    
    FAMILY("LIFESTYLE_FAMILY"),
    
    ROMANCE("LIFESTYLE_ROMANCE"),
    
    COUPLE("LIFESTYLE_COUPLE"),
    
    SOLO("LIFESTYLE_SOLO"),
    
    BACKPACKER("LIFESTYLE_BACKPACKER"),
    
    SHOPPING("LIFESTYLE_SHOPPING"),
    
    SPORTS("LIFESTYLE_SPORTS"),
    
    MOUNTAIN("LIFESTYLE_MOUNTAIN"),
    
    BEACH("LIFESTYLE_BEACH"),
    
    CITY("LIFESTYLE_CITY"),
    
    COUNTRY("LIFESTYLE_COUNTRY"),
    
    CULTURE("LIFESTYLE_CULTURE"),
    
    ECO("LIFESTYLE_ECO");

    private String value;

    LifestyleTypesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleTypesEnum fromValue(String value) {
      for (LifestyleTypesEnum b : LifestyleTypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE_TYPES = "lifestyleTypes";
  private List<LifestyleTypesEnum> lifestyleTypes = null;

  public static final String JSON_PROPERTY_TOTAL_REVIEWS = "totalReviews";
  private Integer totalReviews = 0;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Boolean available = false;

  public static final String JSON_PROPERTY_HOTEL_AVAILABLE = "hotelAvailable";
  private Boolean hotelAvailable = false;

  public static final String JSON_PROPERTY_RESERVATIONS = "reservations";
  private ContactDto reservations;

  public static final String JSON_PROPERTY_SOCIALS = "socials";
  private List<Social> socials = null;

  public static final String JSON_PROPERTY_IMAGES = "images";
  private List<Multimedia> images = null;

  public static final String JSON_PROPERTY_VIDEOS = "videos";
  private List<Multimedia> videos = null;

  public static final String JSON_PROPERTY_POLICY = "policy";
  private PropertyPolicy policy;

  public static final String JSON_PROPERTY_THIRD_PARTY_REVIEWS = "thirdPartyReviews";
  private List<Recognition> thirdPartyReviews = null;

  public static final String JSON_PROPERTY_ATTRACTIONS = "attractions";
  private Integer attractions = 0;

  public static final String JSON_PROPERTY_RECREATIONS = "recreations";
  private Integer recreations = 0;

  public static final String JSON_PROPERTY_POIS = "pois";
  private Integer pois = 0;

  public static final String JSON_PROPERTY_RESTAURANTS = "restaurants";
  private Integer restaurants = 0;

  public static final String JSON_PROPERTY_MEETING_ROOMS = "meetingRooms";
  private Integer meetingRooms = 0;

  public static final String JSON_PROPERTY_SPAS = "spas";
  private Integer spas = 0;

  public static final String JSON_PROPERTY_BUNDLES = "bundles";
  private Integer bundles = 0;

  public static final String JSON_PROPERTY_UPGRADES = "upgrades";
  private Integer upgrades = 0;

  public static final String JSON_PROPERTY_FULL_NAME_OF_GENERAL_MANAGER = "fullNameOfGeneralManager";
  private String fullNameOfGeneralManager;

  public static final String JSON_PROPERTY_PROFILE_PICTURE_IDENTIFIER_GENERAL_MANAGER = "profilePictureIdentifierGeneralManager";
  private String profilePictureIdentifierGeneralManager;

  public static final String JSON_PROPERTY_MESSAGES_OF_GENERAL_MANAGER = "messagesOfGeneralManager";
  private List<SimpleDescription> messagesOfGeneralManager = null;

  public static final String JSON_PROPERTY_LOCATION_CATEGORY = "locationCategory";
  private String locationCategory;

  public static final String JSON_PROPERTY_SEGMENT_CATEGORY = "segmentCategory";
  private String segmentCategory;

  public static final String JSON_PROPERTY_HOTEL_CATEGORY = "hotelCategory";
  private String hotelCategory;

  public static final String JSON_PROPERTY_ARCHITECTURAL_STYLE = "architecturalStyle";
  private String architecturalStyle;

  public static final String JSON_PROPERTY_WHEN_BUILT = "whenBuilt";
  private String whenBuilt;

  public static final String JSON_PROPERTY_MULTIMEDIA_IDENTIFIER = "multimediaIdentifier";
  private String multimediaIdentifier;

  public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
  private String imageIdentifier;

  public static final String JSON_PROPERTY_IMAGE_ANGLE = "imageAngle";
  private String imageAngle;

  public static final String JSON_PROPERTY_VIDEO_IDENTIFIER = "videoIdentifier";
  private String videoIdentifier;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode;

  public static final String JSON_PROPERTY_MEMBERSHIP_RATE_DISCOUNT = "membershipRateDiscount";
  private Float membershipRateDiscount = 0.0f;

  public static final String JSON_PROPERTY_PRICE_SCORE = "priceScore";
  private Integer priceScore = 0;

  public static final String JSON_PROPERTY_PERK_SCORE = "perkScore";
  private Integer perkScore = 0;

  public static final String JSON_PROPERTY_PACKAGE_SCORE = "packageScore";
  private Integer packageScore = 0;

  public static final String JSON_PROPERTY_LOYALTY_SCORE = "loyaltyScore";
  private Integer loyaltyScore = 0;

  public static final String JSON_PROPERTY_POPULAR_SCORE = "popularScore";
  private Integer popularScore = 0;

  public static final String JSON_PROPERTY_EXPERIENCE_SCORE = "experienceScore";
  private Integer experienceScore = 0;

  public static final String JSON_PROPERTY_AVAILABILITY_SCORE = "availabilityScore";
  private Integer availabilityScore = 0;

  public static final String JSON_PROPERTY_VIEWS = "views";
  private Long views = 0l;

  public static final String JSON_PROPERTY_ADDRESS1 = "address1";
  private String address1;

  public static final String JSON_PROPERTY_ADDRESS2 = "address2";
  private String address2;

  public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
  private String postalCode;

  public static final String JSON_PROPERTY_STATE = "state";
  private String state;

  public static final String JSON_PROPERTY_CITY = "city";
  private GeoName city;

  public static final String JSON_PROPERTY_HOTEL_AMENITY_CODES = "hotelAmenityCodes";
  private List<String> hotelAmenityCodes = null;

  public static final String JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES = "propertyAccessibilityCodes";
  private List<String> propertyAccessibilityCodes = null;

  public static final String JSON_PROPERTY_PROPERTY_SECURITY_CODES = "propertySecurityCodes";
  private List<String> propertySecurityCodes = null;

  public static final String JSON_PROPERTY_NUMBER_OF_ROOMS = "numberOfRooms";
  private Integer numberOfRooms = 0;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active;

  public static final String JSON_PROPERTY_URL_PARAMETERS = "urlParameters";
  private String urlParameters;

  public HotelOnMap() { 
  }

  public HotelOnMap identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier. This is NOT the same as the unique hotel record identifier.
   * @return identifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "document-1", value = "Unique record identifier. This is NOT the same as the unique hotel record identifier.")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public HotelOnMap hotelIdentifier(String hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Unique hotel record identifier.
   * @return hotelIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "hotel-1", value = "Unique hotel record identifier.")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(String hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public HotelOnMap name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Hotel trade name
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "The Loveliest Hotel", value = "Hotel trade name")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public HotelOnMap localName(String localName) {
    
    this.localName = localName;
    return this;
  }

   /**
   * Hotel local name if different from the trade name or if it is the local language.
   * @return localName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Det Beste Hotellet", value = "Hotel local name if different from the trade name or if it is the local language.")
  @JsonProperty(JSON_PROPERTY_LOCAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocalName() {
    return localName;
  }


  @JsonProperty(JSON_PROPERTY_LOCAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocalName(String localName) {
    this.localName = localName;
  }


  public HotelOnMap chain(String chain) {
    
    this.chain = chain;
    return this;
  }

   /**
   * Name of hotel chain if applicable.
   * @return chain
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Hotel chain", value = "Name of hotel chain if applicable.")
  @JsonProperty(JSON_PROPERTY_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getChain() {
    return chain;
  }


  @JsonProperty(JSON_PROPERTY_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChain(String chain) {
    this.chain = chain;
  }


  public HotelOnMap brand(String brand) {
    
    this.brand = brand;
    return this;
  }

   /**
   * Name of hotel brand
   * @return brand
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Hotel brand", value = "Name of hotel brand")
  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBrand() {
    return brand;
  }


  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBrand(String brand) {
    this.brand = brand;
  }


  public HotelOnMap urlName(String urlName) {
    
    this.urlName = urlName;
    return this;
  }

   /**
   * Unique URL-friendly name slug of hotel
   * @return urlName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "the-loveliest-hotel-new-york-united-states", value = "Unique URL-friendly name slug of hotel")
  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrlName() {
    return urlName;
  }


  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrlName(String urlName) {
    this.urlName = urlName;
  }


  public HotelOnMap starRating(Integer starRating) {
    
    this.starRating = starRating;
    return this;
  }

   /**
   * Official or self-designated property star rating. Note that in some regions there are 6-star hotels. They are the same as 5-star hotels everywhere else.
   * minimum: 0
   * maximum: 6
   * @return starRating
  **/
  @javax.annotation.Nullable
 @Min(0) @Max(6)  @ApiModelProperty(example = "4", value = "Official or self-designated property star rating. Note that in some regions there are 6-star hotels. They are the same as 5-star hotels everywhere else.")
  @JsonProperty(JSON_PROPERTY_STAR_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getStarRating() {
    return starRating;
  }


  @JsonProperty(JSON_PROPERTY_STAR_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStarRating(Integer starRating) {
    this.starRating = starRating;
  }


  public HotelOnMap bookings(Long bookings) {
    
    this.bookings = bookings;
    return this;
  }

   /**
   * Number of bookings for this property on the wink.travel payment.
   * @return bookings
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "6054", value = "Number of bookings for this property on the wink.travel payment.")
  @JsonProperty(JSON_PROPERTY_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getBookings() {
    return bookings;
  }


  @JsonProperty(JSON_PROPERTY_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookings(Long bookings) {
    this.bookings = bookings;
  }


  public HotelOnMap aggregateReviewRating(Float aggregateReviewRating) {
    
    this.aggregateReviewRating = aggregateReviewRating;
    return this;
  }

   /**
   * Aggregate score based on all current user reviews.
   * @return aggregateReviewRating
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "7.8", value = "Aggregate score based on all current user reviews.")
  @JsonProperty(JSON_PROPERTY_AGGREGATE_REVIEW_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getAggregateReviewRating() {
    return aggregateReviewRating;
  }


  @JsonProperty(JSON_PROPERTY_AGGREGATE_REVIEW_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAggregateReviewRating(Float aggregateReviewRating) {
    this.aggregateReviewRating = aggregateReviewRating;
  }


  public HotelOnMap location(HotelOnMapLocation location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public HotelOnMapLocation getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocation(HotelOnMapLocation location) {
    this.location = location;
  }


  public HotelOnMap shortDescriptions(List<SimpleDescription> shortDescriptions) {
    
    this.shortDescriptions = shortDescriptions;
    return this;
  }

  public HotelOnMap addShortDescriptionsItem(SimpleDescription shortDescriptionsItem) {
    if (this.shortDescriptions == null) {
      this.shortDescriptions = new ArrayList<>();
    }
    this.shortDescriptions.add(shortDescriptionsItem);
    return this;
  }

   /**
   * A localized list of short property descriptions
   * @return shortDescriptions
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "A localized list of short property descriptions")
  @JsonProperty(JSON_PROPERTY_SHORT_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleDescription> getShortDescriptions() {
    return shortDescriptions;
  }


  @JsonProperty(JSON_PROPERTY_SHORT_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShortDescriptions(List<SimpleDescription> shortDescriptions) {
    this.shortDescriptions = shortDescriptions;
  }


  public HotelOnMap longDescriptions(List<SimpleDescription> longDescriptions) {
    
    this.longDescriptions = longDescriptions;
    return this;
  }

  public HotelOnMap addLongDescriptionsItem(SimpleDescription longDescriptionsItem) {
    if (this.longDescriptions == null) {
      this.longDescriptions = new ArrayList<>();
    }
    this.longDescriptions.add(longDescriptionsItem);
    return this;
  }

   /**
   * A localized list of longer property descriptions
   * @return longDescriptions
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "A localized list of longer property descriptions")
  @JsonProperty(JSON_PROPERTY_LONG_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleDescription> getLongDescriptions() {
    return longDescriptions;
  }


  @JsonProperty(JSON_PROPERTY_LONG_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLongDescriptions(List<SimpleDescription> longDescriptions) {
    this.longDescriptions = longDescriptions;
  }


  public HotelOnMap aggregateGreendexRating(Float aggregateGreendexRating) {
    
    this.aggregateGreendexRating = aggregateGreendexRating;
    return this;
  }

   /**
   * Aggregate Green Index score if the property has answered our questionnaire available in the Extranet.
   * @return aggregateGreendexRating
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "7.0", value = "Aggregate Green Index score if the property has answered our questionnaire available in the Extranet.")
  @JsonProperty(JSON_PROPERTY_AGGREGATE_GREENDEX_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getAggregateGreendexRating() {
    return aggregateGreendexRating;
  }


  @JsonProperty(JSON_PROPERTY_AGGREGATE_GREENDEX_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAggregateGreendexRating(Float aggregateGreendexRating) {
    this.aggregateGreendexRating = aggregateGreendexRating;
  }


  public HotelOnMap lifestyleTypes(List<LifestyleTypesEnum> lifestyleTypes) {
    
    this.lifestyleTypes = lifestyleTypes;
    return this;
  }

  public HotelOnMap addLifestyleTypesItem(LifestyleTypesEnum lifestyleTypesItem) {
    if (this.lifestyleTypes == null) {
      this.lifestyleTypes = new ArrayList<>();
    }
    this.lifestyleTypes.add(lifestyleTypesItem);
    return this;
  }

   /**
   * A list of lifestyles the property associates with.
   * @return lifestyleTypes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"LIFESTYLE_HEALTH_FITNESS\",\"LIFESTYLE_RELAX\"]", value = "A list of lifestyles the property associates with.")
  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LifestyleTypesEnum> getLifestyleTypes() {
    return lifestyleTypes;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyleTypes(List<LifestyleTypesEnum> lifestyleTypes) {
    this.lifestyleTypes = lifestyleTypes;
  }


  public HotelOnMap totalReviews(Integer totalReviews) {
    
    this.totalReviews = totalReviews;
    return this;
  }

   /**
   * Count of total reviews left by users at this property.
   * @return totalReviews
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "989", value = "Count of total reviews left by users at this property.")
  @JsonProperty(JSON_PROPERTY_TOTAL_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTotalReviews() {
    return totalReviews;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalReviews(Integer totalReviews) {
    this.totalReviews = totalReviews;
  }


  public HotelOnMap available(Boolean available) {
    
    this.available = available;
    return this;
  }

   /**
   * Flag indicating whether the payment has made this property available for sale.
   * @return available
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Flag indicating whether the payment has made this property available for sale.")
  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(Boolean available) {
    this.available = available;
  }


  public HotelOnMap hotelAvailable(Boolean hotelAvailable) {
    
    this.hotelAvailable = hotelAvailable;
    return this;
  }

   /**
   * Flag indicating whether the property has made this property available for sale.
   * @return hotelAvailable
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Flag indicating whether the property has made this property available for sale.")
  @JsonProperty(JSON_PROPERTY_HOTEL_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHotelAvailable() {
    return hotelAvailable;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelAvailable(Boolean hotelAvailable) {
    this.hotelAvailable = hotelAvailable;
  }


  public HotelOnMap reservations(ContactDto reservations) {
    
    this.reservations = reservations;
    return this;
  }

   /**
   * Get reservations
   * @return reservations
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RESERVATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ContactDto getReservations() {
    return reservations;
  }


  @JsonProperty(JSON_PROPERTY_RESERVATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReservations(ContactDto reservations) {
    this.reservations = reservations;
  }


  public HotelOnMap socials(List<Social> socials) {
    
    this.socials = socials;
    return this;
  }

  public HotelOnMap addSocialsItem(Social socialsItem) {
    if (this.socials == null) {
      this.socials = new ArrayList<>();
    }
    this.socials.add(socialsItem);
    return this;
  }

   /**
   * Property&#39;s social network accounts
   * @return socials
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Property's social network accounts")
  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Social> getSocials() {
    return socials;
  }


  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocials(List<Social> socials) {
    this.socials = socials;
  }


  public HotelOnMap images(List<Multimedia> images) {
    
    this.images = images;
    return this;
  }

  public HotelOnMap addImagesItem(Multimedia imagesItem) {
    if (this.images == null) {
      this.images = new ArrayList<>();
    }
    this.images.add(imagesItem);
    return this;
  }

   /**
   * Property images.
   * @return images
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Property images.")
  @JsonProperty(JSON_PROPERTY_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Multimedia> getImages() {
    return images;
  }


  @JsonProperty(JSON_PROPERTY_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImages(List<Multimedia> images) {
    this.images = images;
  }


  public HotelOnMap videos(List<Multimedia> videos) {
    
    this.videos = videos;
    return this;
  }

  public HotelOnMap addVideosItem(Multimedia videosItem) {
    if (this.videos == null) {
      this.videos = new ArrayList<>();
    }
    this.videos.add(videosItem);
    return this;
  }

   /**
   * Property videos.
   * @return videos
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Property videos.")
  @JsonProperty(JSON_PROPERTY_VIDEOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Multimedia> getVideos() {
    return videos;
  }


  @JsonProperty(JSON_PROPERTY_VIDEOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVideos(List<Multimedia> videos) {
    this.videos = videos;
  }


  public HotelOnMap policy(PropertyPolicy policy) {
    
    this.policy = policy;
    return this;
  }

   /**
   * Get policy
   * @return policy
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PropertyPolicy getPolicy() {
    return policy;
  }


  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPolicy(PropertyPolicy policy) {
    this.policy = policy;
  }


  public HotelOnMap thirdPartyReviews(List<Recognition> thirdPartyReviews) {
    
    this.thirdPartyReviews = thirdPartyReviews;
    return this;
  }

  public HotelOnMap addThirdPartyReviewsItem(Recognition thirdPartyReviewsItem) {
    if (this.thirdPartyReviews == null) {
      this.thirdPartyReviews = new ArrayList<>();
    }
    this.thirdPartyReviews.add(thirdPartyReviewsItem);
    return this;
  }

   /**
   * Array of awards and third party reviews given to property by certified / non-certified providers.
   * @return thirdPartyReviews
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Array of awards and third party reviews given to property by certified / non-certified providers.")
  @JsonProperty(JSON_PROPERTY_THIRD_PARTY_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Recognition> getThirdPartyReviews() {
    return thirdPartyReviews;
  }


  @JsonProperty(JSON_PROPERTY_THIRD_PARTY_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThirdPartyReviews(List<Recognition> thirdPartyReviews) {
    this.thirdPartyReviews = thirdPartyReviews;
  }


  public HotelOnMap attractions(Integer attractions) {
    
    this.attractions = attractions;
    return this;
  }

   /**
   * Number of attractions property has listed on its profile.
   * @return attractions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "5", value = "Number of attractions property has listed on its profile.")
  @JsonProperty(JSON_PROPERTY_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAttractions() {
    return attractions;
  }


  @JsonProperty(JSON_PROPERTY_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttractions(Integer attractions) {
    this.attractions = attractions;
  }


  public HotelOnMap recreations(Integer recreations) {
    
    this.recreations = recreations;
    return this;
  }

   /**
   * Number of activites property has listed on its profile.
   * @return recreations
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "3", value = "Number of activites property has listed on its profile.")
  @JsonProperty(JSON_PROPERTY_RECREATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRecreations() {
    return recreations;
  }


  @JsonProperty(JSON_PROPERTY_RECREATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecreations(Integer recreations) {
    this.recreations = recreations;
  }


  public HotelOnMap pois(Integer pois) {
    
    this.pois = pois;
    return this;
  }

   /**
   * Number of places property has listed on its profile.
   * @return pois
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "9", value = "Number of places property has listed on its profile.")
  @JsonProperty(JSON_PROPERTY_POIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPois() {
    return pois;
  }


  @JsonProperty(JSON_PROPERTY_POIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPois(Integer pois) {
    this.pois = pois;
  }


  public HotelOnMap restaurants(Integer restaurants) {
    
    this.restaurants = restaurants;
    return this;
  }

   /**
   * Number of restaurants property has on its profile.
   * @return restaurants
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2", value = "Number of restaurants property has on its profile.")
  @JsonProperty(JSON_PROPERTY_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRestaurants() {
    return restaurants;
  }


  @JsonProperty(JSON_PROPERTY_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRestaurants(Integer restaurants) {
    this.restaurants = restaurants;
  }


  public HotelOnMap meetingRooms(Integer meetingRooms) {
    
    this.meetingRooms = meetingRooms;
    return this;
  }

   /**
   * Number of meeting rooms property has on its profile.
   * @return meetingRooms
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2", value = "Number of meeting rooms property has on its profile.")
  @JsonProperty(JSON_PROPERTY_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMeetingRooms() {
    return meetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeetingRooms(Integer meetingRooms) {
    this.meetingRooms = meetingRooms;
  }


  public HotelOnMap spas(Integer spas) {
    
    this.spas = spas;
    return this;
  }

   /**
   * Number of spas property has on its profile.
   * @return spas
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "Number of spas property has on its profile.")
  @JsonProperty(JSON_PROPERTY_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSpas() {
    return spas;
  }


  @JsonProperty(JSON_PROPERTY_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSpas(Integer spas) {
    this.spas = spas;
  }


  public HotelOnMap bundles(Integer bundles) {
    
    this.bundles = bundles;
    return this;
  }

   /**
   * Number of packages property has on its profile.
   * @return bundles
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "5", value = "Number of packages property has on its profile.")
  @JsonProperty(JSON_PROPERTY_BUNDLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getBundles() {
    return bundles;
  }


  @JsonProperty(JSON_PROPERTY_BUNDLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBundles(Integer bundles) {
    this.bundles = bundles;
  }


  public HotelOnMap upgrades(Integer upgrades) {
    
    this.upgrades = upgrades;
    return this;
  }

   /**
   * Number of add-ons property has on its profile.
   * @return upgrades
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "5", value = "Number of add-ons property has on its profile.")
  @JsonProperty(JSON_PROPERTY_UPGRADES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getUpgrades() {
    return upgrades;
  }


  @JsonProperty(JSON_PROPERTY_UPGRADES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpgrades(Integer upgrades) {
    this.upgrades = upgrades;
  }


  public HotelOnMap fullNameOfGeneralManager(String fullNameOfGeneralManager) {
    
    this.fullNameOfGeneralManager = fullNameOfGeneralManager;
    return this;
  }

   /**
   * Full name of the property&#39;s current and active general manager.
   * @return fullNameOfGeneralManager
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "John Smith", value = "Full name of the property's current and active general manager.")
  @JsonProperty(JSON_PROPERTY_FULL_NAME_OF_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFullNameOfGeneralManager() {
    return fullNameOfGeneralManager;
  }


  @JsonProperty(JSON_PROPERTY_FULL_NAME_OF_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullNameOfGeneralManager(String fullNameOfGeneralManager) {
    this.fullNameOfGeneralManager = fullNameOfGeneralManager;
  }


  public HotelOnMap profilePictureIdentifierGeneralManager(String profilePictureIdentifierGeneralManager) {
    
    this.profilePictureIdentifierGeneralManager = profilePictureIdentifierGeneralManager;
    return this;
  }

   /**
   * Cloudinary identifier referencing image of general manager.
   * @return profilePictureIdentifierGeneralManager
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "cloudinary-identifier-1", value = "Cloudinary identifier referencing image of general manager.")
  @JsonProperty(JSON_PROPERTY_PROFILE_PICTURE_IDENTIFIER_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProfilePictureIdentifierGeneralManager() {
    return profilePictureIdentifierGeneralManager;
  }


  @JsonProperty(JSON_PROPERTY_PROFILE_PICTURE_IDENTIFIER_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProfilePictureIdentifierGeneralManager(String profilePictureIdentifierGeneralManager) {
    this.profilePictureIdentifierGeneralManager = profilePictureIdentifierGeneralManager;
  }


  public HotelOnMap messagesOfGeneralManager(List<SimpleDescription> messagesOfGeneralManager) {
    
    this.messagesOfGeneralManager = messagesOfGeneralManager;
    return this;
  }

  public HotelOnMap addMessagesOfGeneralManagerItem(SimpleDescription messagesOfGeneralManagerItem) {
    if (this.messagesOfGeneralManager == null) {
      this.messagesOfGeneralManager = new ArrayList<>();
    }
    this.messagesOfGeneralManager.add(messagesOfGeneralManagerItem);
    return this;
  }

   /**
   * A list of localized welcome messages created by the property&#39;s general manager.
   * @return messagesOfGeneralManager
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "We are excited to see you on our premises sooner than you can say lickedy split!", value = "A list of localized welcome messages created by the property's general manager.")
  @JsonProperty(JSON_PROPERTY_MESSAGES_OF_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleDescription> getMessagesOfGeneralManager() {
    return messagesOfGeneralManager;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGES_OF_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessagesOfGeneralManager(List<SimpleDescription> messagesOfGeneralManager) {
    this.messagesOfGeneralManager = messagesOfGeneralManager;
  }


  public HotelOnMap locationCategory(String locationCategory) {
    
    this.locationCategory = locationCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;LOC&#x60; code. See [OTA reference data](#operation/showAvailableCodesForCategory)
   * @return locationCategory
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "34", value = "Supported OTA specification `LOC` code. See [OTA reference data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocationCategory() {
    return locationCategory;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocationCategory(String locationCategory) {
    this.locationCategory = locationCategory;
  }


  public HotelOnMap segmentCategory(String segmentCategory) {
    
    this.segmentCategory = segmentCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEG&#x60; code. See [OTA reference data](#operation/showAvailableCodesForCategory)
   * @return segmentCategory
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "7", value = "Supported OTA specification `SEG` code. See [OTA reference data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_SEGMENT_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSegmentCategory() {
    return segmentCategory;
  }


  @JsonProperty(JSON_PROPERTY_SEGMENT_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSegmentCategory(String segmentCategory) {
    this.segmentCategory = segmentCategory;
  }


  public HotelOnMap hotelCategory(String hotelCategory) {
    
    this.hotelCategory = hotelCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;PCT&#x60; code. See [OTA reference data](#operation/showAvailableCodesForCategory)
   * @return hotelCategory
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "45", value = "Supported OTA specification `PCT` code. See [OTA reference data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_HOTEL_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelCategory() {
    return hotelCategory;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelCategory(String hotelCategory) {
    this.hotelCategory = hotelCategory;
  }


  public HotelOnMap architecturalStyle(String architecturalStyle) {
    
    this.architecturalStyle = architecturalStyle;
    return this;
  }

   /**
   * Supported OTA specification &#x60;ARC&#x60; code. See [OTA reference data](#operation/showAvailableCodesForCategory)
   * @return architecturalStyle
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "7", value = "Supported OTA specification `ARC` code. See [OTA reference data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_ARCHITECTURAL_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getArchitecturalStyle() {
    return architecturalStyle;
  }


  @JsonProperty(JSON_PROPERTY_ARCHITECTURAL_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArchitecturalStyle(String architecturalStyle) {
    this.architecturalStyle = architecturalStyle;
  }


  public HotelOnMap whenBuilt(String whenBuilt) {
    
    this.whenBuilt = whenBuilt;
    return this;
  }

   /**
   * Year the property was constructed.
   * @return whenBuilt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1927", value = "Year the property was constructed.")
  @JsonProperty(JSON_PROPERTY_WHEN_BUILT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWhenBuilt() {
    return whenBuilt;
  }


  @JsonProperty(JSON_PROPERTY_WHEN_BUILT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWhenBuilt(String whenBuilt) {
    this.whenBuilt = whenBuilt;
  }


  public HotelOnMap multimediaIdentifier(String multimediaIdentifier) {
    
    this.multimediaIdentifier = multimediaIdentifier;
    return this;
  }

   /**
   * Featured image identifier for this property.
   * @return multimediaIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "media-1", value = "Featured image identifier for this property.")
  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMultimediaIdentifier() {
    return multimediaIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMultimediaIdentifier(String multimediaIdentifier) {
    this.multimediaIdentifier = multimediaIdentifier;
  }


  public HotelOnMap imageIdentifier(String imageIdentifier) {
    
    this.imageIdentifier = imageIdentifier;
    return this;
  }

   /**
   * Featured Cloudinary image identifier for this property.
   * @return imageIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Featured Cloudinary image identifier for this property.")
  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImageIdentifier() {
    return imageIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageIdentifier(String imageIdentifier) {
    this.imageIdentifier = imageIdentifier;
  }


  public HotelOnMap imageAngle(String imageAngle) {
    
    this.imageAngle = imageAngle;
    return this;
  }

   /**
   * Meta data information about image angle that gives integrators a chance to crop this image properly.
   * @return imageAngle
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "-90", value = "Meta data information about image angle that gives integrators a chance to crop this image properly.")
  @JsonProperty(JSON_PROPERTY_IMAGE_ANGLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImageAngle() {
    return imageAngle;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_ANGLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageAngle(String imageAngle) {
    this.imageAngle = imageAngle;
  }


  public HotelOnMap videoIdentifier(String videoIdentifier) {
    
    this.videoIdentifier = videoIdentifier;
    return this;
  }

   /**
   * Featured Cloudinary video identifier for this property.
   * @return videoIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Featured Cloudinary video identifier for this property.")
  @JsonProperty(JSON_PROPERTY_VIDEO_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVideoIdentifier() {
    return videoIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_VIDEO_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVideoIdentifier(String videoIdentifier) {
    this.videoIdentifier = videoIdentifier;
  }


  public HotelOnMap currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Currency code for property.
   * @return currencyCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "USD", value = "Currency code for property.")
  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }


  public HotelOnMap membershipRateDiscount(Float membershipRateDiscount) {
    
    this.membershipRateDiscount = membershipRateDiscount;
    return this;
  }

   /**
   * Average percent member discount weighed across all sales channels.
   * @return membershipRateDiscount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "0.2", value = "Average percent member discount weighed across all sales channels.")
  @JsonProperty(JSON_PROPERTY_MEMBERSHIP_RATE_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getMembershipRateDiscount() {
    return membershipRateDiscount;
  }


  @JsonProperty(JSON_PROPERTY_MEMBERSHIP_RATE_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMembershipRateDiscount(Float membershipRateDiscount) {
    this.membershipRateDiscount = membershipRateDiscount;
  }


  public HotelOnMap priceScore(Integer priceScore) {
    
    this.priceScore = priceScore;
    return this;
  }

   /**
   * A property&#39;s price score is based on calculating historical pricing data. Each property receives a unique score. There is no max score; it&#39;s there to compare it against other properties.
   * @return priceScore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "9", value = "A property's price score is based on calculating historical pricing data. Each property receives a unique score. There is no max score; it's there to compare it against other properties.")
  @JsonProperty(JSON_PROPERTY_PRICE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPriceScore() {
    return priceScore;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPriceScore(Integer priceScore) {
    this.priceScore = priceScore;
  }


  public HotelOnMap perkScore(Integer perkScore) {
    
    this.perkScore = perkScore;
    return this;
  }

   /**
   * A property&#39;s perk score is based on the type of perks that is offered to the guests across all master rates. There is no max score; it&#39;s there to compare it against other properties.
   * @return perkScore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "4", value = "A property's perk score is based on the type of perks that is offered to the guests across all master rates. There is no max score; it's there to compare it against other properties.")
  @JsonProperty(JSON_PROPERTY_PERK_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPerkScore() {
    return perkScore;
  }


  @JsonProperty(JSON_PROPERTY_PERK_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPerkScore(Integer perkScore) {
    this.perkScore = perkScore;
  }


  public HotelOnMap packageScore(Integer packageScore) {
    
    this.packageScore = packageScore;
    return this;
  }

   /**
   * A property&#39;s package score is based on general availability and price for all packages and add-ons offered by the property. There is no max score; it&#39;s there to compare it against other properties.
   * @return packageScore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "4", value = "A property's package score is based on general availability and price for all packages and add-ons offered by the property. There is no max score; it's there to compare it against other properties.")
  @JsonProperty(JSON_PROPERTY_PACKAGE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPackageScore() {
    return packageScore;
  }


  @JsonProperty(JSON_PROPERTY_PACKAGE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPackageScore(Integer packageScore) {
    this.packageScore = packageScore;
  }


  public HotelOnMap loyaltyScore(Integer loyaltyScore) {
    
    this.loyaltyScore = loyaltyScore;
    return this;
  }

   /**
   * A property&#39;s loyalty score is based on calculating how many available rate plans honor loyalty points. There is no max score; it&#39;s there to compare it against other properties.
   * @return loyaltyScore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "5", value = "A property's loyalty score is based on calculating how many available rate plans honor loyalty points. There is no max score; it's there to compare it against other properties.")
  @JsonProperty(JSON_PROPERTY_LOYALTY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getLoyaltyScore() {
    return loyaltyScore;
  }


  @JsonProperty(JSON_PROPERTY_LOYALTY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLoyaltyScore(Integer loyaltyScore) {
    this.loyaltyScore = loyaltyScore;
  }


  public HotelOnMap popularScore(Integer popularScore) {
    
    this.popularScore = popularScore;
    return this;
  }

   /**
   * A property&#39;s popular score is based on calculating number of bookings across room types. There is no max score; it&#39;s there to compare it against other properties.
   * @return popularScore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "45", value = "A property's popular score is based on calculating number of bookings across room types. There is no max score; it's there to compare it against other properties.")
  @JsonProperty(JSON_PROPERTY_POPULAR_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPopularScore() {
    return popularScore;
  }


  @JsonProperty(JSON_PROPERTY_POPULAR_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPopularScore(Integer popularScore) {
    this.popularScore = popularScore;
  }


  public HotelOnMap experienceScore(Integer experienceScore) {
    
    this.experienceScore = experienceScore;
    return this;
  }

   /**
   * A property&#39;s experience score is based on how calculating how many types of experiences are available and at what price ranges. There is no max score; it&#39;s there to compare it against other properties.
   * @return experienceScore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "5", value = "A property's experience score is based on how calculating how many types of experiences are available and at what price ranges. There is no max score; it's there to compare it against other properties.")
  @JsonProperty(JSON_PROPERTY_EXPERIENCE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getExperienceScore() {
    return experienceScore;
  }


  @JsonProperty(JSON_PROPERTY_EXPERIENCE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExperienceScore(Integer experienceScore) {
    this.experienceScore = experienceScore;
  }


  public HotelOnMap availabilityScore(Integer availabilityScore) {
    
    this.availabilityScore = availabilityScore;
    return this;
  }

   /**
   * A property&#39;s availability score is based on general availability of all room types. If most room types are always unavailable, the attractiveness of this property goes down. We use this as our primary benchmark to decide how and when to feature properties. There is no max score; it&#39;s there to compare it against other properties.
   * @return availabilityScore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "5", value = "A property's availability score is based on general availability of all room types. If most room types are always unavailable, the attractiveness of this property goes down. We use this as our primary benchmark to decide how and when to feature properties. There is no max score; it's there to compare it against other properties.")
  @JsonProperty(JSON_PROPERTY_AVAILABILITY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAvailabilityScore() {
    return availabilityScore;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABILITY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailabilityScore(Integer availabilityScore) {
    this.availabilityScore = availabilityScore;
  }


  public HotelOnMap views(Long views) {
    
    this.views = views;
    return this;
  }

   /**
   * Total number of user views of this property.
   * @return views
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "10432", value = "Total number of user views of this property.")
  @JsonProperty(JSON_PROPERTY_VIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getViews() {
    return views;
  }


  @JsonProperty(JSON_PROPERTY_VIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setViews(Long views) {
    this.views = views;
  }


  public HotelOnMap address1(String address1) {
    
    this.address1 = address1;
    return this;
  }

   /**
   * Property physical location address line 1
   * @return address1
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "234 Near da beach", value = "Property physical location address line 1")
  @JsonProperty(JSON_PROPERTY_ADDRESS1)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddress1() {
    return address1;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS1)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress1(String address1) {
    this.address1 = address1;
  }


  public HotelOnMap address2(String address2) {
    
    this.address2 = address2;
    return this;
  }

   /**
   * Second line of property address.
   * @return address2
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Pebble #5001", value = "Second line of property address.")
  @JsonProperty(JSON_PROPERTY_ADDRESS2)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddress2() {
    return address2;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS2)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress2(String address2) {
    this.address2 = address2;
  }


  public HotelOnMap postalCode(String postalCode) {
    
    this.postalCode = postalCode;
    return this;
  }

   /**
   * Postal / zip code
   * @return postalCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "90210", value = "Postal / zip code")
  @JsonProperty(JSON_PROPERTY_POSTAL_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPostalCode() {
    return postalCode;
  }


  @JsonProperty(JSON_PROPERTY_POSTAL_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPostalCode(String postalCode) {
    this.postalCode = postalCode;
  }


  public HotelOnMap state(String state) {
    
    this.state = state;
    return this;
  }

   /**
   * Not all countries have states. Add the state if the property is in a country that contain states.
   * @return state
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "CA", value = "Not all countries have states. Add the state if the property is in a country that contain states.")
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(String state) {
    this.state = state;
  }


  public HotelOnMap city(GeoName city) {
    
    this.city = city;
    return this;
  }

   /**
   * Get city
   * @return city
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoName getCity() {
    return city;
  }


  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCity(GeoName city) {
    this.city = city;
  }


  public HotelOnMap hotelAmenityCodes(List<String> hotelAmenityCodes) {
    
    this.hotelAmenityCodes = hotelAmenityCodes;
    return this;
  }

  public HotelOnMap addHotelAmenityCodesItem(String hotelAmenityCodesItem) {
    if (this.hotelAmenityCodes == null) {
      this.hotelAmenityCodes = new ArrayList<>();
    }
    this.hotelAmenityCodes.add(hotelAmenityCodesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;HAC&#x60; code. See [OTA reference data](#operation/showAvailableCodesForCategory)
   * @return hotelAmenityCodes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"1\",\"7\"]", value = "Supported OTA specification `HAC` code. See [OTA reference data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_HOTEL_AMENITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getHotelAmenityCodes() {
    return hotelAmenityCodes;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_AMENITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelAmenityCodes(List<String> hotelAmenityCodes) {
    this.hotelAmenityCodes = hotelAmenityCodes;
  }


  public HotelOnMap propertyAccessibilityCodes(List<String> propertyAccessibilityCodes) {
    
    this.propertyAccessibilityCodes = propertyAccessibilityCodes;
    return this;
  }

  public HotelOnMap addPropertyAccessibilityCodesItem(String propertyAccessibilityCodesItem) {
    if (this.propertyAccessibilityCodes == null) {
      this.propertyAccessibilityCodes = new ArrayList<>();
    }
    this.propertyAccessibilityCodes.add(propertyAccessibilityCodesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;PHY&#x60; code. See [OTA reference data](#operation/showAvailableCodesForCategory)
   * @return propertyAccessibilityCodes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"1\",\"7\"]", value = "Supported OTA specification `PHY` code. See [OTA reference data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPropertyAccessibilityCodes() {
    return propertyAccessibilityCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyAccessibilityCodes(List<String> propertyAccessibilityCodes) {
    this.propertyAccessibilityCodes = propertyAccessibilityCodes;
  }


  public HotelOnMap propertySecurityCodes(List<String> propertySecurityCodes) {
    
    this.propertySecurityCodes = propertySecurityCodes;
    return this;
  }

  public HotelOnMap addPropertySecurityCodesItem(String propertySecurityCodesItem) {
    if (this.propertySecurityCodes == null) {
      this.propertySecurityCodes = new ArrayList<>();
    }
    this.propertySecurityCodes.add(propertySecurityCodesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEC&#x60; code. See [OTA reference data](#operation/showAvailableCodesForCategory)
   * @return propertySecurityCodes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"1\",\"7\"]", value = "Supported OTA specification `SEC` code. See [OTA reference data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_PROPERTY_SECURITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPropertySecurityCodes() {
    return propertySecurityCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_SECURITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertySecurityCodes(List<String> propertySecurityCodes) {
    this.propertySecurityCodes = propertySecurityCodes;
  }


  public HotelOnMap numberOfRooms(Integer numberOfRooms) {
    
    this.numberOfRooms = numberOfRooms;
    return this;
  }

   /**
   * Number of rooms / keys for this property.
   * @return numberOfRooms
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "32", value = "Number of rooms / keys for this property.")
  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumberOfRooms() {
    return numberOfRooms;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfRooms(Integer numberOfRooms) {
    this.numberOfRooms = numberOfRooms;
  }


  public HotelOnMap active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * A property is considered active when both available and hotelAvailable flags are true.
   * @return active
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "A property is considered active when both available and hotelAvailable flags are true.")
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActive(Boolean active) {
    this.active = active;
  }


  public HotelOnMap urlParameters(String urlParameters) {
    
    this.urlParameters = urlParameters;
    return this;
  }

   /**
   * Convenience data point that creates url friendly query parameters of property.
   * @return urlParameters
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Convenience data point that creates url friendly query parameters of property.")
  @JsonProperty(JSON_PROPERTY_URL_PARAMETERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrlParameters() {
    return urlParameters;
  }


  @JsonProperty(JSON_PROPERTY_URL_PARAMETERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrlParameters(String urlParameters) {
    this.urlParameters = urlParameters;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HotelOnMap hotelOnMap = (HotelOnMap) o;
    return Objects.equals(this.identifier, hotelOnMap.identifier) &&
        Objects.equals(this.hotelIdentifier, hotelOnMap.hotelIdentifier) &&
        Objects.equals(this.name, hotelOnMap.name) &&
        Objects.equals(this.localName, hotelOnMap.localName) &&
        Objects.equals(this.chain, hotelOnMap.chain) &&
        Objects.equals(this.brand, hotelOnMap.brand) &&
        Objects.equals(this.urlName, hotelOnMap.urlName) &&
        Objects.equals(this.starRating, hotelOnMap.starRating) &&
        Objects.equals(this.bookings, hotelOnMap.bookings) &&
        Objects.equals(this.aggregateReviewRating, hotelOnMap.aggregateReviewRating) &&
        Objects.equals(this.location, hotelOnMap.location) &&
        Objects.equals(this.shortDescriptions, hotelOnMap.shortDescriptions) &&
        Objects.equals(this.longDescriptions, hotelOnMap.longDescriptions) &&
        Objects.equals(this.aggregateGreendexRating, hotelOnMap.aggregateGreendexRating) &&
        Objects.equals(this.lifestyleTypes, hotelOnMap.lifestyleTypes) &&
        Objects.equals(this.totalReviews, hotelOnMap.totalReviews) &&
        Objects.equals(this.available, hotelOnMap.available) &&
        Objects.equals(this.hotelAvailable, hotelOnMap.hotelAvailable) &&
        Objects.equals(this.reservations, hotelOnMap.reservations) &&
        Objects.equals(this.socials, hotelOnMap.socials) &&
        Objects.equals(this.images, hotelOnMap.images) &&
        Objects.equals(this.videos, hotelOnMap.videos) &&
        Objects.equals(this.policy, hotelOnMap.policy) &&
        Objects.equals(this.thirdPartyReviews, hotelOnMap.thirdPartyReviews) &&
        Objects.equals(this.attractions, hotelOnMap.attractions) &&
        Objects.equals(this.recreations, hotelOnMap.recreations) &&
        Objects.equals(this.pois, hotelOnMap.pois) &&
        Objects.equals(this.restaurants, hotelOnMap.restaurants) &&
        Objects.equals(this.meetingRooms, hotelOnMap.meetingRooms) &&
        Objects.equals(this.spas, hotelOnMap.spas) &&
        Objects.equals(this.bundles, hotelOnMap.bundles) &&
        Objects.equals(this.upgrades, hotelOnMap.upgrades) &&
        Objects.equals(this.fullNameOfGeneralManager, hotelOnMap.fullNameOfGeneralManager) &&
        Objects.equals(this.profilePictureIdentifierGeneralManager, hotelOnMap.profilePictureIdentifierGeneralManager) &&
        Objects.equals(this.messagesOfGeneralManager, hotelOnMap.messagesOfGeneralManager) &&
        Objects.equals(this.locationCategory, hotelOnMap.locationCategory) &&
        Objects.equals(this.segmentCategory, hotelOnMap.segmentCategory) &&
        Objects.equals(this.hotelCategory, hotelOnMap.hotelCategory) &&
        Objects.equals(this.architecturalStyle, hotelOnMap.architecturalStyle) &&
        Objects.equals(this.whenBuilt, hotelOnMap.whenBuilt) &&
        Objects.equals(this.multimediaIdentifier, hotelOnMap.multimediaIdentifier) &&
        Objects.equals(this.imageIdentifier, hotelOnMap.imageIdentifier) &&
        Objects.equals(this.imageAngle, hotelOnMap.imageAngle) &&
        Objects.equals(this.videoIdentifier, hotelOnMap.videoIdentifier) &&
        Objects.equals(this.currencyCode, hotelOnMap.currencyCode) &&
        Objects.equals(this.membershipRateDiscount, hotelOnMap.membershipRateDiscount) &&
        Objects.equals(this.priceScore, hotelOnMap.priceScore) &&
        Objects.equals(this.perkScore, hotelOnMap.perkScore) &&
        Objects.equals(this.packageScore, hotelOnMap.packageScore) &&
        Objects.equals(this.loyaltyScore, hotelOnMap.loyaltyScore) &&
        Objects.equals(this.popularScore, hotelOnMap.popularScore) &&
        Objects.equals(this.experienceScore, hotelOnMap.experienceScore) &&
        Objects.equals(this.availabilityScore, hotelOnMap.availabilityScore) &&
        Objects.equals(this.views, hotelOnMap.views) &&
        Objects.equals(this.address1, hotelOnMap.address1) &&
        Objects.equals(this.address2, hotelOnMap.address2) &&
        Objects.equals(this.postalCode, hotelOnMap.postalCode) &&
        Objects.equals(this.state, hotelOnMap.state) &&
        Objects.equals(this.city, hotelOnMap.city) &&
        Objects.equals(this.hotelAmenityCodes, hotelOnMap.hotelAmenityCodes) &&
        Objects.equals(this.propertyAccessibilityCodes, hotelOnMap.propertyAccessibilityCodes) &&
        Objects.equals(this.propertySecurityCodes, hotelOnMap.propertySecurityCodes) &&
        Objects.equals(this.numberOfRooms, hotelOnMap.numberOfRooms) &&
        Objects.equals(this.active, hotelOnMap.active) &&
        Objects.equals(this.urlParameters, hotelOnMap.urlParameters);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, name, localName, chain, brand, urlName, starRating, bookings, aggregateReviewRating, location, shortDescriptions, longDescriptions, aggregateGreendexRating, lifestyleTypes, totalReviews, available, hotelAvailable, reservations, socials, images, videos, policy, thirdPartyReviews, attractions, recreations, pois, restaurants, meetingRooms, spas, bundles, upgrades, fullNameOfGeneralManager, profilePictureIdentifierGeneralManager, messagesOfGeneralManager, locationCategory, segmentCategory, hotelCategory, architecturalStyle, whenBuilt, multimediaIdentifier, imageIdentifier, imageAngle, videoIdentifier, currencyCode, membershipRateDiscount, priceScore, perkScore, packageScore, loyaltyScore, popularScore, experienceScore, availabilityScore, views, address1, address2, postalCode, state, city, hotelAmenityCodes, propertyAccessibilityCodes, propertySecurityCodes, numberOfRooms, active, urlParameters);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HotelOnMap {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    localName: ").append(toIndentedString(localName)).append("\n");
    sb.append("    chain: ").append(toIndentedString(chain)).append("\n");
    sb.append("    brand: ").append(toIndentedString(brand)).append("\n");
    sb.append("    urlName: ").append(toIndentedString(urlName)).append("\n");
    sb.append("    starRating: ").append(toIndentedString(starRating)).append("\n");
    sb.append("    bookings: ").append(toIndentedString(bookings)).append("\n");
    sb.append("    aggregateReviewRating: ").append(toIndentedString(aggregateReviewRating)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    shortDescriptions: ").append(toIndentedString(shortDescriptions)).append("\n");
    sb.append("    longDescriptions: ").append(toIndentedString(longDescriptions)).append("\n");
    sb.append("    aggregateGreendexRating: ").append(toIndentedString(aggregateGreendexRating)).append("\n");
    sb.append("    lifestyleTypes: ").append(toIndentedString(lifestyleTypes)).append("\n");
    sb.append("    totalReviews: ").append(toIndentedString(totalReviews)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("    hotelAvailable: ").append(toIndentedString(hotelAvailable)).append("\n");
    sb.append("    reservations: ").append(toIndentedString(reservations)).append("\n");
    sb.append("    socials: ").append(toIndentedString(socials)).append("\n");
    sb.append("    images: ").append(toIndentedString(images)).append("\n");
    sb.append("    videos: ").append(toIndentedString(videos)).append("\n");
    sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
    sb.append("    thirdPartyReviews: ").append(toIndentedString(thirdPartyReviews)).append("\n");
    sb.append("    attractions: ").append(toIndentedString(attractions)).append("\n");
    sb.append("    recreations: ").append(toIndentedString(recreations)).append("\n");
    sb.append("    pois: ").append(toIndentedString(pois)).append("\n");
    sb.append("    restaurants: ").append(toIndentedString(restaurants)).append("\n");
    sb.append("    meetingRooms: ").append(toIndentedString(meetingRooms)).append("\n");
    sb.append("    spas: ").append(toIndentedString(spas)).append("\n");
    sb.append("    bundles: ").append(toIndentedString(bundles)).append("\n");
    sb.append("    upgrades: ").append(toIndentedString(upgrades)).append("\n");
    sb.append("    fullNameOfGeneralManager: ").append(toIndentedString(fullNameOfGeneralManager)).append("\n");
    sb.append("    profilePictureIdentifierGeneralManager: ").append(toIndentedString(profilePictureIdentifierGeneralManager)).append("\n");
    sb.append("    messagesOfGeneralManager: ").append(toIndentedString(messagesOfGeneralManager)).append("\n");
    sb.append("    locationCategory: ").append(toIndentedString(locationCategory)).append("\n");
    sb.append("    segmentCategory: ").append(toIndentedString(segmentCategory)).append("\n");
    sb.append("    hotelCategory: ").append(toIndentedString(hotelCategory)).append("\n");
    sb.append("    architecturalStyle: ").append(toIndentedString(architecturalStyle)).append("\n");
    sb.append("    whenBuilt: ").append(toIndentedString(whenBuilt)).append("\n");
    sb.append("    multimediaIdentifier: ").append(toIndentedString(multimediaIdentifier)).append("\n");
    sb.append("    imageIdentifier: ").append(toIndentedString(imageIdentifier)).append("\n");
    sb.append("    imageAngle: ").append(toIndentedString(imageAngle)).append("\n");
    sb.append("    videoIdentifier: ").append(toIndentedString(videoIdentifier)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    membershipRateDiscount: ").append(toIndentedString(membershipRateDiscount)).append("\n");
    sb.append("    priceScore: ").append(toIndentedString(priceScore)).append("\n");
    sb.append("    perkScore: ").append(toIndentedString(perkScore)).append("\n");
    sb.append("    packageScore: ").append(toIndentedString(packageScore)).append("\n");
    sb.append("    loyaltyScore: ").append(toIndentedString(loyaltyScore)).append("\n");
    sb.append("    popularScore: ").append(toIndentedString(popularScore)).append("\n");
    sb.append("    experienceScore: ").append(toIndentedString(experienceScore)).append("\n");
    sb.append("    availabilityScore: ").append(toIndentedString(availabilityScore)).append("\n");
    sb.append("    views: ").append(toIndentedString(views)).append("\n");
    sb.append("    address1: ").append(toIndentedString(address1)).append("\n");
    sb.append("    address2: ").append(toIndentedString(address2)).append("\n");
    sb.append("    postalCode: ").append(toIndentedString(postalCode)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    hotelAmenityCodes: ").append(toIndentedString(hotelAmenityCodes)).append("\n");
    sb.append("    propertyAccessibilityCodes: ").append(toIndentedString(propertyAccessibilityCodes)).append("\n");
    sb.append("    propertySecurityCodes: ").append(toIndentedString(propertySecurityCodes)).append("\n");
    sb.append("    numberOfRooms: ").append(toIndentedString(numberOfRooms)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    urlParameters: ").append(toIndentedString(urlParameters)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

