/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 19.0.14-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Itinerary
 */
@JsonPropertyOrder({
  Itinerary.JSON_PROPERTY_START_DATE,
  Itinerary.JSON_PROPERTY_END_DATE,
  Itinerary.JSON_PROPERTY_ADULTS,
  Itinerary.JSON_PROPERTY_CHILDREN,
  Itinerary.JSON_PROPERTY_GUESTS,
  Itinerary.JSON_PROPERTY_NIGHTS,
  Itinerary.JSON_PROPERTY_HOURS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-28T12:37:26.819025+07:00[Asia/Bangkok]")
public class Itinerary {
  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private OffsetDateTime startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private OffsetDateTime endDate;

  public static final String JSON_PROPERTY_ADULTS = "adults";
  private Integer adults;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  private Integer children;

  public static final String JSON_PROPERTY_GUESTS = "guests";
  private Integer guests;

  public static final String JSON_PROPERTY_NIGHTS = "nights";
  private Long nights;

  public static final String JSON_PROPERTY_HOURS = "hours";
  private Long hours;

  public Itinerary() { 
  }

  @JsonCreator
  public Itinerary(
    @JsonProperty(JSON_PROPERTY_START_DATE) OffsetDateTime startDate, 
    @JsonProperty(JSON_PROPERTY_END_DATE) OffsetDateTime endDate, 
    @JsonProperty(JSON_PROPERTY_ADULTS) Integer adults, 
    @JsonProperty(JSON_PROPERTY_CHILDREN) Integer children, 
    @JsonProperty(JSON_PROPERTY_GUESTS) Integer guests, 
    @JsonProperty(JSON_PROPERTY_NIGHTS) Long nights, 
    @JsonProperty(JSON_PROPERTY_HOURS) Long hours
  ) {
    this();
    this.startDate = startDate;
    this.endDate = endDate;
    this.adults = adults;
    this.children = children;
    this.guests = guests;
    this.nights = nights;
    this.hours = hours;
  }

   /**
   * Start date
   * @return startDate
  **/
  @javax.annotation.Nonnull
  @Valid
  @ApiModelProperty(required = true, value = "Start date")
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getStartDate() {
    return startDate;
  }




   /**
   * End date
   * @return endDate
  **/
  @javax.annotation.Nonnull
  @Valid
  @ApiModelProperty(required = true, value = "End date")
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getEndDate() {
    return endDate;
  }




   /**
   * Number of adults
   * minimum: 1
   * @return adults
  **/
  @javax.annotation.Nonnull
 @Min(1)  @ApiModelProperty(required = true, value = "Number of adults")
  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAdults() {
    return adults;
  }




   /**
   * Number of children
   * minimum: 0
   * @return children
  **/
  @javax.annotation.Nonnull
 @Min(0)  @ApiModelProperty(required = true, value = "Number of children")
  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getChildren() {
    return children;
  }




   /**
   * Total number of adults and children
   * @return guests
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Total number of adults and children")
  @JsonProperty(JSON_PROPERTY_GUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getGuests() {
    return guests;
  }




   /**
   * Total number of room nights
   * @return nights
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Total number of room nights")
  @JsonProperty(JSON_PROPERTY_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getNights() {
    return nights;
  }




   /**
   * Number of hours between start and end dates. Used for itineraries that require bookings that occur within hours and not days. E.g. Meeting room reservation.
   * @return hours
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Number of hours between start and end dates. Used for itineraries that require bookings that occur within hours and not days. E.g. Meeting room reservation.")
  @JsonProperty(JSON_PROPERTY_HOURS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getHours() {
    return hours;
  }




  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Itinerary itinerary = (Itinerary) o;
    return Objects.equals(this.startDate, itinerary.startDate) &&
        Objects.equals(this.endDate, itinerary.endDate) &&
        Objects.equals(this.adults, itinerary.adults) &&
        Objects.equals(this.children, itinerary.children) &&
        Objects.equals(this.guests, itinerary.guests) &&
        Objects.equals(this.nights, itinerary.nights) &&
        Objects.equals(this.hours, itinerary.hours);
  }

  @Override
  public int hashCode() {
    return Objects.hash(startDate, endDate, adults, children, guests, nights, hours);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Itinerary {\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    adults: ").append(toIndentedString(adults)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    guests: ").append(toIndentedString(guests)).append("\n");
    sb.append("    nights: ").append(toIndentedString(nights)).append("\n");
    sb.append("    hours: ").append(toIndentedString(hours)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

