/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 19.0.14-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.extranet.model.AdvanceBookingRateQualifier;
import travel.wink.sdk.extranet.model.ArrivalDaysOfWeekRateQualifier;
import travel.wink.sdk.extranet.model.AvailableDaysOfWeekRateQualifier;
import travel.wink.sdk.extranet.model.BlackoutDate;
import travel.wink.sdk.extranet.model.CityRateQualifier;
import travel.wink.sdk.extranet.model.ContinentRateQualifier;
import travel.wink.sdk.extranet.model.CountryRateQualifier;
import travel.wink.sdk.extranet.model.DepartureDaysOfWeekRateQualifier;
import travel.wink.sdk.extranet.model.IPRangeRateQualifier;
import travel.wink.sdk.extranet.model.LengthOfStayRateQualifier;
import travel.wink.sdk.extranet.model.MinutesBeforeBookingStartDateRateQualifier;
import travel.wink.sdk.extranet.model.PrepayRateQualifier;
import travel.wink.sdk.extranet.model.PromotionRateQualifier;
import travel.wink.sdk.extranet.model.RateModifierModifier;
import travel.wink.sdk.extranet.model.RefundableRateQualifier;
import travel.wink.sdk.extranet.model.RequiredDaysOfWeekRateQualifier;
import travel.wink.sdk.extranet.model.RoomRangeRateQualifier;
import travel.wink.sdk.extranet.model.SellDateRateQualifier;
import travel.wink.sdk.extranet.model.SimpleDescription;
import travel.wink.sdk.extranet.model.StayDateRateQualifier;
import travel.wink.sdk.extranet.model.TimezoneRateQualifier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * RateModifier
 */
@JsonPropertyOrder({
  RateModifier.JSON_PROPERTY_IDENTIFIER,
  RateModifier.JSON_PROPERTY_HOTEL_IDENTIFIER,
  RateModifier.JSON_PROPERTY_NAME,
  RateModifier.JSON_PROPERTY_TYPE,
  RateModifier.JSON_PROPERTY_MODIFIER,
  RateModifier.JSON_PROPERTY_ENABLED,
  RateModifier.JSON_PROPERTY_PRICING_TYPE,
  RateModifier.JSON_PROPERTY_DESCRIPTIONS,
  RateModifier.JSON_PROPERTY_CITY_RATE_QUALIFIERS,
  RateModifier.JSON_PROPERTY_CONTINENT_RATE_QUALIFIERS,
  RateModifier.JSON_PROPERTY_COUNTRY_RATE_QUALIFIERS,
  RateModifier.JSON_PROPERTY_PROMOTION_RATE_QUALIFIERS,
  RateModifier.JSON_PROPERTY_IP_RANGE_RATE_QUALIFIERS,
  RateModifier.JSON_PROPERTY_ROOM_RANGE_RATE_QUALIFIER,
  RateModifier.JSON_PROPERTY_PREPAY_RATE_QUALIFIER,
  RateModifier.JSON_PROPERTY_REFUNDABLE_RATE_QUALIFIER,
  RateModifier.JSON_PROPERTY_TIMEZONE_RATE_QUALIFIERS,
  RateModifier.JSON_PROPERTY_LAST_MINUTE_RATE_QUALIFIER,
  RateModifier.JSON_PROPERTY_LENGTH_OF_STAY_RATE_QUALIFIER,
  RateModifier.JSON_PROPERTY_ADVANCE_BOOKING_RATE_QUALIFIER,
  RateModifier.JSON_PROPERTY_STAY_DATE_RATE_QUALIFIERS,
  RateModifier.JSON_PROPERTY_SELL_DATE_RATE_QUALIFIERS,
  RateModifier.JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK_RATE_QUALIFIER,
  RateModifier.JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK_RATE_QUALIFIER,
  RateModifier.JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK_RATE_QUALIFIER,
  RateModifier.JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK_RATE_QUALIFIER,
  RateModifier.JSON_PROPERTY_MASTER_RATE_IDENTIFIERS,
  RateModifier.JSON_PROPERTY_PACKAGE_IDENTIFIERS,
  RateModifier.JSON_PROPERTY_ADD_ON_IDENTIFIERS,
  RateModifier.JSON_PROPERTY_RATE_PLAN_IDENTIFIERS,
  RateModifier.JSON_PROPERTY_BLACKOUT_DATES
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-28T12:37:26.819025+07:00[Asia/Bangkok]")
public class RateModifier {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private String hotelIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  /**
   * Set whether you want the price to go up or down when the rules of this promotion have been satisfied.
   */
  public enum TypeEnum {
    PREMIUM("PREMIUM"),
    
    DISCOUNT("DISCOUNT");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_MODIFIER = "modifier";
  private RateModifierModifier modifier;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled = true;

  /**
   * This determines whether this discount should be applied per night, per stay or per person - per night
   */
  public enum PricingTypeEnum {
    HOUR("PER_HOUR"),
    
    PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
    
    STAY("PER_STAY"),
    
    PERSON("PER_PERSON"),
    
    NIGHT("PER_NIGHT"),
    
    PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
    
    PERSON_PER_STAY("PER_PERSON_PER_STAY"),
    
    USE("PER_USE");

    private String value;

    PricingTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricingTypeEnum fromValue(String value) {
      for (PricingTypeEnum b : PricingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
  private PricingTypeEnum pricingType;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescription> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_CITY_RATE_QUALIFIERS = "cityRateQualifiers";
  private List<CityRateQualifier> cityRateQualifiers = null;

  public static final String JSON_PROPERTY_CONTINENT_RATE_QUALIFIERS = "continentRateQualifiers";
  private List<ContinentRateQualifier> continentRateQualifiers = null;

  public static final String JSON_PROPERTY_COUNTRY_RATE_QUALIFIERS = "countryRateQualifiers";
  private List<CountryRateQualifier> countryRateQualifiers = null;

  public static final String JSON_PROPERTY_PROMOTION_RATE_QUALIFIERS = "promotionRateQualifiers";
  private List<PromotionRateQualifier> promotionRateQualifiers = null;

  public static final String JSON_PROPERTY_IP_RANGE_RATE_QUALIFIERS = "ipRangeRateQualifiers";
  private List<IPRangeRateQualifier> ipRangeRateQualifiers = null;

  public static final String JSON_PROPERTY_ROOM_RANGE_RATE_QUALIFIER = "roomRangeRateQualifier";
  private RoomRangeRateQualifier roomRangeRateQualifier;

  public static final String JSON_PROPERTY_PREPAY_RATE_QUALIFIER = "prepayRateQualifier";
  private PrepayRateQualifier prepayRateQualifier;

  public static final String JSON_PROPERTY_REFUNDABLE_RATE_QUALIFIER = "refundableRateQualifier";
  private RefundableRateQualifier refundableRateQualifier;

  public static final String JSON_PROPERTY_TIMEZONE_RATE_QUALIFIERS = "timezoneRateQualifiers";
  private List<TimezoneRateQualifier> timezoneRateQualifiers = null;

  public static final String JSON_PROPERTY_LAST_MINUTE_RATE_QUALIFIER = "lastMinuteRateQualifier";
  private MinutesBeforeBookingStartDateRateQualifier lastMinuteRateQualifier;

  public static final String JSON_PROPERTY_LENGTH_OF_STAY_RATE_QUALIFIER = "lengthOfStayRateQualifier";
  private LengthOfStayRateQualifier lengthOfStayRateQualifier;

  public static final String JSON_PROPERTY_ADVANCE_BOOKING_RATE_QUALIFIER = "advanceBookingRateQualifier";
  private AdvanceBookingRateQualifier advanceBookingRateQualifier;

  public static final String JSON_PROPERTY_STAY_DATE_RATE_QUALIFIERS = "stayDateRateQualifiers";
  private List<StayDateRateQualifier> stayDateRateQualifiers = null;

  public static final String JSON_PROPERTY_SELL_DATE_RATE_QUALIFIERS = "sellDateRateQualifiers";
  private List<SellDateRateQualifier> sellDateRateQualifiers = null;

  public static final String JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK_RATE_QUALIFIER = "availableDaysOfWeekRateQualifier";
  private AvailableDaysOfWeekRateQualifier availableDaysOfWeekRateQualifier;

  public static final String JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK_RATE_QUALIFIER = "arrivalDaysOfWeekRateQualifier";
  private ArrivalDaysOfWeekRateQualifier arrivalDaysOfWeekRateQualifier;

  public static final String JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK_RATE_QUALIFIER = "departureDaysOfWeekRateQualifier";
  private DepartureDaysOfWeekRateQualifier departureDaysOfWeekRateQualifier;

  public static final String JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK_RATE_QUALIFIER = "requiredDaysOfWeekRateQualifier";
  private RequiredDaysOfWeekRateQualifier requiredDaysOfWeekRateQualifier;

  public static final String JSON_PROPERTY_MASTER_RATE_IDENTIFIERS = "masterRateIdentifiers";
  private List<String> masterRateIdentifiers = null;

  public static final String JSON_PROPERTY_PACKAGE_IDENTIFIERS = "packageIdentifiers";
  private List<String> packageIdentifiers = null;

  public static final String JSON_PROPERTY_ADD_ON_IDENTIFIERS = "addOnIdentifiers";
  private List<String> addOnIdentifiers = null;

  public static final String JSON_PROPERTY_RATE_PLAN_IDENTIFIERS = "ratePlanIdentifiers";
  private List<String> ratePlanIdentifiers = null;

  public static final String JSON_PROPERTY_BLACKOUT_DATES = "blackoutDates";
  private List<BlackoutDate> blackoutDates = null;

  public RateModifier() { 
  }

  public RateModifier identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier
   * @return identifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "document-1", value = "Unique record identifier")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public RateModifier hotelIdentifier(String hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel identifier.
   * @return hotelIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "hotel-1", value = "Hotel identifier.")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(String hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public RateModifier name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Internal name of promotion.
   * @return name
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Early bird", required = true, value = "Internal name of promotion.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public RateModifier type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Set whether you want the price to go up or down when the rules of this promotion have been satisfied.
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "DISCOUNT", required = true, value = "Set whether you want the price to go up or down when the rules of this promotion have been satisfied.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public RateModifier modifier(RateModifierModifier modifier) {
    
    this.modifier = modifier;
    return this;
  }

   /**
   * Get modifier
   * @return modifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RateModifierModifier getModifier() {
    return modifier;
  }


  @JsonProperty(JSON_PROPERTY_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setModifier(RateModifierModifier modifier) {
    this.modifier = modifier;
  }


  public RateModifier enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Whether this promotion is enabled or not.
   * @return enabled
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Whether this promotion is enabled or not.")
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public RateModifier pricingType(PricingTypeEnum pricingType) {
    
    this.pricingType = pricingType;
    return this;
  }

   /**
   * This determines whether this discount should be applied per night, per stay or per person - per night
   * @return pricingType
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "PER_PERSON_PER_NIGHT", required = true, value = "This determines whether this discount should be applied per night, per stay or per person - per night")
  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricingTypeEnum getPricingType() {
    return pricingType;
  }


  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricingType(PricingTypeEnum pricingType) {
    this.pricingType = pricingType;
  }


  public RateModifier descriptions(List<SimpleDescription> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public RateModifier addDescriptionsItem(SimpleDescription descriptionsItem) {
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Localized descriptions describing promotion. At least one English entry is required.
   * @return descriptions
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Localized descriptions describing promotion. At least one English entry is required.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleDescription> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<SimpleDescription> descriptions) {
    this.descriptions = descriptions;
  }


  public RateModifier cityRateQualifiers(List<CityRateQualifier> cityRateQualifiers) {
    
    this.cityRateQualifiers = cityRateQualifiers;
    return this;
  }

  public RateModifier addCityRateQualifiersItem(CityRateQualifier cityRateQualifiersItem) {
    if (this.cityRateQualifiers == null) {
      this.cityRateQualifiers = new ArrayList<>();
    }
    this.cityRateQualifiers.add(cityRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific cities. See [Geo-IP city reference data](#operation/searchForCity)
   * @return cityRateQualifiers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Restrict promotion to specific cities. See [Geo-IP city reference data](#operation/searchForCity)")
  @JsonProperty(JSON_PROPERTY_CITY_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CityRateQualifier> getCityRateQualifiers() {
    return cityRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_CITY_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCityRateQualifiers(List<CityRateQualifier> cityRateQualifiers) {
    this.cityRateQualifiers = cityRateQualifiers;
  }


  public RateModifier continentRateQualifiers(List<ContinentRateQualifier> continentRateQualifiers) {
    
    this.continentRateQualifiers = continentRateQualifiers;
    return this;
  }

  public RateModifier addContinentRateQualifiersItem(ContinentRateQualifier continentRateQualifiersItem) {
    if (this.continentRateQualifiers == null) {
      this.continentRateQualifiers = new ArrayList<>();
    }
    this.continentRateQualifiers.add(continentRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific continents. See [Geo-IP continent reference data](#operation/showContinents)
   * @return continentRateQualifiers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Restrict promotion to specific continents. See [Geo-IP continent reference data](#operation/showContinents)")
  @JsonProperty(JSON_PROPERTY_CONTINENT_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ContinentRateQualifier> getContinentRateQualifiers() {
    return continentRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinentRateQualifiers(List<ContinentRateQualifier> continentRateQualifiers) {
    this.continentRateQualifiers = continentRateQualifiers;
  }


  public RateModifier countryRateQualifiers(List<CountryRateQualifier> countryRateQualifiers) {
    
    this.countryRateQualifiers = countryRateQualifiers;
    return this;
  }

  public RateModifier addCountryRateQualifiersItem(CountryRateQualifier countryRateQualifiersItem) {
    if (this.countryRateQualifiers == null) {
      this.countryRateQualifiers = new ArrayList<>();
    }
    this.countryRateQualifiers.add(countryRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific countries. See [Geo-IP country reference data](#operation/showCountries)
   * @return countryRateQualifiers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Restrict promotion to specific countries. See [Geo-IP country reference data](#operation/showCountries)")
  @JsonProperty(JSON_PROPERTY_COUNTRY_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CountryRateQualifier> getCountryRateQualifiers() {
    return countryRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryRateQualifiers(List<CountryRateQualifier> countryRateQualifiers) {
    this.countryRateQualifiers = countryRateQualifiers;
  }


  public RateModifier promotionRateQualifiers(List<PromotionRateQualifier> promotionRateQualifiers) {
    
    this.promotionRateQualifiers = promotionRateQualifiers;
    return this;
  }

  public RateModifier addPromotionRateQualifiersItem(PromotionRateQualifier promotionRateQualifiersItem) {
    if (this.promotionRateQualifiers == null) {
      this.promotionRateQualifiers = new ArrayList<>();
    }
    this.promotionRateQualifiers.add(promotionRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion by requiring users to enter a promo code.
   * @return promotionRateQualifiers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Restrict promotion by requiring users to enter a promo code.")
  @JsonProperty(JSON_PROPERTY_PROMOTION_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PromotionRateQualifier> getPromotionRateQualifiers() {
    return promotionRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTION_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionRateQualifiers(List<PromotionRateQualifier> promotionRateQualifiers) {
    this.promotionRateQualifiers = promotionRateQualifiers;
  }


  public RateModifier ipRangeRateQualifiers(List<IPRangeRateQualifier> ipRangeRateQualifiers) {
    
    this.ipRangeRateQualifiers = ipRangeRateQualifiers;
    return this;
  }

  public RateModifier addIpRangeRateQualifiersItem(IPRangeRateQualifier ipRangeRateQualifiersItem) {
    if (this.ipRangeRateQualifiers == null) {
      this.ipRangeRateQualifiers = new ArrayList<>();
    }
    this.ipRangeRateQualifiers.add(ipRangeRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific IP ranges.
   * @return ipRangeRateQualifiers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Restrict promotion to specific IP ranges.")
  @JsonProperty(JSON_PROPERTY_IP_RANGE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<IPRangeRateQualifier> getIpRangeRateQualifiers() {
    return ipRangeRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_IP_RANGE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIpRangeRateQualifiers(List<IPRangeRateQualifier> ipRangeRateQualifiers) {
    this.ipRangeRateQualifiers = ipRangeRateQualifiers;
  }


  public RateModifier roomRangeRateQualifier(RoomRangeRateQualifier roomRangeRateQualifier) {
    
    this.roomRangeRateQualifier = roomRangeRateQualifier;
    return this;
  }

   /**
   * Get roomRangeRateQualifier
   * @return roomRangeRateQualifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ROOM_RANGE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RoomRangeRateQualifier getRoomRangeRateQualifier() {
    return roomRangeRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RANGE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomRangeRateQualifier(RoomRangeRateQualifier roomRangeRateQualifier) {
    this.roomRangeRateQualifier = roomRangeRateQualifier;
  }


  public RateModifier prepayRateQualifier(PrepayRateQualifier prepayRateQualifier) {
    
    this.prepayRateQualifier = prepayRateQualifier;
    return this;
  }

   /**
   * Get prepayRateQualifier
   * @return prepayRateQualifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PREPAY_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PrepayRateQualifier getPrepayRateQualifier() {
    return prepayRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_PREPAY_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrepayRateQualifier(PrepayRateQualifier prepayRateQualifier) {
    this.prepayRateQualifier = prepayRateQualifier;
  }


  public RateModifier refundableRateQualifier(RefundableRateQualifier refundableRateQualifier) {
    
    this.refundableRateQualifier = refundableRateQualifier;
    return this;
  }

   /**
   * Get refundableRateQualifier
   * @return refundableRateQualifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REFUNDABLE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RefundableRateQualifier getRefundableRateQualifier() {
    return refundableRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDABLE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundableRateQualifier(RefundableRateQualifier refundableRateQualifier) {
    this.refundableRateQualifier = refundableRateQualifier;
  }


  public RateModifier timezoneRateQualifiers(List<TimezoneRateQualifier> timezoneRateQualifiers) {
    
    this.timezoneRateQualifiers = timezoneRateQualifiers;
    return this;
  }

  public RateModifier addTimezoneRateQualifiersItem(TimezoneRateQualifier timezoneRateQualifiersItem) {
    if (this.timezoneRateQualifiers == null) {
      this.timezoneRateQualifiers = new ArrayList<>();
    }
    this.timezoneRateQualifiers.add(timezoneRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific time zones. See [Geo-IP timezone reference data](#operation/showTimezones)
   * @return timezoneRateQualifiers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Restrict promotion to specific time zones. See [Geo-IP timezone reference data](#operation/showTimezones)")
  @JsonProperty(JSON_PROPERTY_TIMEZONE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TimezoneRateQualifier> getTimezoneRateQualifiers() {
    return timezoneRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_TIMEZONE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimezoneRateQualifiers(List<TimezoneRateQualifier> timezoneRateQualifiers) {
    this.timezoneRateQualifiers = timezoneRateQualifiers;
  }


  public RateModifier lastMinuteRateQualifier(MinutesBeforeBookingStartDateRateQualifier lastMinuteRateQualifier) {
    
    this.lastMinuteRateQualifier = lastMinuteRateQualifier;
    return this;
  }

   /**
   * Get lastMinuteRateQualifier
   * @return lastMinuteRateQualifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LAST_MINUTE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MinutesBeforeBookingStartDateRateQualifier getLastMinuteRateQualifier() {
    return lastMinuteRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_LAST_MINUTE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastMinuteRateQualifier(MinutesBeforeBookingStartDateRateQualifier lastMinuteRateQualifier) {
    this.lastMinuteRateQualifier = lastMinuteRateQualifier;
  }


  public RateModifier lengthOfStayRateQualifier(LengthOfStayRateQualifier lengthOfStayRateQualifier) {
    
    this.lengthOfStayRateQualifier = lengthOfStayRateQualifier;
    return this;
  }

   /**
   * Get lengthOfStayRateQualifier
   * @return lengthOfStayRateQualifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LENGTH_OF_STAY_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LengthOfStayRateQualifier getLengthOfStayRateQualifier() {
    return lengthOfStayRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_LENGTH_OF_STAY_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLengthOfStayRateQualifier(LengthOfStayRateQualifier lengthOfStayRateQualifier) {
    this.lengthOfStayRateQualifier = lengthOfStayRateQualifier;
  }


  public RateModifier advanceBookingRateQualifier(AdvanceBookingRateQualifier advanceBookingRateQualifier) {
    
    this.advanceBookingRateQualifier = advanceBookingRateQualifier;
    return this;
  }

   /**
   * Get advanceBookingRateQualifier
   * @return advanceBookingRateQualifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADVANCE_BOOKING_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AdvanceBookingRateQualifier getAdvanceBookingRateQualifier() {
    return advanceBookingRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_ADVANCE_BOOKING_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdvanceBookingRateQualifier(AdvanceBookingRateQualifier advanceBookingRateQualifier) {
    this.advanceBookingRateQualifier = advanceBookingRateQualifier;
  }


  public RateModifier stayDateRateQualifiers(List<StayDateRateQualifier> stayDateRateQualifiers) {
    
    this.stayDateRateQualifiers = stayDateRateQualifiers;
    return this;
  }

  public RateModifier addStayDateRateQualifiersItem(StayDateRateQualifier stayDateRateQualifiersItem) {
    if (this.stayDateRateQualifiers == null) {
      this.stayDateRateQualifiers = new ArrayList<>();
    }
    this.stayDateRateQualifiers.add(stayDateRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific stay dates the user wants to arrive.
   * @return stayDateRateQualifiers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Restrict promotion to specific stay dates the user wants to arrive.")
  @JsonProperty(JSON_PROPERTY_STAY_DATE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<StayDateRateQualifier> getStayDateRateQualifiers() {
    return stayDateRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_STAY_DATE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStayDateRateQualifiers(List<StayDateRateQualifier> stayDateRateQualifiers) {
    this.stayDateRateQualifiers = stayDateRateQualifiers;
  }


  public RateModifier sellDateRateQualifiers(List<SellDateRateQualifier> sellDateRateQualifiers) {
    
    this.sellDateRateQualifiers = sellDateRateQualifiers;
    return this;
  }

  public RateModifier addSellDateRateQualifiersItem(SellDateRateQualifier sellDateRateQualifiersItem) {
    if (this.sellDateRateQualifiers == null) {
      this.sellDateRateQualifiers = new ArrayList<>();
    }
    this.sellDateRateQualifiers.add(sellDateRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific dates the booking is made.
   * @return sellDateRateQualifiers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Restrict promotion to specific dates the booking is made.")
  @JsonProperty(JSON_PROPERTY_SELL_DATE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SellDateRateQualifier> getSellDateRateQualifiers() {
    return sellDateRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_SELL_DATE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSellDateRateQualifiers(List<SellDateRateQualifier> sellDateRateQualifiers) {
    this.sellDateRateQualifiers = sellDateRateQualifiers;
  }


  public RateModifier availableDaysOfWeekRateQualifier(AvailableDaysOfWeekRateQualifier availableDaysOfWeekRateQualifier) {
    
    this.availableDaysOfWeekRateQualifier = availableDaysOfWeekRateQualifier;
    return this;
  }

   /**
   * Get availableDaysOfWeekRateQualifier
   * @return availableDaysOfWeekRateQualifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AvailableDaysOfWeekRateQualifier getAvailableDaysOfWeekRateQualifier() {
    return availableDaysOfWeekRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailableDaysOfWeekRateQualifier(AvailableDaysOfWeekRateQualifier availableDaysOfWeekRateQualifier) {
    this.availableDaysOfWeekRateQualifier = availableDaysOfWeekRateQualifier;
  }


  public RateModifier arrivalDaysOfWeekRateQualifier(ArrivalDaysOfWeekRateQualifier arrivalDaysOfWeekRateQualifier) {
    
    this.arrivalDaysOfWeekRateQualifier = arrivalDaysOfWeekRateQualifier;
    return this;
  }

   /**
   * Get arrivalDaysOfWeekRateQualifier
   * @return arrivalDaysOfWeekRateQualifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ArrivalDaysOfWeekRateQualifier getArrivalDaysOfWeekRateQualifier() {
    return arrivalDaysOfWeekRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArrivalDaysOfWeekRateQualifier(ArrivalDaysOfWeekRateQualifier arrivalDaysOfWeekRateQualifier) {
    this.arrivalDaysOfWeekRateQualifier = arrivalDaysOfWeekRateQualifier;
  }


  public RateModifier departureDaysOfWeekRateQualifier(DepartureDaysOfWeekRateQualifier departureDaysOfWeekRateQualifier) {
    
    this.departureDaysOfWeekRateQualifier = departureDaysOfWeekRateQualifier;
    return this;
  }

   /**
   * Get departureDaysOfWeekRateQualifier
   * @return departureDaysOfWeekRateQualifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DepartureDaysOfWeekRateQualifier getDepartureDaysOfWeekRateQualifier() {
    return departureDaysOfWeekRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDepartureDaysOfWeekRateQualifier(DepartureDaysOfWeekRateQualifier departureDaysOfWeekRateQualifier) {
    this.departureDaysOfWeekRateQualifier = departureDaysOfWeekRateQualifier;
  }


  public RateModifier requiredDaysOfWeekRateQualifier(RequiredDaysOfWeekRateQualifier requiredDaysOfWeekRateQualifier) {
    
    this.requiredDaysOfWeekRateQualifier = requiredDaysOfWeekRateQualifier;
    return this;
  }

   /**
   * Get requiredDaysOfWeekRateQualifier
   * @return requiredDaysOfWeekRateQualifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RequiredDaysOfWeekRateQualifier getRequiredDaysOfWeekRateQualifier() {
    return requiredDaysOfWeekRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequiredDaysOfWeekRateQualifier(RequiredDaysOfWeekRateQualifier requiredDaysOfWeekRateQualifier) {
    this.requiredDaysOfWeekRateQualifier = requiredDaysOfWeekRateQualifier;
  }


  public RateModifier masterRateIdentifiers(List<String> masterRateIdentifiers) {
    
    this.masterRateIdentifiers = masterRateIdentifiers;
    return this;
  }

  public RateModifier addMasterRateIdentifiersItem(String masterRateIdentifiersItem) {
    if (this.masterRateIdentifiers == null) {
      this.masterRateIdentifiers = new ArrayList<>();
    }
    this.masterRateIdentifiers.add(masterRateIdentifiersItem);
    return this;
  }

   /**
   * Restrict on specific master rates.
   * @return masterRateIdentifiers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"master-rate-1\",\"master-rate-2\"]", value = "Restrict on specific master rates.")
  @JsonProperty(JSON_PROPERTY_MASTER_RATE_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getMasterRateIdentifiers() {
    return masterRateIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_MASTER_RATE_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMasterRateIdentifiers(List<String> masterRateIdentifiers) {
    this.masterRateIdentifiers = masterRateIdentifiers;
  }


  public RateModifier packageIdentifiers(List<String> packageIdentifiers) {
    
    this.packageIdentifiers = packageIdentifiers;
    return this;
  }

  public RateModifier addPackageIdentifiersItem(String packageIdentifiersItem) {
    if (this.packageIdentifiers == null) {
      this.packageIdentifiers = new ArrayList<>();
    }
    this.packageIdentifiers.add(packageIdentifiersItem);
    return this;
  }

   /**
   * Restrict on specific packages.
   * @return packageIdentifiers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"package-1\",\"package-2\"]", value = "Restrict on specific packages.")
  @JsonProperty(JSON_PROPERTY_PACKAGE_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPackageIdentifiers() {
    return packageIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_PACKAGE_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPackageIdentifiers(List<String> packageIdentifiers) {
    this.packageIdentifiers = packageIdentifiers;
  }


  public RateModifier addOnIdentifiers(List<String> addOnIdentifiers) {
    
    this.addOnIdentifiers = addOnIdentifiers;
    return this;
  }

  public RateModifier addAddOnIdentifiersItem(String addOnIdentifiersItem) {
    if (this.addOnIdentifiers == null) {
      this.addOnIdentifiers = new ArrayList<>();
    }
    this.addOnIdentifiers.add(addOnIdentifiersItem);
    return this;
  }

   /**
   * Restrict on specific add-ons.
   * @return addOnIdentifiers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"add-on-1\",\"add-on-2\"]", value = "Restrict on specific add-ons.")
  @JsonProperty(JSON_PROPERTY_ADD_ON_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAddOnIdentifiers() {
    return addOnIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_ADD_ON_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddOnIdentifiers(List<String> addOnIdentifiers) {
    this.addOnIdentifiers = addOnIdentifiers;
  }


  public RateModifier ratePlanIdentifiers(List<String> ratePlanIdentifiers) {
    
    this.ratePlanIdentifiers = ratePlanIdentifiers;
    return this;
  }

  public RateModifier addRatePlanIdentifiersItem(String ratePlanIdentifiersItem) {
    if (this.ratePlanIdentifiers == null) {
      this.ratePlanIdentifiers = new ArrayList<>();
    }
    this.ratePlanIdentifiers.add(ratePlanIdentifiersItem);
    return this;
  }

   /**
   * Restrict on specific rate plans.
   * @return ratePlanIdentifiers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"rate-plan-1\",\"rate-plan-2\"]", value = "Restrict on specific rate plans.")
  @JsonProperty(JSON_PROPERTY_RATE_PLAN_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getRatePlanIdentifiers() {
    return ratePlanIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRatePlanIdentifiers(List<String> ratePlanIdentifiers) {
    this.ratePlanIdentifiers = ratePlanIdentifiers;
  }


  public RateModifier blackoutDates(List<BlackoutDate> blackoutDates) {
    
    this.blackoutDates = blackoutDates;
    return this;
  }

  public RateModifier addBlackoutDatesItem(BlackoutDate blackoutDatesItem) {
    if (this.blackoutDates == null) {
      this.blackoutDates = new ArrayList<>();
    }
    this.blackoutDates.add(blackoutDatesItem);
    return this;
  }

   /**
   * Exclude this promotion from specific date ranges.
   * @return blackoutDates
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Exclude this promotion from specific date ranges.")
  @JsonProperty(JSON_PROPERTY_BLACKOUT_DATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BlackoutDate> getBlackoutDates() {
    return blackoutDates;
  }


  @JsonProperty(JSON_PROPERTY_BLACKOUT_DATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBlackoutDates(List<BlackoutDate> blackoutDates) {
    this.blackoutDates = blackoutDates;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RateModifier rateModifier = (RateModifier) o;
    return Objects.equals(this.identifier, rateModifier.identifier) &&
        Objects.equals(this.hotelIdentifier, rateModifier.hotelIdentifier) &&
        Objects.equals(this.name, rateModifier.name) &&
        Objects.equals(this.type, rateModifier.type) &&
        Objects.equals(this.modifier, rateModifier.modifier) &&
        Objects.equals(this.enabled, rateModifier.enabled) &&
        Objects.equals(this.pricingType, rateModifier.pricingType) &&
        Objects.equals(this.descriptions, rateModifier.descriptions) &&
        Objects.equals(this.cityRateQualifiers, rateModifier.cityRateQualifiers) &&
        Objects.equals(this.continentRateQualifiers, rateModifier.continentRateQualifiers) &&
        Objects.equals(this.countryRateQualifiers, rateModifier.countryRateQualifiers) &&
        Objects.equals(this.promotionRateQualifiers, rateModifier.promotionRateQualifiers) &&
        Objects.equals(this.ipRangeRateQualifiers, rateModifier.ipRangeRateQualifiers) &&
        Objects.equals(this.roomRangeRateQualifier, rateModifier.roomRangeRateQualifier) &&
        Objects.equals(this.prepayRateQualifier, rateModifier.prepayRateQualifier) &&
        Objects.equals(this.refundableRateQualifier, rateModifier.refundableRateQualifier) &&
        Objects.equals(this.timezoneRateQualifiers, rateModifier.timezoneRateQualifiers) &&
        Objects.equals(this.lastMinuteRateQualifier, rateModifier.lastMinuteRateQualifier) &&
        Objects.equals(this.lengthOfStayRateQualifier, rateModifier.lengthOfStayRateQualifier) &&
        Objects.equals(this.advanceBookingRateQualifier, rateModifier.advanceBookingRateQualifier) &&
        Objects.equals(this.stayDateRateQualifiers, rateModifier.stayDateRateQualifiers) &&
        Objects.equals(this.sellDateRateQualifiers, rateModifier.sellDateRateQualifiers) &&
        Objects.equals(this.availableDaysOfWeekRateQualifier, rateModifier.availableDaysOfWeekRateQualifier) &&
        Objects.equals(this.arrivalDaysOfWeekRateQualifier, rateModifier.arrivalDaysOfWeekRateQualifier) &&
        Objects.equals(this.departureDaysOfWeekRateQualifier, rateModifier.departureDaysOfWeekRateQualifier) &&
        Objects.equals(this.requiredDaysOfWeekRateQualifier, rateModifier.requiredDaysOfWeekRateQualifier) &&
        Objects.equals(this.masterRateIdentifiers, rateModifier.masterRateIdentifiers) &&
        Objects.equals(this.packageIdentifiers, rateModifier.packageIdentifiers) &&
        Objects.equals(this.addOnIdentifiers, rateModifier.addOnIdentifiers) &&
        Objects.equals(this.ratePlanIdentifiers, rateModifier.ratePlanIdentifiers) &&
        Objects.equals(this.blackoutDates, rateModifier.blackoutDates);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, name, type, modifier, enabled, pricingType, descriptions, cityRateQualifiers, continentRateQualifiers, countryRateQualifiers, promotionRateQualifiers, ipRangeRateQualifiers, roomRangeRateQualifier, prepayRateQualifier, refundableRateQualifier, timezoneRateQualifiers, lastMinuteRateQualifier, lengthOfStayRateQualifier, advanceBookingRateQualifier, stayDateRateQualifiers, sellDateRateQualifiers, availableDaysOfWeekRateQualifier, arrivalDaysOfWeekRateQualifier, departureDaysOfWeekRateQualifier, requiredDaysOfWeekRateQualifier, masterRateIdentifiers, packageIdentifiers, addOnIdentifiers, ratePlanIdentifiers, blackoutDates);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RateModifier {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    modifier: ").append(toIndentedString(modifier)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    pricingType: ").append(toIndentedString(pricingType)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    cityRateQualifiers: ").append(toIndentedString(cityRateQualifiers)).append("\n");
    sb.append("    continentRateQualifiers: ").append(toIndentedString(continentRateQualifiers)).append("\n");
    sb.append("    countryRateQualifiers: ").append(toIndentedString(countryRateQualifiers)).append("\n");
    sb.append("    promotionRateQualifiers: ").append(toIndentedString(promotionRateQualifiers)).append("\n");
    sb.append("    ipRangeRateQualifiers: ").append(toIndentedString(ipRangeRateQualifiers)).append("\n");
    sb.append("    roomRangeRateQualifier: ").append(toIndentedString(roomRangeRateQualifier)).append("\n");
    sb.append("    prepayRateQualifier: ").append(toIndentedString(prepayRateQualifier)).append("\n");
    sb.append("    refundableRateQualifier: ").append(toIndentedString(refundableRateQualifier)).append("\n");
    sb.append("    timezoneRateQualifiers: ").append(toIndentedString(timezoneRateQualifiers)).append("\n");
    sb.append("    lastMinuteRateQualifier: ").append(toIndentedString(lastMinuteRateQualifier)).append("\n");
    sb.append("    lengthOfStayRateQualifier: ").append(toIndentedString(lengthOfStayRateQualifier)).append("\n");
    sb.append("    advanceBookingRateQualifier: ").append(toIndentedString(advanceBookingRateQualifier)).append("\n");
    sb.append("    stayDateRateQualifiers: ").append(toIndentedString(stayDateRateQualifiers)).append("\n");
    sb.append("    sellDateRateQualifiers: ").append(toIndentedString(sellDateRateQualifiers)).append("\n");
    sb.append("    availableDaysOfWeekRateQualifier: ").append(toIndentedString(availableDaysOfWeekRateQualifier)).append("\n");
    sb.append("    arrivalDaysOfWeekRateQualifier: ").append(toIndentedString(arrivalDaysOfWeekRateQualifier)).append("\n");
    sb.append("    departureDaysOfWeekRateQualifier: ").append(toIndentedString(departureDaysOfWeekRateQualifier)).append("\n");
    sb.append("    requiredDaysOfWeekRateQualifier: ").append(toIndentedString(requiredDaysOfWeekRateQualifier)).append("\n");
    sb.append("    masterRateIdentifiers: ").append(toIndentedString(masterRateIdentifiers)).append("\n");
    sb.append("    packageIdentifiers: ").append(toIndentedString(packageIdentifiers)).append("\n");
    sb.append("    addOnIdentifiers: ").append(toIndentedString(addOnIdentifiers)).append("\n");
    sb.append("    ratePlanIdentifiers: ").append(toIndentedString(ratePlanIdentifiers)).append("\n");
    sb.append("    blackoutDates: ").append(toIndentedString(blackoutDates)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

