/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

@ApiModel(description="Property address.")
@JsonPropertyOrder(value={"address1", "address2", "state", "postalCode", "vatId", "geoNameId"})
public class HotelAddress {
    public static final String JSON_PROPERTY_ADDRESS1 = "address1";
    private String address1;
    public static final String JSON_PROPERTY_ADDRESS2 = "address2";
    private String address2;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;
    public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
    private String postalCode;
    public static final String JSON_PROPERTY_VAT_ID = "vatId";
    private String vatId;
    public static final String JSON_PROPERTY_GEO_NAME_ID = "geoNameId";
    private String geoNameId;

    public HotelAddress address1(String address1) {
        this.address1 = address1;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="234 Near da beach", required=true, value="First line of property address.")
    @JsonProperty(value="address1")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAddress1() {
        return this.address1;
    }

    @JsonProperty(value="address1")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    public HotelAddress address2(String address2) {
        this.address2 = address2;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Pebble #5001", value="Second line of property address.")
    @JsonProperty(value="address2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAddress2() {
        return this.address2;
    }

    @JsonProperty(value="address2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    public HotelAddress state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="CA", value="Not all countries have states. Add the state if the property is in a country that contain states.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(String state) {
        this.state = state;
    }

    public HotelAddress postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="90210", required=true, value="Postal / zip code")
    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPostalCode() {
        return this.postalCode;
    }

    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public HotelAddress vatId(String vatId) {
        this.vatId = vatId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ABC1234", value="If property country requires a VAT identification number to operate, enter it here.")
    @JsonProperty(value="vatId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVatId() {
        return this.vatId;
    }

    @JsonProperty(value="vatId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVatId(String vatId) {
        this.vatId = vatId;
    }

    public HotelAddress geoNameId(String geoNameId) {
        this.geoNameId = geoNameId;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Beverly Hills", required=true, value="City / Island / Destination of property. See [GeoName reference]().")
    @JsonProperty(value="geoNameId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getGeoNameId() {
        return this.geoNameId;
    }

    @JsonProperty(value="geoNameId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGeoNameId(String geoNameId) {
        this.geoNameId = geoNameId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HotelAddress hotelAddress = (HotelAddress)o;
        return Objects.equals(this.address1, hotelAddress.address1) && Objects.equals(this.address2, hotelAddress.address2) && Objects.equals(this.state, hotelAddress.state) && Objects.equals(this.postalCode, hotelAddress.postalCode) && Objects.equals(this.vatId, hotelAddress.vatId) && Objects.equals(this.geoNameId, hotelAddress.geoNameId);
    }

    public int hashCode() {
        return Objects.hash(this.address1, this.address2, this.state, this.postalCode, this.vatId, this.geoNameId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HotelAddress {\n");
        sb.append("    address1: ").append(this.toIndentedString(this.address1)).append("\n");
        sb.append("    address2: ").append(this.toIndentedString(this.address2)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    vatId: ").append(this.toIndentedString(this.vatId)).append("\n");
        sb.append("    geoNameId: ").append(this.toIndentedString(this.geoNameId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

