/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.GuestRoomRemovableResponse;
import travel.wink.sdk.extranet.model.GuestRoomView;
import travel.wink.sdk.extranet.model.MasterRateRoom;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;

public class GuestRoomApi {
    private ApiClient apiClient;

    public GuestRoomApi() {
        this(new ApiClient());
    }

    @Autowired
    public GuestRoomApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec duplicateGuestRoomRequestCreation(String hotelIdentifier, String guestRoomIdentifier) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling duplicateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling duplicateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}/duplicate", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GuestRoomView> duplicateGuestRoom(String hotelIdentifier, String guestRoomIdentifier) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>(){};
        return this.duplicateGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GuestRoomView>> duplicateGuestRoomWithHttpInfo(String hotelIdentifier, String guestRoomIdentifier) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>(){};
        return this.duplicateGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removableGuestRoomRequestCreation(String hotelIdentifier, String guestRoomIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removableGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling removableGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<GuestRoomRemovableResponse> localVarReturnType = new ParameterizedTypeReference<GuestRoomRemovableResponse>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}/removable", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GuestRoomRemovableResponse> removableGuestRoom(String hotelIdentifier, String guestRoomIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomRemovableResponse> localVarReturnType = new ParameterizedTypeReference<GuestRoomRemovableResponse>(){};
        return this.removableGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GuestRoomRemovableResponse>> removableGuestRoomWithHttpInfo(String hotelIdentifier, String guestRoomIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomRemovableResponse> localVarReturnType = new ParameterizedTypeReference<GuestRoomRemovableResponse>(){};
        return this.removableGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removeGuestRoomRequestCreation(String hotelIdentifier, String guestRoomIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling removeGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removeGuestRoom(String hotelIdentifier, String guestRoomIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeGuestRoomWithHttpInfo(String hotelIdentifier, String guestRoomIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removeMultimedia2RequestCreation(String hotelIdentifier, String guestRoomIdentifier, String multimediaIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeMultimedia2", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling removeMultimedia2", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling removeMultimedia2", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GuestRoomView> removeMultimedia2(String hotelIdentifier, String guestRoomIdentifier, String multimediaIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>(){};
        return this.removeMultimedia2RequestCreation(hotelIdentifier, guestRoomIdentifier, multimediaIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GuestRoomView>> removeMultimedia2WithHttpInfo(String hotelIdentifier, String guestRoomIdentifier, String multimediaIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>(){};
        return this.removeMultimedia2RequestCreation(hotelIdentifier, guestRoomIdentifier, multimediaIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec saveGuestRoomRequestCreation(String hotelIdentifier, MasterRateRoom body) throws WebClientResponseException {
        MasterRateRoom postBody = body;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling saveGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (body == null) {
            throw new WebClientResponseException("Missing the required parameter 'body' when calling saveGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GuestRoomView> saveGuestRoom(String hotelIdentifier, MasterRateRoom body) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>(){};
        return this.saveGuestRoomRequestCreation(hotelIdentifier, body).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GuestRoomView>> saveGuestRoomWithHttpInfo(String hotelIdentifier, MasterRateRoom body) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>(){};
        return this.saveGuestRoomRequestCreation(hotelIdentifier, body).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showGuestRoomRequestCreation(String hotelIdentifier, String guestRoomIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling showGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GuestRoomView> showGuestRoom(String hotelIdentifier, String guestRoomIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>(){};
        return this.showGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GuestRoomView>> showGuestRoomWithHttpInfo(String hotelIdentifier, String guestRoomIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>(){};
        return this.showGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showGuestRoomsRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showGuestRooms", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<GuestRoomView> showGuestRooms(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>(){};
        return this.showGuestRoomsRequestCreation(hotelIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<GuestRoomView>>> showGuestRoomsWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>(){};
        return this.showGuestRoomsRequestCreation(hotelIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateGuestRoomRequestCreation(String hotelIdentifier, String guestRoomIdentifier, MasterRateRoom body) throws WebClientResponseException {
        MasterRateRoom postBody = body;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling updateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (body == null) {
            throw new WebClientResponseException("Missing the required parameter 'body' when calling updateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GuestRoomView> updateGuestRoom(String hotelIdentifier, String guestRoomIdentifier, MasterRateRoom body) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>(){};
        return this.updateGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, body).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GuestRoomView>> updateGuestRoomWithHttpInfo(String hotelIdentifier, String guestRoomIdentifier, MasterRateRoom body) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>(){};
        return this.updateGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, body).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec uploadGuestRoomMediaRequestCreation(String hotelIdentifier, String guestRoomIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadGuestRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling uploadGuestRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadGuestRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (files != null) {
            formParams.addAll((Object)"files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}/multimedia", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GuestRoomView> uploadGuestRoomMedia(String hotelIdentifier, String guestRoomIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>(){};
        return this.uploadGuestRoomMediaRequestCreation(hotelIdentifier, guestRoomIdentifier, files).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GuestRoomView>> uploadGuestRoomMediaWithHttpInfo(String hotelIdentifier, String guestRoomIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>(){};
        return this.uploadGuestRoomMediaRequestCreation(hotelIdentifier, guestRoomIdentifier, files).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

