/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.PropertyPolicy;

public class PolicyApi {
    private ApiClient apiClient;

    public PolicyApi() {
        this(new ApiClient());
    }

    @Autowired
    public PolicyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createPolicyRequestCreation(String hotelIdentifier, PropertyPolicy propertyPolicy) throws WebClientResponseException {
        PropertyPolicy postBody = propertyPolicy;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (propertyPolicy == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyPolicy' when calling createPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<PropertyPolicy> localVarReturnType = new ParameterizedTypeReference<PropertyPolicy>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/policy/property", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertyPolicy> createPolicy(String hotelIdentifier, PropertyPolicy propertyPolicy) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyPolicy> localVarReturnType = new ParameterizedTypeReference<PropertyPolicy>(){};
        return this.createPolicyRequestCreation(hotelIdentifier, propertyPolicy).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertyPolicy>> createPolicyWithHttpInfo(String hotelIdentifier, PropertyPolicy propertyPolicy) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyPolicy> localVarReturnType = new ParameterizedTypeReference<PropertyPolicy>(){};
        return this.createPolicyRequestCreation(hotelIdentifier, propertyPolicy).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showPropertyPolicyRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPropertyPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<PropertyPolicy> localVarReturnType = new ParameterizedTypeReference<PropertyPolicy>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/policy/property", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertyPolicy> showPropertyPolicy(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyPolicy> localVarReturnType = new ParameterizedTypeReference<PropertyPolicy>(){};
        return this.showPropertyPolicyRequestCreation(hotelIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertyPolicy>> showPropertyPolicyWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyPolicy> localVarReturnType = new ParameterizedTypeReference<PropertyPolicy>(){};
        return this.showPropertyPolicyRequestCreation(hotelIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updatePropertyPolicyRequestCreation(String hotelIdentifier, PropertyPolicy propertyPolicy) throws WebClientResponseException {
        PropertyPolicy postBody = propertyPolicy;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updatePropertyPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (propertyPolicy == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyPolicy' when calling updatePropertyPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<PropertyPolicy> localVarReturnType = new ParameterizedTypeReference<PropertyPolicy>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/policy/property", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertyPolicy> updatePropertyPolicy(String hotelIdentifier, PropertyPolicy propertyPolicy) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyPolicy> localVarReturnType = new ParameterizedTypeReference<PropertyPolicy>(){};
        return this.updatePropertyPolicyRequestCreation(hotelIdentifier, propertyPolicy).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertyPolicy>> updatePropertyPolicyWithHttpInfo(String hotelIdentifier, PropertyPolicy propertyPolicy) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyPolicy> localVarReturnType = new ParameterizedTypeReference<PropertyPolicy>(){};
        return this.updatePropertyPolicyRequestCreation(hotelIdentifier, propertyPolicy).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

