/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.CountResponse;
import travel.wink.sdk.extranet.model.PageReviewView;
import travel.wink.sdk.extranet.model.ReviewResponse;
import travel.wink.sdk.extranet.model.ReviewView;
import travel.wink.sdk.extranet.model.State;

public class ReviewApi {
    private ApiClient apiClient;

    public ReviewApi() {
        this(new ApiClient());
    }

    @Autowired
    public ReviewApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec respondToReviewRequestCreation(String hotelIdentifier, String reviewIdentifier, ReviewResponse reviewResponse) throws WebClientResponseException {
        ReviewResponse postBody = reviewResponse;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling respondToReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (reviewIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'reviewIdentifier' when calling respondToReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (reviewResponse == null) {
            throw new WebClientResponseException("Missing the required parameter 'reviewResponse' when calling respondToReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("reviewIdentifier", reviewIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<ReviewView> localVarReturnType = new ParameterizedTypeReference<ReviewView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/review/{reviewIdentifier}/response", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ReviewView> respondToReview(String hotelIdentifier, String reviewIdentifier, ReviewResponse reviewResponse) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewView> localVarReturnType = new ParameterizedTypeReference<ReviewView>(){};
        return this.respondToReviewRequestCreation(hotelIdentifier, reviewIdentifier, reviewResponse).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ReviewView>> respondToReviewWithHttpInfo(String hotelIdentifier, String reviewIdentifier, ReviewResponse reviewResponse) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewView> localVarReturnType = new ParameterizedTypeReference<ReviewView>(){};
        return this.respondToReviewRequestCreation(hotelIdentifier, reviewIdentifier, reviewResponse).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showReviewRequestCreation(String hotelIdentifier, String reviewIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (reviewIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'reviewIdentifier' when calling showReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("reviewIdentifier", reviewIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<ReviewView> localVarReturnType = new ParameterizedTypeReference<ReviewView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/review/{reviewIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ReviewView> showReview(String hotelIdentifier, String reviewIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewView> localVarReturnType = new ParameterizedTypeReference<ReviewView>(){};
        return this.showReviewRequestCreation(hotelIdentifier, reviewIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ReviewView>> showReviewWithHttpInfo(String hotelIdentifier, String reviewIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewView> localVarReturnType = new ParameterizedTypeReference<ReviewView>(){};
        return this.showReviewRequestCreation(hotelIdentifier, reviewIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showReviewCountRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showReviewCount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<CountResponse> localVarReturnType = new ParameterizedTypeReference<CountResponse>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/review/count", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CountResponse> showReviewCount(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponse> localVarReturnType = new ParameterizedTypeReference<CountResponse>(){};
        return this.showReviewCountRequestCreation(hotelIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CountResponse>> showReviewCountWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponse> localVarReturnType = new ParameterizedTypeReference<CountResponse>(){};
        return this.showReviewCountRequestCreation(hotelIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showReviewsRequestCreation(String hotelIdentifier, State state) throws WebClientResponseException {
        State postBody = state;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showReviews", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (state == null) {
            throw new WebClientResponseException("Missing the required parameter 'state' when calling showReviews", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<PageReviewView> localVarReturnType = new ParameterizedTypeReference<PageReviewView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/review/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageReviewView> showReviews(String hotelIdentifier, State state) throws WebClientResponseException {
        ParameterizedTypeReference<PageReviewView> localVarReturnType = new ParameterizedTypeReference<PageReviewView>(){};
        return this.showReviewsRequestCreation(hotelIdentifier, state).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageReviewView>> showReviewsWithHttpInfo(String hotelIdentifier, State state) throws WebClientResponseException {
        ParameterizedTypeReference<PageReviewView> localVarReturnType = new ParameterizedTypeReference<PageReviewView>(){};
        return this.showReviewsRequestCreation(hotelIdentifier, state).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

