package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.InventoryUpdateRequest;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.SalesChannel;
import travel.wink.sdk.extranet.model.SalesChannelCreateRequest;
import travel.wink.sdk.extranet.model.SalesChannelUpdateRequest;
import travel.wink.sdk.extranet.model.SelectableKeyValuePair;
import travel.wink.sdk.extranet.model.ShowHotelStatus400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-28T13:49:39.867864+07:00[Asia/Bangkok]")
public class SalesChannelsApi {
    private ApiClient apiClient;

    public SalesChannelsApi() {
        this(new ApiClient());
    }

    @Autowired
    public SalesChannelsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create sales channel
     * Create a new sales channel.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create sales channel and associate it with this hotel identifier
     * @param salesChannelCreateRequest The salesChannelCreateRequest parameter
     * @return SalesChannel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createSalesChannelRequestCreation(String hotelIdentifier, SalesChannelCreateRequest salesChannelCreateRequest) throws WebClientResponseException {
        Object postBody = salesChannelCreateRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'salesChannelCreateRequest' is set
        if (salesChannelCreateRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelCreateRequest' when calling createSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create sales channel
     * Create a new sales channel.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create sales channel and associate it with this hotel identifier
     * @param salesChannelCreateRequest The salesChannelCreateRequest parameter
     * @return SalesChannel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SalesChannel> createSalesChannel(String hotelIdentifier, SalesChannelCreateRequest salesChannelCreateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>() {};
        return createSalesChannelRequestCreation(hotelIdentifier, salesChannelCreateRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannel>> createSalesChannelWithHttpInfo(String hotelIdentifier, SalesChannelCreateRequest salesChannelCreateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>() {};
        return createSalesChannelRequestCreation(hotelIdentifier, salesChannelCreateRequest).toEntity(localVarReturnType);
    }
    /**
     * Remove sales channel
     * Delete a specific sales channel
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove sales channel owned by this hotel identifier
     * @param salesChannelIdentifier Remove sales channel with this identifier
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeSalesChannelRequestCreation(String hotelIdentifier, String salesChannelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'salesChannelIdentifier' is set
        if (salesChannelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelIdentifier' when calling removeSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("salesChannelIdentifier", salesChannelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/{salesChannelIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove sales channel
     * Delete a specific sales channel
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove sales channel owned by this hotel identifier
     * @param salesChannelIdentifier Remove sales channel with this identifier
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeSalesChannel(String hotelIdentifier, String salesChannelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeSalesChannelWithHttpInfo(String hotelIdentifier, String salesChannelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show sales channels
     * Retrieve list of all sales channels for this property. You can decide to retrieve all specific sales channel relationships or only generic ones using the &#39;owner&#39; request parameter.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all sales channels for this hotel identifier
     * @param accept The accept parameter
     * @return List&lt;SalesChannel&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAccountsRequestCreation(String hotelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAccounts", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show sales channels
     * Retrieve list of all sales channels for this property. You can decide to retrieve all specific sales channel relationships or only generic ones using the &#39;owner&#39; request parameter.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all sales channels for this hotel identifier
     * @param accept The accept parameter
     * @return List&lt;SalesChannel&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<SalesChannel> showAccounts(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>() {};
        return showAccountsRequestCreation(hotelIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<SalesChannel>>> showAccountsWithHttpInfo(String hotelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>() {};
        return showAccountsRequestCreation(hotelIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Show sales channel
     * Retrieve a specific sales channel by identifier.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show sales channel owned by this hotel identifier
     * @param salesChannelIdentifier Show sales channel with this hotel identifier
     * @param accept The accept parameter
     * @return SalesChannel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSalesChannelRequestCreation(String hotelIdentifier, String salesChannelIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'salesChannelIdentifier' is set
        if (salesChannelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelIdentifier' when calling showSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("salesChannelIdentifier", salesChannelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/{salesChannelIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show sales channel
     * Retrieve a specific sales channel by identifier.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show sales channel owned by this hotel identifier
     * @param salesChannelIdentifier Show sales channel with this hotel identifier
     * @param accept The accept parameter
     * @return SalesChannel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SalesChannel> showSalesChannel(String hotelIdentifier, String salesChannelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>() {};
        return showSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannel>> showSalesChannelWithHttpInfo(String hotelIdentifier, String salesChannelIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>() {};
        return showSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show rate modifier bundle availability
     * Display a list of key / value pairs that shows the availability of sales channels in the context of rate modifier bundles.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all sales channel pairs for this hotel identifier
     * @param rateModifierBundleIdentifier Show all sales channels pairs in the context of rate modifier availability
     * @param accept The accept parameter
     * @return List&lt;SelectableKeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSalesChannelContextRateModifierBundlePairsRequestCreation(String hotelIdentifier, String rateModifierBundleIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showSalesChannelContextRateModifierBundlePairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'rateModifierBundleIdentifier' is set
        if (rateModifierBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierBundleIdentifier' when calling showSalesChannelContextRateModifierBundlePairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("rateModifierBundleIdentifier", rateModifierBundleIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SelectableKeyValuePair> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePair>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/promobundle/{rateModifierBundleIdentifier}/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show rate modifier bundle availability
     * Display a list of key / value pairs that shows the availability of sales channels in the context of rate modifier bundles.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all sales channel pairs for this hotel identifier
     * @param rateModifierBundleIdentifier Show all sales channels pairs in the context of rate modifier availability
     * @param accept The accept parameter
     * @return List&lt;SelectableKeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<SelectableKeyValuePair> showSalesChannelContextRateModifierBundlePairs(String hotelIdentifier, String rateModifierBundleIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePair> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePair>() {};
        return showSalesChannelContextRateModifierBundlePairsRequestCreation(hotelIdentifier, rateModifierBundleIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<SelectableKeyValuePair>>> showSalesChannelContextRateModifierBundlePairsWithHttpInfo(String hotelIdentifier, String rateModifierBundleIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePair> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePair>() {};
        return showSalesChannelContextRateModifierBundlePairsRequestCreation(hotelIdentifier, rateModifierBundleIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Show rate modifier availability
     * Display a list of key / value pairs that shows the availability of sales channels in the context of rate modifiers.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all sales channel pairs for this hotel identifier
     * @param rateModifierIdentifier Show all sales channels pairs in the context of rate modifier availability
     * @param accept The accept parameter
     * @return List&lt;SelectableKeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSalesChannelContextRateModifierPairsRequestCreation(String hotelIdentifier, String rateModifierIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showSalesChannelContextRateModifierPairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'rateModifierIdentifier' is set
        if (rateModifierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierIdentifier' when calling showSalesChannelContextRateModifierPairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("rateModifierIdentifier", rateModifierIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SelectableKeyValuePair> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePair>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/promo/{rateModifierIdentifier}/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show rate modifier availability
     * Display a list of key / value pairs that shows the availability of sales channels in the context of rate modifiers.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all sales channel pairs for this hotel identifier
     * @param rateModifierIdentifier Show all sales channels pairs in the context of rate modifier availability
     * @param accept The accept parameter
     * @return List&lt;SelectableKeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<SelectableKeyValuePair> showSalesChannelContextRateModifierPairs(String hotelIdentifier, String rateModifierIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePair> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePair>() {};
        return showSalesChannelContextRateModifierPairsRequestCreation(hotelIdentifier, rateModifierIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<SelectableKeyValuePair>>> showSalesChannelContextRateModifierPairsWithHttpInfo(String hotelIdentifier, String rateModifierIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePair> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePair>() {};
        return showSalesChannelContextRateModifierPairsRequestCreation(hotelIdentifier, rateModifierIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Update sale channels promos
     * Toggles availability of a promo for a list of sales channels
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update sales channel owned by this hotel identifier
     * @param rateModifierIdentifier The rate modifier we are enabling / disabling on the sales channel
     * @param inventoryUpdateRequest The inventoryUpdateRequest parameter
     * @return List&lt;SalesChannel&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec toggleSalesChannelPromoAvailabilityRequestCreation(String hotelIdentifier, String rateModifierIdentifier, List<InventoryUpdateRequest> inventoryUpdateRequest) throws WebClientResponseException {
        Object postBody = inventoryUpdateRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling toggleSalesChannelPromoAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'rateModifierIdentifier' is set
        if (rateModifierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierIdentifier' when calling toggleSalesChannelPromoAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'inventoryUpdateRequest' is set
        if (inventoryUpdateRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryUpdateRequest' when calling toggleSalesChannelPromoAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("rateModifierIdentifier", rateModifierIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/promo/{rateModifierIdentifier}/list", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update sale channels promos
     * Toggles availability of a promo for a list of sales channels
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update sales channel owned by this hotel identifier
     * @param rateModifierIdentifier The rate modifier we are enabling / disabling on the sales channel
     * @param inventoryUpdateRequest The inventoryUpdateRequest parameter
     * @return List&lt;SalesChannel&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<SalesChannel> toggleSalesChannelPromoAvailability(String hotelIdentifier, String rateModifierIdentifier, List<InventoryUpdateRequest> inventoryUpdateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>() {};
        return toggleSalesChannelPromoAvailabilityRequestCreation(hotelIdentifier, rateModifierIdentifier, inventoryUpdateRequest).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<SalesChannel>>> toggleSalesChannelPromoAvailabilityWithHttpInfo(String hotelIdentifier, String rateModifierIdentifier, List<InventoryUpdateRequest> inventoryUpdateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>() {};
        return toggleSalesChannelPromoAvailabilityRequestCreation(hotelIdentifier, rateModifierIdentifier, inventoryUpdateRequest).toEntityList(localVarReturnType);
    }
    /**
     * Update sale channels promo bundles
     * Toggles availability of a promo bundle for a list of sales channels
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update sales channel owned by this hotel identifier
     * @param rateModifierBundleIdentifier The rate modifier bundle we are enabling / disabling on the sales channel
     * @param inventoryUpdateRequest The inventoryUpdateRequest parameter
     * @return List&lt;SalesChannel&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec toggleSalesChannelPromoBundleAvailabilityRequestCreation(String hotelIdentifier, String rateModifierBundleIdentifier, List<InventoryUpdateRequest> inventoryUpdateRequest) throws WebClientResponseException {
        Object postBody = inventoryUpdateRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling toggleSalesChannelPromoBundleAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'rateModifierBundleIdentifier' is set
        if (rateModifierBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierBundleIdentifier' when calling toggleSalesChannelPromoBundleAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'inventoryUpdateRequest' is set
        if (inventoryUpdateRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryUpdateRequest' when calling toggleSalesChannelPromoBundleAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("rateModifierBundleIdentifier", rateModifierBundleIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/promobundle/{rateModifierBundleIdentifier}/list", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update sale channels promo bundles
     * Toggles availability of a promo bundle for a list of sales channels
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update sales channel owned by this hotel identifier
     * @param rateModifierBundleIdentifier The rate modifier bundle we are enabling / disabling on the sales channel
     * @param inventoryUpdateRequest The inventoryUpdateRequest parameter
     * @return List&lt;SalesChannel&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<SalesChannel> toggleSalesChannelPromoBundleAvailability(String hotelIdentifier, String rateModifierBundleIdentifier, List<InventoryUpdateRequest> inventoryUpdateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>() {};
        return toggleSalesChannelPromoBundleAvailabilityRequestCreation(hotelIdentifier, rateModifierBundleIdentifier, inventoryUpdateRequest).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<SalesChannel>>> toggleSalesChannelPromoBundleAvailabilityWithHttpInfo(String hotelIdentifier, String rateModifierBundleIdentifier, List<InventoryUpdateRequest> inventoryUpdateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>() {};
        return toggleSalesChannelPromoBundleAvailabilityRequestCreation(hotelIdentifier, rateModifierBundleIdentifier, inventoryUpdateRequest).toEntityList(localVarReturnType);
    }
    /**
     * Update sales channel
     * Update a chosen sales channel
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update sales channel owned by this hotel identifier
     * @param salesChannelIdentifier Update sales channel settings for sales channel with this identifier
     * @param salesChannelUpdateRequest The salesChannelUpdateRequest parameter
     * @return SalesChannel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateSalesChannelRequestCreation(String hotelIdentifier, String salesChannelIdentifier, SalesChannelUpdateRequest salesChannelUpdateRequest) throws WebClientResponseException {
        Object postBody = salesChannelUpdateRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'salesChannelIdentifier' is set
        if (salesChannelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelIdentifier' when calling updateSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'salesChannelUpdateRequest' is set
        if (salesChannelUpdateRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelUpdateRequest' when calling updateSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("salesChannelIdentifier", salesChannelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/{salesChannelIdentifier}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update sales channel
     * Update a chosen sales channel
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update sales channel owned by this hotel identifier
     * @param salesChannelIdentifier Update sales channel settings for sales channel with this identifier
     * @param salesChannelUpdateRequest The salesChannelUpdateRequest parameter
     * @return SalesChannel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SalesChannel> updateSalesChannel(String hotelIdentifier, String salesChannelIdentifier, SalesChannelUpdateRequest salesChannelUpdateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>() {};
        return updateSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, salesChannelUpdateRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannel>> updateSalesChannelWithHttpInfo(String hotelIdentifier, String salesChannelIdentifier, SalesChannelUpdateRequest salesChannelUpdateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannel> localVarReturnType = new ParameterizedTypeReference<SalesChannel>() {};
        return updateSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, salesChannelUpdateRequest).toEntity(localVarReturnType);
    }
}
