/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 19.0.14-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.extranet.model.Moneys;
import travel.wink.sdk.extranet.model.Quote;
import travel.wink.sdk.extranet.model.Rate;
import travel.wink.sdk.extranet.model.SimpleDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * DailyRate
 */
@JsonPropertyOrder({
  DailyRate.JSON_PROPERTY_SOURCE_BASE_RATE,
  DailyRate.JSON_PROPERTY_INTERNAL_BASE_RATE,
  DailyRate.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_RATE,
  DailyRate.JSON_PROPERTY_SOURCE_EXTRA_PAX_MODIFIER,
  DailyRate.JSON_PROPERTY_INTERNAL_EXTRA_PAX_MODIFIER,
  DailyRate.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_PAX_MODIFIER,
  DailyRate.JSON_PROPERTY_SOURCE_EXTRA_CHILD_MODIFIER,
  DailyRate.JSON_PROPERTY_INTERNAL_EXTRA_CHILD_MODIFIER,
  DailyRate.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_CHILD_MODIFIER,
  DailyRate.JSON_PROPERTY_SOURCE_SINGLE_OCCUPANT_MODIFIER,
  DailyRate.JSON_PROPERTY_INTERNAL_SINGLE_OCCUPANT_MODIFIER,
  DailyRate.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_SINGLE_OCCUPANT_MODIFIER,
  DailyRate.JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER,
  DailyRate.JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER,
  DailyRate.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER,
  DailyRate.JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER,
  DailyRate.JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER,
  DailyRate.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER,
  DailyRate.JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER,
  DailyRate.JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER,
  DailyRate.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER,
  DailyRate.JSON_PROPERTY_AVAILABLE,
  DailyRate.JSON_PROPERTY_OFFER_DETAILS,
  DailyRate.JSON_PROPERTY_HAS_MODIFICATION,
  DailyRate.JSON_PROPERTY_HAS_CHANNEL_DISCOUNT,
  DailyRate.JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT,
  DailyRate.JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT,
  DailyRate.JSON_PROPERTY_PREMIUM_PERCENT,
  DailyRate.JSON_PROPERTY_PROMOTION,
  DailyRate.JSON_PROPERTY_ADULTS,
  DailyRate.JSON_PROPERTY_CHILDREN,
  DailyRate.JSON_PROPERTY_RATE,
  DailyRate.JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE,
  DailyRate.JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE,
  DailyRate.JSON_PROPERTY_PHANTOM,
  DailyRate.JSON_PROPERTY_SOURCE,
  DailyRate.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_RATE,
  DailyRate.JSON_PROPERTY_START_DATE,
  DailyRate.JSON_PROPERTY_BETWEEN_DATE,
  DailyRate.JSON_PROPERTY_LAST_NIGHT,
  DailyRate.JSON_PROPERTY_BUNDLED_MODIFIER,
  DailyRate.JSON_PROPERTY_CLOSE_ON_DEPARTURE,
  DailyRate.JSON_PROPERTY_INVENTORY_AVAILABLE,
  DailyRate.JSON_PROPERTY_MASTER_AVAILABILITY,
  DailyRate.JSON_PROPERTY_CLOSE_ON_ARRIVAL,
  DailyRate.JSON_PROPERTY_RATE_IDENTIFIER,
  DailyRate.JSON_PROPERTY_INTERNAL_RATE,
  DailyRate.JSON_PROPERTY_BASE_RATE,
  DailyRate.JSON_PROPERTY_QUANTITY,
  DailyRate.JSON_PROPERTY_SOURCE_RATE,
  DailyRate.JSON_PROPERTY_MIN_OCCUPANCY,
  DailyRate.JSON_PROPERTY_MAX_OCCUPANCY,
  DailyRate.JSON_PROPERTY_MAX_CHILD_OCCUPANCY,
  DailyRate.JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT,
  DailyRate.JSON_PROPERTY_MIN_L_O_S,
  DailyRate.JSON_PROPERTY_MAX_L_O_S,
  DailyRate.JSON_PROPERTY_END_DATE,
  DailyRate.JSON_PROPERTY_DATE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-28T13:49:39.867864+07:00[Asia/Bangkok]")
public class DailyRate {
  public static final String JSON_PROPERTY_SOURCE_BASE_RATE = "sourceBaseRate";
  private Moneys sourceBaseRate;

  public static final String JSON_PROPERTY_INTERNAL_BASE_RATE = "internalBaseRate";
  private Moneys internalBaseRate;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_RATE = "userSpecifiedCurrencyBaseRate";
  private Moneys userSpecifiedCurrencyBaseRate;

  public static final String JSON_PROPERTY_SOURCE_EXTRA_PAX_MODIFIER = "sourceExtraPaxModifier";
  private Double sourceExtraPaxModifier;

  public static final String JSON_PROPERTY_INTERNAL_EXTRA_PAX_MODIFIER = "internalExtraPaxModifier";
  private Double internalExtraPaxModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_PAX_MODIFIER = "userSpecifiedCurrencyExtraPaxModifier";
  private Double userSpecifiedCurrencyExtraPaxModifier;

  public static final String JSON_PROPERTY_SOURCE_EXTRA_CHILD_MODIFIER = "sourceExtraChildModifier";
  private Double sourceExtraChildModifier;

  public static final String JSON_PROPERTY_INTERNAL_EXTRA_CHILD_MODIFIER = "internalExtraChildModifier";
  private Double internalExtraChildModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_CHILD_MODIFIER = "userSpecifiedCurrencyExtraChildModifier";
  private Double userSpecifiedCurrencyExtraChildModifier;

  public static final String JSON_PROPERTY_SOURCE_SINGLE_OCCUPANT_MODIFIER = "sourceSingleOccupantModifier";
  private Double sourceSingleOccupantModifier;

  public static final String JSON_PROPERTY_INTERNAL_SINGLE_OCCUPANT_MODIFIER = "internalSingleOccupantModifier";
  private Double internalSingleOccupantModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_SINGLE_OCCUPANT_MODIFIER = "userSpecifiedCurrencySingleOccupantModifier";
  private Double userSpecifiedCurrencySingleOccupantModifier;

  public static final String JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER = "sourcePromotionalModifier";
  private Double sourcePromotionalModifier;

  public static final String JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER = "internalPromotionalModifier";
  private Double internalPromotionalModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER = "userSpecifiedCurrencyPromotionalModifier";
  private Double userSpecifiedCurrencyPromotionalModifier;

  public static final String JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER = "sourcePremiumModifier";
  private Double sourcePremiumModifier;

  public static final String JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER = "internalPremiumModifier";
  private Double internalPremiumModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER = "userSpecifiedCurrencyPremiumModifier";
  private Double userSpecifiedCurrencyPremiumModifier;

  public static final String JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER = "sourceChannelModifier";
  private Double sourceChannelModifier;

  public static final String JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER = "internalChannelModifier";
  private Double internalChannelModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER = "userSpecifiedCurrencyChannelModifier";
  private Double userSpecifiedCurrencyChannelModifier;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Boolean available;

  public static final String JSON_PROPERTY_OFFER_DETAILS = "offerDetails";
  private List<SimpleDescription> offerDetails = null;

  public static final String JSON_PROPERTY_HAS_MODIFICATION = "hasModification";
  private Boolean hasModification;

  public static final String JSON_PROPERTY_HAS_CHANNEL_DISCOUNT = "hasChannelDiscount";
  private Boolean hasChannelDiscount;

  public static final String JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT = "channelDiscountPercent";
  private Float channelDiscountPercent;

  public static final String JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT = "promotionalDiscountPercent";
  private Float promotionalDiscountPercent;

  public static final String JSON_PROPERTY_PREMIUM_PERCENT = "premiumPercent";
  private Float premiumPercent;

  public static final String JSON_PROPERTY_PROMOTION = "promotion";
  private String promotion;

  public static final String JSON_PROPERTY_ADULTS = "adults";
  private Integer adults;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  private Integer children;

  public static final String JSON_PROPERTY_RATE = "rate";
  private Rate rate;

  public static final String JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE = "sourceToUserCurrencyQuote";
  private Quote sourceToUserCurrencyQuote;

  public static final String JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE = "sourceToInternalCurrencyQuote";
  private Quote sourceToInternalCurrencyQuote;

  public static final String JSON_PROPERTY_PHANTOM = "phantom";
  private Boolean phantom;

  /**
   * Gets or Sets source
   */
  public enum SourceEnum {
    TRAVELIKO("TRAVELIKO"),
    
    SITEMINDER("SITEMINDER"),
    
    FASTBOOKING("FASTBOOKING"),
    
    RATEGAIN("RATEGAIN"),
    
    CLOUD_BEDS("CLOUD_BEDS"),
    
    YIELD_PLANET("YIELD_PLANET"),
    
    TRAVELCLICK("TRAVELCLICK"),
    
    HOTEL_GURU("HOTEL_GURU"),
    
    OTHER_CHANNEL_MANAGER("OTHER_CHANNEL_MANAGER"),
    
    BOOKING_JINI("BOOKING_JINI"),
    
    HOTEL_LINK_SOLUTIONS("HOTEL_LINK_SOLUTIONS"),
    
    ALLOTZ("ALLOTZ"),
    
    DEDGE("DEDGE"),
    
    RATE_TIGER("RATE_TIGER"),
    
    RESAVENUE("RESAVENUE"),
    
    COMANCHE("COMANCHE"),
    
    OMNIBEES("OMNIBEES"),
    
    EZEE("EZEE"),
    
    SYNXIS("SYNXIS");

    private String value;

    SourceEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SourceEnum fromValue(String value) {
      for (SourceEnum b : SourceEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SOURCE = "source";
  private SourceEnum source;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_RATE = "userSpecifiedCurrencyRate";
  private Moneys userSpecifiedCurrencyRate;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private Boolean startDate;

  public static final String JSON_PROPERTY_BETWEEN_DATE = "betweenDate";
  private Boolean betweenDate;

  public static final String JSON_PROPERTY_LAST_NIGHT = "lastNight";
  private Boolean lastNight;

  public static final String JSON_PROPERTY_BUNDLED_MODIFIER = "bundledModifier";
  private Boolean bundledModifier;

  public static final String JSON_PROPERTY_CLOSE_ON_DEPARTURE = "closeOnDeparture";
  private Boolean closeOnDeparture;

  public static final String JSON_PROPERTY_INVENTORY_AVAILABLE = "inventoryAvailable";
  private Boolean inventoryAvailable;

  public static final String JSON_PROPERTY_MASTER_AVAILABILITY = "masterAvailability";
  private Boolean masterAvailability;

  public static final String JSON_PROPERTY_CLOSE_ON_ARRIVAL = "closeOnArrival";
  private Boolean closeOnArrival;

  public static final String JSON_PROPERTY_RATE_IDENTIFIER = "rateIdentifier";
  private String rateIdentifier;

  public static final String JSON_PROPERTY_INTERNAL_RATE = "internalRate";
  private Moneys internalRate;

  public static final String JSON_PROPERTY_BASE_RATE = "baseRate";
  private Moneys baseRate;

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  private Integer quantity;

  public static final String JSON_PROPERTY_SOURCE_RATE = "sourceRate";
  private Moneys sourceRate;

  public static final String JSON_PROPERTY_MIN_OCCUPANCY = "minOccupancy";
  private Integer minOccupancy;

  public static final String JSON_PROPERTY_MAX_OCCUPANCY = "maxOccupancy";
  private Integer maxOccupancy;

  public static final String JSON_PROPERTY_MAX_CHILD_OCCUPANCY = "maxChildOccupancy";
  private Integer maxChildOccupancy;

  public static final String JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT = "totalDiscountPercent";
  private Float totalDiscountPercent;

  public static final String JSON_PROPERTY_MIN_L_O_S = "minLOS";
  private Integer minLOS;

  public static final String JSON_PROPERTY_MAX_L_O_S = "maxLOS";
  private Integer maxLOS;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private Boolean endDate;

  public static final String JSON_PROPERTY_DATE = "date";
  private LocalDate date;

  public DailyRate() { 
  }

  public DailyRate sourceBaseRate(Moneys sourceBaseRate) {
    
    this.sourceBaseRate = sourceBaseRate;
    return this;
  }

   /**
   * Get sourceBaseRate
   * @return sourceBaseRate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_BASE_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getSourceBaseRate() {
    return sourceBaseRate;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_BASE_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceBaseRate(Moneys sourceBaseRate) {
    this.sourceBaseRate = sourceBaseRate;
  }


  public DailyRate internalBaseRate(Moneys internalBaseRate) {
    
    this.internalBaseRate = internalBaseRate;
    return this;
  }

   /**
   * Get internalBaseRate
   * @return internalBaseRate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_BASE_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getInternalBaseRate() {
    return internalBaseRate;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_BASE_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalBaseRate(Moneys internalBaseRate) {
    this.internalBaseRate = internalBaseRate;
  }


  public DailyRate userSpecifiedCurrencyBaseRate(Moneys userSpecifiedCurrencyBaseRate) {
    
    this.userSpecifiedCurrencyBaseRate = userSpecifiedCurrencyBaseRate;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyBaseRate
   * @return userSpecifiedCurrencyBaseRate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getUserSpecifiedCurrencyBaseRate() {
    return userSpecifiedCurrencyBaseRate;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyBaseRate(Moneys userSpecifiedCurrencyBaseRate) {
    this.userSpecifiedCurrencyBaseRate = userSpecifiedCurrencyBaseRate;
  }


  public DailyRate sourceExtraPaxModifier(Double sourceExtraPaxModifier) {
    
    this.sourceExtraPaxModifier = sourceExtraPaxModifier;
    return this;
  }

   /**
   * Get sourceExtraPaxModifier
   * @return sourceExtraPaxModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourceExtraPaxModifier() {
    return sourceExtraPaxModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceExtraPaxModifier(Double sourceExtraPaxModifier) {
    this.sourceExtraPaxModifier = sourceExtraPaxModifier;
  }


  public DailyRate internalExtraPaxModifier(Double internalExtraPaxModifier) {
    
    this.internalExtraPaxModifier = internalExtraPaxModifier;
    return this;
  }

   /**
   * Get internalExtraPaxModifier
   * @return internalExtraPaxModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalExtraPaxModifier() {
    return internalExtraPaxModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalExtraPaxModifier(Double internalExtraPaxModifier) {
    this.internalExtraPaxModifier = internalExtraPaxModifier;
  }


  public DailyRate userSpecifiedCurrencyExtraPaxModifier(Double userSpecifiedCurrencyExtraPaxModifier) {
    
    this.userSpecifiedCurrencyExtraPaxModifier = userSpecifiedCurrencyExtraPaxModifier;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyExtraPaxModifier
   * @return userSpecifiedCurrencyExtraPaxModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUserSpecifiedCurrencyExtraPaxModifier() {
    return userSpecifiedCurrencyExtraPaxModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyExtraPaxModifier(Double userSpecifiedCurrencyExtraPaxModifier) {
    this.userSpecifiedCurrencyExtraPaxModifier = userSpecifiedCurrencyExtraPaxModifier;
  }


  public DailyRate sourceExtraChildModifier(Double sourceExtraChildModifier) {
    
    this.sourceExtraChildModifier = sourceExtraChildModifier;
    return this;
  }

   /**
   * Get sourceExtraChildModifier
   * @return sourceExtraChildModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourceExtraChildModifier() {
    return sourceExtraChildModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceExtraChildModifier(Double sourceExtraChildModifier) {
    this.sourceExtraChildModifier = sourceExtraChildModifier;
  }


  public DailyRate internalExtraChildModifier(Double internalExtraChildModifier) {
    
    this.internalExtraChildModifier = internalExtraChildModifier;
    return this;
  }

   /**
   * Get internalExtraChildModifier
   * @return internalExtraChildModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalExtraChildModifier() {
    return internalExtraChildModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalExtraChildModifier(Double internalExtraChildModifier) {
    this.internalExtraChildModifier = internalExtraChildModifier;
  }


  public DailyRate userSpecifiedCurrencyExtraChildModifier(Double userSpecifiedCurrencyExtraChildModifier) {
    
    this.userSpecifiedCurrencyExtraChildModifier = userSpecifiedCurrencyExtraChildModifier;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyExtraChildModifier
   * @return userSpecifiedCurrencyExtraChildModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUserSpecifiedCurrencyExtraChildModifier() {
    return userSpecifiedCurrencyExtraChildModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyExtraChildModifier(Double userSpecifiedCurrencyExtraChildModifier) {
    this.userSpecifiedCurrencyExtraChildModifier = userSpecifiedCurrencyExtraChildModifier;
  }


  public DailyRate sourceSingleOccupantModifier(Double sourceSingleOccupantModifier) {
    
    this.sourceSingleOccupantModifier = sourceSingleOccupantModifier;
    return this;
  }

   /**
   * Get sourceSingleOccupantModifier
   * @return sourceSingleOccupantModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourceSingleOccupantModifier() {
    return sourceSingleOccupantModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceSingleOccupantModifier(Double sourceSingleOccupantModifier) {
    this.sourceSingleOccupantModifier = sourceSingleOccupantModifier;
  }


  public DailyRate internalSingleOccupantModifier(Double internalSingleOccupantModifier) {
    
    this.internalSingleOccupantModifier = internalSingleOccupantModifier;
    return this;
  }

   /**
   * Get internalSingleOccupantModifier
   * @return internalSingleOccupantModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalSingleOccupantModifier() {
    return internalSingleOccupantModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalSingleOccupantModifier(Double internalSingleOccupantModifier) {
    this.internalSingleOccupantModifier = internalSingleOccupantModifier;
  }


  public DailyRate userSpecifiedCurrencySingleOccupantModifier(Double userSpecifiedCurrencySingleOccupantModifier) {
    
    this.userSpecifiedCurrencySingleOccupantModifier = userSpecifiedCurrencySingleOccupantModifier;
    return this;
  }

   /**
   * Get userSpecifiedCurrencySingleOccupantModifier
   * @return userSpecifiedCurrencySingleOccupantModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUserSpecifiedCurrencySingleOccupantModifier() {
    return userSpecifiedCurrencySingleOccupantModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencySingleOccupantModifier(Double userSpecifiedCurrencySingleOccupantModifier) {
    this.userSpecifiedCurrencySingleOccupantModifier = userSpecifiedCurrencySingleOccupantModifier;
  }


  public DailyRate sourcePromotionalModifier(Double sourcePromotionalModifier) {
    
    this.sourcePromotionalModifier = sourcePromotionalModifier;
    return this;
  }

   /**
   * Get sourcePromotionalModifier
   * @return sourcePromotionalModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourcePromotionalModifier() {
    return sourcePromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourcePromotionalModifier(Double sourcePromotionalModifier) {
    this.sourcePromotionalModifier = sourcePromotionalModifier;
  }


  public DailyRate internalPromotionalModifier(Double internalPromotionalModifier) {
    
    this.internalPromotionalModifier = internalPromotionalModifier;
    return this;
  }

   /**
   * Get internalPromotionalModifier
   * @return internalPromotionalModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalPromotionalModifier() {
    return internalPromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalPromotionalModifier(Double internalPromotionalModifier) {
    this.internalPromotionalModifier = internalPromotionalModifier;
  }


  public DailyRate userSpecifiedCurrencyPromotionalModifier(Double userSpecifiedCurrencyPromotionalModifier) {
    
    this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyPromotionalModifier
   * @return userSpecifiedCurrencyPromotionalModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUserSpecifiedCurrencyPromotionalModifier() {
    return userSpecifiedCurrencyPromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyPromotionalModifier(Double userSpecifiedCurrencyPromotionalModifier) {
    this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
  }


  public DailyRate sourcePremiumModifier(Double sourcePremiumModifier) {
    
    this.sourcePremiumModifier = sourcePremiumModifier;
    return this;
  }

   /**
   * Get sourcePremiumModifier
   * @return sourcePremiumModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourcePremiumModifier() {
    return sourcePremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourcePremiumModifier(Double sourcePremiumModifier) {
    this.sourcePremiumModifier = sourcePremiumModifier;
  }


  public DailyRate internalPremiumModifier(Double internalPremiumModifier) {
    
    this.internalPremiumModifier = internalPremiumModifier;
    return this;
  }

   /**
   * Get internalPremiumModifier
   * @return internalPremiumModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalPremiumModifier() {
    return internalPremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalPremiumModifier(Double internalPremiumModifier) {
    this.internalPremiumModifier = internalPremiumModifier;
  }


  public DailyRate userSpecifiedCurrencyPremiumModifier(Double userSpecifiedCurrencyPremiumModifier) {
    
    this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyPremiumModifier
   * @return userSpecifiedCurrencyPremiumModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUserSpecifiedCurrencyPremiumModifier() {
    return userSpecifiedCurrencyPremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyPremiumModifier(Double userSpecifiedCurrencyPremiumModifier) {
    this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
  }


  public DailyRate sourceChannelModifier(Double sourceChannelModifier) {
    
    this.sourceChannelModifier = sourceChannelModifier;
    return this;
  }

   /**
   * Get sourceChannelModifier
   * @return sourceChannelModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourceChannelModifier() {
    return sourceChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceChannelModifier(Double sourceChannelModifier) {
    this.sourceChannelModifier = sourceChannelModifier;
  }


  public DailyRate internalChannelModifier(Double internalChannelModifier) {
    
    this.internalChannelModifier = internalChannelModifier;
    return this;
  }

   /**
   * Get internalChannelModifier
   * @return internalChannelModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalChannelModifier() {
    return internalChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalChannelModifier(Double internalChannelModifier) {
    this.internalChannelModifier = internalChannelModifier;
  }


  public DailyRate userSpecifiedCurrencyChannelModifier(Double userSpecifiedCurrencyChannelModifier) {
    
    this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyChannelModifier
   * @return userSpecifiedCurrencyChannelModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getUserSpecifiedCurrencyChannelModifier() {
    return userSpecifiedCurrencyChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyChannelModifier(Double userSpecifiedCurrencyChannelModifier) {
    this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
  }


  public DailyRate available(Boolean available) {
    
    this.available = available;
    return this;
  }

   /**
   * Get available
   * @return available
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(Boolean available) {
    this.available = available;
  }


  public DailyRate offerDetails(List<SimpleDescription> offerDetails) {
    
    this.offerDetails = offerDetails;
    return this;
  }

  public DailyRate addOfferDetailsItem(SimpleDescription offerDetailsItem) {
    if (this.offerDetails == null) {
      this.offerDetails = new ArrayList<>();
    }
    this.offerDetails.add(offerDetailsItem);
    return this;
  }

   /**
   * Get offerDetails
   * @return offerDetails
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OFFER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleDescription> getOfferDetails() {
    return offerDetails;
  }


  @JsonProperty(JSON_PROPERTY_OFFER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOfferDetails(List<SimpleDescription> offerDetails) {
    this.offerDetails = offerDetails;
  }


  public DailyRate hasModification(Boolean hasModification) {
    
    this.hasModification = hasModification;
    return this;
  }

   /**
   * Get hasModification
   * @return hasModification
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HAS_MODIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasModification() {
    return hasModification;
  }


  @JsonProperty(JSON_PROPERTY_HAS_MODIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasModification(Boolean hasModification) {
    this.hasModification = hasModification;
  }


  public DailyRate hasChannelDiscount(Boolean hasChannelDiscount) {
    
    this.hasChannelDiscount = hasChannelDiscount;
    return this;
  }

   /**
   * Get hasChannelDiscount
   * @return hasChannelDiscount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HAS_CHANNEL_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasChannelDiscount() {
    return hasChannelDiscount;
  }


  @JsonProperty(JSON_PROPERTY_HAS_CHANNEL_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasChannelDiscount(Boolean hasChannelDiscount) {
    this.hasChannelDiscount = hasChannelDiscount;
  }


  public DailyRate channelDiscountPercent(Float channelDiscountPercent) {
    
    this.channelDiscountPercent = channelDiscountPercent;
    return this;
  }

   /**
   * Get channelDiscountPercent
   * @return channelDiscountPercent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getChannelDiscountPercent() {
    return channelDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannelDiscountPercent(Float channelDiscountPercent) {
    this.channelDiscountPercent = channelDiscountPercent;
  }


  public DailyRate promotionalDiscountPercent(Float promotionalDiscountPercent) {
    
    this.promotionalDiscountPercent = promotionalDiscountPercent;
    return this;
  }

   /**
   * Get promotionalDiscountPercent
   * @return promotionalDiscountPercent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPromotionalDiscountPercent() {
    return promotionalDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalDiscountPercent(Float promotionalDiscountPercent) {
    this.promotionalDiscountPercent = promotionalDiscountPercent;
  }


  public DailyRate premiumPercent(Float premiumPercent) {
    
    this.premiumPercent = premiumPercent;
    return this;
  }

   /**
   * Get premiumPercent
   * @return premiumPercent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PREMIUM_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPremiumPercent() {
    return premiumPercent;
  }


  @JsonProperty(JSON_PROPERTY_PREMIUM_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPremiumPercent(Float premiumPercent) {
    this.premiumPercent = premiumPercent;
  }


  public DailyRate promotion(String promotion) {
    
    this.promotion = promotion;
    return this;
  }

   /**
   * Get promotion
   * @return promotion
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPromotion() {
    return promotion;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotion(String promotion) {
    this.promotion = promotion;
  }


  public DailyRate adults(Integer adults) {
    
    this.adults = adults;
    return this;
  }

   /**
   * Get adults
   * @return adults
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAdults() {
    return adults;
  }


  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdults(Integer adults) {
    this.adults = adults;
  }


  public DailyRate children(Integer children) {
    
    this.children = children;
    return this;
  }

   /**
   * Get children
   * @return children
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getChildren() {
    return children;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildren(Integer children) {
    this.children = children;
  }


  public DailyRate rate(Rate rate) {
    
    this.rate = rate;
    return this;
  }

   /**
   * Get rate
   * @return rate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Rate getRate() {
    return rate;
  }


  @JsonProperty(JSON_PROPERTY_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRate(Rate rate) {
    this.rate = rate;
  }


  public DailyRate sourceToUserCurrencyQuote(Quote sourceToUserCurrencyQuote) {
    
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
    return this;
  }

   /**
   * Get sourceToUserCurrencyQuote
   * @return sourceToUserCurrencyQuote
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Quote getSourceToUserCurrencyQuote() {
    return sourceToUserCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceToUserCurrencyQuote(Quote sourceToUserCurrencyQuote) {
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
  }


  public DailyRate sourceToInternalCurrencyQuote(Quote sourceToInternalCurrencyQuote) {
    
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
    return this;
  }

   /**
   * Get sourceToInternalCurrencyQuote
   * @return sourceToInternalCurrencyQuote
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Quote getSourceToInternalCurrencyQuote() {
    return sourceToInternalCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceToInternalCurrencyQuote(Quote sourceToInternalCurrencyQuote) {
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
  }


  public DailyRate phantom(Boolean phantom) {
    
    this.phantom = phantom;
    return this;
  }

   /**
   * Get phantom
   * @return phantom
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PHANTOM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPhantom() {
    return phantom;
  }


  @JsonProperty(JSON_PROPERTY_PHANTOM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhantom(Boolean phantom) {
    this.phantom = phantom;
  }


  public DailyRate source(SourceEnum source) {
    
    this.source = source;
    return this;
  }

   /**
   * Get source
   * @return source
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SourceEnum getSource() {
    return source;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSource(SourceEnum source) {
    this.source = source;
  }


  public DailyRate userSpecifiedCurrencyRate(Moneys userSpecifiedCurrencyRate) {
    
    this.userSpecifiedCurrencyRate = userSpecifiedCurrencyRate;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyRate
   * @return userSpecifiedCurrencyRate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getUserSpecifiedCurrencyRate() {
    return userSpecifiedCurrencyRate;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyRate(Moneys userSpecifiedCurrencyRate) {
    this.userSpecifiedCurrencyRate = userSpecifiedCurrencyRate;
  }


  public DailyRate startDate(Boolean startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Get startDate
   * @return startDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(Boolean startDate) {
    this.startDate = startDate;
  }


  public DailyRate betweenDate(Boolean betweenDate) {
    
    this.betweenDate = betweenDate;
    return this;
  }

   /**
   * Get betweenDate
   * @return betweenDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BETWEEN_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getBetweenDate() {
    return betweenDate;
  }


  @JsonProperty(JSON_PROPERTY_BETWEEN_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBetweenDate(Boolean betweenDate) {
    this.betweenDate = betweenDate;
  }


  public DailyRate lastNight(Boolean lastNight) {
    
    this.lastNight = lastNight;
    return this;
  }

   /**
   * Get lastNight
   * @return lastNight
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LAST_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLastNight() {
    return lastNight;
  }


  @JsonProperty(JSON_PROPERTY_LAST_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastNight(Boolean lastNight) {
    this.lastNight = lastNight;
  }


  public DailyRate bundledModifier(Boolean bundledModifier) {
    
    this.bundledModifier = bundledModifier;
    return this;
  }

   /**
   * Get bundledModifier
   * @return bundledModifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BUNDLED_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getBundledModifier() {
    return bundledModifier;
  }


  @JsonProperty(JSON_PROPERTY_BUNDLED_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBundledModifier(Boolean bundledModifier) {
    this.bundledModifier = bundledModifier;
  }


  public DailyRate closeOnDeparture(Boolean closeOnDeparture) {
    
    this.closeOnDeparture = closeOnDeparture;
    return this;
  }

   /**
   * Get closeOnDeparture
   * @return closeOnDeparture
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CLOSE_ON_DEPARTURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCloseOnDeparture() {
    return closeOnDeparture;
  }


  @JsonProperty(JSON_PROPERTY_CLOSE_ON_DEPARTURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCloseOnDeparture(Boolean closeOnDeparture) {
    this.closeOnDeparture = closeOnDeparture;
  }


  public DailyRate inventoryAvailable(Boolean inventoryAvailable) {
    
    this.inventoryAvailable = inventoryAvailable;
    return this;
  }

   /**
   * Get inventoryAvailable
   * @return inventoryAvailable
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INVENTORY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getInventoryAvailable() {
    return inventoryAvailable;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInventoryAvailable(Boolean inventoryAvailable) {
    this.inventoryAvailable = inventoryAvailable;
  }


  public DailyRate masterAvailability(Boolean masterAvailability) {
    
    this.masterAvailability = masterAvailability;
    return this;
  }

   /**
   * Get masterAvailability
   * @return masterAvailability
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MASTER_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMasterAvailability() {
    return masterAvailability;
  }


  @JsonProperty(JSON_PROPERTY_MASTER_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMasterAvailability(Boolean masterAvailability) {
    this.masterAvailability = masterAvailability;
  }


  public DailyRate closeOnArrival(Boolean closeOnArrival) {
    
    this.closeOnArrival = closeOnArrival;
    return this;
  }

   /**
   * Get closeOnArrival
   * @return closeOnArrival
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CLOSE_ON_ARRIVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCloseOnArrival() {
    return closeOnArrival;
  }


  @JsonProperty(JSON_PROPERTY_CLOSE_ON_ARRIVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCloseOnArrival(Boolean closeOnArrival) {
    this.closeOnArrival = closeOnArrival;
  }


  public DailyRate rateIdentifier(String rateIdentifier) {
    
    this.rateIdentifier = rateIdentifier;
    return this;
  }

   /**
   * Get rateIdentifier
   * @return rateIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRateIdentifier() {
    return rateIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateIdentifier(String rateIdentifier) {
    this.rateIdentifier = rateIdentifier;
  }


  public DailyRate internalRate(Moneys internalRate) {
    
    this.internalRate = internalRate;
    return this;
  }

   /**
   * Get internalRate
   * @return internalRate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getInternalRate() {
    return internalRate;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalRate(Moneys internalRate) {
    this.internalRate = internalRate;
  }


  public DailyRate baseRate(Moneys baseRate) {
    
    this.baseRate = baseRate;
    return this;
  }

   /**
   * Get baseRate
   * @return baseRate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BASE_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getBaseRate() {
    return baseRate;
  }


  @JsonProperty(JSON_PROPERTY_BASE_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBaseRate(Moneys baseRate) {
    this.baseRate = baseRate;
  }


  public DailyRate quantity(Integer quantity) {
    
    this.quantity = quantity;
    return this;
  }

   /**
   * Get quantity
   * @return quantity
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }


  public DailyRate sourceRate(Moneys sourceRate) {
    
    this.sourceRate = sourceRate;
    return this;
  }

   /**
   * Get sourceRate
   * @return sourceRate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getSourceRate() {
    return sourceRate;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceRate(Moneys sourceRate) {
    this.sourceRate = sourceRate;
  }


  public DailyRate minOccupancy(Integer minOccupancy) {
    
    this.minOccupancy = minOccupancy;
    return this;
  }

   /**
   * Get minOccupancy
   * @return minOccupancy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinOccupancy() {
    return minOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinOccupancy(Integer minOccupancy) {
    this.minOccupancy = minOccupancy;
  }


  public DailyRate maxOccupancy(Integer maxOccupancy) {
    
    this.maxOccupancy = maxOccupancy;
    return this;
  }

   /**
   * Get maxOccupancy
   * @return maxOccupancy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxOccupancy() {
    return maxOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxOccupancy(Integer maxOccupancy) {
    this.maxOccupancy = maxOccupancy;
  }


  public DailyRate maxChildOccupancy(Integer maxChildOccupancy) {
    
    this.maxChildOccupancy = maxChildOccupancy;
    return this;
  }

   /**
   * Get maxChildOccupancy
   * @return maxChildOccupancy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MAX_CHILD_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxChildOccupancy() {
    return maxChildOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_CHILD_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxChildOccupancy(Integer maxChildOccupancy) {
    this.maxChildOccupancy = maxChildOccupancy;
  }


  public DailyRate totalDiscountPercent(Float totalDiscountPercent) {
    
    this.totalDiscountPercent = totalDiscountPercent;
    return this;
  }

   /**
   * Get totalDiscountPercent
   * @return totalDiscountPercent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalDiscountPercent() {
    return totalDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalDiscountPercent(Float totalDiscountPercent) {
    this.totalDiscountPercent = totalDiscountPercent;
  }


  public DailyRate minLOS(Integer minLOS) {
    
    this.minLOS = minLOS;
    return this;
  }

   /**
   * Get minLOS
   * @return minLOS
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MIN_L_O_S)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinLOS() {
    return minLOS;
  }


  @JsonProperty(JSON_PROPERTY_MIN_L_O_S)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinLOS(Integer minLOS) {
    this.minLOS = minLOS;
  }


  public DailyRate maxLOS(Integer maxLOS) {
    
    this.maxLOS = maxLOS;
    return this;
  }

   /**
   * Get maxLOS
   * @return maxLOS
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MAX_L_O_S)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxLOS() {
    return maxLOS;
  }


  @JsonProperty(JSON_PROPERTY_MAX_L_O_S)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxLOS(Integer maxLOS) {
    this.maxLOS = maxLOS;
  }


  public DailyRate endDate(Boolean endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Get endDate
   * @return endDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(Boolean endDate) {
    this.endDate = endDate;
  }


  public DailyRate date(LocalDate date) {
    
    this.date = date;
    return this;
  }

   /**
   * Get date
   * @return date
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getDate() {
    return date;
  }


  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDate(LocalDate date) {
    this.date = date;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DailyRate dailyRate = (DailyRate) o;
    return Objects.equals(this.sourceBaseRate, dailyRate.sourceBaseRate) &&
        Objects.equals(this.internalBaseRate, dailyRate.internalBaseRate) &&
        Objects.equals(this.userSpecifiedCurrencyBaseRate, dailyRate.userSpecifiedCurrencyBaseRate) &&
        Objects.equals(this.sourceExtraPaxModifier, dailyRate.sourceExtraPaxModifier) &&
        Objects.equals(this.internalExtraPaxModifier, dailyRate.internalExtraPaxModifier) &&
        Objects.equals(this.userSpecifiedCurrencyExtraPaxModifier, dailyRate.userSpecifiedCurrencyExtraPaxModifier) &&
        Objects.equals(this.sourceExtraChildModifier, dailyRate.sourceExtraChildModifier) &&
        Objects.equals(this.internalExtraChildModifier, dailyRate.internalExtraChildModifier) &&
        Objects.equals(this.userSpecifiedCurrencyExtraChildModifier, dailyRate.userSpecifiedCurrencyExtraChildModifier) &&
        Objects.equals(this.sourceSingleOccupantModifier, dailyRate.sourceSingleOccupantModifier) &&
        Objects.equals(this.internalSingleOccupantModifier, dailyRate.internalSingleOccupantModifier) &&
        Objects.equals(this.userSpecifiedCurrencySingleOccupantModifier, dailyRate.userSpecifiedCurrencySingleOccupantModifier) &&
        Objects.equals(this.sourcePromotionalModifier, dailyRate.sourcePromotionalModifier) &&
        Objects.equals(this.internalPromotionalModifier, dailyRate.internalPromotionalModifier) &&
        Objects.equals(this.userSpecifiedCurrencyPromotionalModifier, dailyRate.userSpecifiedCurrencyPromotionalModifier) &&
        Objects.equals(this.sourcePremiumModifier, dailyRate.sourcePremiumModifier) &&
        Objects.equals(this.internalPremiumModifier, dailyRate.internalPremiumModifier) &&
        Objects.equals(this.userSpecifiedCurrencyPremiumModifier, dailyRate.userSpecifiedCurrencyPremiumModifier) &&
        Objects.equals(this.sourceChannelModifier, dailyRate.sourceChannelModifier) &&
        Objects.equals(this.internalChannelModifier, dailyRate.internalChannelModifier) &&
        Objects.equals(this.userSpecifiedCurrencyChannelModifier, dailyRate.userSpecifiedCurrencyChannelModifier) &&
        Objects.equals(this.available, dailyRate.available) &&
        Objects.equals(this.offerDetails, dailyRate.offerDetails) &&
        Objects.equals(this.hasModification, dailyRate.hasModification) &&
        Objects.equals(this.hasChannelDiscount, dailyRate.hasChannelDiscount) &&
        Objects.equals(this.channelDiscountPercent, dailyRate.channelDiscountPercent) &&
        Objects.equals(this.promotionalDiscountPercent, dailyRate.promotionalDiscountPercent) &&
        Objects.equals(this.premiumPercent, dailyRate.premiumPercent) &&
        Objects.equals(this.promotion, dailyRate.promotion) &&
        Objects.equals(this.adults, dailyRate.adults) &&
        Objects.equals(this.children, dailyRate.children) &&
        Objects.equals(this.rate, dailyRate.rate) &&
        Objects.equals(this.sourceToUserCurrencyQuote, dailyRate.sourceToUserCurrencyQuote) &&
        Objects.equals(this.sourceToInternalCurrencyQuote, dailyRate.sourceToInternalCurrencyQuote) &&
        Objects.equals(this.phantom, dailyRate.phantom) &&
        Objects.equals(this.source, dailyRate.source) &&
        Objects.equals(this.userSpecifiedCurrencyRate, dailyRate.userSpecifiedCurrencyRate) &&
        Objects.equals(this.startDate, dailyRate.startDate) &&
        Objects.equals(this.betweenDate, dailyRate.betweenDate) &&
        Objects.equals(this.lastNight, dailyRate.lastNight) &&
        Objects.equals(this.bundledModifier, dailyRate.bundledModifier) &&
        Objects.equals(this.closeOnDeparture, dailyRate.closeOnDeparture) &&
        Objects.equals(this.inventoryAvailable, dailyRate.inventoryAvailable) &&
        Objects.equals(this.masterAvailability, dailyRate.masterAvailability) &&
        Objects.equals(this.closeOnArrival, dailyRate.closeOnArrival) &&
        Objects.equals(this.rateIdentifier, dailyRate.rateIdentifier) &&
        Objects.equals(this.internalRate, dailyRate.internalRate) &&
        Objects.equals(this.baseRate, dailyRate.baseRate) &&
        Objects.equals(this.quantity, dailyRate.quantity) &&
        Objects.equals(this.sourceRate, dailyRate.sourceRate) &&
        Objects.equals(this.minOccupancy, dailyRate.minOccupancy) &&
        Objects.equals(this.maxOccupancy, dailyRate.maxOccupancy) &&
        Objects.equals(this.maxChildOccupancy, dailyRate.maxChildOccupancy) &&
        Objects.equals(this.totalDiscountPercent, dailyRate.totalDiscountPercent) &&
        Objects.equals(this.minLOS, dailyRate.minLOS) &&
        Objects.equals(this.maxLOS, dailyRate.maxLOS) &&
        Objects.equals(this.endDate, dailyRate.endDate) &&
        Objects.equals(this.date, dailyRate.date);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sourceBaseRate, internalBaseRate, userSpecifiedCurrencyBaseRate, sourceExtraPaxModifier, internalExtraPaxModifier, userSpecifiedCurrencyExtraPaxModifier, sourceExtraChildModifier, internalExtraChildModifier, userSpecifiedCurrencyExtraChildModifier, sourceSingleOccupantModifier, internalSingleOccupantModifier, userSpecifiedCurrencySingleOccupantModifier, sourcePromotionalModifier, internalPromotionalModifier, userSpecifiedCurrencyPromotionalModifier, sourcePremiumModifier, internalPremiumModifier, userSpecifiedCurrencyPremiumModifier, sourceChannelModifier, internalChannelModifier, userSpecifiedCurrencyChannelModifier, available, offerDetails, hasModification, hasChannelDiscount, channelDiscountPercent, promotionalDiscountPercent, premiumPercent, promotion, adults, children, rate, sourceToUserCurrencyQuote, sourceToInternalCurrencyQuote, phantom, source, userSpecifiedCurrencyRate, startDate, betweenDate, lastNight, bundledModifier, closeOnDeparture, inventoryAvailable, masterAvailability, closeOnArrival, rateIdentifier, internalRate, baseRate, quantity, sourceRate, minOccupancy, maxOccupancy, maxChildOccupancy, totalDiscountPercent, minLOS, maxLOS, endDate, date);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DailyRate {\n");
    sb.append("    sourceBaseRate: ").append(toIndentedString(sourceBaseRate)).append("\n");
    sb.append("    internalBaseRate: ").append(toIndentedString(internalBaseRate)).append("\n");
    sb.append("    userSpecifiedCurrencyBaseRate: ").append(toIndentedString(userSpecifiedCurrencyBaseRate)).append("\n");
    sb.append("    sourceExtraPaxModifier: ").append(toIndentedString(sourceExtraPaxModifier)).append("\n");
    sb.append("    internalExtraPaxModifier: ").append(toIndentedString(internalExtraPaxModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyExtraPaxModifier: ").append(toIndentedString(userSpecifiedCurrencyExtraPaxModifier)).append("\n");
    sb.append("    sourceExtraChildModifier: ").append(toIndentedString(sourceExtraChildModifier)).append("\n");
    sb.append("    internalExtraChildModifier: ").append(toIndentedString(internalExtraChildModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyExtraChildModifier: ").append(toIndentedString(userSpecifiedCurrencyExtraChildModifier)).append("\n");
    sb.append("    sourceSingleOccupantModifier: ").append(toIndentedString(sourceSingleOccupantModifier)).append("\n");
    sb.append("    internalSingleOccupantModifier: ").append(toIndentedString(internalSingleOccupantModifier)).append("\n");
    sb.append("    userSpecifiedCurrencySingleOccupantModifier: ").append(toIndentedString(userSpecifiedCurrencySingleOccupantModifier)).append("\n");
    sb.append("    sourcePromotionalModifier: ").append(toIndentedString(sourcePromotionalModifier)).append("\n");
    sb.append("    internalPromotionalModifier: ").append(toIndentedString(internalPromotionalModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyPromotionalModifier: ").append(toIndentedString(userSpecifiedCurrencyPromotionalModifier)).append("\n");
    sb.append("    sourcePremiumModifier: ").append(toIndentedString(sourcePremiumModifier)).append("\n");
    sb.append("    internalPremiumModifier: ").append(toIndentedString(internalPremiumModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyPremiumModifier: ").append(toIndentedString(userSpecifiedCurrencyPremiumModifier)).append("\n");
    sb.append("    sourceChannelModifier: ").append(toIndentedString(sourceChannelModifier)).append("\n");
    sb.append("    internalChannelModifier: ").append(toIndentedString(internalChannelModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyChannelModifier: ").append(toIndentedString(userSpecifiedCurrencyChannelModifier)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("    offerDetails: ").append(toIndentedString(offerDetails)).append("\n");
    sb.append("    hasModification: ").append(toIndentedString(hasModification)).append("\n");
    sb.append("    hasChannelDiscount: ").append(toIndentedString(hasChannelDiscount)).append("\n");
    sb.append("    channelDiscountPercent: ").append(toIndentedString(channelDiscountPercent)).append("\n");
    sb.append("    promotionalDiscountPercent: ").append(toIndentedString(promotionalDiscountPercent)).append("\n");
    sb.append("    premiumPercent: ").append(toIndentedString(premiumPercent)).append("\n");
    sb.append("    promotion: ").append(toIndentedString(promotion)).append("\n");
    sb.append("    adults: ").append(toIndentedString(adults)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    rate: ").append(toIndentedString(rate)).append("\n");
    sb.append("    sourceToUserCurrencyQuote: ").append(toIndentedString(sourceToUserCurrencyQuote)).append("\n");
    sb.append("    sourceToInternalCurrencyQuote: ").append(toIndentedString(sourceToInternalCurrencyQuote)).append("\n");
    sb.append("    phantom: ").append(toIndentedString(phantom)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    userSpecifiedCurrencyRate: ").append(toIndentedString(userSpecifiedCurrencyRate)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    betweenDate: ").append(toIndentedString(betweenDate)).append("\n");
    sb.append("    lastNight: ").append(toIndentedString(lastNight)).append("\n");
    sb.append("    bundledModifier: ").append(toIndentedString(bundledModifier)).append("\n");
    sb.append("    closeOnDeparture: ").append(toIndentedString(closeOnDeparture)).append("\n");
    sb.append("    inventoryAvailable: ").append(toIndentedString(inventoryAvailable)).append("\n");
    sb.append("    masterAvailability: ").append(toIndentedString(masterAvailability)).append("\n");
    sb.append("    closeOnArrival: ").append(toIndentedString(closeOnArrival)).append("\n");
    sb.append("    rateIdentifier: ").append(toIndentedString(rateIdentifier)).append("\n");
    sb.append("    internalRate: ").append(toIndentedString(internalRate)).append("\n");
    sb.append("    baseRate: ").append(toIndentedString(baseRate)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    sourceRate: ").append(toIndentedString(sourceRate)).append("\n");
    sb.append("    minOccupancy: ").append(toIndentedString(minOccupancy)).append("\n");
    sb.append("    maxOccupancy: ").append(toIndentedString(maxOccupancy)).append("\n");
    sb.append("    maxChildOccupancy: ").append(toIndentedString(maxChildOccupancy)).append("\n");
    sb.append("    totalDiscountPercent: ").append(toIndentedString(totalDiscountPercent)).append("\n");
    sb.append("    minLOS: ").append(toIndentedString(minLOS)).append("\n");
    sb.append("    maxLOS: ").append(toIndentedString(maxLOS)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

