/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 19.0.14-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Property response to review.
 */
@ApiModel(description = "Property response to review.")
@JsonPropertyOrder({
  ReviewResponse.JSON_PROPERTY_HOTEL_IDENTIFIER,
  ReviewResponse.JSON_PROPERTY_REVIEW_IDENTIFIER,
  ReviewResponse.JSON_PROPERTY_USER_IDENTIFIER,
  ReviewResponse.JSON_PROPERTY_RESPONSE_FROM_HOTEL,
  ReviewResponse.JSON_PROPERTY_APPROVED_TEXT,
  ReviewResponse.JSON_PROPERTY_APPROVED_IMAGE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-28T13:49:39.867864+07:00[Asia/Bangkok]")
public class ReviewResponse {
  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private String hotelIdentifier;

  public static final String JSON_PROPERTY_REVIEW_IDENTIFIER = "reviewIdentifier";
  private String reviewIdentifier;

  public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
  private String userIdentifier;

  public static final String JSON_PROPERTY_RESPONSE_FROM_HOTEL = "responseFromHotel";
  private String responseFromHotel;

  public static final String JSON_PROPERTY_APPROVED_TEXT = "approvedText";
  private Boolean approvedText;

  public static final String JSON_PROPERTY_APPROVED_IMAGE = "approvedImage";
  private Boolean approvedImage;

  public ReviewResponse() { 
  }

  public ReviewResponse hotelIdentifier(String hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel identifier associated with review.
   * @return hotelIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "hotel-1", value = "Hotel identifier associated with review.")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(String hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public ReviewResponse reviewIdentifier(String reviewIdentifier) {
    
    this.reviewIdentifier = reviewIdentifier;
    return this;
  }

   /**
   * Review identifier of review being responded to.
   * @return reviewIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "review-1", value = "Review identifier of review being responded to.")
  @JsonProperty(JSON_PROPERTY_REVIEW_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReviewIdentifier() {
    return reviewIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_REVIEW_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReviewIdentifier(String reviewIdentifier) {
    this.reviewIdentifier = reviewIdentifier;
  }


  public ReviewResponse userIdentifier(String userIdentifier) {
    
    this.userIdentifier = userIdentifier;
    return this;
  }

   /**
   * User identifier of property manager who responded to the review.
   * @return userIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "user-1", value = "User identifier of property manager who responded to the review.")
  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUserIdentifier() {
    return userIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserIdentifier(String userIdentifier) {
    this.userIdentifier = userIdentifier;
  }


  public ReviewResponse responseFromHotel(String responseFromHotel) {
    
    this.responseFromHotel = responseFromHotel;
    return this;
  }

   /**
   * User identifier of property manager who responded to the review.
   * @return responseFromHotel
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Thank you for coming. Lovely to hear you enjoyed your stay.", required = true, value = "User identifier of property manager who responded to the review.")
  @JsonProperty(JSON_PROPERTY_RESPONSE_FROM_HOTEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getResponseFromHotel() {
    return responseFromHotel;
  }


  @JsonProperty(JSON_PROPERTY_RESPONSE_FROM_HOTEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setResponseFromHotel(String responseFromHotel) {
    this.responseFromHotel = responseFromHotel;
  }


  public ReviewResponse approvedText(Boolean approvedText) {
    
    this.approvedText = approvedText;
    return this;
  }

   /**
   * Property approves the use of guest review text with property profile.
   * @return approvedText
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Property approves the use of guest review text with property profile.")
  @JsonProperty(JSON_PROPERTY_APPROVED_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getApprovedText() {
    return approvedText;
  }


  @JsonProperty(JSON_PROPERTY_APPROVED_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApprovedText(Boolean approvedText) {
    this.approvedText = approvedText;
  }


  public ReviewResponse approvedImage(Boolean approvedImage) {
    
    this.approvedImage = approvedImage;
    return this;
  }

   /**
   * Property approves the use of guest generated image with property profile.
   * @return approvedImage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Property approves the use of guest generated image with property profile.")
  @JsonProperty(JSON_PROPERTY_APPROVED_IMAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getApprovedImage() {
    return approvedImage;
  }


  @JsonProperty(JSON_PROPERTY_APPROVED_IMAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApprovedImage(Boolean approvedImage) {
    this.approvedImage = approvedImage;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ReviewResponse reviewResponse = (ReviewResponse) o;
    return Objects.equals(this.hotelIdentifier, reviewResponse.hotelIdentifier) &&
        Objects.equals(this.reviewIdentifier, reviewResponse.reviewIdentifier) &&
        Objects.equals(this.userIdentifier, reviewResponse.userIdentifier) &&
        Objects.equals(this.responseFromHotel, reviewResponse.responseFromHotel) &&
        Objects.equals(this.approvedText, reviewResponse.approvedText) &&
        Objects.equals(this.approvedImage, reviewResponse.approvedImage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hotelIdentifier, reviewIdentifier, userIdentifier, responseFromHotel, approvedText, approvedImage);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ReviewResponse {\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    reviewIdentifier: ").append(toIndentedString(reviewIdentifier)).append("\n");
    sb.append("    userIdentifier: ").append(toIndentedString(userIdentifier)).append("\n");
    sb.append("    responseFromHotel: ").append(toIndentedString(responseFromHotel)).append("\n");
    sb.append("    approvedText: ").append(toIndentedString(approvedText)).append("\n");
    sb.append("    approvedImage: ").append(toIndentedString(approvedImage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

