/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 19.0.14-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * SalesChannelUpdateRequest
 */
@JsonPropertyOrder({
  SalesChannelUpdateRequest.JSON_PROPERTY_IDENTIFIER,
  SalesChannelUpdateRequest.JSON_PROPERTY_ENABLED,
  SalesChannelUpdateRequest.JSON_PROPERTY_BLACKLISTED,
  SalesChannelUpdateRequest.JSON_PROPERTY_PERCENT_DISCOUNT,
  SalesChannelUpdateRequest.JSON_PROPERTY_COMMISSION,
  SalesChannelUpdateRequest.JSON_PROPERTY_RATE_MODIFIER_IDENTIFIERS,
  SalesChannelUpdateRequest.JSON_PROPERTY_RATE_MODIFIER_BUNDLE_IDENTIFIERS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-28T13:49:39.867864+07:00[Asia/Bangkok]")
public class SalesChannelUpdateRequest {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled = true;

  public static final String JSON_PROPERTY_BLACKLISTED = "blacklisted";
  private Boolean blacklisted = true;

  public static final String JSON_PROPERTY_PERCENT_DISCOUNT = "percentDiscount";
  private Float percentDiscount;

  public static final String JSON_PROPERTY_COMMISSION = "commission";
  private Float commission;

  public static final String JSON_PROPERTY_RATE_MODIFIER_IDENTIFIERS = "rateModifierIdentifiers";
  private List<String> rateModifierIdentifiers = null;

  public static final String JSON_PROPERTY_RATE_MODIFIER_BUNDLE_IDENTIFIERS = "rateModifierBundleIdentifiers";
  private List<String> rateModifierBundleIdentifiers = null;

  public SalesChannelUpdateRequest() { 
  }

  public SalesChannelUpdateRequest identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier
   * @return identifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "sales-channel-1", required = true, value = "Unique record identifier")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public SalesChannelUpdateRequest enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Flag the supplier can use to enable / disable a sales channel
   * @return enabled
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Flag the supplier can use to enable / disable a sales channel")
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public SalesChannelUpdateRequest blacklisted(Boolean blacklisted) {
    
    this.blacklisted = blacklisted;
    return this;
  }

   /**
   * Flag the supplier can use to ignore a sales channel
   * @return blacklisted
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Flag the supplier can use to ignore a sales channel")
  @JsonProperty(JSON_PROPERTY_BLACKLISTED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBlacklisted() {
    return blacklisted;
  }


  @JsonProperty(JSON_PROPERTY_BLACKLISTED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBlacklisted(Boolean blacklisted) {
    this.blacklisted = blacklisted;
  }


  public SalesChannelUpdateRequest percentDiscount(Float percentDiscount) {
    
    this.percentDiscount = percentDiscount;
    return this;
  }

   /**
   * Percent discount on this channel and all its children [unless configured at the child level].
   * minimum: 0.0
   * maximum: 1.0
   * @return percentDiscount
  **/
  @javax.annotation.Nonnull
  @NotNull
 @DecimalMin("0.0") @DecimalMax("1.0")  @ApiModelProperty(example = "0.15", required = true, value = "Percent discount on this channel and all its children [unless configured at the child level].")
  @JsonProperty(JSON_PROPERTY_PERCENT_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getPercentDiscount() {
    return percentDiscount;
  }


  @JsonProperty(JSON_PROPERTY_PERCENT_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPercentDiscount(Float percentDiscount) {
    this.percentDiscount = percentDiscount;
  }


  public SalesChannelUpdateRequest commission(Float commission) {
    
    this.commission = commission;
    return this;
  }

   /**
   * Amount of sales commission earned through this channel and all its children [unless configured at the child level].
   * minimum: 0.0
   * maximum: 1.0
   * @return commission
  **/
  @javax.annotation.Nonnull
  @NotNull
 @DecimalMin("0.0") @DecimalMax("1.0")  @ApiModelProperty(example = "0.2", required = true, value = "Amount of sales commission earned through this channel and all its children [unless configured at the child level].")
  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getCommission() {
    return commission;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCommission(Float commission) {
    this.commission = commission;
  }


  public SalesChannelUpdateRequest rateModifierIdentifiers(List<String> rateModifierIdentifiers) {
    
    this.rateModifierIdentifiers = rateModifierIdentifiers;
    return this;
  }

  public SalesChannelUpdateRequest addRateModifierIdentifiersItem(String rateModifierIdentifiersItem) {
    if (this.rateModifierIdentifiers == null) {
      this.rateModifierIdentifiers = new ArrayList<>();
    }
    this.rateModifierIdentifiers.add(rateModifierIdentifiersItem);
    return this;
  }

   /**
   * Unique identifiers of promotions you would like to apply to this channel and all its children [unless configured at the child level].
   * @return rateModifierIdentifiers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"promo-1\",\"promo-2\"]", value = "Unique identifiers of promotions you would like to apply to this channel and all its children [unless configured at the child level].")
  @JsonProperty(JSON_PROPERTY_RATE_MODIFIER_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getRateModifierIdentifiers() {
    return rateModifierIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_RATE_MODIFIER_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateModifierIdentifiers(List<String> rateModifierIdentifiers) {
    this.rateModifierIdentifiers = rateModifierIdentifiers;
  }


  public SalesChannelUpdateRequest rateModifierBundleIdentifiers(List<String> rateModifierBundleIdentifiers) {
    
    this.rateModifierBundleIdentifiers = rateModifierBundleIdentifiers;
    return this;
  }

  public SalesChannelUpdateRequest addRateModifierBundleIdentifiersItem(String rateModifierBundleIdentifiersItem) {
    if (this.rateModifierBundleIdentifiers == null) {
      this.rateModifierBundleIdentifiers = new ArrayList<>();
    }
    this.rateModifierBundleIdentifiers.add(rateModifierBundleIdentifiersItem);
    return this;
  }

   /**
   * Unique identifiers of promotion bundles you would like to apply to this channel and all its children [unless configured at the child level].
   * @return rateModifierBundleIdentifiers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"promo-bundle-1\",\"promo-bundle-2\"]", value = "Unique identifiers of promotion bundles you would like to apply to this channel and all its children [unless configured at the child level].")
  @JsonProperty(JSON_PROPERTY_RATE_MODIFIER_BUNDLE_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getRateModifierBundleIdentifiers() {
    return rateModifierBundleIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_RATE_MODIFIER_BUNDLE_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateModifierBundleIdentifiers(List<String> rateModifierBundleIdentifiers) {
    this.rateModifierBundleIdentifiers = rateModifierBundleIdentifiers;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SalesChannelUpdateRequest salesChannelUpdateRequest = (SalesChannelUpdateRequest) o;
    return Objects.equals(this.identifier, salesChannelUpdateRequest.identifier) &&
        Objects.equals(this.enabled, salesChannelUpdateRequest.enabled) &&
        Objects.equals(this.blacklisted, salesChannelUpdateRequest.blacklisted) &&
        Objects.equals(this.percentDiscount, salesChannelUpdateRequest.percentDiscount) &&
        Objects.equals(this.commission, salesChannelUpdateRequest.commission) &&
        Objects.equals(this.rateModifierIdentifiers, salesChannelUpdateRequest.rateModifierIdentifiers) &&
        Objects.equals(this.rateModifierBundleIdentifiers, salesChannelUpdateRequest.rateModifierBundleIdentifiers);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, enabled, blacklisted, percentDiscount, commission, rateModifierIdentifiers, rateModifierBundleIdentifiers);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SalesChannelUpdateRequest {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    blacklisted: ").append(toIndentedString(blacklisted)).append("\n");
    sb.append("    percentDiscount: ").append(toIndentedString(percentDiscount)).append("\n");
    sb.append("    commission: ").append(toIndentedString(commission)).append("\n");
    sb.append("    rateModifierIdentifiers: ").append(toIndentedString(rateModifierIdentifiers)).append("\n");
    sb.append("    rateModifierBundleIdentifiers: ").append(toIndentedString(rateModifierBundleIdentifiers)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

